/*
GENCHAR() -- Character generator

JJH, Jan 1986
*/

unsigned char c_tab[96][12] = {
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* ' ' */
   0x00,0x00,0x10,0x10,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,	/* '!' */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x24,0x6c,0x6c,	/* '"' */
   0x00,0x00,0x00,0x24,0x24,0x7e,0x24,0x24,0x7e,0x24,0x24,0x00,	/* '#' */
   0x00,0x00,0x18,0x3c,0x5a,0x1a,0x1c,0x38,0x58,0x5a,0x3c,0x18,	/* '$' */
   0x00,0x00,0x40,0x26,0x26,0x10,0x10,0x08,0x08,0x64,0x64,0x02,	/* '%' */
   0x00,0x00,0x3a,0x44,0x4a,0x48,0x50,0x20,0x50,0x50,0x20,0x00, /* '&' */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x08,0x18,0x18,	/* ''' */
   0x00,0x00,0x08,0x10,0x20,0x20,0x20,0x20,0x20,0x20,0x10,0x08,	/* '(' */
   0x00,0x00,0x20,0x10,0x08,0x08,0x08,0x08,0x08,0x08,0x10,0x20,	/* ')' */
   0x00,0x00,0x00,0x42,0x24,0x18,0x7e,0x18,0x24,0x42,0x00,0x00,	/* '*' */
   0x00,0x00,0x00,0x10,0x10,0x10,0x7c,0x10,0x10,0x10,0x00,0x00,	/* '+' */
   0x10,0x08,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* ',' */
   0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,	/* '-' */
   0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* '.' */
   0x00,0x00,0x40,0x20,0x20,0x10,0x10,0x08,0x08,0x04,0x04,0x02,	/* '/' */
   0x00,0x00,0x58,0x24,0x62,0x52,0x52,0x4a,0x4a,0x46,0x24,0x1a,	/* '0' */
   0x00,0x00,0x38,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x30,0x10,	/* '1' */
   0x00,0x00,0x7e,0x40,0x20,0x10,0x08,0x04,0x02,0x42,0x24,0x18,	/* '2' */
   0x00,0x00,0x3c,0x42,0x02,0x02,0x02,0x1c,0x02,0x02,0x42,0x3c,	/* '3' */
   0x00,0x00,0x04,0x04,0x04,0x04,0x7e,0x44,0x24,0x14,0x0c,0x04,	/* '4' */
   0x00,0x00,0x3c,0x42,0x42,0x02,0x02,0x3c,0x40,0x40,0x40,0x7e,	/* '5' */
   0x00,0x00,0x3c,0x42,0x42,0x42,0x7c,0x40,0x20,0x10,0x08,0x04,	/* '6' */
   0x00,0x00,0x20,0x20,0x10,0x10,0x08,0x08,0x04,0x04,0x02,0x7e,	/* '7' */
   0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x3c,0x42,0x42,0x42,0x3c,	/* '8' */
   0x00,0x00,0x20,0x10,0x08,0x04,0x3c,0x42,0x42,0x42,0x42,0x3c,	/* '9' */
   0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,	/* ':' */
   0x10,0x08,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,	/* ';' */
   0x00,0x00,0x04,0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x04,0x00,	/* '<' */
   0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,	/* '=' */
   0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x40,0x00,	/* '>' */
   0x00,0x00,0x10,0x00,0x10,0x10,0x10,0x08,0x04,0x44,0x44,0x38,	/* '?' */
   0x00,0x00,0x1c,0x22,0x40,0x5c,0x52,0x52,0x4e,0x42,0x24,0x18,	/* '@' */
   0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x7e,0x42,0x42,0x24,0x18,	/* 'A' */
   0x00,0x00,0x7c,0x22,0x22,0x22,0x22,0x3c,0x22,0x22,0x22,0x7c,	/* 'B' */
   0x00,0x00,0x1c,0x22,0x40,0x40,0x40,0x40,0x40,0x40,0x22,0x1c,	/* 'C' */
   0x00,0x00,0x78,0x24,0x22,0x22,0x22,0x22,0x22,0x22,0x24,0x78,	/* 'D' */
   0x00,0x00,0x7e,0x40,0x40,0x40,0x40,0x78,0x40,0x40,0x40,0x7e,	/* 'E' */
   0x00,0x00,0x40,0x40,0x40,0x40,0x40,0x78,0x40,0x40,0x40,0x7e,	/* 'F' */
   0x00,0x00,0x1c,0x22,0x42,0x4e,0x40,0x40,0x40,0x40,0x22,0x1c,	/* 'G' */
   0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,	/* 'H' */
   0x00,0x00,0x38,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x38,	/* 'I' */
   0x00,0x00,0x38,0x44,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,	/* 'J' */
   0x00,0x00,0x42,0x44,0x48,0x50,0x60,0x60,0x50,0x48,0x44,0x42,	/* 'K' */
   0x00,0x00,0x7e,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,	/* 'L' */
   0x00,0x00,0x42,0x42,0x42,0x42,0x42,0x5a,0x5a,0x66,0x66,0x42,	/* 'M' */
   0x00,0x00,0x42,0x46,0x46,0x4a,0x4a,0x52,0x52,0x62,0x62,0x42,	/* 'N' */
   0x00,0x00,0x18,0x24,0x42,0x42,0x42,0x42,0x42,0x42,0x24,0x18,	/* 'O' */
   0x00,0x00,0x40,0x40,0x40,0x40,0x40,0x7c,0x42,0x42,0x42,0x7c,	/* 'P' */
   0x00,0x00,0x1a,0x24,0x4a,0x42,0x42,0x42,0x42,0x42,0x24,0x18,	/* 'Q' */
   0x00,0x00,0x42,0x42,0x44,0x44,0x48,0x7c,0x42,0x42,0x42,0x7c, /* 'R' */
   0x00,0x00,0x3c,0x42,0x02,0x02,0x02,0x3c,0x40,0x40,0x42,0x3c,	/* 'S' */
   0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7c,	/* 'T' */
   0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,	/* 'U' */
   0x00,0x00,0x18,0x18,0x24,0x24,0x24,0x24,0x42,0x42,0x42,0x42,	/* 'V' */
   0x00,0x00,0x42,0x66,0x66,0x5a,0x5a,0x42,0x42,0x42,0x42,0x42,	/* 'W' */
   0x00,0x00,0x42,0x42,0x24,0x24,0x18,0x18,0x24,0x24,0x42,0x42,	/* 'X' */
   0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x28,0x44,0x44,0x44,	/* 'Y' */
   0x00,0x00,0x7e,0x20,0x20,0x10,0x10,0x08,0x08,0x04,0x04,0x7e,	/* 'Z' */
   0x00,0x00,0x1c,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1c,	/* '[' */
   0x00,0x00,0x02,0x04,0x04,0x08,0x08,0x10,0x10,0x20,0x20,0x40,	/* '\' */
   0x00,0x00,0x38,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x38,	/* ']' */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x14,0x08,	/* '^' */
   0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* '_' */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x10,0x20,0x40,	/* '`' */
   0x00,0x00,0x3c,0x48,0x48,0x38,0x08,0x70,0x00,0x00,0x00,0x00,	/* 'a' */
   0x00,0x00,0x58,0x64,0x44,0x44,0x64,0x58,0x40,0x40,0x40,0x40,	/* 'b' */
   0x00,0x00,0x38,0x44,0x40,0x40,0x44,0x38,0x00,0x00,0x00,0x00,	/* 'c' */
   0x00,0x00,0x34,0x4c,0x44,0x44,0x4c,0x34,0x04,0x04,0x04,0x04,	/* 'd' */
   0x00,0x00,0x38,0x44,0x40,0x7c,0x44,0x38,0x00,0x00,0x00,0x00,	/* 'e' */
   0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x70,0x20,0x24,0x24,0x18,	/* 'f' */
   0x00,0x78,0x04,0x3c,0x44,0x44,0x44,0x3c,0x00,0x00,0x00,0x00,	/* 'g' */
   0x00,0x00,0x44,0x44,0x44,0x44,0x44,0x78,0x40,0x40,0x40,0x40,	/* 'h' */
   0x00,0x00,0x38,0x10,0x10,0x10,0x10,0x30,0x00,0x10,0x00,0x00,	/* 'i' */
   0x00,0x38,0x44,0x04,0x04,0x04,0x04,0x0c,0x00,0x04,0x00,0x00,	/* 'j' */
   0x00,0x00,0x44,0x48,0x50,0x60,0x50,0x48,0x44,0x40,0x40,0x40,	/* 'k' */
   0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x18,	/* 'l' */
   0x00,0x00,0x54,0x54,0x54,0x54,0x7c,0x40,0x00,0x00,0x00,0x00,	/* 'm' */
   0x00,0x00,0x44,0x44,0x44,0x44,0x78,0x40,0x00,0x00,0x00,0x00,	/* 'n' */
   0x00,0x00,0x38,0x44,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00,	/* 'o' */
   0x00,0x40,0x40,0x78,0x44,0x44,0x44,0x78,0x00,0x00,0x00,0x00,	/* 'p' */
   0x00,0x04,0x04,0x3c,0x44,0x44,0x44,0x3c,0x00,0x00,0x00,0x00,	/* 'q' */
   0x00,0x00,0x40,0x40,0x40,0x40,0x64,0x58,0x00,0x00,0x00,0x00,	/* 'r' */
   0x00,0x00,0x78,0x04,0x04,0x38,0x40,0x3c,0x00,0x00,0x00,0x00,	/* 's' */
   0x00,0x00,0x18,0x20,0x20,0x20,0x20,0x78,0x20,0x00,0x00,0x00,	/* 't' */
   0x00,0x00,0x34,0x4c,0x44,0x44,0x44,0x44,0x00,0x00,0x00,0x00,	/* 'u' */
   0x00,0x00,0x10,0x28,0x28,0x44,0x44,0x44,0x00,0x00,0x00,0x00,	/* 'v' */
   0x00,0x00,0x28,0x54,0x54,0x54,0x44,0x44,0x00,0x00,0x00,0x00,	/* 'w' */
   0x00,0x00,0x44,0x28,0x10,0x10,0x28,0x44,0x00,0x00,0x00,0x00,	/* 'x' */
   0x00,0x70,0x08,0x3c,0x44,0x44,0x44,0x44,0x00,0x00,0x00,0x00,	/* 'y' */
   0x00,0x00,0x7c,0x40,0x20,0x10,0x08,0x7c,0x00,0x00,0x00,0x00,	/* 'z' */
   0x00,0x0c,0x10,0x10,0x10,0x10,0x20,0x10,0x10,0x10,0x10,0x0c,	/* '{' */
   0x00,0x00,0x10,0x10,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,	/* '|' */
   0x00,0x30,0x08,0x08,0x08,0x08,0x04,0x08,0x08,0x08,0x08,0x30,	/* '}' */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x54,0x24,0x00,0x00, /* '~' */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 7F  */
   };

genchar(str,out,xout,scale)
char *str;			/* String to be converted to dot pattern */
unsigned char **out;		/* Output array				*/
int xout;			/* Length of output array		*/
int scale;			/* Factor for blowing up characters	*/
{
int i, j, k, nchar, x, c;
unsigned char mask[12];

scale = (scale<1) ? 1 : scale;
nchar = strlen(str);
x=0;
for(i=0; i<8; i++) mask[i]= (0x0080>>i);

for(k=0; k<nchar; k++) {
   c = (str[k]&0x7f) - ' ';
   if(c<0) continue;
   for(i=0; i<8*scale; i++,x++) {
      if(x>=xout) return(x);
      for(j=0; j<12*scale; j++) {
	 out[j][x] = (c_tab[c][j/scale] & mask[i/scale]) ? 0xff : 0;
	 }
      }
   }
return(x);
}

