#define NEWSUM
#define NEWJIT
C  Program to do phase retrieval of diffraction-limited images, designed for
C    WFPC2. Can also be used to simulate diffraction images.

#define __MAXZER 11
C#define NSUB 3
#define PI 3.14159
C#define __MAXWAVE 1
C#define __MAXSTAR 1
C#define __MAXPSFSIZE 150
C#define __MAXCHANGE 0.5

#define __NGPAR 1
#define __NSMOOTH 5
#define __MAXFRM 50
#define __MAXFPAR 3

#define __MAXWAVE 9

#define __MAXSTAR 100
#define __MAXPSFSIZE 25
#define __MAXCHANGE 0.05
#define __MAXSPAR 5
#undef __BIGMEM
#define __SMOOTHSIZE 32

        SUBROUTINE PSFPHASE(A,IMAGESR,IMAGEER,IMAGESC,IMAGEEC)

        REAL A(IMAGESC:IMAGEEC,IMAGESR:IMAGEER)

	PARAMETER (NGPAR=__NGPAR, NSMOOTH=__NSMOOTH)
	PARAMETER (MAXWAVE=__MAXWAVE,MAXSTAR=__MAXSTAR,MAXSPAR=__MAXSPAR+NGPAR)
	PARAMETER (MAXPSFSIZE = __MAXPSFSIZE, MAXZER = __MAXZER)
	PARAMETER (MAXFRM = __MAXFRM, MAXFPAR = __MAXFPAR)
	PARAMETER (MAXPAR = MAXZER+NSMOOTH+MAXSTAR*MAXSPAR+29+MAXFRM*MAXFPAR+121)
        INTEGER SR, SC, ER, EC, UPPER
        LOGICAL KEYCHECK, SUB, LOCK(MAXPAR), HAVEFILT, HAVEOUT, HAVEPHOT
	LOGICAL FOCSLOPE, VARASTIG, FITPSLOPE, FITPLOC, FITPSIZE, VARCOMA, FITPQE
	LOGICAL HAVEDUMP, HAVEJIT, HAVESPEC, RESOLVE, HAVEGAUSS, HAVEJITLIS
	REAL VV(2), LPAR(MAXPAR), WAVE(MAXWAVE), WEIGHT(MAXWAVE)
        REAL W(10000), AA(10000), X(MAXSTAR), Y(MAXSTAR)
        REAL WF(5000), WT(5000)
        CHARACTER PARM*8, FILT*10, TWORD*80, FILTNAME*80, OUTFILE*80
	CHARACTER*64 JITFILE(MAXFRM), JITLIS

	INTEGER*8 LOCDATA(MAXFRM)
	INTEGER NX(MAXFRM), NY(MAXFRM)
	REAL DX(MAXFRM), DY(MAXFRM), DZ2F(MAXFRM), DZ3F(MAXFRM), EXPOS(MAXFRM)

	REAL HIGHBAD, LOWBAD
	COMMON /PARAM/ SUB, RN, GAIN, LOCK, LPAR, MAXITER, HAVEOUT, 
     &       HIGHBAD, LOWBAD, FOCSLOPE, VARASTIG, VARCOMA,
     &       FITPSLOPE, FITPLOC, FITPSIZE, FITPQE, HAVEDUMP, HAVESPEC, SPECSTART, 
     &       RESOLVE, RESOLVE0
        common /abervar/ focvar(5), astigvar(10), comavar(10), sphvar(5), trevar(10)

	common /nsubcom/ nsub

	integer iwx, iwy, icx, icy, nwx(maxfrm), nwy(maxfrm), ssize
        parameter(ssize = __SMOOTHSIZE)
	real wj(-ssize:ssize,-ssize:ssize,maxfrm)
	common /jitter/ wj, nwx, nwy
	real jitscale
        LOGICAL REVERSE, SFLIP, TFLIP, NEWSMEAR
	COMMON /REV/ REVERSE, SFLIP, TFLIP, NEWSMEAR, jitscale

        INCLUDE 'vistadisk/source/include/vistalink.inc'
        INCLUDE 'vistadisk/source/include/imagelink.inc'
        INCLUDE 'vistadisk/source/include/photfiles.inc'

        CHARACTER LABEL*80, FSTRCAT*80
        REAL PHOT(NUMDATA), IPHOT(2)

	logical havez22
	real z22
	common /parm/ z22,havez22

	integer itest
	common /getscale/ itest
	common /map/ imap

C   Keyword definition
        CALL KEYINIT
        CALL KEYDEF('BOX=')
        CALL KEYDEF('WAVE=')
        CALL KEYDEF('CAM=')
        CALL KEYDEF('RAD=')
        CALL KEYDEF('X=')
        CALL KEYDEF('Y=')
        CALL KEYDEF('SUB') 
        CALL KEYDEF('RN=')
        CALL KEYDEF('GAIN=')
        CALL KEYDEF('PSF=')
        CALL KEYDEF('IWRITE=')
        CALL KEYDEF('LOCK=')
        CALL KEYDEF('FILT=')
        CALL KEYDEF('MAXITER=')
        CALL KEYDEF('OUT=')
        CALL KEYDEF('PHOT')
        CALL KEYDEF('STARS=')
        CALL KEYDEF('Z22=')
        CALL KEYDEF('HIGHBAD=')
        CALL KEYDEF('LOWBAD=')
        CALL KEYDEF('NSAMP=')
        CALL KEYDEF('FOCSLOPE')
        CALL KEYDEF('VARASTIG')
        CALL KEYDEF('VARCOMA')
        CALL KEYDEF('FITPSLOPE')
        CALL KEYDEF('FITPLOC')
        CALL KEYDEF('FITPSIZE')
#ifdef NEWSUM
        CALL KEYDEF('FITPQE')
#endif
        CALL KEYDEF('FOCVAR=')
        CALL KEYDEF('SPHVAR=')
        CALL KEYDEF('TREVAR=')
        CALL KEYDEF('ASTIGVAR=')
        CALL KEYDEF('COMAVAR=')
        CALL KEYDEF('DUMP=')
        CALL KEYDEF('SPEC=')
        CALL KEYDEF('HAVESPEC')
        CALL KEYDEF('RESOLVE')
        CALL KEYDEF('RESOLVE=')
        CALL KEYDEF('JITTER=')
        CALL KEYDEF('JITLIS=')
        CALL KEYDEF('JITSIG=')
        CALL KEYDEF('JITBUF=')
        CALL KEYDEF('JITSCALE=')
        CALL KEYDEF('ITEST=')
        CALL KEYDEF('MAP=')
        CALL KEYDEF('NDIM=')
        CALL KEYDEF('NSUB=')
        CALL KEYDEF('REVERSE')
        CALL KEYDEF('SFLIP')
        CALL KEYDEF('TFLIP')
        CALL KEYDEF('SKY=')
        CALL KEYDEF('EXP=')
        CALL KEYDEF('DX=')
        CALL KEYDEF('DY=')
        CALL KEYDEF('DZ2F=')
        CALL KEYDEF('DZ3F=')
        CALL KEYDEF('NEWSMEAR')

C Keyword initialization
        NDIM = 256
        FITRAD = 3
        WAVE(1) = 5500.E-10
        WEIGHT(1) = 1.
        IBX = 0
        IPSF = 0
        IWRITE = 0
        SUB = .FALSE.
        RN = 6.
        GAIN = 14.
        HAVEFILT = .FALSE.
        HAVEOUT = .FALSE.
        HAVEPHOT = .FALSE.
        IPHOT(1) = 1
        IPHOT(2) = 0
        X(1) = -1
        Y(1) = -1
        HAVEZ22 = .FALSE.
        MAXITER = 50
	HIGHBAD = 32767
	LOWBAD = -32767
        NSAMP = 4
        FOCSLOPE = .FALSE.
        VARASTIG = .FALSE.
        VARCOMA = .FALSE.
        FITPSLOPE = .FALSE.
        FITPLOC = .FALSE.
        FITPSIZE = .FALSE.
        FITPQE = .FALSE.
	HAVEDUMP = .FALSE.
	SPECSTART = 0.
	HAVESPEC = .FALSE.
	RESOLVE = .FALSE.
        RESOLVE0 = 0.1
        HAVEJIT = .FALSE.
        HAVEJITLIS = .FALSE.
        HAVEGAUSS = .FALSE.
        REVERSE = .FALSE.
        SFLIP = .FALSE.
        TFLIP = .FALSE.
        IMAP = 1
        JITBUF = 0
        JITSCALE = 1.
        ITEST = 0
        NSUB = 3
        SKY0 = 0.
        NDZ2F = 0
        NDZ3F = 0
        NDX = 0
        NDY = 0
        NEXP = 0
        NEWSMEAR = .FALSE.

        LOCK(1) = .TRUE.
        LPAR(1) = 0.0
        DO 4501 I=2,MAXPAR
          LOCK(I) = .FALSE.
          LPAR(I) = 0.0
4501    CONTINUE
        LPAR(MAXZER+1) = 0.8
        LPAR(MAXZER+2) = 0.04
        LPAR(MAXZER+3) = 0.04
        LPAR(MAXZER+4) = 2
        LPAR(MAXZER+5) = 2
        LPAR(MAXZER+NSMOOTH+1) = 1000.
        LPAR(MAXZER+NSMOOTH+2) = 0.0

        DO 4502 I=1,10
          IF (I .LE. 5) THEN
            FOCVAR(I) = 0.
            SPHVAR(I) = 0.
          END IF
          COMAVAR(I) = 0.
          ASTIGVAR(I) = 0.
          TREVAR(I) = 0.
4502    CONTINUE
      
C  Set keyword values
        DO 5501 I=1,NCON
          TWORD = WORD(I)
          L = UPPER(TWORD)
          IF (TWORD(1:5) .EQ. 'WAVE=') THEN
            CALL ASSIGN(WORD(I),WAVE,PARM)
            IF (XERR) RETURN
            WAVE(1) = WAVE(1)*1.E-10
          ELSE IF (TWORD(1:5) .EQ. 'NDIM=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            NDIM = NINT(TMP)
          ELSE IF (TWORD(1:4) .EQ. 'CAM=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            ICAM = NINT(TMP)
          ELSE IF (TWORD(1:4) .EQ. 'RAD=') THEN
            CALL ASSIGN(WORD(I),FITRAD,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:2) .EQ. 'X=') THEN
            CALL ASSIGN(WORD(I),X,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:2) .EQ. 'Y=') THEN
            CALL ASSIGN(WORD(I),Y,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:4) .EQ. 'PSF=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            IPSF = NINT(TMP)
          ELSE IF (TWORD(1:7) .EQ. 'IWRITE=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            IWRITE = NINT(TMP)
          ELSE IF (TWORD(1:3) .EQ. 'RN=') THEN
            CALL ASSIGN(WORD(I),RN,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:5) .EQ. 'GAIN=') THEN
            CALL ASSIGN(WORD(I),GAIN,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:8) .EQ. 'HIGHBAD=') THEN
            CALL ASSIGN(WORD(I),HIGHBAD,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:7) .EQ. 'LOWBAD=') THEN
            CALL ASSIGN(WORD(I),LOWBAD,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:8) .EQ. 'MAXITER=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            MAXITER = NINT(TMP)
          ELSE IF (TWORD(1:6) .EQ. 'NSAMP=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            NSAMP = NINT(TMP)
          ELSE IF (TWORD(1:5) .EQ. 'LOCK=') THEN
            CALL ASSIGNV(WORD(I),2,VV,NV,PARM)
            IF (XERR) RETURN
            IF (NV .NE. 2) THEN
              XERR = .TRUE.
              PRINT *, 'Error in LOCK keyword...'
              RETURN
            END IF
            IF (VV(1) .GT. 0) LOCK(NINT(VV(1))) = .TRUE.
            VV(1) = ABS(VV(1))
            LPAR(NINT(VV(1))) = VV(2)
          ELSE IF (TWORD .EQ. 'SUB') THEN
            SUB = .TRUE.
          ELSE IF (TWORD .EQ. 'PHOT') THEN
            HAVEPHOT = .TRUE.
          ELSE IF (TWORD(1:6) .EQ. 'STARS=') THEN
            CALL ASSIGNV(WORD(I),2,IPHOT,NPHOT,PARM)
	    IF (XERR) RETURN
          ELSE IF (TWORD(1:5) .EQ. 'FILT=') THEN
            HAVEFILT = .TRUE.
            FILT = WORD(I)(6:)
          ELSE IF (TWORD(1:4) .EQ. 'OUT=') THEN
            HAVEOUT = .TRUE.
            OUTFILE = WORD(I)(5:)
            OPEN(7,FILE=OUTFILE,STATUS='UNKNOWN')
          ELSE IF (TWORD(1:4) .EQ. 'Z22=') THEN
            CALL ASSIGN(WORD(I),Z22,PARM)
            IF (XERR) RETURN
            HAVEZ22 = .TRUE.
          ELSE IF (TWORD .EQ. 'FOCSLOPE') THEN
            FOCSLOPE = .TRUE.
          ELSE IF (TWORD .EQ. 'VARASTIG') THEN
            VARASTIG = .TRUE.
          ELSE IF (TWORD .EQ. 'VARCOMA') THEN
            VARCOMA = .TRUE.
          ELSE IF (TWORD .EQ. 'FITPSLOPE') THEN
            FITPSLOPE = .TRUE.
          ELSE IF (TWORD .EQ. 'FITPLOC') THEN
            FITPLOC = .TRUE.
          ELSE IF (TWORD .EQ. 'FITPSIZE') THEN
            FITPSIZE = .TRUE.
          ELSE IF (TWORD .EQ. 'FITPQE') THEN
            FITPQE = .TRUE.
          ELSE IF (TWORD(1:7) .EQ. 'FOCVAR=') THEN
            CALL ASSIGNV(WORD(I),5,FOCVAR,N,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:7) .EQ. 'SPHVAR=') THEN
            CALL ASSIGNV(WORD(I),5,SPHVAR,N,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:7) .EQ. 'TREVAR=') THEN
            CALL ASSIGNV(WORD(I),10,TREVAR,N,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:9) .EQ. 'ASTIGVAR=') THEN
            CALL ASSIGNV(WORD(I),10,ASTIGVAR,N,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:8) .EQ. 'COMAVAR=') THEN
            CALL ASSIGNV(WORD(I),10,COMAVAR,N,PARM)
            IF (XERR) RETURN
	  ELSE IF (TWORD(1:5) .EQ. 'DUMP=') THEN
            LL = INDEX(WORD(I)(6:),' ') - 1
            OPEN(3,FILE=WORD(I)(6:LL+6),STATUS='OLD',IOSTAT=IERR)
            IF (IERR .NE. 0) THEN
              PRINT *, 'Error opening dump file ', WORD(I)(6:LL+6)
              XERR = .TRUE.
              RETURN
            END IF
	    HAVEDUMP = .TRUE.
	  ELSE IF (TWORD(1:5) .EQ. 'SPEC=') THEN
            CALL ASSIGN(WORD(I),SPECSTART,PARM)
	    IF (XERR) RETURN
	  ELSE IF (TWORD(1:8) .EQ. 'HAVESPEC') THEN
            HAVESPEC = .TRUE.
	  ELSE IF (TWORD(1:8) .EQ. 'RESOLVE=') THEN
            RESOLVE = .TRUE.
            CALL ASSIGN(WORD(I),RESOLVE0,PARM)
            IF (XERR) RETURN
	  ELSE IF (TWORD(1:7) .EQ. 'RESOLVE') THEN
            RESOLVE = .TRUE.
	  ELSE IF (TWORD(1:7) .EQ. 'JITTER=') THEN
            HAVEJIT = .TRUE.
            JITFILE(1) = WORD(I)(8:)
	  ELSE IF (TWORD(1:7) .EQ. 'JITLIS=') THEN
            HAVEJITLIS = .TRUE.
            JITLIS = WORD(I)(8:)
	  ELSE IF (TWORD(1:7) .EQ. 'JITSIG=') THEN
            HAVEGAUSS = .TRUE.
            CALL ASSIGN(WORD(I),GAUSS,PARM)
            IF (XERR) RETURN
	  ELSE IF (TWORD(1:7) .EQ. 'JITBUF=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            JITBUF = NINT(TMP)
	  ELSE IF (TWORD(1:9) .EQ. 'JITSCALE=') THEN
            CALL ASSIGN(WORD(I),JITSCALE,PARM)
            IF (XERR) RETURN
	  ELSE IF (TWORD(1:6) .EQ. 'ITEST=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            ITEST = NINT(TMP)
	  ELSE IF (TWORD(1:4) .EQ. 'MAP=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            IMAP = NINT(TMP)
	  ELSE IF (TWORD(1:5) .EQ. 'NSUB=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            NSUB = NINT(TMP)
	  ELSE IF (TWORD(1:4) .EQ. 'SKY=') THEN
            CALL ASSIGN(WORD(I),SKY0,PARM)
            IF (XERR) RETURN
	  ELSE IF (TWORD(1:7) .EQ. 'REVERSE') THEN
            REVERSE = .TRUE.
	  ELSE IF (TWORD(1:5) .EQ. 'SFLIP') THEN
            SFLIP = .TRUE.
	  ELSE IF (TWORD(1:5) .EQ. 'TFLIP') THEN
            TFLIP = .TRUE.
	  ELSE IF (TWORD(1:8) .EQ. 'NEWSMEAR') THEN
            NEWSMEAR = .TRUE.
          ELSE IF (TWORD(1:4) .EQ. 'EXP=') THEN
            CALL ASSIGNV(WORD(I),MAXFRM,EXPOS,NEXP,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:3) .EQ. 'DX=') THEN
            CALL ASSIGNV(WORD(I),MAXFRM,DX,NDX,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:3) .EQ. 'DY=') THEN
            CALL ASSIGNV(WORD(I),MAXFRM,DY,NDY,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:5) .EQ. 'DZ2F=') THEN
            CALL ASSIGNV(WORD(I),MAXFRM,DZ2F,NDZ2F,PARM)
            IF (XERR) RETURN
          ELSE IF (TWORD(1:5) .EQ. 'DZ3F=') THEN
            CALL ASSIGNV(WORD(I),MAXFRM,DZ3F,NDZ3F,PARM)
            IF (XERR) RETURN
          END IF
5501    CONTINUE

C    Check for invalid keywords
        IF (.NOT. KEYCHECK()) THEN
          XERR = .TRUE.
          RETURN
        END IF

C    Get the image locations
	NFRAMES = NINTS
        IF (NEXP .NE. 0 .AND. NEXP .NE. NFRAMES) THEN
            PRINT *, 'Wrong number of exptimes specified'
	    XERR = .TRUE.
            RETURN
        END IF
        IF (NDX .NE. 0 .AND. NDX .NE. NFRAMES) THEN
            PRINT *, 'Wrong number of dx specified'
	    XERR = .TRUE.
            RETURN
        END IF
        IF (NDY .NE. 0 .AND. NDY .NE. NFRAMES) THEN
            PRINT *, 'Wrong number of dy specified'
	    XERR = .TRUE.
            RETURN
        END IF
        IF (NDZ2F .NE. 0 .AND. NDZ2F .NE. NFRAMES) THEN
            PRINT *, 'Wrong number of dz2f specified'
	    XERR = .TRUE.
            RETURN
        END IF
        IF (NDZ3F .NE. 0 .AND. NDZ3F .NE. NFRAMES) THEN
            PRINT *, 'Wrong number of dz3f specified'
	    XERR = .TRUE.
            RETURN
        END IF

	DO IFRAME=1,NFRAMES
          LOCDATA(IFRAME) = IMLOC(IBUF(IFRAME))
          NX(IFRAME) = ICOORD(NNCOL,IBUF(IFRAME))
          NY(IFRAME) = ICOORD(NNROW,IBUF(IFRAME))
          NROW = NY(IFRAME)
          NCOL = NX(IFRAME)
          IF (NX(IFRAME) .NE. NX(1) .OR. NY(IFRAME) .NE. NY(1)) THEN
            PRINT *, 'All frames must be the same size'
            XERR = .TRUE.
            RETURN
          END IF
          IF (NEXP .EQ. 0) EXPOS(IFRAME) = 1.
          IF (NDX .EQ. 0) DX(IFRAME) = 0.
          IF (NDY .EQ. 0) DY(IFRAME) = 0.
          IF (NDZ2F .EQ. 0) DZ2F(IFRAME) = 0.
          IF (NDZ3F .EQ. 0) DZ3F(IFRAME) = 0.
	END DO


C    Check FFT array dimensions
        IF (NDIM .NE. 128 .AND. NDIM .NE. 256 .AND. NDIM .NE. 512
     &     .AND. NDIM .NE. 1024) THEN
          PRINT *, 'Illegal value of NDIM: ', NDIM
          XERR = .TRUE.
          RETURN
        END IF

C    Check fitting radius
        IF (2*FITRAD+3 .GT. MAXPSFSIZE) THEN
          PRINT *, 'Must use smaller fitting radius'
          XERR = .TRUE.
          RETURN
        END IF

C    Check for legal combinations for parameter variation
        IF (FOCSLOPE .AND. LOCK(4)) THEN
          PRINT *, 'Cant fit focus slopes without fitting focus'
          XERR = .TRUE.
          RETURN
        END IF

        IF (VARASTIG .AND. (LOCK(5) .OR. LOCK(6))) THEN
          PRINT *, 'Cant fit astig slopes without fitting astig'
          XERR = .TRUE.
          RETURN
        END IF

        IF (VARCOMA .AND. (LOCK(7) .OR. LOCK(8))) THEN
          PRINT *, 'Cant fit coma slopes without fitting coma'
          XERR = .TRUE.
          RETURN
        END IF

C    Check if output buffer is specified if write option is given
        IF (IWRITE .NE. 0 .AND. IPSF .LE. 0 .OR. IPSF .GT. MAXIM) THEN
          PRINT *, 'You must specify a legal output buffer with PSF= '
          PRINT *, '  if you are using the IWRITE option! '
          XERR = .TRUE.
          RETURN
        END IF

C    Load the weighting array with jitter information if given
        NJIT = 0
        IF (HAVEJIT) NJIT=NJIT+1
        IF (HAVEJITLIS) NJIT=NJIT+1
        IF (HAVEGAUSS) NJIT=NJIT+1
        IF (NJIT .GT. 1) THEN
          PRINT *, 
     &       'Cant specify more than one of JITTER=, JITLIS=, JITSIG='
          XERR = .TRUE.
          RETURN
        END IF

#ifdef NEWJIT
        IF (MOD(NSAMP,2) .EQ. 0) THEN
          PRINT *, 'Must use an odd NSAMP'
C          XERR  = .TRUE.
C          RETURN
        END IF
#else
        IF (MOD(NSAMP,2) .EQ. 1) THEN
          PRINT *, 'Must use an even NSAMP'
          NSAMP = NSAMP - 1
C	  XERR  = .TRUE.
C          RETURN
        END IF
#endif
        IF (NJIT .GT. 0 .AND. 2*NSAMP .GT. SSIZE) THEN
          PRINT *, 'NSAMP too big for jitter array'
          XERR = .TRUE.
          RETURN
        END IF
        IF (HAVEJITLIS) THEN
          NJIT=NFRAMES
          L = INDEX(JITLIS,' ') -1
          OPEN(2,FILE=JITLIS(1:L),STATUS='unknown',IOSTAT=IERR)
          IF (IERR .NE. 0) THEN
            PRINT *, 'Error opening file: ', JITLIS
            XERR = .TRUE.
            RETURN
          END IF
	  DO I=1,NJIT
            READ(2,'(A)',ERR=999) JITFILE(I)
	  END DO
	  CLOSE(2)
          HAVEJIT = .TRUE.
          GOTO 1000

999       PRINT *, 'Error reading correct number of entries from JITLIS file'
	  CLOSE(2)
	  XERR = .TRUE.
	  RETURN
        ELSE
          NJIT = 1
        END IF

1000    CONTINUE
	DO IJIT = 1, NJIT
          CALL READJITTER(JITFILE(IJIT),ICAM,NSAMP,WJ(-SSIZE,-SSIZE,IJIT),
     &      SSIZE,HAVEJIT,HAVEGAUSS,GAUSS,NWX(IJIT),NWY(IJIT))
          if (nwx(ijit) .lt. 0 .or. nwy(ijit) .lt. 0) then
            PRINT *, 'Error with jitter file: ', JITFILE(IJIT)
            XERR = .TRUE.
            RETURN
          end if
	  print *, 'nwx, nwy: ', nwx(ijit), nwy(ijit)
	  do i=-nwy(ijit)/2,nwy(ijit)/2
            print 111, (wj(j,i,ijit),j=-nwx(ijit)/2,nwx(ijit)/2)
          end do
        END DO

111     format(21f7.4)
        IF (JITBUF .NE. 0) THEN
          ITMP = IBUF(1)
          IBUF(1) = ABS(JITBUF)
          TEMPHEAD = 'END '
          CALL LHEADSET('SIMPLE',.TRUE.,TEMPHEAD)
          CALL INHEADSET('BITPIX',-32,TEMPHEAD)
          CALL INHEADSET('NAXIS',2,TEMPHEAD)
          CALL INHEADSET('NAXIS1',NWX(1),TEMPHEAD)
          CALL INHEADSET('NAXIS2',NWY(1),TEMPHEAD)
          CALL INHEADSET('CRVAL1',-NWX(1)/2,TEMPHEAD)
          CALL INHEADSET('CRVAL2',-NWY(1)/2,TEMPHEAD)
          NP = 1
          CALL CREATEIM(LOCATION,KSR,KER,KSC,KEC,NP,TEMPHEAD,.TRUE.)
          CALL CCLOADJIT(LOCATION,KSR,KER,KSC,KEC,WJ,-SSIZE,SSIZE)
          IBUF(1) = ITMP
	  IF (JITBUF .LT. 0) RETURN
        END IF
	if (icam .le. 0) return

C    Get the wavelengths to calculate at if a filter was specified
        NWAVE = 1
        IF (HAVEFILT) THEN
          L = INDEX(FILT,' ') - 1
          FILTNAME = FSTRCAT('wfpc2cal/filters/',FILT(1:L))
          OPEN(2,FILE=FILTNAME,STATUS='OLD',IOSTAT=IERR)
          IF (IERR .NE. 0) THEN
            PRINT *, 'Error opening file: ', FILTNAME
            XERR = .TRUE.
            RETURN
          END IF
          I = 1
232       READ(2,*,END=233) WF(I), WT(I)
          I = I + 1
          GOTO 232
233       CLOSE(2)
          NF = I - 1

C    Now get the system response, interpolate it to the filter throughput
C      points, and multiply it in. Find the wavelengths where thoughput
C      drops to 0.05*peak and split this wavelength range into MAXWAVE
C      sections. Get the throughput at each one of the new intemediate points.
C      Calculate the weights at each of these points for a Simpsons 
C      integrations.
          OPEN(2,FILE='wfpc2cal/response/system',STATUS='OLD',IOSTAT=IERR)
          IF (IERR .NE. 0) THEN
            PRINT *, 'Error opening system response file '
            XERR = .TRUE.
            RETURN
          END IF
          I = 1
234       READ(2,*,END=235)  W(I), AA(I)
          I = I + 1
          GOTO 234
235       CLOSE(2)

          QMAX = 0.
          NWAVE = MAXWAVE 
          WWTOT = 0.
          DO J=1, NF
            CALL LININT(W,AA,I-1,WF(J),WW)
            WW = WW*WT(J)
            QMAX = MAX(QMAX,WW)
          END DO

	  WMIN = 1.E10
	  WMAX = -1.E10
          DO J=1,NF
            CALL LININT(W,AA,I-1,WF(J),WW)
            WW = WW*WT(J)/QMAX
            IF (WW .GT. 0.05) THEN
              WMIN = MIN(WMIN,WF(J))
              WMAX = MAX(WMAX,WF(J))
            END IF
          END DO
          DW = (WMAX-WMIN)/MAXWAVE
	  DO J = 1, MAXWAVE
            WAVE(J) = WMIN+DW/2+(J-1)*DW
            CALL LININT(WF,WT,NF,WAVE(J),WW)
            CALL LININT(W,AA,I-1,WAVE(J),WWW)
            IF (I .EQ. 1 .OR. I .EQ. NWAVE) THEN
              SIMP = 1./3.
            ELSE IF (MOD(I,2) .EQ. 0) THEN
              SIMP = 4./3.
            ELSE
              SIMP = 2./3.
            END IF
            WEIGHT(J) = WW*WWW*SIMP
            WWTOT = WWTOT + WEIGHT(J)
          END DO
          DO I=1,NWAVE
            WAVE(I) = WAVE(I) * 1.E-10
            WEIGHT(I) = WEIGHT(I) / WWTOT
          END DO

        ELSE
C         If monochromatic, dont fit for spectrum slope!
          HAVESPEC = .FALSE.

        END IF

	IF (NWAVE .GT. MAXWAVE) THEN
          PRINT *, 'Error: too many wavelengths...'
          XERR = .TRUE.
          RETURN
        END IF

C  Get the location(s) of the star(s) to fit
        IF (HAVEPHOT) THEN
          IF (IPHOT(2) .NE. 0) THEN
            I1 = NINT(IPHOT(1))
            I2 = NINT(IPHOT(2))
          ELSE
            I1 = 1 
            I2 = NSTARS
          END IF
          IF (I2-I1+1 .GT. MAXSTAR) THEN
            PRINT *, 'Only using first ', MAXSTAR, '  stars'
            I2 = I1 + MAXSTAR - 1
          END IF
          II = 1
          DO I=I1,I2
            CALL GETPHOTREC(LABEL,PHOT,I)
            X(II) = PHOT(COLLOC)
            Y(II) = PHOT(ROWLOC)
	if (abs(iwrite) .eq. 99) then
            x(ii) = nint(x(ii))
            y(ii) = nint(y(ii))
        end if
            II = II + 1
          END DO
          NSTAR = I2-I1+1
        ELSE IF (X(1) .GT. 0 .AND. Y(1) .GT. 0) THEN
          NSTAR = 1
          X(1) = X(1) - IMAGESC + 1
          Y(1) = Y(1) - IMAGESR + 1
        ELSE
          PRINT *, 'You must specify a stellar position with X= Y= or PHOT..'
	  XERR = .TRUE.
	  RETURN
        END IF

	IF (FITPSLOPE .AND. FITPSIZE .AND. NSTAR .LT. 2) THEN
          PRINT *, 'Cant fit for pupil function with only one star'
	  XERR = .TRUE.
	  RETURN
        END IF

C  Allocate big arrays for phase retreival
        CALL CCALLOC(4*2*NDIM*NDIM*(MAXZER+6+NSMOOTH+NGPAR),LOC1)
	IF (LOC1 .EQ. 0) THEN
          PRINT *, 'cant allocate memory.'
          PRINT *, 'enter new maxzer+6 to allocate: '
          READ *, itemp
          CALL CCALLOC(4*2*NDIM*NDIM*ITEMP,LOC1)
        END IF
        CALL CCALLOC(4*2*NDIM*NDIM,LOC2)
        CALL CCALLOC(4*2*NDIM*NDIM*3,LOCS)
#ifdef __BIGMEM
        CALL CCALLOC(4*NDIM*NDIM*MAXWAVE*MAXSTAR,LOCX)
#else
        CALL CCALLOC(4*NDIM*NDIM,LOCX)
#endif
        CALL CCALLOC(4*NDIM*NDIM,LOCW)
        N1 = 2
        N2 = NDIM
        N3 = NDIM
        N4 = MAXZER+6+NSMOOTH+NGPAR
        N5 = MAXWAVE
        N6 = MAXSTAR

C  Allocate output array if required and send off to phase retrieval 
C    subroutine for all the work
        IF (IPSF .GT. 0) THEN
          ITMP = IBUF(1)
          IBUF(1) = IPSF
          TEMPHEAD = 'END '
          CALL LHEADSET('SIMPLE',.TRUE.,TEMPHEAD)
          CALL INHEADSET('BITPIX',-32,TEMPHEAD)
          CALL INHEADSET('NAXIS',2,TEMPHEAD)
          CALL INHEADSET('NAXIS1',NDIM,TEMPHEAD)
          CALL INHEADSET('NAXIS2',NDIM,TEMPHEAD)
          CALL INHEADSET('CRVAL1',1,TEMPHEAD)
          CALL INHEADSET('CRVAL2',1,TEMPHEAD)
          NP = 1
          CALL CREATEIM(LOCATION,KSR,KER,KSC,KEC,NP,TEMPHEAD,.TRUE.)
C          CALL CCPHASERET(A,IMAGEEC-IMAGESC+1,IMAGEER-IMAGESR+1,
          CALL CCPHASERET(LOCDATA,NCOL,NROW,NFRAMES,DX,DY,DZ2F,DZ3F,EXPOS,
     &     WAVE,WEIGHT,NWAVE,X,Y,NSTAR,SKY0,ICAM,FITRAD,IWRITE,NSAMP,
     &     LOCATION,KSR,KER,KSC,KEC,IBUF(1),LOC1,LOC2,LOCS,LOCX,LOCW,
     &     N1,N2,N3,N4,N5,N6)
          IBUF(1) = ITMP
        ELSE
C          CALL CCPHASERET(A,IMAGEEC-IMAGESC+1,IMAGEER-IMAGESR+1,
          LOCATION = 0
          CALL CCPHASERET(LOCDATA,NCOL,NROW,NFRAMES,DX,DY,DZ2F,DZ3F,EXPOS,
     &     WAVE,WEIGHT,NWAVE,X,Y,NSTAR,SKY0,ICAM,FITRAD,IWRITE,NSAMP,
     &     LOCATION,IDUM,IDUM,IDUM,IDUM,IDUM,LOC1,LOC2,LOCS,LOCX,LOCW,N1,N2,N3,N4,N5,N6)
        END IF

        CALL CCFREE(4*2*NDIM*NDIM*(MAXZER+6+NSMOOTH+NGPAR),LOC1)
        CALL CCFREE(4*2*NDIM*NDIM,LOC2)
        CALL CCFREE(4*2*NDIM*NDIM*3,LOCS)
#ifdef __BIGMEM
        CALL CCFREE(4*NDIM*NDIM*MAXWAVE*MAXSTAR,LOCX)
#else
        CALL CCFREE(4*NDIM*NDIM,LOCX)
#endif
        CALL CCFREE(4*NDIM*NDIM,LOCW)

        RETURN
        END

C  Subroutine that does all the work!

  	subroutine phaseret(locdata,ncol,nrow,nframes,dxf,dyf,dz2f,dz3f,expos,wave,weight,nwave,
     &        x,y,nstar,sky0,icam,fitrad,iwrite,nsamp,out,ksr,ker,ksc,kec,outbuf,
     &        dfft,fft,smear,inten,phase,n1,n2,n3,n4,n5,n6)

        implicit none

        include 'vistadisk/source/include/vistalink.inc'
      
	integer nsmooth
	parameter(nsmooth = __NSMOOTH)
        integer maxzer,maxpar,ndim,iwrite,ksr,ker,ksc,kec,nwave,nstar,maxspar
        integer maxstar,maxwave,ndim2,istar,n1,n2,n3,n4,n5,n6,maxpsfsize,nspar, is
	integer outbuf, ngpar, nframes
	integer*8 locdata(nframes)
	real dxf(nframes), dyf(nframes), expos(nframes)
	real dz2f(nframes), dz3f(nframes)
	parameter (maxzer=__MAXZER,maxwave=__MAXWAVE, ngpar=__NGPAR)
        parameter (maxstar=__MAXSTAR, maxspar=__MAXSPAR+ngpar)
	integer maxfrm, maxfpar
        parameter (maxfrm=__MAXFRM, maxfpar=__MAXFPAR)
	parameter (maxpar = MAXZER+NSMOOTH+MAXSTAR*MAXSPAR+29+MAXFRM*MAXFPAR+121)
	parameter (maxpsfsize = __MAXPSFSIZE)
	real maxchange, pi
	parameter (maxchange = __MAXCHANGE, pi=PI)
        real out(ksc:kec,ksr:ker)
	real dz4f(maxfrm)

        integer i, j, k, niter, npar, icam, ncol, nrow, ix, iy, izer, jzer, ipar
	integer ifft, ipsf, nfpar, iframe, nn(2), ns(nsmooth)
C        real a(ncol,nrow)
	real data
	real fitrad, fitrad2, x(nstar), y(nstar), xx, yy, xxx, w0
        real z(maxzer), wave(nwave), radius(maxwave), weight(nwave), ww, wtot
	real zvar(0:5,maxzer)
	real radx(maxwave), rady(maxwave), sig(maxstar,ngpar+1)
        real zern, sumres2(0:maxfrm), dx, dy, z2(maxstar), z3(maxstar), spec(maxstar)
        real alp(maxpar,maxpar), beta(maxpar), dp(maxpar), clamp(maxpar)
        real alpold(maxpar,maxpar), betaold(maxpar), zold(maxzer), dpold(maxpar)
        real sumres2old(0:maxfrm), lambda, sig2, scaleold, scale(maxstar), drv(maxpar)
        real lpar(maxpar), pupslope, pupsize, xc, yc
        logical lock(maxpar), redo, sub, haveout, verbose

        integer ist, nzer, iwave, iii, jjj, nsamp
#ifdef __BIGMEM
        real inten(n2,n3,n5,n6)
#else
        real inten(n2,n3)
#endif
        real phase(n2,n3)
        real dfft(n1,n2,n3,n4), fft(n1,n2,n3)
        real smear(n1,n2,n3,3), gnorm
        real psf(maxpsfsize,maxpsfsize,maxstar,maxfrm)
        real dpsf(maxpsfsize,maxpsfsize,maxpar)
        real model, eps, sky(maxstar), sky0
        real diff, sumpsf, getdpsf, tpsf, pqepsf
  	real s(11)
	integer nz4, nz5, nz6, nz7, nz8, iextra, nextra, islope, ifact
        real par(maxpar), parold(maxpar)
	integer maxsamp
        parameter (maxsamp = 31)
	real pqe(maxsamp,maxsamp)

        real rn, gain, rng, smpar(nsmooth), highbad, lowbad, trevar(10), slope(5)
	real focvar(5), sphvar(5), astigvar(10), comavar(10), specstart, resolve0
        integer maxiter
	logical focslope, varastig, varcoma, fitpslope, fitploc, fitpsize, fitpqe
	logical havedump, havespec, resolve
        common /param/ sub, rn, gain, lock, lpar, maxiter, haveout, 
     &       highbad, lowbad, focslope, varastig, varcoma, 
     &       fitpslope, fitploc, fitpsize, fitpqe, havedump, havespec, specstart,
     &       resolve, resolve0
        common /abervar/ focvar, astigvar, comavar, sphvar, trevar

	integer iwx, iwy, icx, icy, nwx(maxfrm), nwy(maxfrm), ssize
        integer ngw, ismooth, jsmooth, isamp, jsamp
        parameter(ssize = __SMOOTHSIZE)
	real wj(2*ssize+1,2*ssize+1,maxfrm)
        real gauss(2,-ssize:ssize,-ssize:ssize,ngpar+1)
	real r, theta, ctheta, stheta, gtot(ngpar+1)
	common /jitter/ wj, nwx, nwy
	integer smtype
	real jitscale
        LOGICAL REVERSE, SFLIP, TFLIP, NEWSMEAR, SKIP
	COMMON /REV/ REVERSE, SFLIP, TFLIP, NEWSMEAR, jitscale

	integer itest
	common /getscale/ itest
	character card*80
        INCLUDE 'vistadisk/source/include/imagelink.inc'

	data verbose /.true./

C	Input:
C          data(ncol,nrow): raw data
C          wave:  wavelength
C          x, y:  position in image
C          icam:  camera index
C          fitrad: fitting radius

	if (verbose) print *, 'Top of phaseret'

C   	Starting guess
        niter = 0
        sumres2old(0) = 1e20
        sumres2(0) = 1e20
        lambda = 0.01
        fitrad2 = fitrad**2
        rng = (rn/gain)**2
        ndim = n2
        ndim2 = ndim/2

        if (iwrite .ne. 0) then
	 if (verbose) print *, 'initializing out', nstar
	 do i=ksc,kec
          do j=ksr,ker
            out(i,j) = 0.
	  end do
	 end do
        end if

C   Get first guess at scale factor, assuming 0.9*light in within fitting
C         radius as a good guess
C       Loop over all the stars
        do istar = 1, nstar
	 if (verbose) print *, istar, x(istar), y(istar), expos(1)
         scale(istar) = 0.
         xx=x(istar)+dxf(1)
         yy=y(istar)+dyf(1)
C        Loop over the data points
         do iy=nint(yy)-fitrad-1,nint(yy)+fitrad+1
          dy = iy-yy
          do ix=nint(xx)-fitrad-1,nint(xx)+fitrad+1
            dx = ix-xx
            if (dx**2+dy**2 .le. fitrad2 .and.
     &          ix .ge. 1 .and. iy .ge. 1 .and.
     &          ix .le. ncol .and. iy .le. nrow) then
C            Accumulate scale
C	      data = a(ix,iy)
	      call ccgetdata(locdata(1),ix,iy,ncol,nrow,data)
              if (data .gt. lowbad .and. data .lt. highbad) 
     &          scale(istar)  = scale(istar) + data
            end if
          end do
         end do
         scale(istar) = scale(istar) / 0.9 / expos(1)
         if (scale(istar) .eq. 0) scale(istar) = 1.
         if (iwrite .eq. -3) scale(istar) = 1.
         sky(istar) = sky0
	  if (verbose) print *, istar, expos(1), scale(istar), sky(istar)
        end do
	

C       Next two parameters are for pixel smearing: central pixel fraction
C         and adjacent neighbor fraction
	do i=1,nsmooth
          smpar(i) = lpar(maxzer+i)
        end do

C       Initialize clamps
        do i=1,maxpar
          clamp(i) = 1.
        end do

C       Setup initial parameters

C   Parameter list (including all optional parameters):
C       1-maxzer :  z1 - zmax  (10 usually)
C       maxzer+1   :  smcent
C       maxzer+2   :  smadj(x)
C       maxzer+3   :  smadj(y)
C       maxzer+4   :  smx
C       maxzer+5   :  smy
C       maxzer+nsmooth+(istar-1)*nspar+1  :  scale(istar)
C       maxzer+nsmooth+(istar-1)*nspar+2  :  sky(istar)
C       maxzer+nsmooth+(istar-1)*nspar+3  :  z2(istar)
C       maxzer+nsmooth+(istar-1)*nspar+4  :  z3(istar)
C       maxzer+nsmooth+(istar-1)*nspar+5  :  spectrum slope
C       maxzer+nsmooth+(istar-1)*nspar+6   :  smearing (resolution) width

C	maxzer+nsmooth+nstar*nspar+(iframe-2)*nfpar+1 :  dz2(iframe)
C	maxzer+nsmooth+nstar*nspar+(iframe-2)*nfpar+2 :  dz3(iframe)
C	maxzer+nsmooth+nstar*nspar+(iframe-2)*nfpar+3 :  dz4(iframe)

C       maxzer+nsmooth+nstar*nspar+(nf-1)*nfpar+1..5   :  focus slope terms
C       maxzer+nsmooth+nstar*nspar+(nf-1)*nfpar+6..10  :  z5 slope terms
C       maxzer+nsmooth+nstar*nspar+(nf-1)*nfpar+11..15 :  z6 slope terms
C       maxzer+nsmooth+nstar*nspar+(nf-1)*nfpar+16..20 :  z7 slope terms
C       maxzer+nsmooth+nstar*nspar+(nf-1)*nfpar+21..25 :  z8 slope terms
C       maxzer+nsmooth+nstar*nspar+(nf-1)*nfpar+26   :  pupil slope term
C       maxzer+nsmooth+nstar*nspar+(nf-1)*nfpar+27   :  x pupil center
C       maxzer+nsmooth+nstar*nspar+(nf-1)*nfpar+28   :  y pupil center
C       maxzer+nsmooth+nstar*nspar+(nf-1)*nfpar+29   :  pupil size

        lock(1) = .true.
        lock(2) = .true.
        lock(3) = .true.

        npar = 0
        do izer = 1, maxzer
          if (.not. lock(izer)) then 
            npar = npar + 1           
            par(npar) = lpar(izer)
          end if
          zvar(0,izer) = lpar(izer)
        end do

        do 4551 i = 1, nsmooth
          if (.not. lock(maxzer+i)) then
            npar = npar + 1
	    par(npar) = smpar(i)
          else 
            smpar(i) = lpar(maxzer+i)
          end if
4551    continue
	if (verbose) print *, 'Number of zernike parameters: ', npar
	smtype = 0
	if (smpar(4) .gt. 0 .or. smpar(5) .gt. 0) smtype = 1
#ifdef NEWJIT
        smtype = 1
#endif

C  Dont allow lock of scale, sky, or z2, z3
	nspar = 4
	if (havespec) nspar = nspar + 1
        if (resolve) nspar = nspar + ngpar
        do istar=1,nstar
	  z2(istar) = 0.0
	  z3(istar) = 0.0
	  spec(istar) = specstart
          do i=1,ngpar
            if (resolve) then
              sig(istar,i) = resolve0
C              if (ngpar .gt. 1) then
C                sig(istar,ngpar-1) = 1.
C                sig(istar,ngpar) = 0.
C              end if
            else
              sig(istar,i) = 0.
            end if
          end do
 	  if (havedump) then
            if (.not. havespec) goto 4552
            read(3,*,err=4552) 
     &        xxx,xxx,xxx,scale(istar),sky(istar),z2(istar),z3(istar),spec(istar)
            goto 4553
4552        read(3,*) xxx,xxx,xxx,scale(istar),sky(istar),z2(istar),z3(istar)
4553        continue
          end if	
          npar = npar + 1
          par(npar) = scale(istar)
          npar = npar + 1
          par(npar) = sky(istar)
          npar = npar + 1
          par(npar) = z2(istar)
          npar = npar + 1
          par(npar) = z3(istar)
          if (havespec) then
	    npar = npar + 1
            par(npar) = spec(istar)
          end if
          if (resolve) then
            do i = 1, ngpar
	      npar = npar + 1
              par(npar) = sig(istar,i)
            end do
          end if
	  if (verbose) print *, 'Number of zernike +star parameters: ', npar
        end do
	if (havedump) close(3)

C  Frame shift parameters
        nfpar = 2
	if (.not. lock(4)) nfpar = nfpar + 1
        dz4f(1) = 0.
        do iframe=2,nframes
          npar = npar + 1
	  par(npar) = dz2f(iframe)
          npar = npar + 1
	  par(npar) = dz3f(iframe)
          if (.not. lock(4)) npar = npar + 1
          dz4f(iframe) = 0.
	  par(npar) = dz4f(iframe)
	  if (verbose) print *, 'Number of zernike +star+frame parameters: ', npar
	end do


	pupslope = 5.088e-4*800.
	if (fitpslope) then
          par(npar+1) = 5.088e-4*800.
          npar = npar+1
        end if

C  WFPC2 approximate centers for pupil centering
	if (icam .eq. 1) then
          xc = 380
          yc = 428
        else if (icam .eq. 2) then
          xc = 432
          yc = 398
        else if (icam .eq. 3) then
          xc = 395
          yc = 400
        else if (icam .eq. 4) then
          xc = 390
          yc = 400
        else
          xc = 0
          yc = 0
        end if
        if (itest .eq. 3) then
          xc = 400
          yc = 400
        end if
        if (fitploc) then
          par(npar+1) = xc
          par(npar+2) = yc
          npar = npar + 2
        end if

C  WFPC2 secondary obscuration size
        if (icam .ge. 2 .and. icam .le. 4) then
          pupsize = 0.433
        else if (icam .eq. 1) then
          pupsize = 0.410
        else
          pupsize = 0.
        end if
        if (fitpsize) then
          par(npar+1) = pupsize
          npar = npar + 1
        end if

C  Subpixel qe
        do j=1,nsamp
	  do i=1,nsamp
            pqe(i,j) = 1.
	    if (fitpqe) then
              npar = npar + 1
              par(npar) = pqe(i,j)
            end if
	  end do
	end do

C  Aberration variation parameters
	do i=1,5
	  zvar(i,1) = 0.
	  zvar(i,2) = 0.
	  zvar(i,3) = 0.
	  zvar(i,4) = focvar(i)
          zvar(i,5) = astigvar(i)
          zvar(i,6) = astigvar(i+5)
          zvar(i,7) = comavar(i)
          zvar(i,8) = comavar(i+5)
          zvar(i,9) = trevar(i)
          zvar(i,10) = trevar(i+5)
          zvar(i,11) = sphvar(i)
	end do
	if (focslope) then
          do i=1,5
            npar=npar+1
            par(npar) = zvar(i,4)
	  end do
	end if
	if (varastig) then
          do i=1,5
            npar=npar+1
            par(npar) = zvar(i,5)
	  end do
          do i=1,5
            npar=npar+1
            par(npar) = zvar(i,6)
	  end do
	end if
	if (varcoma) then
          do i=1,5
            npar=npar+1
            par(npar) = zvar(i,7)
	  end do
          do i=1,5
            npar=npar+1
            par(npar) = zvar(i,8)
	  end do
	end if

	w0 = wave(nwave/2+1)

	print *, 'total parameters: ', npar

C       Start the iterations
100     niter = niter + 1

C  Always set z(2) and z(3) to zero since their information is carried
C     along separately for each star and z(2-3) will be set per star below
        z(2) = 0.
        z(3) = 0.

C       Get the phase of the pupil function
        print *, 'NITER: ', niter
        do i=4,maxzer
          if (i .ge. 4 .and. i .le. 11) then
            print 88, i, (zvar(j,i),j=0,5)
          else
            print 88, i, zvar(0,i)
          end if
88        format(i6,6(1pe11.3))
        end do
        print 90, (smpar(is),is=1,nsmooth), smtype
        do i=2,nframes
          print 92, i, dz2f(i), dz3f(i), dz4f(i)
92	  format('frame : ', i3,3(1pe11.3))
	end do
	print 91,  pupslope, xc, yc, pupsize
90	format('  smpars : ', 5f9.3,i3)
91	format('  pupil : ', 4f9.3)
        do istar=1,nstar
	  print 89, istar,scale(istar), sky(istar),
     &              z2(istar), z3(istar), spec(istar), (sig(istar,k),k=1,ngpar)
89        format('  star :', i2,2f8.1,2(1pe11.3),5(0pf9.2))
        end do
        do jsamp = 1, nsamp
            print 95, (pqe(isamp,jsamp),isamp=1,nsamp)
95          format(3x,15f8.2)
        end do


C      Initialize arrays
	do i=0,maxfrm
          sumres2(i) = 0.
	end do
        do i=1,npar
          beta(i) = 0.
          do j=1,i
            alp(j,i) = 0.
          end do
        end do

C      Get fourier transform of smoothing function for this iteration
	if (smpar(4) .gt. 0 .or. smpar(5) .gt. 0) then
          nn(1) = ndim
          nn(2) = ndim
#ifdef NEWJIT
          call makegauss(smear(1,1,1,2),ndim,smpar(4),2)
          call fourn(smear(1,1,1,2),nn,2,1)
#else
          call makegauss(smear,ndim,smpar(4),2)
          call fourn(smear,nn,2,1)
#endif
          ismooth = nint(max(smpar(4)*7,smpar(5)*7))
	  ismooth = 0
	end if

C       Loop over all of the frames
        do 4700 iframe = 1, nframes
          if (nogo) return

#ifdef NEWJIT
C       Get fourier transform of jitter function for this frame
         do j=1,ndim
           do i=1,ndim
             smear(1,i,j,1) = 0.
             smear(2,i,j,1) = 0.
             smear(1,i,j,3) = 0.
             smear(2,i,j,3) = 0.
           end do
         end do
         do j=1,2*ssize+1
           jjj = j-ssize+1
           if (jjj .le. 0) jjj=jjj+ndim
           do i=1,2*ssize+1
             iii = i-ssize+1
             if (iii .le. 0) iii=iii+ndim
             smear(1,iii,jjj,1) = wj(i,j,iframe)
             smear(1,iii,jjj,3) = wj(i,j,iframe)
           end do
         end do
         nn(1) = ndim
         nn(2) = ndim
         call fourn(smear,nn,2,1)
         if (smpar(4) .gt. 0 .or. smpar(5) .gt. 0) then
C         Save another copy for use with derivatives
           call fourn(smear(1,1,1,3),nn,2,1)
           call fullcmul(smear,smear(1,1,1,2),ndim)
         end if
	 ismooth = 0
#endif

C       Loop over all the star positions
         do 4701 istar=1,nstar
           if (nogo) return
C         Zero out the sampled PSF and derivatives
	 xx=x(istar)+nint(dxf(iframe))
	 yy=y(istar)+nint(dyf(iframe))
         jjj = 0
         do iy=nint(yy)-fitrad-3,nint(yy)+fitrad+3
           jjj = jjj+1
           iii = 0
           do ix=nint(xx)-fitrad-3,nint(xx)+fitrad+3
             iii = iii + 1
             psf(iii,jjj,istar,iframe) = 0
             do i=1,maxpar
               dpsf(iii,jjj,i) = 0.
             end do
           end do
         end do

	 call zerloc(xx,yy,zvar,z)
         z(2) = z2(istar)+dz2f(iframe)
         z(3) = z3(istar)+dz3f(iframe)
	 z(4) = z(4)+dz4f(iframe)
         slope(1) = xx-400
         slope(2) = yy-400
         slope(3) = (xx-400)**2
         slope(4) = (yy-400)**2
         slope(5) = (xx-400)*(yy-400)

C  Make integration array with smearing from jitter and/or resolved source
	if (resolve) then
          do k=1,ngpar+1
            gtot(k) =0
          end do
          do j=-ssize,ssize
            do i=-ssize,ssize
              r=i**2+j**2
#ifdef NOTDEF
              if (ngpar .eq. 1) then
#endif
                gauss(1,i,j,1)= exp(-r/2/sig(istar,1)**2)
                gauss(1,i,j,2)= exp(-r/2/(sig(istar,1)+0.5)**2)

C     Modified Hubble law
		gauss(1,i,j,1) = (1 + (r/sig(istar,1))**2 ) ** -1
		gauss(1,i,j,1) = (1 + (r/(sig(istar,1)+0.5))**2 ) ** -1
#ifdef NOTDEF
              else
                gauss(1,i,j,1) = (1 + r/sig(istar,1)**2)
	        gauss(1,i,j,1) = exp(gauss(1,i,j,1)**-sig(istar,3))

                gauss(1,i,j,2) = (1 + r/(sig(istar,1)+0.5)**2)
	        gauss(1,i,j,2) = exp(gauss(1,i,j,2)**-sig(istar,3))

                gauss(1,i,j,3) = (1 + r/sig(istar,1)**2)
	        gauss(1,i,j,3) = exp(gauss(1,i,j,3)**-(sig(istar,3)+0.5))

                theta = sig(istar,4)
                ctheta = cosd(theta)**2
                stheta = sind(theta)**2

                gauss(1,i,j,1)= 
     &            (1+r*ctheta/(sig(istar,1)**2) + r*stheta/(sig(istar,2)**2))
                gauss(1,i,j,1) = exp(gauss(i,j,1)**(-sig(istar,3)))

                gauss(1,i,j,2)= 
     &            (1+r*ctheta/(sig(istar,1)+0.5)**2 + r*stheta/(sig(istar,2)**2))
                gauss(1,i,j,2) = exp(gauss(i,j,2)**(-sig(istar,3)))

                gauss(1,i,j,3)= 
     &            (1+r*ctheta/(sig(istar,1)**2) + r*stheta/(sig(istar,2)+0.5)**2)
                gauss(1,i,j,3) = exp(gauss(i,j,3)**(-sig(istar,3)))

                gauss(1,i,j,4)= 
     &            (1+r*ctheta/(sig(istar,1)**2) + r*stheta/sig(istar,2)**2)
                gauss(1,i,j,4) = exp(gauss(i,j,4)**(-(sig(istar,3)+0.5)))

                theta = sig(istar,4)+10
                ctheta = cosd(theta)**2
                stheta = sind(theta)**2
                gauss(1,i,j,5)= 
     &            (1+r*ctheta/sig(istar,1)**2 + r*stheta/sig(istar,2)**2)
                gauss(1,i,j,5) = exp(gauss(i,j,5)**(-sig(istar,3)))
              end if
#endif
              do k=1,ngpar+1
                gtot(k) = gtot(k) + gauss(1,i,j,k)
              end do
            end do
          end do
          do j=-ssize,ssize
            do i=-ssize,ssize
              do k=1,ngpar+1
                gauss(1,i,j,k)= gauss(1,i,j,k)/gtot(k)
              end do
            end do
          end do
          if (ngpar .eq. 1) then
	    ngw=min(ssize,nint(5*(sig(istar,1)+0.5)))
          else
            ngw=max(nint(5*(sig(istar,1)+0.5)),nint(5*(sig(istar,2)+0.5)))
            ngw=min(ssize,ngw)
          end if
        else
          do j=-ssize, ssize
            do i=-ssize, ssize
              gauss(1,i,j,1) = 0.
            end do
          end do
          gauss(1,0,0,1) = 1.
	  ngw = 0
        end if
        if (abs(iwrite) .eq. 4) then
          do j=1,ndim
            do i=1,ndim
              out(i,j) = 0.
            end do
          end do
          do j=-ssize,ssize
            do i=-ssize,ssize
              out(ndim2+i,ndim2+j) = gauss(1,i,j,1)
            end do
          end do
          if (iwrite .lt. 0) return
        end if

C       Loop over all the input wavelengths

C       Get normalization correct
         wtot = 0
         do iwave=1,nwave
	   ww = weight(iwave) * (wave(iwave)/w0)**spec(istar) 
           wtot = wtot + ww
         end do

         do 4601 iwave = 1, nwave

	   ww = weight(iwave) * (wave(iwave)/w0)**spec(istar) / wtot

C   Get the intensity of the pupil function at the relevant location(s)
#ifdef __BIGMEM
	   if (niter .eq. 1 .or. fitpslope .or. fitploc .or. fitpsize)
     &       call makepupil(inten(1,1,iwave,istar),ndim,icam,
     &             xx,yy,wave(iwave),radius(iwave),
     &             radx(iwave),rady(iwave),nsamp,pupslope,xc,yc,pupsize)
#else
           call makepupil(inten,ndim,icam,
     &           xx,yy,wave(iwave),radius(iwave),
     &           radx(iwave),rady(iwave),nsamp,pupslope,xc,yc,pupsize)
#endif
           if (abs(iwrite) .eq. 1) then
             do j=1,ndim
               do i=1,ndim 
#ifdef __BIGMEM
                 out(i,j) = inten(i,j,iwave,istar)
#else
                 out(i,j) = inten(i,j)
#endif
               end do
             end do
             if (iwrite .lt. 0) return
           end if

C       Make the phase map
#ifdef __BIGMEM
          call makephase(inten(1,1,iwave,istar),phase,ndim,z,
     &          radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
#else
          call makephase(inten,phase,ndim,z,
     &          radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
#endif
          if (abs(iwrite) .eq. 2) then
            do j=1,ndim
              do i=1,ndim 
                out(i,j) = phase(i,j)
              end do
            end do
            if (iwrite .lt. 0) return
          end if

C       Get the PSF in fully sampled form
          if (iwrite .eq. -3) then
            ifact = 0
          else
            ifact = 1
          end if

#ifdef __BIGMEM
          call dofft(fft,inten(1,1,iwave,istar),phase,ndim)
	  if (smtype .eq. 1)
     &      call psfsmooth(fft,ndim,smear,1,ndim,fitrad*nsamp,ismooth)
	  if (resolve)
     &      call psfsmooth(fft,ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
#else
          call dofft(fft,inten,phase,ndim)
	  if (smtype .eq. 1)
     &      call psfsmooth(fft,ndim,smear,1,ndim,fitrad*nsamp,ismooth)
	  if (resolve)
     &      call psfsmooth(fft,ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
#endif
          if (abs(iwrite) .eq. 3) then
            do j=1,ndim
              jjj = mod(j+ndim/2-1,2*ndim/2)+1
              do i=1,ndim 
                iii = mod(i+ndim/2-1,2*ndim/2)+1
                if (iwave .eq. 1) then
                  out(i,j) = expos(iframe)*scale(istar)*fft(1,iii,jjj)*ww
                else
                  out(i,j) = out(i,j) + expos(iframe)*scale(istar)*fft(1,iii,jjj)*ww
                end if
              end do
            end do
            if (iwrite .lt. 0 .and. iwave .eq. nwave) then
              call ccinheadset('MAXZER',maxzer,headbuf(1,outbuf))
	      do i=1,maxzer
                do j=0,5
                  write(card,70) i, j
70	          format('Z',i2.2,'_',i1)
                  call ccfheadset(card,dble(zvar(j,i)),headbuf(1,outbuf))
                end do
              end do
              call ccinheadset('CAMERA',icam,headbuf(1,outbuf))
              call ccinheadset('NSAMP',nsamp,headbuf(1,outbuf))
              call ccfheadset('X',dble(xx),headbuf(1,outbuf))
              call ccfheadset('Y',dble(yy),headbuf(1,outbuf))
              call ccfheadset('PUPSLOPE',dble(pupslope),headbuf(1,outbuf))
              call ccfheadset('PUPXC',dble(xc),headbuf(1,outbuf))
              call ccfheadset('PUPYC',dble(yc),headbuf(1,outbuf))
              call ccfheadset('PUPSIZE',dble(pupsize),headbuf(1,outbuf))
              call ccfheadset('SMCENT',dble(smpar(1)),headbuf(1,outbuf))
              call ccfheadset('SMADJ(X)',dble(smpar(2)),headbuf(1,outbuf))
              call ccfheadset('SMADJ(Y)',dble(smpar(3)),headbuf(1,outbuf))
              call ccinheadset('NWAVE',nwave,headbuf(1,outbuf))
              do i=1,nwave
                write(card,79) i
79	        format('WAVE',i2.2)
                call ccfheadset(card,dble(wave(i)),headbuf(1,outbuf))
                write(card,80) i
80	        format('WEIGHT',i2.2)
                call ccfheadset(card,dble(weight(i)),headbuf(1,outbuf))
              end do
              return
            end if
          end if

C       Get the derivatives in fully sampled form
          nzer = 0
	  nz4 = 0
          do izer = 1, maxzer
            if (.not. lock(izer)) then 
              nzer = nzer + 1           
	      if (izer .eq. 4) nz4 = nzer
              z(izer) = z(izer)+0.01
#ifdef __BIGMEM
              call makephase(inten(1,1,iwave,istar),phase,ndim,z,
     &              radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
              call dofft(dfft(1,1,1,nzer),inten(1,1,iwave,istar),phase,ndim)
	      if (smtype .eq. 1)
     &          call psfsmooth(dfft(1,1,1,nzer),ndim,smear,1,ndim,fitrad*nsamp,ismooth)
	      if (resolve)
     &          call psfsmooth(dfft(1,1,1,nzer),ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
#else
              call makephase(inten,phase,ndim,z,
     &              radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
              call dofft(dfft(1,1,1,nzer),inten,phase,ndim)
	      if (smtype .eq. 1)
     &          call psfsmooth(dfft(1,1,1,nzer),ndim,smear,1,ndim,fitrad*nsamp,ismooth)
	      if (resolve)
     &          call psfsmooth(dfft(1,1,1,nzer),ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
#endif
	      if (abs(iwrite) .eq. 6+nzer) then
                do j=1,ndim
                  do i=1,ndim 
C                    out(i,j) = (dfft(1,i,j,nzer) - fft(1,i,j)) / 0.01
                    out(i,j) = dfft(1,i,j,nzer)
                  end do
                end do
                if (iwrite .lt. 0) return
              end if
              z(izer) = z(izer) - 0.01 
            end if
          end do

C    Get the z2 and z3 derivatives even though they are locked
          do izer=2,3
            z(izer) = z(izer)+0.01
#ifdef __BIGMEM
            call makephase(inten(1,1,iwave,istar),phase,ndim,z,
     &            radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
            call dofft(dfft(1,1,1,nzer+izer-1),inten(1,1,iwave,istar),
     &           phase,ndim)
	    if (smtype .eq. 1)
     &        call psfsmooth(dfft(1,1,1,nzer+izer-1),ndim,smear,1,ndim,fitrad*nsamp,ismooth)
	    if (resolve)
     &        call psfsmooth(dfft(1,1,1,nzer+izer-1),ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
#else
            call makephase(inten,phase,ndim,z,
     &            radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
            call dofft(dfft(1,1,1,nzer+izer-1),inten,phase,ndim)
	    if (smtype .eq. 1)
     &        call psfsmooth(dfft(1,1,1,nzer+izer-1),ndim,smear,1,ndim,fitrad*nsamp,ismooth)
	    if (resolve)
     &        call psfsmooth(dfft(1,1,1,nzer+izer-1),ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
#endif
            z(izer) = z(izer) - 0.01 
          end do

C    Get the pupil slope derivatives if desired
          if (fitpslope) then
            call makepupil(inten,ndim,icam,
     &            xx,yy,wave(iwave),radius(iwave),
     &            radx(iwave),rady(iwave),nsamp,pupslope*1.01,xc,yc,pupsize)
            call makephase(inten,phase,ndim,z,
     &            radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
            call dofft(dfft(1,1,1,nzer+3),inten,phase,ndim)
	    if (smtype .eq. 1)
     &        call psfsmooth(dfft(1,1,1,nzer+3),ndim,smear,1,ndim,fitrad*nsamp,ismooth)
	    if (resolve)
     &        call psfsmooth(dfft(1,1,1,nzer+3),ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
          end if
          if (fitploc) then
            call makepupil(inten,ndim,icam,
     &            xx,yy,wave(iwave),radius(iwave),
     &            radx(iwave),rady(iwave),nsamp,pupslope,xc*1.01,yc,pupsize)
            call makephase(inten,phase,ndim,z,
     &            radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
            call dofft(dfft(1,1,1,nzer+4),inten,phase,ndim)
	    if (smtype .eq. 1)
     &        call psfsmooth(dfft(1,1,1,nzer+4),ndim,smear,1,ndim,fitrad*nsamp,ismooth)
	    if (resolve)
     &        call psfsmooth(dfft(1,1,1,nzer+4),ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
            call makepupil(inten,ndim,icam,
     &            xx,yy,wave(iwave),radius(iwave),
     &            radx(iwave),rady(iwave),nsamp,pupslope,xc,yc*1.01,pupsize)
            call makephase(inten,phase,ndim,z,
     &            radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
            call dofft(dfft(1,1,1,nzer+5),inten,phase,ndim)
	    if (smtype .eq. 1)
     &        call psfsmooth(dfft(1,1,1,nzer+5),ndim,smear,1,ndim,fitrad*nsamp,ismooth)
	    if (resolve)
     &        call psfsmooth(dfft(1,1,1,nzer+5),ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
          end if
          if (fitpsize) then
            call makepupil(inten,ndim,icam,
     &            xx,yy,wave(iwave),radius(iwave),
     &            radx(iwave),rady(iwave),nsamp,pupslope,xc,yc,pupsize*1.01)
            call makephase(inten,phase,ndim,z,
     &            radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
            call dofft(dfft(1,1,1,nzer+6),inten,phase,ndim)
	    if (smtype .eq. 1)
     &        call psfsmooth(dfft(1,1,1,nzer+6),ndim,smear,1,ndim,fitrad*nsamp,ismooth)
	    if (resolve)
     &        call psfsmooth(dfft(1,1,1,nzer+6),ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
          end if
C   Reset pupil if we have modified it
          if (fitploc .or. fitpslope .or. fitpsize) then
            call makepupil(inten,ndim,icam,
     &           xx,yy,wave(iwave),radius(iwave),
     &           radx(iwave),rady(iwave),nsamp,pupslope,xc,yc,pupsize)
          end if
          if (smpar(4) .gt. 0 .and. smpar(5) .gt. 0) then
            call makephase(inten,phase,ndim,z,
     &              radius(iwave),radx(iwave),rady(iwave),wave(iwave),icam)
            do jsmooth = 4,5
              smpar(jsmooth) = smpar(jsmooth)*1.05
	      call makegauss(smear(1,1,1,2),ndim,smpar(4),2)
              call fourn(smear(1,1,1,2),nn,2,1)
#ifdef NEWJIT
              call fullcmul(smear(1,1,1,2),smear(1,1,1,3),ndim)
#endif
              call dofft(dfft(1,1,1,nzer+6+jsmooth-3),inten,phase,ndim)
              call psfsmooth(dfft(1,1,1,nzer+6+jsmooth-3),ndim,smear(1,1,1,2),1,ndim,
     &                       fitrad*nsamp,ismooth)
	      if (resolve)
     &          call psfsmooth(dfft(1,1,1,nzer+6+jsmooth-3),ndim,gauss,-ssize,ssize,ifact*fitrad,ngw)
              smpar(jsmooth) = smpar(jsmooth)/1.05
	      call makegauss(smear(1,1,1,2),ndim,smpar(4),2)
              call fourn(smear(1,1,1,2),nn,2,1)
            end do
          end if
          if (resolve) then
            do k=1,ngpar
              ifft = nzer+6+nsmooth+k
              call dofft(dfft(1,1,1,ifft),inten,phase,ndim)
	      if (smtype .eq. 1)
     &          call psfsmooth(dfft(1,1,1,ifft),ndim,smear,1,ndim,
     &                         fitrad*nsamp,ismooth)
	      if (resolve)
     &          call psfsmooth(dfft(1,1,1,ifft),ndim,gauss,
     &                         -ssize,ssize,ifact*fitrad,ngw)
            end do
          end if

C       Bin down both the PSF and the derivatives to CCD pixel size

C         Loop over CCD pixels in the fit
          jjj = 0
          do iy=nint(yy)-fitrad-3,nint(yy)+fitrad+3
            jjj = jjj+1
            dy = iy-yy
            iii = 0
            do ix=nint(xx)-fitrad-3,nint(xx)+fitrad+3
              iii = iii + 1
              dx = ix-xx
              if (dx**2+dy**2 .le. (fitrad+2)**2) then
#ifdef NEWSUM
        	  tpsf = sumpsf(fft,ndim,dx,dy,nsamp,pqe,maxsamp)
#else
	          tpsf = sumpsf(fft,ndim,dx,dy,smpar,nsmooth,nsamp,wj(1,1,iframe),nwx(iframe),nwy(iframe))
#endif
C        print *, iii, jjj, iwave, ww, tpsf, dx, dy, smpar, nwx(iframe), nwy(iframe),z

                if (abs(iwrite) .eq. 99) out(iii,jjj) = tpsf
                psf(iii,jjj,istar,iframe) = psf(iii,jjj,istar,iframe) + ww * tpsf

C            Derivates wrt Zernikes
                npar = 0
                do izer = 1, maxzer
                  if (.not. lock(izer)) then
                   npar = npar + 1
                   dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) + 
     &              ww * 1. / (.01) * 
#ifdef NEWSUM
     &          (sumpsf(dfft(1,1,1,npar),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &          (sumpsf(dfft(1,1,1,npar),ndim,dx,dy,smpar,nsmooth,nsamp,
     &               wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
                  end if
                end do
C            Derivatives wrt smearing function
	        do jsmooth = 1, nsmooth
C              Pixel smoothing parameters are a special case we have to compute
C               later when we do the pixel smoothing
                 ns(jsmooth) = 0
                 if (.not. lock(maxzer+jsmooth)) then
                  npar = npar + 1
                  if (jsmooth .le. 3) then
                    ns(jsmooth) = npar
#ifdef NEWSUM
                    dpsf(iii,jjj,npar) = psf(iii,jjj,istar,iframe)
#else
	            smpar(jsmooth) = smpar(jsmooth)*1.01
		    dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) +
     &                 ww * 1. / (.01*smpar(jsmooth)) *
     &	       (sumpsf(fft,ndim,dx,dy,smpar,nsmooth,nsamp,wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
	            smpar(jsmooth) = smpar(jsmooth)/1.01
#endif
                  else
                    dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) + 
     &                  ww * 1. / (.05*smpar(jsmooth)) * 
#ifdef NEWSUM
     &          (sumpsf(dfft(1,1,1,nzer+6+jsmooth-3),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &         (sumpsf(dfft(1,1,1,nzer+6+jsmooth-3),ndim,dx,dy,smpar,nsmooth,nsamp,
     &               wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
                  end if
                 end if
                end do
C            Derivatives wrt star parameters (scale, sky, z2, z3)
		do i = 1, nstar
                  if (i .eq. istar) then
                    npar = npar + 1
		    dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) + psf(iii,jjj,istar,iframe)
	            npar = npar + 1
		    dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) + 1.
	            npar = npar + 1
                    dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) + 
     &                  ww * 1. / (.01) * 
#ifdef NEWSUM
     &        (sumpsf(dfft(1,1,1,nzer+1),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &        (sumpsf(dfft(1,1,1,nzer+1),ndim,dx,dy,smpar,nsmooth,nsamp,
     &               wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
	            npar = npar + 1
                    dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) + 
     &                  ww * 1. / (.01) * 
#ifdef NEWSUM
     &        (sumpsf(dfft(1,1,1,nzer+2),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &        (sumpsf(dfft(1,1,1,nzer+2),ndim,dx,dy,smpar,nsmooth,nsamp,
     &               wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
C            Derivative wrt spectrum slope
                    if (havespec) then
                      npar = npar + 1
                      dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) +
     &                  ww * tpsf * log(wave(iwave)/w0)
                    end if
		    if (resolve) then
                      do k=1,ngpar
                       npar = npar + 1
                       if (k .lt. 4) then
                         dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) +
     &                    ww * 1. / .5 *
#ifdef NEWSUM
     &          (sumpsf(dfft(1,1,1,nzer+6+nsmooth+k),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &                (sumpsf(dfft(1,1,1,nzer+6+nsmooth+k),ndim,dx,dy,smpar,
     &                 nsmooth,nsamp,wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
                       else
                         dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) +
     &                    ww * 1. / 10. *
#ifdef NEWSUM
     &          (sumpsf(dfft(1,1,1,nzer+6+nsmooth+k),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &                (sumpsf(dfft(1,1,1,nzer+6+nsmooth+k),ndim,dx,dy,smpar,
     &                 nsmooth,nsamp,wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
                       end if
                      end do
	            end if
	          else
                    npar = npar + 4
 	            if (havespec) npar = npar +1
 	            if (resolve) npar = npar + ngpar
                  end if
                end do
     
C            Derivatives wrt frame shifts
	        do i=2,nframes
                  if (i .eq. iframe) then
	            npar = npar + 1
                    dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) + 
     &                ww * 1. / (.01) * 
#ifdef NEWSUM
     &        (sumpsf(dfft(1,1,1,nzer+1),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &        (sumpsf(dfft(1,1,1,nzer+1),ndim,dx,dy,smpar,nsmooth,nsamp,
     &                wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
	            npar = npar + 1
                    dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) + 
     &                ww * 1. / (.01) * 
#ifdef NEWSUM
     &        (sumpsf(dfft(1,1,1,nzer+2),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &        (sumpsf(dfft(1,1,1,nzer+2),ndim,dx,dy,smpar,nsmooth,nsamp,
     &                wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
                    if (.not. lock(4)) then
                      npar = npar + 1
                      dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) + 
     &                  ww * 1. / (.01) * 
#ifdef NEWSUM
     &        (sumpsf(dfft(1,1,1,nz4),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &        (sumpsf(dfft(1,1,1,nz4),ndim,dx,dy,smpar,nsmooth,nsamp,
     &                  wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
                    end if
                  else
                    npar = npar + 2
	            if (.not. lock(4)) npar = npar + 1
                  end if
                end do
C            Derivative wrt pupil slope
	        if (fitpslope) then
                   npar = npar + 1
                   dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) +
     &              ww * 1. / (.01*pupslope) *
#ifdef NEWSUM
     &        (sumpsf(dfft(1,1,1,nzer+3),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &        (sumpsf(dfft(1,1,1,nzer+3),ndim,dx,dy,smpar,nsmooth,nsamp,
     &               wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
                end if
C            Derivative wrt pupil location
	        if (fitploc) then
                   npar = npar + 1
                   dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) +
     &              ww * 1. / (.01*xc) *
#ifdef NEWSUM
     &        (sumpsf(dfft(1,1,1,nzer+4),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &        (sumpsf(dfft(1,1,1,nzer+4),ndim,dx,dy,smpar,nsmooth,nsamp,
     &               wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
                   npar = npar + 1
                   dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) +
     &              ww * 1. / (.01*yc) *
#ifdef NEWSUM
     &        (sumpsf(dfft(1,1,1,nzer+5),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &        (sumpsf(dfft(1,1,1,nzer+5),ndim,dx,dy,smpar,nsmooth,nsamp,
     &               wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
                end if
C            Derivative wrt pupil size
	        if (fitpsize) then
	            npar = npar + 1
                    dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) +
     &              ww * 1. / (.01*pupsize) *
#ifdef NEWSUM
     &        (sumpsf(dfft(1,1,1,nzer+6),ndim,dx,dy,nsamp,pqe,maxsamp) - tpsf)
#else
     &        (sumpsf(dfft(1,1,1,nzer+6),ndim,dx,dy,smpar,nsmooth,nsamp,
     &               wj(1,1,iframe),nwx(iframe),nwy(iframe)) - tpsf)
#endif
                end if

#ifdef NEWSUM
C             Derivative wrt subpixel qe parameters
		if (fitpqe) then
                  do jsamp=1,nsamp
                    do isamp=1,nsamp
                      npar = npar +1
                      dpsf(iii,jjj,npar) = dpsf(iii,jjj,npar) + 
     &              ww * 1. * 
     &       (pqepsf(fft,ndim,dx,dy,nsamp,pqe,maxsamp,isamp,jsamp)*
     &       (1+1./(nsamp*nsamp-1.)) - tpsf / (nsamp*nsamp-1.))
CC	if (ix .eq. nint(xx) .and. iy .eq. nint(yy)) then
CC	  print *, ix, iy, iii, jjj, dx, dy, isamp, jsamp, npar, tpsf,
CC     &              pqepsf(fft,ndim,dx,dy,nsamp,pqe,maxsamp,isamp,jsamp)
CC	end if
                    end do
                  end do
                end if
#endif
              end if
          
            end do
          end do
	  if (iwrite .eq. -99) return

4601     continue
	 print *, 'Radii: ', (radx(iwave),rady(iwave),iwave=1,nwave)

	 if (verbose) print *, 'total parameters 2: ', npar

C   Do pixel smearing for PSF and all derivatives
#ifdef NEWSUM
	 call dosmear(psf(1,1,istar,iframe),maxpsfsize,smpar,nsmooth,fitrad)
	 do ipar = 1, npar
           skip = .false.
           do jsmooth=1,nsmooth
             if (ipar .eq. ns(jsmooth)) skip = .true.
	   end do
	   if (.not. skip) 
     &       call dosmear(dpsf(1,1,ipar),maxpsfsize,smpar,nsmooth,fitrad)
	 end do
C   Derivatives with respect to pixel smooth parameters
	 do jsmooth = 1, nsmooth
           if (ns(jsmooth) .gt. 0) then
             ipar = ns(jsmooth)
	     smpar(jsmooth) = smpar(jsmooth)*1.01
	     call dosmear(dpsf(1,1,ipar),maxpsfsize,smpar,nsmooth,fitrad)
	     smpar(jsmooth) = smpar(jsmooth)/1.01
             do jjj=1,2*fitrad+7
               do iii=1,2*fitrad+7
                 dpsf(iii,jjj,ipar) = 
     &             (dpsf(iii,jjj,ipar) - psf(iii,jjj,istar,iframe) ) / (0.01*smpar(jsmooth))
               end do
             end do
           end if
	 end do
#endif

C   Now accumulate least squares matrices
         jjj = 0
         do iy=nint(yy)-fitrad-3,nint(yy)+fitrad+3
          dy = iy-yy
          jjj = jjj + 1
          iii = 0
          do ix=nint(xx)-fitrad-3,nint(xx)+fitrad+3
            dx = ix-xx
            iii = iii + 1
C	    data = a(ix,iy)
	    call ccgetdata(locdata(iframe),ix,iy,ncol,nrow,data)
            if (dx**2+dy**2 .le. fitrad2 .and.
     &          ix .ge. 1 .and. iy .ge. 1 .and.
     &          ix .le. ncol .and. iy .le. nrow .and.
     &          data .gt. lowbad .and. data .lt. highbad) then

C           Weighting by photon statistics, plus read noise, plus 0.0075 
C             flat fielding error
              sig2 = data/gain+rng+(0.0075*data)**2

C           Accumulate sumres2
              diff = data - expos(iframe)*scale(istar)*psf(iii,jjj,istar,iframe) - sky(istar)
C 	if (ix .eq. nint(xx) .and. iy .eq. nint(yy))
C     &  print *, iframe, iii, jjj, expos(iframe), scale(istar), sky(istar), psf(iii,jjj,istar,iframe), data
	      sumres2(iframe) = sumres2(iframe) + diff**2/sig2
              sumres2(0) = sumres2(0) + diff**2/sig2
	
C           dpsf gives the derivative of the model wrt each zernike
              npar = 0
              nz4 = 0
	      nz5 = 0
	      nz6 = 0
	      nz7 = 0
	      nz8 = 0
              do i=1,maxzer+nsmooth
                if (.not. lock(i)) then
                  npar = npar + 1
	          if (i .eq. 4) nz4 = npar
	          if (i .eq. 5) nz5 = npar
	          if (i .eq. 6) nz6 = npar
	          if (i .eq. 7) nz7 = npar
	          if (i .eq. 8) nz8 = npar
                  drv(npar) = expos(iframe)*scale(istar) * dpsf(iii,jjj,npar)
                end if
              end do
	      do i=1,nstar
                do ipar = 1, nspar
	          npar = npar + 1
                  if (i .eq. istar) then
                    if (ipar .eq. 1) then
                      drv(npar) = psf(iii,jjj,istar,iframe)
                    else if (ipar .eq. 2) then
                      drv(npar) = 1.
                    else
                      drv(npar) = expos(iframe)*scale(istar)*dpsf(iii,jjj,npar)
                    end if
                  else
	            drv(npar) = 0.
                  end if
	        end do
              end do
	      do i=2,nframes
                do ipar = 1, nfpar
	          npar = npar + 1
                  if (i .eq. iframe) then
	            drv(npar) = expos(iframe)*scale(istar)*dpsf(iii,jjj,npar)
                  else
	            drv(npar) = 0.
                  end if
	        end do
	      end do
              if (fitpslope) then
                npar = npar + 1
                drv(npar) = expos(iframe)*scale(istar)*dpsf(iii,jjj,npar)
              end if
              if (fitploc) then
                npar = npar + 1
                drv(npar) = expos(iframe)*scale(istar)*dpsf(iii,jjj,npar)
	        npar = npar + 1
                drv(npar) = expos(iframe)*scale(istar)*dpsf(iii,jjj,npar)
              end if
              if (fitpsize) then
                npar = npar + 1
                drv(npar) = expos(iframe)*scale(istar)*dpsf(iii,jjj,npar)
              end if
	      if (fitpqe) then
                do jsamp=1,nsamp
	          do isamp=1,nsamp
                    npar = npar + 1
                    drv(npar) = expos(iframe)*scale(istar)*dpsf(iii,jjj,npar)
                 end do
               end do
              end if

	      if (focslope) then
                do islope=1,5
                  npar = npar + 1
                  drv(npar) = slope(islope)*drv(nz4)
                end do
              end if
              if (varastig) then
                do islope=1,5
                  npar = npar + 1
                  drv(npar) = slope(islope)*drv(nz5)
                end do
                do islope=1,5
                  npar = npar + 1
                  drv(npar) = slope(islope)*drv(nz6)
                end do
              end if
              if (varcoma) then
                do islope=1,5
                  npar = npar + 1
                  drv(npar) = slope(islope)*drv(nz7)
                end do
                do islope=1,5
                  npar = npar + 1
                  drv(npar) = slope(islope)*drv(nz8)
                end do
              end if

C           Accumulate alp and beta
	      do i=1,npar
                beta(i) = beta(i) + diff/sig2*drv(i)
	        do j=1,i
                  alp(j,i) = alp(j,i) + drv(i)*drv(j)/sig2
                end do
              end do
            end if
          end do
         end do
	 print *, ' after star, frame, sumres2: ', istar, iframe, sumres2(0)
4701     continue
4700    continue

C  Adjust lambda depending on sumres2
	print *, ' sumres2, sumres2old: ', sumres2(0), sumres2old(0), lambda, niter, npar
        if (niter .gt. 1 .and. sumres2(0) .gt. sumres2old(0)) then
	  do i=0,nframes
            sumres2(i) = sumres2old(i)
          end do
          lambda = lambda*2
          do i= 1, npar
            par(i) = parold(i)
            beta(i) = betaold(i)
            do j=1,i
              alp(j,i) = alpold(j,i)
            end do
          end do
        else
	  do i=0,nframes
            sumres2old(i) = sumres2(i)
          end do
          lambda = lambda/2.
          lambda = max(0.005,lambda)
          do i= 1, npar
            parold(i) = par(i)
            betaold(i) = beta(i)
            do j=1,i
              alpold(j,i) = alp(j,i)
            end do
          end do
        end if

        if (niter .ge. maxiter) then
          redo = .false.
          goto 199
        end if

C       Invert the matrix and get the correction vector
        do 6501 i=1,npar
          do 6502 j=i+1,npar
            alp(j,i) = alp(i,j)
6502      continue
          alp(i,i) = alp(i,i)*(1.+lambda)
	if (verbose) print *, i, alp(i,i), beta(i)
6501    continue
        call invers(alp,maxpar,npar,ist)
        if (ist .ne. 0) then
          print *, 'error inverting matrix'
          do i=1,npar
            print *, i, alp(i,i)
          end do
          return
        end if
        do i=1,npar
          dpold(i) = dp(i)
        end do
        call vmul(alp,maxpar,npar,beta,dp)
        
C  Maximum allowable changes are 0.05 waves for zernikes, and 5 percent for
C     brightness. Reduce these by a factor of two each time the correction
C     changes sign.
        do i=1,npar 
          if (niter .gt. 1 .and. dpold(i)/dp(i) .lt. 0) clamp(i) = clamp(i)/2.
          clamp(i) = max(clamp(i),0.2)
        end do

        redo = .false.

C     Correct the parameters, see if weve converged.

C      Zernikes: max change is 0.05 waves
        do i=1,nzer
          if (abs(dp(i)) .gt. 0.01*abs(par(i)) .and.
     &        abs(dp(i)) .gt. 1.e-5) redo = .true.
          par(i) = par(i) + dp(i)/(1.+abs(dp(i))/(clamp(i)*maxchange))
	  if (verbose) print *, i, par(i), dp(i), clamp(i), redo
        end do

C      Smearing parameters: max change is 0.05
        do i=1,nsmooth
          if (.not. lock(maxzer+i)) then
            nzer = nzer + 1
            if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
            par(nzer) = par(nzer) + 
     &                  dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.1))
	    if (verbose) print *, i, nzer, par(nzer), dp(nzer), clamp(nzer), redo
          end if
        end do

	do istar=1,nstar
C      Scale factor: max change is 10 percent
          nzer = nzer + 1
          if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
          par(nzer) = par(nzer) + 
     &       dp(nzer)/(1.+abs(dp(nzer))/(0.1*scale(istar)*clamp(nzer)))
	  if (verbose) print *, nzer, par(nzer), dp(nzer), clamp(nzer), redo

C      Sky: max change is 5 DN
          nzer = nzer + 1
          if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer)) .and.
     &        abs(dp(nzer)) .gt. 1.e-5) redo = .true.
          if (.not. lock(17)) par(nzer) = par(nzer) + 
     &       dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*5.0))
	  if (verbose) print *, nzer, par(nzer), dp(nzer), clamp(nzer), redo

C      z2 and z3: max change is 0.05 waves
	  nzer = nzer + 1
          if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer)) .and.
     &        abs(dp(nzer)) .gt. 1.e-5) redo = .true.
          par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.1))
	  if (verbose) print *, nzer, par(nzer), dp(nzer), clamp(nzer), redo
	  nzer = nzer + 1
          if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer)) .and.
     &        abs(dp(nzer)) .gt. 1.e-5) redo = .true.
          par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.1))
	  if (verbose) print *, nzer, par(nzer), dp(nzer), clamp(nzer), redo

C     spectrum slope: max change is 0.5
          if (havespec) then
	    nzer = nzer + 1
            if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
            par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.5))
	    if (verbose) print *, nzer, par(nzer), dp(nzer), clamp(nzer), redo
          end if

C     smearing resolution parameter
          if (resolve) then
            do k=1,ngpar
	      nzer = nzer + 1
              if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.

              if (k .eq. 4) then
                par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*30))
              else if
     &  (par(nzer) + dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.5)) .gt. 0) then
                par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.5))
              else
                  par(nzer) = par(nzer) / 2. 
              end if
            end do
          end if

        end do

C      Frame shift parameters
	do iframe = 2, nframes
	  nzer = nzer + 1
          if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer)) .and. 
     &        abs(dp(nzer)) .gt. 1.e-5) redo = .true.
          par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.05))
	  if (verbose) print *, nzer, par(nzer), dp(nzer), clamp(nzer), redo
	  nzer = nzer + 1
          if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer)) .and. 
     &        abs(dp(nzer)) .gt. 1.e-5) redo = .true.
          par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.05))
	  if (verbose) print *, nzer, par(nzer), dp(nzer), clamp(nzer), redo
          if (.not. lock(4)) then
	    nzer = nzer + 1
            if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer)) .and. 
     &          abs(dp(nzer)) .gt. 1.e-5) redo = .true.
            par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.01))
	    if (verbose) print *, nzer, par(nzer), dp(nzer), clamp(nzer), redo
          end if
        end do

C      Obscuration slope term
        if (fitpslope) then
          nzer = nzer + 1
          if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
          par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.05))
        end if

C      Obscuration location term
        if (fitploc) then
          nzer = nzer + 1
          if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
          par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*10))
          nzer = nzer + 1
          if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
          par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*10))
        end if

C      Obscuration size term
        if (fitpsize) then
          nzer = nzer + 1
          if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
          par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.05))
        end if
	if (fitpqe) then
          do jsamp = 1, nsamp
	    do isamp=1,nsamp
                nzer = nzer + 1
                if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
                par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*0.01))
	    if (verbose) print *, nzer, isamp, jsamp, par(nzer), dp(nzer), clamp(nzer), redo
            end do
          end do
	end if

C      Focus slope terms
        if (focslope) then
          do j=1,2
            nzer = nzer + 1
            if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
            par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*1.e-4))
          end do
          do j=1,3
            nzer = nzer + 1
            if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
            par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*2.e-7))
          end do
        end if

C      Astigmatism slope terms
        if (varastig) then
          do i=1,2
            do j=1,2
              nzer = nzer + 1
              if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
              par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*1.e-4))
            end do
            do j=1,3
              nzer = nzer + 1
              if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
              par(nzer) = par(nzer) + 
     &                  dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*2.e-7))
            end do
          end do
        end if

C      Coma slope terms
        if (varcoma) then
          do i=1,2
            do j=1,2
              nzer = nzer + 1
              if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
              par(nzer) = par(nzer) + 
     &                dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*1.e-4))
            end do
            do j=1,3
              nzer = nzer + 1
              if (abs(dp(nzer)) .gt. 0.01*abs(par(nzer))) redo = .true.
              par(nzer) = par(nzer) + 
     &                  dp(nzer)/(1.+abs(dp(nzer))/(clamp(nzer)*2.e-7))
            end do
          end do
        end if

199     continue

C       Translate new parameters to their named equivalents
        npar = 0
        do i=1,maxzer+nsmooth
          if (.not. lock(i)) then
            npar = npar + 1
            if (i .le. maxzer) then
              zvar(0,i) = par(npar)
            else 
	      smpar(i-maxzer) = par(npar)
            end if
          end if
        end do
        if (lock(maxzer+3) .and. smpar(3) .eq. 0 .and. 
     &      .not. newsmear) smpar(3) = smpar(2)

        do istar=1,nstar
          npar = npar+1
          scale(istar) = par(npar)
          npar = npar+1
          sky(istar) = par(npar)
          npar = npar+1
          z2(istar) = par(npar)
          npar = npar+1
          z3(istar) = par(npar)
	  if (havespec) then
            npar = npar+1
            spec(istar) = par(npar)
          end if
	  if (resolve) then
            do k=1,ngpar
              npar = npar+1
              sig(istar,k) = par(npar)
            end do
          end if
        end do
	do iframe = 2, nframes
          npar = npar + 1
          dz2f(iframe) = par(npar)
          npar = npar + 1
          dz3f(iframe) = par(npar)
          if (.not. lock(4)) then
            npar = npar + 1
            dz4f(iframe) = par(npar)
          end if
	end do

	if (fitpslope) then
          npar = npar + 1
          pupslope = par(npar)
        end if
	if (fitploc) then
          npar = npar + 1
          xc = par(npar)
          npar = npar + 1
          yc = par(npar)
        end if
	if (fitpsize) then
          npar = npar + 1
          pupsize = par(npar)
        end if
	if (fitpqe) then
	  wtot = 0
          do jsamp = 1, nsamp
	    do isamp=1,nsamp
              npar = npar + 1
	      wtot = wtot + par(npar)
            end do
          end do
          npar = npar - nsamp*nsamp
          do jsamp = 1, nsamp
	    do isamp=1,nsamp
              npar = npar + 1	
	      par(npar) = par(npar) * (nsamp*nsamp)/wtot
              pqe(isamp,jsamp) = par(npar) 
            end do
          end do
	end if

	if (focslope) then
	  do i=1,5
            npar = npar + 1
            zvar(i,4) = par(npar)
	  end do
	end if
	if (varastig) then
	  do i=1,5
            npar = npar + 1
            zvar(i,5) = par(npar)
	  end do
	  do i=1,5
            npar = npar + 1
            zvar(i,6) = par(npar)
	  end do
	end if
	if (varcoma) then
	  do i=1,5
            npar = npar + 1
            zvar(i,7) = par(npar)
	  end do
	  do i=1,5
            npar = npar + 1
            zvar(i,8) = par(npar)
	  end do
	end if


        if (nogo) return
 
        if (redo) goto 100

201     continue

C       Subtract the fit from the data if called for
	if (sub) then
         do iframe=1,nframes
         do istar=1,nstar
	  xx=x(istar)+nint(dxf(iframe))
	  yy=y(istar)+nint(dyf(iframe))
          jjj=0
          do iy=nint(yy)-fitrad-3,nint(yy)+fitrad+3
            dy = iy-yy
            jjj=jjj+1
            iii=0
            do ix=nint(xx)-fitrad-3,nint(xx)+fitrad+3
              dx = ix-xx
              iii=iii+1
C	      data = a(ix,iy)
	      call ccgetdata(locdata(iframe),ix,iy,ncol,nrow,data)
              if (dx**2+dy**2 .le. fitrad2 .and.
     &          ix .ge. 1 .and. iy .ge. 1 .and.
     &          ix .le. ncol .and. iy .le. nrow .and.
     &          data .gt. lowbad .and. data .lt. highbad) then
               data = data - expos(iframe)*scale(istar)*psf(iii,jjj,istar,iframe)
	       call ccputdata(locdata(iframe),ix,iy,ncol,nrow,data)
C	       a(ix,iy) = data
              end if
            end do
          end do
         end do
	 end do
        end if

	if (haveout) then
          write(7,*) niter, sumres2(0), ndim, nwave, nstar, nframes, nsamp, 
     &               fitrad, wave(1), wave(nwave)
          do i=1,maxzer
	    if (i .ge. 4 .and. i .le. 11) then
              write(7,88) i, (zvar(j,i),j=0,5)
            else
              write(7,88) i, zvar(0,i)
            end if
	  end do
          write(7,76) (smpar(is),is=1,nsmooth), pupslope, xc, yc, pupsize
76        format(9f12.4)
	  do i=1,nframes
	    write(7,78) i, dz2f(i), dz3f(i), dz4f(i), sumres2(i)
	  end do
78	  format(i3,4(1pe11.3))
          do istar=1,nstar
	    call zerloc(x(istar),y(istar),zvar,s)
            write(7,77) istar, x(istar), y(istar), scale(istar), 
     &          sky(istar), z2(istar), z3(istar), (s(j),j=4,11),
     &          spec(istar), (sig(istar,k),k=1,ngpar)
77	    format(i6, 16(1pe11.3))
          end do
          do jsamp = 1, nsamp
            print 95, (pqe(isamp,jsamp),isamp=1,nsamp)
          end do
          close(7)
        end if

	return
	end
       

C    Subroutine to fill pupil intensity 
        subroutine makepupil(inten,ndim,icam,x,y,wave,radius,radx,rady,
     &                       nsamp,pupslope,xc,yc,pupsize)
      
C        implicit none 
        integer ndim, icam, maxap, nsamp, ipass, jj, ii
	real pi 
        parameter (maxap = 20, pi=PI)
        real x, y, wave, radius, tot, pupslope, pupsize, xc, yc, radx, rady
        real inten(ndim,ndim)
	logical compute

        real ap(5,maxap), asize, anorm, pixsize, radius2
        real cdist, rdist, cdist2, rdist2, dist, theta, xd, yd
        real crot, rrot, diam, r, r2, c, d, dd, pixscale, xscale, yscale
	real xsize, ysize
        integer naper, nsub, ndim2, irow, icol, itot, i, j, in, iap, nsub0

	common /nsubcom/ nsub0

        call getap(icam,ap,naper,x,y,pupslope,xc,yc,pupsize)
        diam = 2.4

C	call wfpcscale(icam,x,y,pixscale)
C        pixsize = pixscale / 3600. * pi/180. / nsamp
C        radius = ndim * diam * pixsize / wave / 2
        if (nsamp .eq. 0) then
          radius = ndim / 4
          radx = ndim / 4
          rady = ndim / 4
          xsize = radx * 2 * wave / diam / ndim
          ysize = rady * 2 * wave / diam / ndim
        else
	  call wfpcscale(icam,x,y,xscale,yscale)
          xsize = xscale / 3600. * pi/180. / nsamp
          ysize = yscale / 3600. * pi/180. / nsamp
        end if
        radx = ndim * diam * xsize / wave / 2
        rady = ndim * diam * ysize / wave / 2
	radius = 1.

C	print 77, wave, nsamp, pixsize*180/pi*3600., radius
C	print 77, wave, nsamp, xsize*180/pi*3600., radx, ysize, rady
77	format('wave, nsamp, pixsize, radius: ',1pe11.3,i3,1pe11.3,0pf7.2,
     &        1pe11.3,0pf7.2)

C        nsub = NSUB

	do 4401 irow = 1,ndim
          do 4402 icol=1,ndim
            inten(icol,irow) = 0.
4402      continue
4401    continue

C   Set up the input array
        ndim2 = ndim/2
        radius2 = radius**2
        tot = 0

C  Do two passes
        do 4500 ipass = 1, 2
          if (ipass .eq. 1) then
            nsub = 0
          else
            nsub = nsub0
          end if
          asize = (2.*nsub+1)
          anorm = asize**2

        do 4501 irow=1,ndim
C          if (mod(irow,20) .eq. 0) print *, irow, ipass
          rdist = irow-ndim2
C          if (abs(rdist) .gt. radius+2) goto 4501
          if (abs(rdist) .gt. rady+2) goto 4501
          rdist2 = rdist**2
          do 4502 icol=1,ndim
            cdist = icol-ndim2
C            if (abs(cdist) .gt. radius+2) goto 4502
            if (abs(cdist) .gt. radx+2) goto 4502

            compute = .false.
            if (ipass .eq. 1) then
C              dist = rdist2 + cdist**2
C              if (dist .le. (radius+2)**2) compute = .true.
              dist = rdist2/rady**2 + cdist**2/radx**2
              if (dist .le. (radius*1.05)**2) compute = .true.
            else
              do jj=-1,1
                do ii=-1,1
                  if (abs(inten(icol+ii,irow+jj)-inten(icol,irow)) .gt. 1.e-5)
     &               then
                        compute = .true.
 			goto 4499
	          end if
                end do
              end do
            end if
4499        continue
            if (compute) then
              itot = 0
C	if (ipass .eq. 2) print *, icol, irow, inten(icol,irow), nsub
C   This pixel is in (or very close) to the entrance stop. Divide it into
C       subpixels for a finer sampling of the apertures and wavefront errors
              do 4503 i=-nsub,nsub
                r=rdist+i/asize
                r=r/rady
                r2=r**2
                do 4504 j=-nsub,nsub
                  in = 0
                  c=cdist+j/asize
		  c=c/radx
                  d = r2 + c**2
                  if (c .eq. 0) then
                     theta = pi/2.
                     if (r .lt. 0) theta = theta + pi
                  else
                     theta = atan(r/c)
                     if (c .lt. 0) theta = theta + pi
                  end if
                  if (d .lt. radius2) then
                    in = 1
C   This subpixel is in the entrace aperture. Check to see if its obscured
C       by anything from the aperture file.
                    do 4505 iap = 1, naper
                      if (ap(5,iap) .ne. 0.) then
                        dd = sqrt(d)
                        rrot = dd * sin(theta-ap(5,iap))
                        crot = dd * cos(theta-ap(5,iap))
                      else
                        rrot = r
                        crot = c
                      end if
                      xd = abs(crot/radius - ap(1,iap))
                      yd = abs(rrot/radius - ap(2,iap))
                      if (ap(4,iap) .lt. 1.e-6) then
                        if (xd .lt. ap(3,iap)) then
                          if (yd .lt. ap(3,iap)) then
                            dd = xd**2 + yd**2
                            if (dd .lt. ap(3,iap)**2)
     &                         in = 0
                          end if
                        end if
                      else
                        if (xd .lt. ap(3,iap) .and. yd .lt. ap(4,iap))
     &                        in = 0
                      end if
4505                continue
C    Now add in the wavefront errors if its a clear subpixel.
                    if (in .eq. 1) then
                      itot = itot + 1
                    end if
                  end if
4504            continue
4503          continue
              inten(icol,irow) = itot/anorm
            end if
            if (ipass .eq. 2) tot = tot + inten(icol,irow)**2
4502      continue
4501    continue

4500    continue

        tot = sqrt(tot)*ndim
        do 5501 irow=1,ndim
          do 5502 icol=1,ndim
            inten(icol,irow) = inten(icol,irow)/tot
5502      continue
5501    continue

        return
        end

        subroutine getap(icam,ap,naper,x,y,pupslope,xc,yc,pupsize)
 
C        implicit none
        real pi, pupslope, pupsize
        integer naper, icam, i, maxaper
        parameter (pi = PI, maxaper=20)
        real ap(5,maxaper), x, y, sec, rad, angle, tmp, xc, yc
	integer itest
	common /getscale/ itest

C        real z4, delf, w0
C        z4 = 0.
C        w0 = 0.
C	delf = 165.931*(z4*w0*1.e6 + 1.205)*1.e-3
C        xc = 400
C        yc = 400

	if (icam .ge. 1 .and. icam .le. 4) then
          naper = 9

	  ap(1,1) = 0.000
	  ap(2,1) = 0.000
	  ap(3,1) = 1.042
	  ap(4,1) = 0.011
	  ap(5,1) = 45.000 - mod(icam-1,4)*90 - int((icam-1)/4)*45

	  ap(1,2) = 0.000
	  ap(2,2) = 0.000
	  ap(3,2) = 0.011
	  ap(4,2) = 1.042
	  ap(5,2) = 45.000 - mod(icam-1,4)*90 - int((icam-1)/4)*45

	  ap(1,3) = 0.8921
	  ap(2,3) = 0.000
	  ap(3,3) = 0.065
	  ap(4,3) = 0.000
	  ap(5,3) = 45.000 - mod(icam-1,4)*90 - int((icam-1)/4)*45
  
	  ap(1,4) = -0.4615
  	  ap(2,4) = 0.7555
	  ap(3,4) =  0.065
	  ap(4,4) = 0.000
	  ap(5,4) = 45.000 - mod(icam-1,4)*90 - int((icam-1)/4)*45

	  ap(1,5) = -0.4564
	  ap(2,5) = -0.7606
	  ap(3,5) =  0.065
	  ap(4,5) = 0.000
	  ap(5,5) = 45.000 - mod(icam-1,4)*90 - int((icam-1)/4)*45

	  ap(1,6) = 0.000
	  ap(2,6) = 0.000
	  ap(3,6) = 0.330
	  ap(4,6) = 0.000
	  ap(5,6) = 45.000 - mod(icam-1,4)*90 - int((icam-1)/4)*45

C    WFPC obscurations
          if (icam .ge. 2 .and. icam .le. 4) then
            sec = 0.433
            rad = 0.024
          else
            sec = 0.410
            rad = 0.029
          end if
          sec = pupsize
          angle = 225.
          if (icam .gt. 4) angle = 0.
	
C   For unaberrated system from Hasan paper
	  if (icam .eq. 1) then
	    ap(1,7)=.201 / 800. * ((yc-y) - (x-xc))
	    ap(2,7)= .196 / 800. * ((yc-y) + (x-xc))
          else if (icam .le. 4) then
	    ap(1,7)=.402 / 800. * ((yc-y) - (x-xc))
	    ap(2,7)= .391 / 800. * ((yc-y) + (x-xc))
          end if

C   From TinyTim
          if (icam .eq. 1) then
C            ap(1,7)=5.088e-4 * (yc-y)
C            ap(2,7)=5.088e-4 * (xc-x)
            ap(1,7)=pupslope/800 * (yc-y)
            ap(2,7)=pupslope/800 * (xc-x)
            tmp = ap(1,7)
            ap(1,7) = ap(1,7)*cosd(-45.) - ap(2,7)*sind(-45.)
            ap(2,7) = tmp*cosd(-45.) + ap(2,7)*sind(-45.)
          else if (icam .le. 4) then
C            ap(1,7)=.3880455 / 800. * ((yc-y) - (x-xc))
C            ap(2,7)=.4000455 / 800. * ((yc-y) + (x-xc))
            ap(1,7) = pupslope / 800. * ((yc-y) - (x-xc))
            ap(2,7) = pupslope / 800. * ((yc-y) + (x-xc))
          end if

	  if (itest .eq. 3) then
            ap(1,7) = 0.
            ap(2,7) = 0.
	    do i=1,6
              ap(5,i) = 0.
            end do
          end if
  
	  ap(3,7) = sec
	  ap(4,7) = 0.000
	  ap(5,7) = angle
  
	  ap(1,8) = ap(1,7)
	  ap(2,8) = ap(2,7)
	  ap(3,8) = rad
	  ap(4,8) = 1.212
	  ap(5,8) = angle

	  if (icam .eq. 1) then
	    ap(1,9) = 0.771 + ap(1,7)
          else
	    ap(1,9) = ap(1,7) - 0.771
          end if
	  ap(2,9) = ap(2,7)
	  ap(3,9) = 0.771
	  ap(4,9) = rad
	  ap(5,9) = angle

          do i=1,naper
            ap(5,i) = ap(5,i) * pi/180.
          end do
        else
	  naper = 1
	  ap(1,1) = 0.000
	  ap(2,1) = 0.000
	  ap(3,1) = 0.000
	  ap(4,1) = 0.000
        end if

        return
        end

C       Get the phase of the pupil function
        subroutine makephase(inten,phase,ndim,z,radius,radx,rady,wave,icam)

        implicit none
        integer maxzer, i, j, ndim2, ndim, init, ii, icam, imap
        parameter (maxzer = __MAXZER)
        real inten(ndim,ndim), phase(ndim,ndim)
        real z(maxzer), getzer, wave, pi
	parameter (pi = PI)
        real coef(3,22), eps, d, dr, dc, theta, radius, wold, radx, rady
	real wfpcmap(280,280), dx, dy, x0, y0, theta0, a0
	real r, x, y, ran1
	integer ixmap, jymap, kernel, ierr
	integer nx, ny, irot
	common /map/ imap
        integer itest
	common /getscale/ itest
	data kernel/-12387/
	data init /0/
	save

	if (init .eq. 0) then
          if (imap .le. 1) then
            a0 = 6328.e-10
          else if  (imap .eq. 2) then
            a0 = 5470.e-10
          else if  (imap .eq. 3) then
            a0 = 10000.e-10
          end if
          open(1,file='wfpc2cal/optics/wfpcmap.tab',status='old',iostat=ierr)
          if (ierr .ne. 0) then
             print *, 'error opening wfpcmap.tab file'
             return
          end if
          theta0 = pi
          nx = 280
          ny = 280
          dx = 0.00739927
          dy = 0.00739927
          x0 = (1-141)*dx
          y0 = (1-141)*dy
          do i=1,ny
            read(1,*) (wfpcmap(ii,i),ii=1,nx)
            do j=1,nx
              wfpcmap(j,i) = wfpcmap(j,i) * a0/wave
            end do
          end do
          close(1)
          wold = wave
          init = 1
        else if (wave .ne. wold) then
          do 5512 j = 1, ny
            do 5513 i = 1, nx
              wfpcmap(i,j) = wfpcmap(i,j) * wold/wave
5513        continue
5512      continue
          wold = wave
        end if

        if (icam .ge. 1 .and. icam .le. 4) then
          irot = mod(icam,4)
          if (itest .eq. 3) irot = 2
          eps = 0.33
        else
          irot = 0
          eps = 0
        end if

        call initzer(z,coef,maxzer,eps,wave)

        ndim2 = ndim/2
        do 4501 j=1,ndim
          dr = j-ndim2
	  dr = dr/rady
          do 4502 i=1,ndim
            dc = i-ndim2	
	    dc = dc/radx
            if (inten(i,j) .gt. 0) then
              d = dr**2 + dc**2
	      if (dc .eq. 0 .and. dr .eq. 0) then
                theta = irot*pi/2.
              else
                theta = atan2(dr,dc) + irot*pi/2.
              end if
              phase(i,j) = getzer(coef,sqrt(d),radius,theta)
	      if (imap .gt. 0) then
                r = sqrt(d)/radius
                x = r*cos(theta-theta0)
                y = -r*sin(theta-theta0)
                ixmap = nint( (x-x0)/dx + 1)
                jymap = nint( (y-y0)/dy + 1)
                phase(i,j) = phase(i,j) + wfpcmap(jymap,ixmap)
              else if (imap .lt. 0) then
                x = 2*ran1(kernel)-1
                phase(i,j) = phase(i,j) + x
              end if
            else
              phase(i,j) = 0.
            end if
4502      continue
4501    continue

        return
        end

        function getzer(coef,d,radius,theta)

        implicit none
        integer maxzer, i, j
	real pi
        parameter (maxzer = __MAXZER, pi=PI)
        real coef(3,22), d, radius, theta, r2, r3, ct, st, getzer, r
	real thetanew
	integer nx, ny, imap, init
	logical havez22
	real z22
	common /parm/ z22,havez22

	thetanew = theta + pi*3./4.
	thetanew = -thetanew
        r = d / radius
        r2 = r**2
        r3 = r2*r
        ct = cos(thetanew)
        st = sin(thetanew)
        getzer = coef(1,1)
        getzer = getzer + coef(1,2) * r*ct
        getzer = getzer + coef(1,3) * r*st
        getzer = getzer + coef(1,4) * (r2 + coef(2,4))
        getzer = getzer + coef(1,5) * r2*cos(2.*thetanew)
        getzer = getzer + coef(1,6) * r2*sin(2.*thetanew)
        getzer = getzer + coef(1,7) * (r3 + coef(2,7) * r) * ct
        getzer = getzer + coef(1,8) * (r3 + coef(2,8) * r) * st
        getzer = getzer + coef(1,9) * r3*cos(3.*thetanew)
        getzer = getzer + coef(1,10) * r3*sin(3.*thetanew)
        getzer = getzer + coef(1,11) *
     &           (r2**2 + coef(2,11)*r2 + coef(3,11))

C  Add in 5th order spherical by hand
        if (havez22) 
     &   getzer = getzer + 
     &    coef(1,22) * 74.82446 * 
     &    (r3**2 - 1.663350*r2**2 + 0.803136*r2 - 0.104406)

 
        return
        end

        subroutine initzer(z,coef,npar,eps,wave)

C        implicit none
         
        integer npar, i
        real z(npar),coef(3,22),eps,eps2,w0,wave
	real r,r2,r3,thetanew,st,ct
C        parameter (w0 = 6328.e-10)
	logical havez22
	real z22
	common /parm/ z22,havez22
        parameter (w0 = 5470.e-10)

        eps2 = eps**2
        coef(1,1) = 1.
        coef(1,2) = z(2) * 2./sqrt(1.+eps2)
        coef(1,3) = z(3) * 2./sqrt(1.+eps2)
        coef(1,4) = z(4) * 2.*sqrt(3.)/(1.-eps2)
        coef(2,4) = - (1.+eps2)/2.
        coef(1,5) = z(5) * sqrt(6./(1.+eps2+eps2**2))
        coef(1,6) = z(6) * sqrt(6./(1.+eps2+eps2**2))
        coef(1,7) = z(7) * 3.*sqrt(8.*(1+eps2))/(1-eps2)
     &                   /sqrt(1+4*eps2+eps2**2)
        coef(2,7) = -2.*(1.+eps2+eps2**2)/3./(1.+eps2)
        coef(1,8) = z(8) * 3.*sqrt(8.*(1+eps2))/(1-eps2)
     &                   /sqrt(1+4*eps2+eps2**2)
        coef(2,8) = coef(2,7)
        coef(1,9) = z(9) * sqrt(8./(1+eps2+eps2**2+eps2**3))
        coef(1,10) = z(10) * sqrt(8./(1+eps2+eps2**2+eps2**3))
        coef(1,11) = z(11) * 6.*sqrt(5.)/(1.-eps2)**2
        coef(2,11) = -1.*(1.+eps2)
        coef(3,11) = (1.+4.*eps2+eps2**2)/6.

        do i=2,11
          coef(1,i) = coef(1,i) * w0/wave
        end do

	if (havez22) coef(1,22) = z22 * w0/wave

        return
        end

C  Subroutine to get PSF from intensity and phase maps
        subroutine dofft(fft,inten,phase,ndim)

        implicit none
        integer ndim
        real fft(2,ndim,ndim), twopi
        real inten(ndim,ndim), phase(ndim,ndim)
        integer nn(2), i, j
        parameter (twopi = 2. * PI)

        nn(1) = ndim
        nn(2) = ndim
        do 4501 j=1,ndim
          do 4502 i=1,ndim
            fft(1,i,j) = inten(i,j) * cos(twopi*phase(i,j))
            fft(2,i,j) = inten(i,j) * sin(twopi*phase(i,j))
 4502     continue
 4501   continue

        call fourn(fft,nn,2,1)

C    Take the modulus squared for the PSF
        do 9501 j=1,ndim
            do 9502 i=1,ndim
              fft(1,i,j) = fft(1,i,j)**2 + fft(2,i,j)**2
 9502       continue
 9501   continue

	return
	end

C  Subroutine to smooth a PSF by a specified smoothing function, either by
C    fourier or real-space convolution. 

	subroutine psfsmooth(fft,ndim,smear,is,ie,fitrad,nsmooth)

	implicit none
	integer i, j, iii, jjj
	integer is, ie, nn(2), ndim, ndim2, nsmooth
	real fft(2,ndim,ndim)
	real smear(2,is:ie,is:ie), rad, tmp, fitrad
	real tmpsmear(512,512), tot1, tot2, xtot1, xtot2, ytot1, ytot2

C  Resort the array to put the star in the center
	tot1 = 0
	xtot1 = 0
	ytot1 = 0
        ndim2 = ndim/2
        do 7501 j=1,ndim
          jjj = mod(j+ndim2-1,2*ndim2)+1
          do 7502 i=1,ndim
            iii = mod(i+ndim2-1,2*ndim2)+1
            fft(2,i,j) = fft(1,iii,jjj)
	    tot1=tot1+fft(2,i,j)
	    xtot1=xtot1+i*fft(1,iii,jjj)
	    ytot1=ytot1+j*fft(1,iii,jjj)
 7502     continue
 7501   continue

C If nsmooth <=0, we smooth by Fourier, otherwise by real-space convolution
C If nsmooth <=0, assume smoothing function has already been Fourier transformed
	if (nsmooth .le. 0) then
          if (ndim .ne. ie-is+1) then
	    print *, 'error: smear dimension not equal to PSF dimension'
	    pause
	  else if (ndim .gt. 512) then
	    print *, 'error: ndim greater than 512 for smear'
	  end if
	  do j=1,ndim
            do i=1,ndim
              fft(1,i,j) = fft(2,i,j)
              fft(2,i,j) = 0.
C	      tmpsmear(i,j) = smear(1,i,j)
            end do
          end do
C Transform both functions to Fourier space
	  nn(1) = ndim
	  nn(2) = ndim
          call fourn(fft,nn,2,1)
C          call fourn(smear,nn,2,1)
C Complex multiply
          do 5501 j=1,ndim
            do 5502 i=1,ndim
              tmp        = fft(1,i,j)*smear(1,i,j)-fft(2,i,j)*smear(2,i,j)
              fft(2,i,j) = fft(2,i,j)*smear(1,i,j)+fft(1,i,j)*smear(2,i,j)
              fft(1,i,j) = tmp
 5502       continue
 5501     continue
C Transform back
          call fourn(fft,nn,2,-1)
C Take modulus
          do j=1,ndim
            do i=1,ndim
              fft(2,i,j) = sqrt(fft(1,i,j)**2+fft(2,i,j)**2)/ndim/ndim
C	      smear(1,i,j) = tmpsmear(i,j)
C	      smear(2,i,j) = 0.
            end do
          end do

	else

C  Real space convolution
          do 8501 j=1,ndim
            jjj = mod(j+ndim2-1,2*ndim2)+1
            do 8502 i=1,ndim
              iii = mod(i+ndim2-1,2*ndim2)+1
              smear(2,i,j) = smear(1,iii,jjj)
 8502       continue
 8501     continue
	  do j=1,ndim
            do i=1,ndim
              fft(1,i,j) = fft(2,i,j)
              fft(2,i,j) = 0.
	      tmpsmear(i,j) = smear(1,i,j)
	      smear(1,i,j) = smear(2,i,j)
            end do
          end do
          call phconvolveit(fft,1,ndim,1,ndim,
     &         smear,-ndim/2,ndim/2-1,-ndim/2,ndim/2-1,fitrad,nsmooth)
	  do j=1,ndim
            do i=1,ndim
	      smear(1,i,j) = tmpsmear(i,j)
            end do
          end do

	end if

C Resort star back to origin of array
	tot2 = 0
	xtot2 = 0
	ytot2 = 0
        do j=1,ndim
          jjj = mod(j+ndim2-1,2*ndim2)+1
          do i=1,ndim
            iii = mod(i+ndim2-1,2*ndim2)+1
            fft(1,iii,jjj) = fft(2,i,j)
	    tot2 = tot2+fft(1,iii,jjj)
	    xtot2=xtot2+i*fft(1,iii,jjj)
	    ytot2=ytot2+j*fft(1,iii,jjj)
          end do
        end do

C	print *, 'smooth tot: ', tot1, tot2, xtot1/tot1, xtot2/tot2, ytot1/tot1, ytot2/tot2
	do j=1,ndim
	  do i=1,ndim
	    fft(1,i,j) = fft(1,i,j)*tot1/tot2
	  end do
	end do

        return
        end 


#ifdef NEWSUM
        function sumpsf(fft,ndim,dx,dy,nsamp,pqe,maxsamp)

	implicit none
	integer ndim, nsamp, i, j, iii, jjj, maxsamp, ndim2, ipix, jpix
	real fft(2,ndim,ndim), dx, dy, pqe(maxsamp,maxsamp)
	real sumpsf

	sumpsf = 0
	ndim2=ndim/2
	do j=nint(dy)*nsamp-nsamp/2,nint(dy)*nsamp+nsamp/2
          jjj = j+1
          if (jjj .le. 0) jjj=jjj+ndim
          jpix = j-nint(dy)*nsamp+nsamp/2+1
	  do i=nint(dx)*nsamp-nsamp/2,nint(dx)*nsamp+nsamp/2
            iii = i+1
            if (iii .le. 0) iii=iii+ndim
            ipix = i-nint(dx)*nsamp+nsamp/2+1
            sumpsf = sumpsf+fft(1,iii,jjj)*pqe(ipix,jpix)
          end do
	end do

	return
	end

        function pqepsf(fft,ndim,dx,dy,nsamp,pqe,maxsamp,ipix,jpix)

	implicit none
	integer ndim, nsamp, i, j, iii, jjj, maxsamp, ndim2, ipix, jpix
	real fft(2,ndim,ndim), dx, dy, pqe(maxsamp,maxsamp)
	real pqepsf

	j = jpix+nint(dy)*nsamp-nsamp/2-1
        jjj = j+1
        if (jjj .le. 0) jjj=jjj+ndim

	i = ipix+nint(dx)*nsamp-nsamp/2-1
        iii = i+1
        if (iii .le. 0) iii=iii+ndim

        pqepsf = fft(1,iii,jjj)

	return
	end
#else

        function sumpsf(fft,ndim,ddx,ddy,smpar,nsmooth,nsamp,wj,nwx,nwy)
	
	implicit none
        integer ndim, i, j, ndim2, ii, jj, nn, js, is, nsamp, iii, jjj
	real fft(2,ndim,ndim), dx, dy, sumpsf, ddx, ddy
        real pi
	integer nsmooth
	parameter (pi=PI)
        real smpar(nsmooth), smdiag, smear, sigx, sigy, gtot

	integer iwx, iwy, icx, icy, nwx, nwy, ssize, js1, js2
        parameter(ssize = __SMOOTHSIZE)
	real wj(-ssize:ssize,-ssize:ssize), jitscale
        LOGICAL REVERSE, SFLIP, TFLIP, NEWSMEAR
	COMMON /REV/ REVERSE, SFLIP, TFLIP, NEWSMEAR, JITSCALE

        sumpsf = 0
        ndim2 = ndim/2
        nn = ndim/2-nsamp/2+1

C      Do a 3x3 convolution with smearing function
        smdiag = (1. - abs(smpar(1)) - 2*smpar(2) - 2*smpar(3)) / 4.

	if (newsmear) then
          smpar(3) = (1. - smpar(1) - 2*smpar(2) ) / 2. / (1. + 4.*smpar(2))
          smdiag = 2*smpar(2)*smpar(3)
        end if

        if (smpar(1) .le. 0 .or. smpar(1) .eq. 1) then
          js1 = 0
          js2 = 0
        else
          js1 = -1
          js2 = 1
        end if
        do 4501 js=js1,js2
          dy = ddy + js
          do 4502 is=js1,js2
            dx = ddx + is
            if (smpar(1) .lt. 0) then
              smear = 1
            else if (abs(js) .eq. 1 .and. abs(is) .eq. 1) then
              smear = smdiag
            else if (js .eq. 0 .and. is .eq. 0) then
              smear = abs(smpar(1))
            else if (js .eq. 0) then
              smear = smpar(2)
            else
              smear = smpar(3)
            end if

C  Integrate over the sampled pixels using weight array determined from
C     jitter function
            icy = nn + nint(dy*nsamp) + nsamp/2  -1
            icx = nn + nint(dx*nsamp) + nsamp/2  -1
	    if (smpar(1) .eq. 0) then
              smear = 0
              if (is .eq. 0 .and. js .eq. 0) then
                smear = 1
                print *, dx, dy, nsamp, icx, icy
              end if
            end if
            do 6501 j=icy-nwy/2,icy+nwy/2
              jjj = mod(j+ndim2-1,2*ndim2)+1
              iwy = j - icy
              do 6502 i=icx-nwx/2,icx+nwx/2
                iii = mod(i+ndim2-1,2*ndim2)+1
                iwx = i - icx
	if (smpar(1) .eq. 0 .and. is .eq. 0 .and. js .eq. 0) then
          if (iii .eq. ndim .and. jjj .eq. ndim) then
           fft(1,iii,jjj) = 1.
	   print *, j, i, jjj, iii, ndim2, fft(1,iii,jjj),iwx,iwy,wj(iwx,iwy)
          else
           fft(1,iii,jjj) = 0.
          end if
        end if
                sumpsf = sumpsf + fft(1,iii,jjj)*smear*wj(iwx,iwy)
6502          continue
6501        continue

4502      continue
4501    continue

        return
        end
#endif

      SUBROUTINE LININT(XA,YA,N,X,Y)
      implicit REAL (a-h,o-z)
      DIMENSION XA(N),YA(N)
      KLO=1
      KHI=N
1     IF (KHI-KLO.GT.1) THEN
        K=(KHI+KLO)/2
        IF(XA(K).GT.X)THEN
          KHI=K
        ELSE
          KLO=K
        ENDIF
      GOTO 1
      ENDIF
      H=XA(KHI)-XA(KLO)
C      IF (H.EQ.0.) PAUSE 'Bad XA input.'
      Y=(X-XA(KLO))/H*(YA(KHI)-YA(KLO)) + YA(KLO)
      RETURN
      END

        subroutine wfpcscale(jcam, x, y, xscale, yscale)

	real c(10,4), d(10,4)
	logical first 
        integer itest
	common /getscale/ itest
	data first /.true./
	save

	icam = jcam
        if (itest .eq. 3 .and. jcam .gt. 2) icam = 2

        if (icam .ge. 1 .and. icam .le. 4) then

	  if (first) then
            open(1,file=
     &	      'wfpc2cal/distort/wfpc2dist_mar94.dat',status='old',iostat=ierr)
            if (ierr .ne. 0) then
              print *, 'error opening distortion file'
              return
            end if
	    read(1,*)
	    do i=1,10
	      read(1,*) (c(i,j),d(i,j),j=1,4)
            end do
 	    first = .false.
	    close(1)
          end if

	  if (itest .eq. 3) then
            xx = 0
            yy = 0
          else
	    xx = x-400
	    yy = y-400
          end if

          dx2dx1 =
     &      c(2,icam) + 2*xx*c(4,icam) + yy*c(5,icam) + 3*xx**2*c(7,icam) +
     &        2*xx*yy*c(8,icam) + yy**2*c(9,icam)
          dx2dy1 =
     &      c(3,icam) + xx*c(5,icam) + 2*yy*c(6,icam) + xx**2*c(8,icam) +
     &      2*xx*yy*c(9,icam) + 3*yy**2*c(10,icam)
          dy2dy1 =
     &      d(3,icam) + 2*yy*d(6,icam) + xx*d(5,icam) + 3*yy**2*d(10,icam) +
     &      2*xx*yy*d(9,icam) + xx**2*d(8,icam)
          dy2dx1 =
     &      d(2,icam) + yy*d(5,icam) + 2*xx*d(4,icam) + yy**2*d(9,icam) +
     &      2*xx*yy*d(8,icam) + 3*xx**2*d(7,icam)
  
  	  pixscale = sqrt(dx2dx1*dy2dy1 - dx2dy1*dy2dx1) * 0.04555

	  xscale = sqrt(dx2dx1**2+dy2dx1**2) * 0.04555
	  yscale = sqrt(dx2dy1**2+dy2dy1**2) * 0.04555

	  if (itest .eq. 1) then
	    if (xscale .lt. yscale) then
	      xscale = xscale / 2
            else
              yscale = yscale / 2
            end if
          else if (itest .eq. 2) then
            xscale = pixscale
            yscale = pixscale
          else if (itest .eq. 3) then
            xscale = pixscale
            yscale = pixscale
          end if
        else
          xscale = 0.05
          yscale = 0.05
        end if

	return
	end

	SUBROUTINE LOADJIT(A,KSR,KER,KSC,KEC,WJ,IS,IE)

	REAL A(KSC:KEC,KSR:KER), WJ(IS:IE,IS:IE)

	DO I=KSR,KER
          DO J=KSC,KEC
            A(J,I) = WJ(J,I)
          END DO
        END DO
 
        RETURN
        END


      SUBROUTINE PHCONVOLVEIT(FFT,KSR,KER,KSC,KEC,FUNC,ISR,IER,ISC,IEC,FITRAD,NGW)

C   Subroutine to perform full blown 2D convolution!

      REAL FFT(2,KSR:KER,KSC:KEC)
      REAL FUNC(2,ISC:IEC,ISR:IER)
#ifdef VMS
      INCLUDE 'VINCLUDE:VISTALINK.INC'
#else
      INCLUDE 'vistadisk/source/include/vistalink.inc'
#endif

C   First zero out the output array
      DO 4401 J = KSR, KER
        DO 4402 I = KSC, KEC
          FFT(2,I,J) = 0.
4402    CONTINUE
4401  CONTINUE

      IF (FITRAD .GT. 0) THEN
	 JSR = MAX(KSR,NINT((KER-KSR+1)/2 - FITRAD))
         JER = MIN(KER,NINT((KER-KSR+1)/2 + FITRAD))
	 JSC = MAX(KSC,NINT((KEC-KSC+1)/2 - FITRAD))
         JEC = MIN(KEC,NINT((KEC-KSC+1)/2 + FITRAD))
      ELSE
         JSR = KSR
         JSC = KSC
         JER = KER
         JEC = KEC
      END IF

C   We will assume that the convolution array is centered on pixel (0,0).
C   Otherwise the convolved image will be shifted relative to the input
C   image and in fact, a good chunk of it might fall outside of the new
C   image boundaries, which are identical to the old ones.

C   Loop over the convolution pixels

      DO 5501 JC = -NGW, NGW
        DO 5502 IC = -NGW, NGW

          IF (NOGO) RETURN

          JS = MAX(JSR,JSR-JC)
          JE = MIN(JER,JER-JC)
          IS = MAX(JSC,JSC-IC)
          IE = MIN(JEC,JEC-IC)

C	if (abs(jc) .le. 5 .and. abs(ic) .le. 5) print *, ic, jc, func(1,ic,jc)

C     Loop over the old image pixels and accumulate the sum
          DO 5503 J = JS,JE
            DO 5504 I = IS,IE

              FFT(2,I+IC,J+JC) = FFT(2,I+IC,J+JC) +
     &                         FUNC(1,IC,JC)*FFT(1,I,J)

5504        CONTINUE
5503      CONTINUE

5502    CONTINUE
5501  CONTINUE

      RETURN
      END

      SUBROUTINE READJITTER(JITFILE,ICAM,NSAMP,WJ,SMOOTHSIZE,HAVEJIT,
     &   HAVEGAUSS,GAUSS,NWX,NWY)

      CHARACTER*(*) JITFILE
      CHARACTER LINE*80
      INTEGER SMOOTHSIZE, UPPER
      REAL WJ(-SMOOTHSIZE:SMOOTHSIZE,-SMOOTHSIZE:SMOOTHSIZE)
      LOGICAL HAVEJIT, MILLI, HAVEGAUSS, HAVEVISTA
      LOGICAL REVERSE, SFLIP, TFLIP, NEWSMEAR
      real jitscale
      COMMON /REV/ REVERSE, SFLIP, TFLIP, NEWSMEAR, jitscale
        integer itest
	common /getscale/ itest
      data kernel/-12581/

      MILLI = .FALSE.
      HAVEVISTA = .FALSE.
      NWX = -1
      NWY = -1
      IF(HAVEJIT) THEN
        L = INDEX(JITFILE,' ') - 1
        OPEN(2,FILE=JITFILE(1:L),STATUS='OLD',IOSTAT=IERR)
        IF (IERR .NE. 0) THEN
          PRINT *, 'Error opening file ', jitfile(1:l)
          RETURN
        END IF
        DO I=1,5
          READ(2,'(A)') LINE
          L = UPPER(LINE)
          IF (INDEX(LINE,'MILLI') .GT. 0) MILLI = .TRUE.
          IF (INDEX(LINE,'BUFFER') .GT. 0) HAVEVISTA = .TRUE.
        END DO
      END IF


C   Load up integration array, with jitter if given
      IF (abs(ICAM) .EQ. 1) THEN
        THETA = 225
	theta = 0
      ELSE IF (abs(ICAM) .EQ. 2) THEN
        THETA = 135
	theta = -90
      ELSE IF (abs(ICAM) .EQ. 3) THEN
        THETA = 45
        theta = -180
      ELSE IF (abs(ICAM) .EQ. 4) THEN
        THETA = 315
        theta = 90
      ELSE
        THETA = 0
      END IF
      if (itest .eq. 3) theta = 0
      if (tflip) then
        theta = -1 * theta
      end if
      CALL WFPCSCALE(abs(ICAM),400.,400.,XSCALE,YSCALE)
      IF (NSAMP .GT. 0) THEN
        XSIZE = XSCALE / NSAMP 
        YSIZE = YSCALE / NSAMP
      ELSE
        XSIZE = XSCALE
        YSIZE = YSCALE
      END IF

C      IF (HAVEGAUSS) THEN
C        DO IY=MAX(-SMOOTHSIZE,NINT(-5*GAUSS/YSIZE/1000.)),
C     &        MIN(SMOOTHSIZE,NINT(5*GAUSS/YSIZE/1000.))
C          DY = IY * YSIZE * 1000.
C          DO IX=MAX(-SMOOTHSIZE,NINT(-5*GAUSS/XSIZE/1000.)),
C     &        MIN(SMOOTHSIZE,NINT(5*GAUSS/XSIZE/1000.))
C            DX = IX * XSIZE * 1000.
C            WJ(IX,IY) = 
C     &       EXP(-0.5*(DX**2+DY**2)/GAUSS**2)/(2.*3.14159*GAUSS**2)
C          END DO
C        END DO
C        NWX = 2*MIN(SMOOTHSIZE,NINT(5*GAUSS/XSIZE/1000.))+1
C        NWY = 2*MIN(SMOOTHSIZE,NINT(5*GAUSS/YSIZE/1000.))+1
C        RETURN
C      END IF

      IF (HAVEGAUSS) MILLI = .TRUE.

      NJIT = 0
      SI_V2 = 0.
      SI_V3 = 0.
      DO IY = -SMOOTHSIZE, SMOOTHSIZE
        DO IX = -SMOOTHSIZE, SMOOTHSIZE
          WJ(IX,IY) = 0.
        END DO
      END DO

      if (icam .le. 0) then
	print *, 'havevista, milli, revers: ', havevista, milli, reverse
        print *, 'xscale yscale: ', xscale, yscale, xsize, ysize
      end if
105   CONTINUE
      
      IF (HAVEJIT) THEN
        IF (HAVEVISTA) THEN
          READ(2,*,END=110,ERR=105) X, SI_V2, SI_V3
	  IF (REVERSE) THEN
            TMP = SI_V2  
            SI_V2 = SI_V3
            SI_V3 = TMP
          END IF
        ELSE
          READ(2,*,END=110,ERR=105) X, X, SI_V2, SI_V3
        END IF
      END IF
      IF (HAVEGAUSS) THEN
         SI_V2 = GASDEV(KERNEL)*GAUSS
         SI_V3 = GASDEV(KERNEL)*GAUSS
      END IF
106   NJIT = NJIT + 1
C   Flip signs because SI_V2/SI_V3 give vehicle motion, which is opposite
C      to star motion
      SI_V2 = -1 * SI_V2
      SI_V3 = -1 * SI_V3
      if (sflip) then
        SI_V2 = -1 * SI_V2
        SI_V3 = -1 * SI_V3
      end if

      DX = SI_V3*COSD(THETA) - SI_V2*SIND(THETA)
      DY = SI_V3*SIND(THETA) + SI_V2*COSD(THETA)
      IF (MILLI) THEN
        DX = DX / (XSIZE*1000)
        DY = DY / (YSIZE*1000)
      ELSE
        DX = DX / XSIZE
        DY = DY / YSIZE
      END IF
	dx = dx*jitscale
	dy = dy*jitscale
#ifdef NEWJIT
      IY = NINT(DY)
      IX = NINT(DX)
      WJ(IX,IY) = WJ(IX,IY) + 1
#else
      DO IY = -SMOOTHSIZE, SMOOTHSIZE
            YD = ABS(IY - DY)
            IF (YD .LT. NSAMP/2-1) THEN
              WY = 1
            ELSE IF (YD .GT. NSAMP/2+1) THEN
              WY = 0
            ELSE
              WY = NSAMP/4. + 0.5 - YD/2.
            END IF
            DO IX = -SMOOTHSIZE, SMOOTHSIZE
              XD = ABS(IX - DX)
              IF (XD .LT. NSAMP/2-1) THEN
                WX = 1
              ELSE IF (XD .GT. NSAMP/2+1) THEN
                WX = 0
              ELSE
                WX = NSAMP/4. + 0.5 - XD/2.
              END IF
              WJ(IX,IY) = WJ(IX,IY) + WX*WY
            END DO
      END DO
#endif

      IF (HAVEJIT) GOTO 105
      IF (HAVEGAUSS .AND. NJIT .LT. 10000) GOTO 105
110   IF (HAVEJIT) CLOSE(2)
      IF (NJIT .EQ. 0) THEN
          HAVEJIT = .FALSE.
          GOTO 106
      END IF

      NWX = 0
      NWY = 0
      DO IY = -SMOOTHSIZE, SMOOTHSIZE
        DO IX = -SMOOTHSIZE, SMOOTHSIZE
          WJ(IX,IY) = WJ(IX,IY) / NJIT
          IF (WJ(IX,IY) .GT. 0) THEN
            NWX = MAX(NWX,ABS(IX))
            NWY = MAX(NWY,ABS(IY))
          END IF
        END DO
      END DO
      NWX = 2*NWX + 1
      NWY = 2*NWY + 1

      RETURN
      END

	subroutine makegauss(smear,ndim,smpar,nsmooth)

	implicit none
	integer ndim,i,j,iii,jjj,nsmooth
	real smear(2,ndim,ndim),pi
	real smpar(nsmooth), gnorm
	parameter(pi = PI)

C        gnorm = 2*pi*smx*smy
        gnorm = 0.
        do j=1,ndim
          if (j .gt. ndim/2) then
            jjj = j-1-ndim
          else
            jjj = j-1
          end if
          do i=1,ndim
            if (i .gt. ndim/2) then
              iii = i-1-ndim
            else
              iii = i-1
            end if
            smear(1,i,j) = exp(-0.5*(iii**2/smpar(1)**2+jjj**2/smpar(2)**2))
            smear(2,i,j) = 0
	    gnorm=gnorm+smear(1,i,j)

          end do
	end do
	do j=1,ndim
	  do i=1,ndim
	    smear(1,i,j) = smear(1,i,j) / gnorm
	  end do
	end do

	return
	end

	subroutine zerloc(xx,yy,zvar,z)
	
	real xx, yy, zvar(0:5,11), z(11)
	real slope(5)

        slope(1) = xx-400
        slope(2) = yy-400
        slope(3) = (xx-400)**2
        slope(4) = (yy-400)**2
        slope(5) = (xx-400)*(yy-400)

	do i=4,11
           z(i) = zvar(0,i)
           do j=1,5
             z(i) = z(i) + zvar(j,i)*slope(j)
           end do
	end do

	return
	end


	subroutine dosmear(psf,maxpsfsize,smpar,nsmooth,fitrad)

	real psf(maxpsfsize,maxpsfsize), tmp(maxpsfsize,maxpsfsize)
	real smpar(nsmooth), fitrad, smdiag
	integer i, j
	real jitscale
        LOGICAL REVERSE, SFLIP, TFLIP, NEWSMEAR
	COMMON /REV/ REVERSE, SFLIP, TFLIP, NEWSMEAR, jitscale

	if (smpar(1) .eq. 1) return
        smdiag = (1. - abs(smpar(1)) - 2*smpar(2) - 2*smpar(3)) / 4.

	if (newsmear) then
          smpar(3) = (1. - smpar(1) - 2*smpar(2) ) / 2. / (1. + 4.*smpar(2))
          smdiag = 2*smpar(2)*smpar(3)
        end if

	do j=1,maxpsfsize
	  do i=1,maxpsfsize
	    tmp(i,j) = 0.
	  end do
	end do
	do j=2,2*fitrad+6
	  do i=2,2*fitrad+6
	    do js=-1,1
	      do is=-1,1
                if (abs(js) .eq. 1 .and. abs(is) .eq. 1) then
                  smear = smdiag
                else if (js .eq. 0 .and. is .eq. 0) then
                  smear = abs(smpar(1))
                else if (js .eq. 0) then
                  smear = smpar(2)
                else
                  smear = smpar(3)
                end if
                tmp(i,j) = tmp(i,j) + smear*psf(i+is,j+js)
              end do
            end do
            
	  end do
	end do

	do j=1,2*fitrad+7
	  do i=1,2*fitrad+7
	    psf(i,j) = tmp(i,j)
          end do
	end do

	return
	end

	subroutine fullcmul(s1,s2,ndim)
	real s1(2,ndim,ndim)
	real s2(2,ndim,ndim)
	do j=1,ndim
	  do i=1,ndim
            tmp        = s1(1,i,j)*s2(1,i,j)-s1(2,i,j)*s2(2,i,j)
            s1(2,i,j) = s1(2,i,j)*s2(1,i,j)+s1(1,i,j)*s2(2,i,j)
            s1(1,i,j) = tmp
          end do
	end do
	return
	end
