#include "Vista.h"
#define __MAXPAR 16

      SUBROUTINE BDFIT(A,ISROW,IEROW,ISCOL,IECOL)
     
      IMPLICIT NONE

      INTEGER ISCOL, IECOL, ISROW, IEROW 
      REAL A(ISCOL:IECOL,ISROW:IEROW)
      
      INCLUDE 'vistadisk/source/include/vistalink.inc'
      INCLUDE 'vistadisk/source/include/imagelink.inc'
      
      LOGICAL KEYCHECK
      CHARACTER PARM*8, STRING*8
      INTEGER MAXPAR
      PARAMETER (MAXPAR = __MAXPAR)

      REAL TMP, FWHM, XCEN, YCEN, RMIN, RMAX, GAIN, SKY, SKYERR, RMAXINNER
      REAL TOTOBS, TOTMOD, BN, GAMMLN, VAL(4)
      INTEGER I, J, MAXITER, ISIGBUF, IPSFBUF, NP, NPIX, IST, NPIXIN, SUBTYPE
      INTEGER NDIM, I1, I2, J1, J2, NITER, IPAR, JPAR, NPAR, NREQD, NREQB
      REAL CHI2, CHI2OLD, CHI2IN
      REAL*8 PAR(MAXPAR), DEL(MAXPAR),  BETA(MAXPAR), ALP(MAXPAR,MAXPAR)
      REAL*8 DPAR(MAXPAR), EPAR(MAXPAR), PAROLD(MAXPAR), LAMBDA
      REAL*8 BETAOLD(MAXPAR), ALPOLD(MAXPAR,MAXPAR)
      REAL*8 GAMMA, B(5), BULGE, DISK, BDRATIO
      REAL*8 RINNER, BNCOEFF
      LOGICAL LOCK(MAXPAR), REDO, MASK, DORINNER
      CHARACTER*9 NAME(MAXPAR)
      
#ifdef __64BITADDRESS
      INTEGER*8 LOCMOD, LOCDERV, LOCWORK, LOCSEE, LOCERR, LOCPSF
#else 
      INTEGER LOCMOD, LOCDERV, LOCWORK, LOCSEE, LOCERR, LOCPSF
#endif
     
      REAL*8 PI 
      PARAMETER(PI = 3.14159)
      LOGICAL DEBUG, CONSERVE, RWEIGHT, ONED, VERBOSE
      COMMON/D/DEBUG, CONSERVE, RWEIGHT
C      COMMON/P/C(15)

      DATA NAME/'Disk  CSB','      h','      inc','      PA',
     +     'Bulge I_e','      r_e','      n','      inc',
     +     'Bar   CSB','      rx','      ry','      PA',
     +     'Sky', 'xcen', 'ycen', 'point'/

C    1D or 2D fit?
      ONED = .FALSE.
      NREQD = 4
      NREQB = 4
      IF (IEROW-ISROW+1 .EQ. 1) THEN
        ONED = .TRUE.
        NREQD = 2
        NREQB = 3
      END IF
      
C     Keywords
      CALL KEYINIT
      CALL KEYDEF('LOCK=')
      CALL KEYDEF('FWHM=')
      CALL KEYDEF('PSFBUF=')
      CALL KEYDEF('GAIN=')
      CALL KEYDEF('SIGBUF=')
      CALL KEYDEF('SKY=')
      CALL KEYDEF('FITSKY')
      CALL KEYDEF('SKYERR=')
      CALL KEYDEF('XCEN=')
      CALL KEYDEF('YCEN=')
      CALL KEYDEF('FITCEN')
      CALL KEYDEF('C=')
      CALL KEYDEF('RMIN=')
      CALL KEYDEF('RMAX=')
      CALL KEYDEF('MAXITER=')
      CALL KEYDEF('MASK')
      CALL KEYDEF('DISK=')
      CALL KEYDEF('BULGE=')
      CALL KEYDEF('BAR=')
      CALL KEYDEF('POINT=')
      CALL KEYDEF('SUB')
      CALL KEYDEF('CHI2')
      CALL KEYDEF('DEBUG')
      CALL KEYDEF('CONSERVE')
      CALL KEYDEF('RWEIGHT')
      CALL KEYDEF('VERBOSE')
      CALL KEYDEF('NORINNER')
      
      IF (.NOT. KEYCHECK()) THEN
         XERR = .TRUE.
         RETURN
      END IF
      
      DO 441 I = 1, 4
         VAL(I) = 0. 
 441  CONTINUE
      
      DO 444 I = 1, MAXPAR
         LOCK(I) = .TRUE.
         PAR(I) = 0.
 444  CONTINUE

      PAR(10) = 1.
      PAR(11) = 1.
      PAR(7) = 1.
      
      XCEN = 0.
      YCEN = 0.
      SKY = 0.
      SKYERR = 0.
      FWHM = 0.
      RMIN = 0.
      RMAX = 0.
      GAIN = 1.
      MASK = .FALSE.
      MAXITER = 100
      SUBTYPE = 0
      DEBUG = .FALSE.
      CONSERVE = .FALSE.
      RWEIGHT = .FALSE.
      VERBOSE = .FALSE.
      DORINNER = .TRUE.
      ISIGBUF = 0
      IPSFBUF = 0

C     Set parameters using the input given to BDFIT2D

      DO 5501 I=1,NCON
         IF (WORD(I)(1:5) .EQ. 'LOCK=') THEN
            CALL ASSIGNV(WORD(I),2,VAL,NP,PARM)
            IF (XERR) RETURN
            IPAR = NINT(ABS(VAL(1)))
            IF (VAL(1) .GT. 0) THEN
               LOCK(IPAR) = .FALSE.
               IF (NP .GE. 2) PAR(IPAR) = VAL(2)
            ELSE
               LOCK(IPAR) = .TRUE.
               PAR(IPAR) = VAL(2)
            END IF
            
         ELSE IF (WORD(I)(1:5) .EQ. 'FWHM=') THEN
            CALL ASSIGN(WORD(I),FWHM,PARM)
            IF (XERR) RETURN
            
         ELSE IF (WORD(I)(1:5) .EQ. 'RMAX=') THEN
            CALL ASSIGN(WORD(I),RMAX,PARM)
            IF (XERR) RETURN
            
         ELSE IF (WORD(I)(1:5) .EQ. 'RMIN=') THEN
            CALL ASSIGN(WORD(I),RMIN,PARM)
            IF (XERR) RETURN
            
         ELSE IF (WORD(I)(1:5) .EQ. 'GAIN=') THEN
            CALL ASSIGN(WORD(I),GAIN,PARM)
            IF (XERR) RETURN
            
         ELSE IF (WORD(I)(1:7) .EQ. 'SIGBUF=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            ISIGBUF = NINT(TMP)
            
         ELSE IF (WORD(I)(1:7) .EQ. 'PSFBUF=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            IPSFBUF = NINT(TMP)
            
         ELSE IF (WORD(I)(1:4) .EQ. 'SKY=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            PAR(13) = TMP
            
         ELSE IF (WORD(I) .EQ. 'FITSKY') THEN
            LOCK(13) = .FALSE.
            
         ELSE IF (WORD(I)(1:7) .EQ. 'SKYERR=') THEN
            CALL ASSIGN(WORD(I),SKYERR,PARM)
            IF (XERR) RETURN
            
         ELSE IF (WORD(I)(1:5) .EQ. 'XCEN=') THEN
            CALL ASSIGN(WORD(I),XCEN,PARM)
            IF (XERR) RETURN
            
         ELSE IF (WORD(I)(1:5) .EQ. 'YCEN=') THEN
            CALL ASSIGN(WORD(I),YCEN,PARM)
            IF (XERR) RETURN
            
         ELSE IF (WORD(I) .EQ. 'FITCEN' )THEN
            LOCK(14) = .FALSE.
            LOCK(15) = .FALSE.
            
         ELSE IF (WORD(I)(1:2) .EQ. 'C=') THEN
            CALL ASSIGNV(WORD(I),2,VAL,NP,PARM)
            XCEN = VAL(2)
            YCEN = VAL(1)
            IF (XERR) RETURN
            
         ELSE IF (WORD(I)(1:8) .EQ. 'MAXITER=') THEN
            CALL ASSIGN(WORD(I),TMP,PARM)
            IF (XERR) RETURN
            MAXITER = NINT(TMP)
            
         ELSE IF (WORD(I) .EQ. 'MASK') THEN
            MASK = .TRUE.
            
         ELSE IF (WORD(I)(1:5) .EQ. 'DISK=') THEN
            CALL ASSIGNV(WORD(I),4,VAL,NP,PARM)
            IF (XERR) RETURN
            IF (NP .NE. NREQD) THEN
               PRINT 101, NREQD
101            FORMAT('You must enter', i2,' disk parameters')
               XERR = .TRUE.
              RETURN
            END IF 
            DO J=1,NREQD
               PAR(J) = VAL(J)
               LOCK(J) = .FALSE.
            END DO
            
         ELSE IF (WORD(I)(1:6) .EQ. 'BULGE=') THEN
            CALL ASSIGNV(WORD(I),4,VAL,NP,PARM)
            IF (XERR) RETURN
            IF (NP .NE. NREQB) THEN
               PRINT 102, NREQB
102            FORMAT('You must enter', i2,' bulge parameters')
              XERR = .TRUE.
              RETURN
            END IF 
            DO J=1,NREQB
              PAR(4+J) = VAL(J)
              LOCK(4+J) = .FALSE.
            END DO
            
         ELSE IF (WORD(I)(1:4) .EQ. 'BAR=') THEN
            CALL ASSIGNV(WORD(I),4,VAL,NP,PARM)
            IF (XERR) RETURN
            IF (ONED) THEN
              PRINT *, 'No bar for 1D model...'
              XERR = .TRUE.
              RETURN
            END IF
            IF (NP .NE. 4) THEN
               PRINT *, 'You must enter 4 bar parameters'
               XERR = .TRUE.
              RETURN
            END IF 
            DO J=1,4
               PAR(8+J) = VAL(J)
               LOCK(8+J) = .FALSE.
            END DO

         ELSE IF (WORD(I)(1:6) .EQ. 'POINT=') THEN
            CALL ASSIGN(WORD(I),VAL,PARM)
            IF (XERR) RETURN
            PAR(16) = VAL(1)
            LOCK(16) = .FALSE.
            
         ELSE IF (WORD(I) .EQ. 'SUB' )THEN
            SUBTYPE = 1
            
         ELSE IF (WORD(I) .EQ. 'CHI2' )THEN
            SUBTYPE = 2
            
         ELSE IF (WORD(I) .EQ. 'DEBUG' )THEN
            DEBUG = .TRUE.
            
         ELSE IF (WORD(I) .EQ. 'CONSERVE' )THEN
            CONSERVE = .TRUE.
            
         ELSE IF (WORD(I) .EQ. 'RWEIGHT' )THEN
            RWEIGHT = .TRUE.
            
         ELSE IF (WORD(I) .EQ. 'VERBOSE' )THEN
            VERBOSE = .TRUE.
            
         ELSE IF (WORD(I) .EQ. 'NORINNER' )THEN
            DORINNER = .FALSE.
            
         END IF
         
 5501 CONTINUE
     
      PAR(14) = XCEN
      PAR(15) = YCEN
 
C     Convert angles to radians
      PAR(3) = PAR(3)*PI/180.
      PAR(4) = PAR(4)*PI/180.
      PAR(12) = PAR(12)*PI/180.
      PAR(8) = PAR(8)*PI/180.
      
      IF (PAR(4) .EQ. 0) PAR(4) = 0.0000001
      IF (PAR(12) .EQ. 0) PAR(12) = 0.0000001
      IF (PAR(8) .EQ. 0) PAR(8) = 0.0000001

      IF (ONED) THEN
         XCEN = ISCOL
         YCEN = ISROW
         LOCK(3) = .TRUE.
         PAR(3) = 0.
         LOCK(4) = .TRUE.
         PAR(4) = 0.
         LOCK(8) = .TRUE.
         PAR(8) = 0.
         LOCK(9) = .TRUE.
         PAR(9) = 0.
         LOCK(10) = .TRUE.
         PAR(10) = 0.
         LOCK(11) = .TRUE.
         PAR(11) = 0.
         LOCK(12) = .TRUE.
         PAR(12) = 0.
      ELSE IF (XCEN .LE. 0 .OR. YCEN .LE. 0) THEN
         PRINT *, 'You must specify non-zero XCEN, YCEN'
         XERR = .TRUE.
         RETURN
      END IF

      IF (RMAX .LE. 0) THEN
         PRINT *, 'You must specify non-zero RMAX'
         XERR = .TRUE.
         RETURN
      END IF
      IF (RMIN .GE. RMAX) THEN
         PRINT *, 'RMIN must be less than RMAX'
         XERR = .TRUE.
         RETURN
      END IF
     
C     If we have an error buffer, get its information
      IF (ISIGBUF .GT. 0) THEN
         IF (.NOT. BUFF(ISIGBUF)) THEN
           PRINT *, 'No data in error buffer: ', ISIGBUF
           XERR = .TRUE.
         END IF
         IF ((ICOORD(NNCOL,ISIGBUF) .NE. ICOORD(NNCOL,IBUF(1))) .OR.
     &       (ICOORD(NNROW,ISIGBUF) .NE. ICOORD(NNROW,IBUF(1)))) THEN
           PRINT *,'Error buffer does not have same size as data buffer'
           XERR = .TRUE.
         END IF
         IF (XERR) RETURN
         LOCERR = IMLOC(ISIGBUF)
         GAIN = -1*GAIN
      END IF
C     If we have a PSF buffer, get its information
      IF (IPSFBUF .GT. 0) THEN
         IF (.NOT. BUFF(IPSFBUF)) THEN
           PRINT *, 'No data in error buffer: ', IPSFBUF
           XERR = .TRUE.
         END IF
         IF (XERR) RETURN
         LOCPSF = IMLOC(IPSFBUF)
         IF (FWHM .GT. 0) THEN
           PRINT *, 'Cannot specify both PSFBUF= and FWHM='
           XERR = .TRUE.
           RETURN
         END IF
         FWHM=5
      END IF
 
C     Allocate arrays of next largest power of 2 (for FFTs for 
C          seeing convolution)
      IF (ONED) THEN
        NDIM = INT (LOG(RMAX+5*FWHM)/LOG(2.) )
        IF (2**NDIM .LT. RMAX+5*FWHM) NDIM = NDIM + 1
      ELSE
        NDIM = INT (LOG(2*RMAX)/LOG(2.) )
        IF (2**NDIM .LT. 2*RMAX) NDIM = NDIM + 1
      END IF
      NDIM = 2**NDIM
     
      IF (ONED) THEN
        I1 = ISCOL
        I2 = MIN(IECOL,NINT(ISCOL+RMAX))
        J1 = ISROW
        J2 = MIN(IEROW,NINT(ISROW+RMAX))
      ELSE 
        I1 = MAX(ISCOL, NINT(XCEN - NDIM/2))
        I2 = MIN(IECOL, NINT(XCEN + NDIM/2 - 1))
        J1 = MAX(ISROW, NINT(YCEN - NDIM/2))
        J2 = MIN(IEROW, NINT(YCEN + NDIM/2 - 1))
      END IF
      
C     Create a holding array for the seeing-convolved model
      CALL CCALLOC(4*NDIM*NDIM,LOCMOD)
      CALL CCALLOC(4*NDIM*NDIM*MAXPAR,LOCDERV)
      IF (LOCMOD .EQ. 0 .OR. LOCDERV .EQ. 0) THEN
         PRINT *, 'Error allocating virtual memory'
         XERR = .TRUE.
         RETURN
      END IF
      
C     Allocate, load and FFT seeing profile and FFT holding array
      CALL CCALLOC(8*NDIM*NDIM,LOCSEE)
      CALL CCALLOC(8*NDIM*NDIM,LOCWORK)
      IF (LOCSEE .EQ. 0 .OR. LOCWORK .EQ. 0) THEN
         PRINT *, 'Error allocating virtual memory'
         XERR = .TRUE.
         RETURN
      END IF
      IF (IPSFBUF .GT. 0) THEN
         CALL CCMKPSF(LOCPSF,ICOORD(IYSR,IPSFBUF),ICOORD(IYER,IPSFBUF),
     &                       ICOORD(IXSC,IPSFBUF),ICOORD(IXEC,IPSFBUF),
     &                LOCSEE,NDIM)
      ELSE IF (FWHM .GT. 0) THEN
         CALL CCMKGAUSS(LOCSEE,NDIM,FWHM)
      END IF
      
C     Square limits and sky error to save computation later
      RMIN = RMIN**2
      RMAX = RMAX**2
      SKYERR = SKYERR**2
      SKY = PAR(13)
      
      NITER = 0
      CHI2OLD = 1.E30
      LAMBDA = 1.E-6
      
      IF (CONSERVE) THEN
         IF (.NOT. LOCK(1) ) THEN
            LOCK(1) = .TRUE.
            PAR(1) = 1.
         ELSE IF (.NOT. LOCK(5)) THEN
            LOCK(5) = .TRUE.
            PAR(5) = 1.
         ELSE IF (.NOT. LOCK(9)) THEN
            LOCK(9) = .TRUE.
            PAR(9) = 1.
         END IF
      END IF
      
 1001 NITER = NITER + 1
      
      IF (NOGO) RETURN
      CALL LOOPDISP
      
C     Initialize matrices

      DO 1002 IPAR = 1, MAXPAR
         BETA(IPAR) = 0.
         DO 1003 JPAR = 1, MAXPAR
            ALP(JPAR,IPAR) = 0.
 1003    CONTINUE
 1002 CONTINUE
      
C     Create model and derivative at all desired pixel locations
      CALL CCLOADMODEL(LOCMOD,LOCDERV,LOCSEE,LOCWORK,J1,J2,I1,I2,
     &     XCEN,YCEN,RMIN,RMAX,PAR,LOCK,MAXPAR,FWHM,NDIM)
      CALL LOOPDISP
      
C     Now accumulate least squares matrices, CHI2, etc
      CALL CCACCUM(LOCMOD,LOCDERV,J1,J2,I1,I2,A,ISROW,IEROW,ISCOL,IECOL,LOCERR,
     &     MASK, XCEN, YCEN, RMIN, RMAX, GAIN, SKYERR, SKY, MAXPAR, NPAR, LOCK, 
     &     CHI2, NPIX, ALP, BETA, NDIM)
      
      IF (DEBUG) GOTO 999
      print *, 'Iteration: ', niter, ' npar: ', npar, ' chi2: ', chi2, 
     &     ' lambda: ', lambda
      
C     If CHI2 increased, back up one step and increase LAMBDA. Otherwise,
C     save current step and decrease LAMBDA.

      IF (CHI2 .GT. CHI2OLD) THEN
         CHI2 = CHI2OLD
         IPAR = 0
         DO I = 1, MAXPAR
            PAR(I) = PAROLD(I)
            IF (.NOT. LOCK(I)) THEN
               IPAR = IPAR + 1
               BETA(IPAR) = BETAOLD(IPAR)
               JPAR = 0
               DO J = 1, MAXPAR
                  IF (.NOT. LOCK(J)) THEN
                     JPAR = JPAR + 1
                     ALP(JPAR,IPAR) = ALPOLD(JPAR,IPAR)
                  END IF
               END DO
            END IF
         END DO
         LAMBDA = LAMBDA * 10.
         NITER = NITER - 1
      ELSE
         CHI2OLD = CHI2
         IPAR = 0
         DO I = 1, MAXPAR
            PAROLD(I) = PAR(I)
            IF (.NOT. LOCK(I)) THEN
               IPAR = IPAR + 1
               BETAOLD(IPAR) = BETA(IPAR)
               JPAR = 0
               DO J = 1, MAXPAR
                  IF (.NOT. LOCK(J)) THEN
                     JPAR = JPAR + 1
                     ALPOLD(JPAR,IPAR) = ALP(JPAR,IPAR)
                  END IF
               END DO
            END IF
         END DO
         LAMBDA = MAX(1.D-6,LAMBDA / 10.)
      END IF
     
      IF (VERBOSE) PRINT *, 'Adjusting and inverting: ', LAMBDA 
      DO IPAR = 1, NPAR
         IF (VERBOSE) PRINT *, IPAR, ALP(IPAR,IPAR), ALPOLD(IPAR,IPAR), beta(ipar)
         ALP(IPAR,IPAR) = ALP(IPAR,IPAR) * (1.+LAMBDA)
C        DO JPAR = 1, NPAR
C          IF (IPAR .NE. JPAR) THEN
C            ALP(JPAR,IPAR) = ALP(JPAR,IPAR) / (1.+LAMBDA)
C          END IF
C        END DO
      END DO
      
C     Invert the matrix and solve for parameter changes

      IF (NPAR .GT. 0) THEN
         CALL DINVERS(ALP,MAXPAR,NPAR,IST)
         IF (IST .NE. 0) THEN
            PRINT *, 'Error inverting matrix'
            do i=1,npar
               print *, par(i), beta(i)
            end do
            do i=1,npar
               print *, (alp(i,j),j=1,npar)
            end do
            XERR = .TRUE.
            RETURN
         END IF
         CALL DVMUL(ALP,MAXPAR,NPAR,BETA,DEL)
         
C     Make the parameter changes

         IF (NITER .EQ. MAXITER) GOTO 201

         IF (VERBOSE) PRINT *, 'Making parameter changes '
         NPAR = 0
         REDO = .FALSE.
         DO 4409 IPAR = 1, MAXPAR
            IF (.NOT. LOCK(IPAR)) THEN
               NPAR = NPAR + 1
               IF (ABS(DEL(NPAR)/PAR(IPAR)) .GT. 0.001) REDO = .TRUE.

C     Dont let intensities change by more than 50%
#define LIMIT
               IF (IPAR .EQ. 1 .OR. IPAR .EQ. 5 .OR. IPAR .EQ. 9 .OR.
     &             IPAR .EQ. 16) THEN
                  PAR(IPAR) = PAR(IPAR) +  DEL(NPAR)
#ifdef LIMIT
     &                 /(1.+abs(del(npar)/(0.5*abs(par(ipar)))) )
#endif
                  PAR(IPAR) = MAX(PAR(IPAR),0.01D0)
                  
C     Dont let scale lengths change by more than 10%
               ELSE IF (IPAR .EQ. 2 .OR. IPAR .EQ. 6 .OR. IPAR .EQ. 10 .OR.
     &                 IPAR .EQ. 11) THEN
                  PAR(IPAR) = PAR(IPAR) + DEL(NPAR)
#ifdef LIMIT
     &                 /(1.+abs(del(npar)/(0.1*abs(par(ipar)))) )
#endif
                  PAR(IPAR) = MAX(PAR(IPAR),0.01D0)
                  
C     Dont let inclination/position angles change by more than 5 degrees (0.09 radians)
               ELSE IF (IPAR .EQ. 3 .OR. IPAR .EQ. 4 .OR. 
     &                  IPAR .EQ. 8 .OR. IPAR .EQ. 12) THEN
                  PAR(IPAR) = PAR(IPAR) + DEL(NPAR)
#ifdef LIMIT
     &                 /(1.+abs(del(npar)/0.09) )
#endif
                  
C     Dont let bulge exponent change by more than 0.1, and make sure it is positive
               ELSE IF (IPAR .EQ. 7) THEN
                  PAR(IPAR) = PAR(IPAR) + DEL(NPAR)
#ifdef LIMIT
     &                 /(1.+abs(del(npar)/0.10) )
#endif
                  PAR(IPAR) = MAX(PAR(IPAR),0.01D0)
                  
C     Dont let sky change by more than 0.1 Dn
               ELSE IF (IPAR .EQ. 13) THEN
                  PAR(IPAR) = PAR(IPAR) + DEL(NPAR)
#ifdef LIMIT
     &                 /(1.+abs(del(npar)/0.10) )
#endif
                  SKY = PAR(IPAR)
                  
               ELSE IF (IPAR .EQ. 14) THEN
                  PAR(IPAR) = PAR(IPAR) + DEL(NPAR)
#ifdef LIMIT
     &                 /(1.+abs(del(npar)/0.10) )
#endif
                  XCEN = PAR(IPAR)
                  
               ELSE IF (IPAR .EQ. 15) THEN
                  PAR(IPAR) = PAR(IPAR) + DEL(NPAR)
#ifdef LIMIT
     &                 /(1.+abs(del(npar)/0.10) )
#endif
                  YCEN = PAR(IPAR)
                  
               ELSE
                  PAR(IPAR) = PAR(IPAR) + DEL(NPAR)
               END IF
               IF (ALP(NPAR,NPAR) .GT. 0) THEN
                  EPAR(IPAR) = SQRT(ALP(NPAR,NPAR))
               ELSE
                  EPAR(IPAR) = 99.99
               END IF
               if (verbose) print 7, name(ipar), par(ipar), parold(ipar), del(npar)
            ELSE
               EPAR(IPAR) = 0.
               if (verbose) print 7, name(ipar), par(ipar)
            END IF
 4409    CONTINUE
         IF (.NOT. VERBOSE) THEN
           PRINT 707, (parold(ipar),ipar=1,maxpar)
           PRINT 707, (par(ipar),ipar=1,maxpar)
         END IF
707      FORMAT(20F9.3)
         
         PAR(3) = MOD(PAR(3),PI)
         PAR(4) = MOD(PAR(4),2*PI)
         PAR(12) = MOD(PAR(12),2*PI)
         PAR(8) = MOD(PAR(8),PI)
         
         IF (VERBOSE) PRINT *, 'Done iteration', NITER, MAXITER, REDO
         IF (NITER .EQ. MAXITER) REDO = .FALSE.
         
         IF (REDO) GOTO 1001

      END IF
      
 201  CONTINUE

C     Fit has converged or gone to maximum number of iterations

C     Compute inner chi2
      IF (VERBOSE) PRINT *, 'Computing RMAXINNER'
      IF (DORINNER .AND. PAR(6) .GT. 0 .AND. PAR(2) .GT. 0) THEN
        RMAXINNER = 2*RINNER(DBLE(PAR(5)), DBLE(PAR(1)), DBLE(PAR(6)), 
     &                     DBLE(PAR(2)), DBLE(PAR(7)))
        CALL CCACCUM(LOCMOD,LOCDERV,J1,J2,I1,I2,A,ISROW,IEROW,ISCOL,IECOL, LOCERR, 
     &    MASK, XCEN, YCEN, RMIN, RMAXINNER, GAIN, SKYERR, SKY, MAXPAR, NPAR, 
     &    LOCK, CHI2IN, NPIXIN, ALP, BETA, NDIM)
      ELSE
        RMAXINNER = 0.
      END IF
      
C     Put fit in place of original array, and get normalization
      CALL CCSUBMODEL(LOCMOD,J1,J2,I1,I2,A,ISROW,IEROW,ISCOL,IECOL,LOCERR,SUBTYPE,
     &     XCEN,YCEN,RMIN, RMAX, TOTOBS, TOTMOD, SKY, NDIM, GAIN, SKYERR)
      
      PAR(1) = PAR(1)*TOTOBS/TOTMOD
      PAR(5) = PAR(5)*TOTOBS/TOTMOD
      PAR(9) = PAR(9)*TOTOBS/TOTMOD

C     Convert angles to degrees
      PAR(3) = PAR(3)*180/PI
      EPAR(3) = EPAR(3)*180/PI
      PAR(4) = PAR(4)*180/PI
      EPAR(4) = EPAR(4)*180/PI
      PAR(8) = PAR(8)*180/PI
      EPAR(8) = EPAR(8)*180/PI
      PAR(12) = PAR(12)*180/PI
      EPAR(12) = EPAR(12)*180/PI

C     Adjust PA appropriately if it is out of bounds
      IF (PAR(4) .LE. 0.) THEN
         PAR(4) = PAR(4) + 180.
      ELSE IF (PAR(4) .GT. 180) THEN
         PAR(4) = PAR(4) - 180.
      END IF
      IF (PAR(12) .LE. 0.) THEN
         PAR(12) = PAR(12) + 180.
      ELSE IF (PAR(12) .GT. 180) THEN
         PAR(12) = PAR(12) - 180.
      END IF

C     Compute bulge-to-disk ratio
      BN = BNCOEFF(DBLE(PAR(7)))
      IF (PAR(1) .EQ. 0) THEN
        BDRATIO = -1
      ELSE IF (PAR(5) .EQ. 0) THEN
        BDRATIO = 0
      ELSE
        GAMMA = EXP(gammln(SNGL(2*PAR(7))))
        BULGE = PAR(7)*GAMMA*(EXP(BN)/BN**(2*PAR(7)))*(PAR(6)**2)*(PAR(5))
        DISK = (PAR(2)**2)*PAR(1)
        BDRATIO = BULGE/DISK
      END IF

C     Print out the final values of the computation

      PRINT *, 'Final values: '
      DO IPAR = 1, MAXPAR
         IF (IPAR .EQ. 5) THEN
         PRINT 7, NAME(IPAR), PAR(IPAR), EPAR(IPAR), PAR(IPAR)*EXP(BN)
         ELSE IF (IPAR .EQ. 6) THEN
         PRINT 7, NAME(IPAR), PAR(IPAR), EPAR(IPAR), PAR(IPAR)/BN**PAR(7)
         ELSE
         PRINT 7, NAME(IPAR), PAR(IPAR), EPAR(IPAR)
         END IF
 7       FORMAT(A9,4F12.5)
         WRITE(STRING,199) IPAR
 199     FORMAT('PAR',I2.2)
         CALL VARIABLE(STRING,SNGL(PAR(IPAR)),.TRUE.)
         WRITE(STRING,299) IPAR
 299     FORMAT('EPAR',I2.2)
         CALL VARIABLE(STRING,SNGL(EPAR(IPAR)),.TRUE.)
      END DO

      IF (DORINNER) THEN
        PRINT 1028, 'Inner Chi^2             ', CHI2IN
        PRINT 1028, 'Inner Chi^2 DOF         ', CHI2IN/(NPIXIN - NPAR)
        CALL VARIABLE('CHI2IN',CHI2IN,.TRUE.)
        CALL VARIABLE('CHI2INDF',CHI2IN/(RMAXINNER**2-NPAR),.TRUE.)
      END IF
      PRINT 1028, '      Chi^2             ', CHI2
      PRINT 1028, '      Chi^2 DOF         ', CHI2/(NPIX-NPAR)
 1028 FORMAT(A24,F9.1)

      PRINT 8,'B/D ratio            ', BDRATIO
 8    FORMAT(A21,F12.4)

      CALL VARIABLE('BDRATIO',SNGL(BDRATIO),.TRUE.)
      CALL VARIABLE('CHI2',CHI2,.TRUE.)
      CALL VARIABLE('CHI2DF',CHI2/(NPIX-NPAR),.TRUE.)
      CALL VARIABLE('NITER',FLOAT(NITER),.TRUE.)

      IF (PAR(3) .LT. 0. .OR. PAR(8) .LT. 0.) THEN
         PRINT *, 'negative and positive inclinations are equivalent'
      END IF
      PAR(3) = PAR(3)*PI/180
      PAR(4) = PAR(4)*PI/180
      PAR(12) = PAR(12)*PI/180
      PAR(8) = PAR(8)*PI/180
      
 999  CONTINUE
      
      CALL CCFREE(4*NDIM*NDIM,LOCMOD)
      CALL CCFREE(4*NDIM*NDIM*MAXPAR,LOCDERV)
      CALL CCFREE(8*NDIM*NDIM,LOCSEE)
      CALL CCFREE(8*NDIM*NDIM,LOCWORK)
      
      RETURN
      END
      
      REAL FUNCTION FUNC(X,Y,FPAR,NPAR,FWHM)
    
C     Function describing the disk, the bulge and the bar brightness profiles 
C     The disk is an exponential law (I(r)=I_o exp{-r/h}), with inclination and 
C     position angle correction.  The bulge is described by an inclined Sersic 
C     profile (I(r)=I_e exp{-b[(r/r_e)^{1/n}-1]}). 
C     The bulge is given the same position angle as the disk. 
C     The bar is a Freeman bar, SQRT(1-(x/ba)^2-(y/bb)^2), + pa
C     FPAR
C      1: DISK  central surface brightness
C      2:       scale length
C      3:       inclination
C      4:       position angle OF DISK AND BULGE
C      5: BULGE effective surface brightness
C      6:       effective radius
C      7:       Sersic exponent n 
C      8:       inclination
C      9: BAR   central surface brightness
C     10:       scale length, one direction (rx)
C     11:       scale length, second direction (ry) 
C     12:       position angle
C     13: SKY   value
C     14: xcen
C     15: xcen
C     16: point source amplitude

      REAL X, Y, FWHM
      REAL A(5)
      REAL*8 FPAR(NPAR)
      DOUBLE PRECISION BNCOEFF

C     some constants
      COSPA = COS(FPAR(4))
      SINPA = SIN(FPAR(4))
      COSBAR = COS(FPAR(12))
      SINBAR = SIN(FPAR(12))
      
C     First the disk....
      XROT = X*COSPA + Y*SINPA
      YROT = -X*SINPA + Y*COSPA
      
      IF (FPAR(1) .LE. 0) THEN
         DISK = 0.
      ELSE
         DISK = FPAR(1)*
     &        EXP(-SQRT( (XROT/COS(FPAR(3)))**2 + YROT**2) / FPAR(2) )
      END IF
      
C     Then the bulge:
      IF (FPAR(6).LE.0.) THEN
         BULGE= 0.
      ELSE
         RAD = SQRT( (XROT/COS(FPAR(8)))**2+YROT**2 )
         
         BN = BNCOEFF(DBLE(FPAR(7)))
         RATIOPW = (RAD/FPAR(6))**(1/FPAR(7))
         BULEXP = -BN*(RATIOPW-1)
         BULGE = FPAR(5)*EXP(BULEXP)
      ENDIF
      
C     And finally the bar:

      IF (FPAR(9).EQ.0.OR.(FPAR(10).EQ.0.).OR.(FPAR(11).EQ.0.)) THEN
         BAR=0.
      ELSE
         XROT = X*COSBAR + Y*SINBAR
         YROT = -X*SINBAR + Y*COSBAR
         BAR = 1.- (XROT/FPAR(10))**2- (YROT/FPAR(11))**2
         IF (BAR.GT.0.) THEN
            BAR = FPAR(9)*SQRT(BAR)
         ELSE
            BAR = 0.
         ENDIF
      ENDIF

      IF (FPAR(16) .EQ. 0) THEN
        POINT = 0
      ELSE
        IF (ABS(X) .LT. 0.5 .AND. ABS(Y) .LT. 0.5) THEN
          POINT=FPAR(16)
        ELSE
          POINT = 0.
        END IF
      END IF
      
C     Sum them up plus sky!

      FUNC = DISK+BULGE+BAR+POINT+FPAR(13)
      
      RETURN
      END
      
      SUBROUTINE GETDERV(X,Y,FPAR,DPAR,NPAR,FWHM)
      IMPLICIT NONE
C     
C     the subroutine with the derivatives with respect to the fitting parameters
C     see FUNCTION FUNC for the definition of the functions
C     
      INTEGER NPAR, i
      REAL X,Y,FWHM
      REAL*8 FPAR(NPAR),DPAR(NPAR)
      REAL A(5), COSI, SINI, COSPA, SINPA, COSBAR, SINBAR, COSBI, SINBI
      REAL XROT, YROT
      REAL*8 RDISK, EDISK, BULEXP, EBUL, RATIOPW, TMP, R, BAR, SBAR
      real*8 tratiopw, tbulexp, tbn
      DOUBLE PRECISION BNCOEFF, DBNCOEFF, BN, DBN

C     some constants

      COSI = COS(FPAR(3))
      SINI = SIN(FPAR(3))
      COSPA = COS(FPAR(4))
      SINPA = SIN(FPAR(4))
      COSBAR = COS(FPAR(12))
      SINBAR = SIN(FPAR(12))
      COSBI = COS(FPAR(8))
      SINBI = SIN(FPAR(8))
      
      XROT = X*COSPA + Y*SINPA
      YROT = -X*SINPA + Y*COSPA
      RDISK =(XROT/COS(FPAR(3)))**2 + YROT**2 
      IF (RDISK .GT. 0) THEN
         RDISK = SQRT(RDISK)
      ELSE
         RDISK = 0.
      END IF
      EDISK = EXP(-RDISK/FPAR(2))
      
C     first the disk
      IF (FPAR(1) .LE. 0) THEN
         DPAR(1) = 0.
         DPAR(2) = 0.
         DPAR(3) = 0.
         DPAR(4) = 0.
         DPAR(14) = 0.
         DPAR(15) = 0.
      ELSE
         DPAR(1) = EDISK
         DPAR(2) = FPAR(1)*EDISK*RDISK/FPAR(2)**2
         IF (RDISK .GT. 0) THEN
            TMP = -FPAR(1)*EDISK/FPAR(2)/RDISK
            DPAR(3) = TMP * XROT**2 * SINI / COSI**3
            DPAR(4) = TMP *
     +           ( XROT/COSI**2*(-X*SINPA+Y*COSPA) +
     +             YROT*(-X*COSPA-Y*SINPA) )
            DPAR(14) = TMP * ( XROT/COSI**2*(-COSPA) + YROT*SINPA )
            DPAR(15) = TMP * ( XROT/COSI**2*(-SINPA) + YROT*(-COSPA) )
         ELSE
            XROT = X*COSPA + Y*SINPA
            YROT = -X*SINPA + Y*COSPA
            RDISK =(XROT/COS(FPAR(3)+0.01))**2 + YROT**2 
            IF (RDISK .GT. 0) THEN
               RDISK = SQRT(RDISK)
            ELSE
               RDISK = 0.
            END IF
            DPAR(3) = FPAR(1)*(EXP(-RDISK/FPAR(2))-EDISK)/0.01

            XROT = X*COS(FPAR(4)+0.01) + Y*SIN(FPAR(4)+0.01)
            YROT = -X*SIN(FPAR(4)+0.01) + Y*COS(FPAR(4)+0.01)
            RDISK =(XROT/COS(FPAR(3)))**2 + YROT**2 
            IF (RDISK .GT. 0) THEN
               RDISK = SQRT(RDISK)
            ELSE
               RDISK = 0.
            END IF
            DPAR(4) = FPAR(1)*(EXP(-RDISK/FPAR(2))-EDISK)/0.01

            XROT = (X-0.01)*COSPA + Y*SINPA
            YROT = -(X-0.01)*SINPA + Y*COSPA
            RDISK =(XROT/COS(FPAR(3)))**2 + YROT**2 
            IF (RDISK .GT. 0) THEN
               RDISK = SQRT(RDISK)
            ELSE
               RDISK = 0.
            END IF
            DPAR(14) = FPAR(1)*(EXP(-RDISK/FPAR(2))-EDISK)/0.01

            XROT = X*COSPA + (Y-0.01)*SINPA
            YROT = -X*SINPA + (Y-0.01)*COSPA
            RDISK =(XROT/COS(FPAR(3)))**2 + YROT**2 
            IF (RDISK .GT. 0) THEN
               RDISK = SQRT(RDISK)
            ELSE
               RDISK = 0.
            END IF
            DPAR(15) = FPAR(1)*(EXP(-RDISK/FPAR(2))-EDISK)/0.01
         END IF
      END IF
      
C     Bulge
      IF (FPAR(6).GT.0.) THEN
         R = SQRT((XROT/COS(FPAR(8)))**2+YROT**2)

C        The bulge is modeled with a Sersic function.
         BN = BNCOEFF(DBLE(FPAR(7)))
         DBN = DBNCOEFF(DBLE(FPAR(7)))

         RATIOPW = (R/FPAR(6))**(1/FPAR(7))
         BULEXP = -BN*(RATIOPW-1)
         EBUL = EXP(BULEXP)
         
         DPAR(5) = EBUL
         TMP = BN*FPAR(5)*RATIOPW*EBUL/FPAR(7)
         DPAR(6) = TMP/FPAR(6)

         IF (R .GT. 0) THEN
           DPAR(4) = DPAR(4) - TMP/R**2*
     &           ( XROT/COS(FPAR(8))**2 * (-X*SINPA + Y*COSPA) +
     &             YROT * (-X*COSPA - Y*SINPA) )
           DPAR(14) = DPAR(14) - TMP/R**2*
     &           ( XROT/COSI**2*(-COSPA) + YROT*SINPA)
           DPAR(15) = DPAR(15) - TMP/R**2*
     &           ( XROT/COSI**2*(-SINPA) + YROT*(-COSPA) )
           DPAR(7) = FPAR(5)*EBUL*
     &        ( -DBN*RATIOPW + BN*LOG(R/FPAR(6))*RATIOPW/FPAR(7)**2+DBN)
           DPAR(8) = -TMP/R**2* XROT**2*SINBI/COSBI**3
         ELSE
           DPAR(7) = FPAR(5)*EBUL* ( -DBN*RATIOPW + DBN)

           R = SQRT((XROT/COS(FPAR(8)+0.01))**2+YROT**2)
           TRATIOPW = (R/FPAR(6))**(1/FPAR(7))
           TBULEXP = -BN*(TRATIOPW-1)
           DPAR(8) = FPAR(5)/0.01*(EXP(TBULEXP)-EBUL)
         END IF
      ELSE
         DPAR(5) = 0.
         DPAR(6) = 0.
         DPAR(7) = 0.
         DPAR(8) = 0.
      ENDIF

C     Bar
      BAR = 1.-( ( X*COSBAR+Y*SINBAR)/FPAR(10) )**2-
     +     ( (-X*SINBAR+Y*COSBAR)/FPAR(11) )**2
      IF (BAR.GT.0. .AND. FPAR(9) .GT. 0) THEN
         SBAR = SQRT(BAR)
         DPAR(9) = SBAR
         DPAR(10) = ( FPAR(9)*(X*COSBAR+Y*SINBAR)**2 )/
     +        ( FPAR(10)*FPAR(10)*FPAR(10)*SBAR )
         DPAR(11) = ( FPAR(9)*(Y*COSBAR-X*SINBAR)**2 )/
     +        ( FPAR(11)*FPAR(11)*FPAR(11)*SBAR )
C     DPAR(12) = 0.5*FPAR(9) * (FPAR(10)*FPAR(10)-FPAR(11)*FPAR(11)) *
C     +           ( 2.*X*X*COS(2.*FPAR(12)) -
C     +             (X*X-Y*Y) * SIN(2.*FPAR(12))
C     +           ) / (FPAR(10)*FPAR(10)*FPAR(11)*FPAR(11)*SBAR)
         DPAR(12) = FPAR(9) / SBAR *
     +        ( -1/FPAR(10)**2 * (X*COSBAR+Y*SINBAR) * (-X*SINBAR+Y*COSBAR) 
     +        - 1/FPAR(11)**2 * (-X*SINBAR+Y*COSBAR) * (-X*COSBAR-Y*SINBAR) )
      ELSE
         SBAR = 0.
         DPAR(9) = 0.
         DPAR(10) = 0.
         DPAR(11) = 0.
         DPAR(12) = 0.
      ENDIF
      
C     SKY
      DPAR(13) = 1.

C     Point source
      IF (FPAR(16) .EQ. 0) THEN
        DPAR(16) = 0.
      ELSE
        IF (ABS(X) .LT. 0.5 .AND. ABS(Y) .LT. 0.5) THEN
          DPAR(16) = 1.
        ELSE
          DPAR(16) = 0.
        END IF
      END IF
      
      RETURN
      END
      
      SUBROUTINE LOADMODEL(MODEL,DERV,SEEING,WORK,J1,J2,I1,I2,
     &     XCEN,YCEN,RMIN,RMAX,PAR,LOCK,MAXPAR,FWHM,NDIM)
      REAL MODEL(I1:I1+NDIM-1,J1:J1+NDIM-1)
      REAL DERV(I1:I1+NDIM-1,J1:J1+NDIM-1,MAXPAR)
      REAL SEEING(2,I1:I1+NDIM-1,J1:J1+NDIM-1)
      REAL WORK(2,I1:I1+NDIM-1,J1:J1+NDIM-1)
      REAL*8 PAR(MAXPAR), DPAR(__MAXPAR)
      LOGICAL LOCK(MAXPAR)
    
C     Compute model a bit larger than fitting region (if possible) to allow
C       for seeing effects at edges 
      DO 3301 IROW = J1, MIN(J1+NDIM-1,NINT(J2+10*FWHM))
         DO 3302 ICOL = I1, MIN(I1+NDIM-1,NINT(I2+10*FWHM))
            
            X = ICOL - XCEN
            Y = IROW - YCEN
            
C     Calculate the current model value
            MODEL(ICOL,IROW) = FUNC(X,Y,PAR,MAXPAR,FWHM)
            
C     Get derivatives with respect to parameters
            CALL GETDERV(X,Y,PAR,DPAR,MAXPAR,FWHM)
            DO I=1,MAXPAR
               DERV(ICOL,IROW,I) = DPAR(I)
            END DO
 3302    CONTINUE
 3301 CONTINUE
      
C     If we have a seeing profile, FFT, multiply by FFT of seeing array, and IFFT

      IF (FWHM .GT. 0) THEN
        IF (J2-J1+1 .EQ. 1) THEN
         CALL ONEDCONVOLVE(MODEL,I1,I1+NDIM-1,FWHM)
         DO I=1,MAXPAR
            IF (.NOT. LOCK(I)) THEN
              CALL ONEDCONVOLVE(DERV(I1,J1,I),I1,I1+NDIM-1,FWHM)
            END IF
         END DO
        ELSE
         CALL FFTCONVOLVE(MODEL,SEEING,WORK,NDIM)
         DO I=1,MAXPAR
            IF (.NOT. LOCK(I)) THEN
                CALL FFTCONVOLVE(DERV(I1,J1,I),SEEING,WORK,NDIM)
            END IF
         END DO
        END IF
      END IF
      
      RETURN
      END
      
      SUBROUTINE ACCUM(MODEL,DPAR,J1,J2,I1,I2,A,ISROW,IEROW,ISCOL,IECOL,B,
     &     MASK, XCEN, YCEN, RMIN, RMAX, GAIN, SKYERR, SKY, MAXPAR, NPAR, 
     &     LOCK, CHI2, NPIX, ALP, BETA, NDIM)
      
      REAL MODEL(I1:I1+NDIM-1,J1:J1+NDIM-1)
      REAL DPAR(I1:I1+NDIM-1,J1:J1+NDIM-1,MAXPAR)
      REAL A(ISCOL:IECOL,ISROW:IEROW)
      REAL B(ISCOL:IECOL,ISROW:IEROW)
      REAL*8 ALP(MAXPAR,MAXPAR), BETA(MAXPAR)
      REAL TOTDPAR(__MAXPAR)
      LOGICAL LOCK(MAXPAR), MASK, MASKED
      LOGICAL DEBUG, CONSERVE, RWEIGHT
      COMMON/D/DEBUG, CONSERVE, RWEIGHT
      
C     Loop through pixels once to get sum of observed data for normalization,
C     also, sum of model and derivatives
      
      IF (CONSERVE) THEN
         TOTOBS = 0.
         TOTMOD = 0.
         DO I=1,MAXPAR
            TOTDPAR(I) = 0.
         END DO
         DO IROW = J1, J2
            RDIST = (IROW-YCEN)**2 
            IF (RDIST .LE. RMAX) THEN
               DO ICOL = I1, I2
                  CDIST = (ICOL-XCEN)**2 
                  DIST = RDIST+CDIST
                  IF (DIST .LE. RMAX .AND. DIST .GE. RMIN .AND. 
     &                 A(ICOL,IROW) .GT. 0) THEN
                     TOTOBS = TOTOBS + A(ICOL,IROW)-SKY
                     TOTMOD = TOTMOD + MODEL(ICOL,IROW)-SKY
                     DO I=1,MAXPAR
                        TOTDPAR(I) = TOTDPAR(I) + DPAR(ICOL,IROW,I)
                     END DO
                  END IF
               END DO
            END IF
         END DO
      ELSE
         TOTOBS = 1.
         TOTMOD = 1.
         DO I=1,MAXPAR
            TOTDPAR(I) = 1.
         END DO
      END IF
      
      CHI2 = 0.
      NPIX = 0
      DO 4401 IROW = J1, J2
         RDIST = (IROW-YCEN)**2 
         DO 4402 ICOL = I1, I2
            
            CDIST = (ICOL-XCEN)**2 
            
            DIST = RDIST+CDIST
            IF (DIST .LE. RMAX .AND. DIST .GE. RMIN .AND.
     &          A(ICOL,IROW) .GT. 0) THEN
C     Error in DN for pixel

               IF (GAIN .GT. 0) THEN
                 SIG2 = A(ICOL,IROW)/GAIN + SKYERR/GAIN
                 SIG2 = MAX(1.,SIG2)
               ELSE
                 SIG2 = B(ICOL,IROW)**2
                 IF (SIG2 .EQ. 0) THEN
                   SIG2 = A(ICOL,IROW)/ABS(GAIN) + SKYERR/ABS(GAIN)
                 END IF
               END IF
               DIFF = (A(ICOL,IROW) - (MODEL(ICOL,IROW)-SKY)*TOTOBS/TOTMOD - SKY)
C	print *, icol, irow, a(icol,irow), model(icol,irow), sky, totobs, totmod,diff, sig2, skyerr,gain, npix
               IF (RWEIGHT) SIG2=SIG2*DIST
               CHI2 = CHI2 + DIFF**2/SIG2
               NPIX = NPIX + 1
               
C     OK, now load up matrices

               NPAR = 0
               DO 4407 IPAR = 1, MAXPAR
                  IF (.NOT. LOCK(IPAR)) THEN
                     NPAR = NPAR + 1
                     IF (CONSERVE) THEN
                        BETA(NPAR) = BETA(NPAR) + DIFF/SIG2*TOTOBS *
     +                       ( DPAR(ICOL,IROW,IPAR)/TOTMOD -
     +                       MODEL(ICOL,IROW)/TOTMOD**2 * TOTDPAR(IPAR) )
                     ELSE
                        BETA(NPAR) = BETA(NPAR) + DIFF*DPAR(ICOL,IROW,IPAR)/SIG2
                     END IF
                     NNPAR = 0
                     DO 4408 JPAR = 1, MAXPAR
                        IF (.NOT. LOCK(JPAR)) THEN
                           NNPAR = NNPAR + 1
                           IF (CONSERVE) THEN
                              ALP(NNPAR,NPAR) = ALP(NNPAR,NPAR) +  TOTOBS**2/SIG2 *
     &                             ( DPAR(ICOL,IROW,IPAR)/TOTMOD -
     &                             MODEL(ICOL,IROW)/TOTMOD**2 * TOTDPAR(IPAR) ) *
     &                             ( DPAR(ICOL,IROW,JPAR)/TOTMOD -
     &                             MODEL(ICOL,IROW)/TOTMOD**2 * TOTDPAR(JPAR) )
                           ELSE
                              ALP(NNPAR,NPAR) = ALP(NNPAR,NPAR) + 
     &                             DPAR(ICOL,IROW,IPAR)*DPAR(ICOL,IROW,JPAR)/SIG2
                           END IF
                        END IF
 4408                CONTINUE
                  END IF
 4407          CONTINUE
            END IF
            
            IF (DEBUG) A(ICOL,IROW) = DPAR(ICOL,IROW,3)
            
 4402    CONTINUE
 4401 CONTINUE
      
      RETURN
      END
      
C     Make a gaussian profile in SEEING array and FFT it (SEEING is allocated
C     to be a complex array

      SUBROUTINE MKGAUSS(SEEING,NDIM,FWHM)
      
      REAL SEEING(2,NDIM,NDIM)
      INTEGER NN(2)
      
      PI = 3.14159
      SIG2 = (FWHM/2.354)**2
      DO I=1,NDIM
         IF (I .LE. NDIM/2) THEN
            Y = I-1
         ELSE
            Y = I-NDIM-1
         END IF
         Y = Y**2
         DO J=1,NDIM
            IF (J .LE. NDIM/2) THEN
               X = J-1
            ELSE
               X = J-NDIM-1
            END IF
            X = X**2
C               Note in equation that X and Y have already been squared!
            SEEING(1,J,I) = EXP(-0.5*(X+Y)/SIG2)
            SEEING(2,J,I) = 0.
         END DO
      END DO
      DO I=1,NDIM
        DO J=1,NDIM
          SEEING(1,J,I) = SEEING(1,J,I) / 2./ PI /SIG2 / NDIM / NDIM
        END DO
      END DO
      
      NN(1) = NDIM
      NN(2) = NDIM
      CALL FOURN(SEEING,NN,2,1)
      
      RETURN
      END

C     Make a PSF profile in SEEING array and FFT it (SEEING is allocated
C     to be a complex array

      SUBROUTINE MKPSF(PSF,ISROW,IEROW,ISCOL,IECOL,SEEING,NDIM)
      
      REAL PSF(ISCOL:IECOL,ISROW:IEROW)
      REAL SEEING(2,NDIM,NDIM)
      INTEGER NN(2)
    
      IXCEN = ISCOL + (IECOL-ISCOL+1)/2 
      IYCEN = ISROW + (IEROW-ISROW+1)/2 
      TOT = 0.
      DO I=1,NDIM
         IF (I .LE. NDIM/2) THEN
            IY = I-1
         ELSE
            IY = I-NDIM-1
         END IF
         DO J=1,NDIM
            IF (J .LE. NDIM/2) THEN
               IX = J-1
            ELSE
               IX = J-NDIM-1
            END IF
            IF (IX+IXCEN .GE. ISCOL .AND. IX+IXCEN .LE. IECOL .AND.
     &          IY+IYCEN .GE. ISROW .AND. IY+IYCEN .LE. IEROW) THEN
              SEEING(1,J,I) = PSF(IX+IXCEN,IY+IYCEN)
              TOT = TOT + PSF(IX+IXCEN,IY+IYCEN)
            ELSE
              SEEING(1,J,I) = 0.
            END IF
            SEEING(2,J,I) = 0.
         END DO
      END DO
      DO I=1,NDIM
        DO J=1,NDIM
          SEEING(1,J,I) = SEEING(1,J,I) / TOT / NDIM / NDIM
        END DO
      END DO
      
      NN(1) = NDIM
      NN(2) = NDIM
      CALL FOURN(SEEING,NN,2,1)
      
      RETURN
      END
      
C     Routine to convolve MODEL with SEEING where the latter has already been
C     FFTd and is a complex array. WORK is a complex array to hold the product	

      SUBROUTINE FFTCONVOLVE(MODEL,SEEING,WORK,NDIM)
      
      REAL MODEL(NDIM,NDIM)
      REAL SEEING(2,NDIM,NDIM)
      REAL WORK(2,NDIM,NDIM), AR, AI
      INTEGER NN(2)
      
      NN(1) = NDIM
      NN(2) = NDIM
      DO IROW = 1, NDIM
         DO ICOL = 1, NDIM
            WORK(1,ICOL,IROW) = MODEL(ICOL,IROW)
            WORK(2,ICOL,IROW) = 0.
         END DO
      END DO
      CALL FOURN(WORK,NN,2,1)
      DO IROW = 1, NDIM
         DO ICOL = 1, NDIM
            AR = WORK(1,ICOL,IROW)*SEEING(1,ICOL,IROW) - 
     &           WORK(2,ICOL,IROW)*SEEING(2,ICOL,IROW)
            AI = WORK(1,ICOL,IROW)*SEEING(2,ICOL,IROW) + 
     &           WORK(2,ICOL,IROW)*SEEING(1,ICOL,IROW)
            WORK(1,ICOL,IROW) = AR
            WORK(2,ICOL,IROW) = AI
         END DO
      END DO
      CALL FOURN(WORK,NN,2,-1)
      DO IROW = 1, NDIM
         DO ICOL = 1, NDIM
            MODEL(ICOL,IROW) = WORK(1,ICOL,IROW)
         END DO
      END DO
      
      RETURN
      END
      
      SUBROUTINE SUBMODEL(MODEL,J1,J2,I1,I2,A,ISROW,IEROW,ISCOL,IECOL,B,SUBTYPE,
     &     XCEN,YCEN,RMIN,RMAX,TOTOBS,TOTMOD,SKY,NDIM,GAIN,SKYERR)
      
      REAL MODEL(I1:I1+NDIM-1,J1:J1+NDIM-1)
      REAL A(ISCOL:IECOL,ISROW:IEROW)
      INTEGER SUBTYPE
      LOGICAL DEBUG, CONSERVE, RWEIGHT
      COMMON/D/DEBUG, CONSERVE, RWEIGHT
      
C     Loop through pixels once to get sum of observed data for normalization,
C     also, sum of model and derivatives
      
      IF (CONSERVE) THEN
         TOTOBS = 0.
         TOTMOD = 0.
         DO IROW = J1, J2
            RDIST = (IROW-YCEN)**2 
            DO ICOL = I1, I2
               CDIST = (ICOL-XCEN)**2 
               DIST = RDIST+CDIST
               IF (DIST .LE. RMAX .AND. DIST .GE. RMIN .AND.
     &              A(ICOL,IROW) .GT. 0) THEN
                  TOTOBS = TOTOBS + A(ICOL,IROW)
                  TOTMOD = TOTMOD + MODEL(ICOL,IROW)
               END IF
            END DO
         END DO
         IF (TOTOBS .EQ. 0) TOTOBS = TOTMOD
      ELSE
         TOTOBS = 1.
         TOTMOD = 1.
      END IF
      
      DO 4401 IROW = J1, J2
         DO 4402 ICOL = I1, I2
            
            IF (SUBTYPE .EQ. 1) THEN 
               A(ICOL,IROW) = A(ICOL,IROW) - MODEL(ICOL,IROW)*TOTOBS/TOTMOD + SKY
            ELSE IF (SUBTYPE .EQ. 2) THEN
               IF (GAIN .GT. 0) THEN
                 SIG2 = A(ICOL,IROW)/GAIN + SKYERR/GAIN
                 SIG2 = MAX(1.,SIG2)
               ELSE
                 SIG2 = B(ICOL,IROW)**2
                 IF (SIG2 .EQ. 0) THEN
                   SIG2 = A(ICOL,IROW)/ABS(GAIN) + SKYERR/ABS(GAIN)
                 END IF
               END IF
               DIFF = (A(ICOL,IROW) - (MODEL(ICOL,IROW)-SKY)*TOTOBS/TOTMOD - SKY)
               A(ICOL,IROW) = DIFF**2/SIG2
            ELSE
C              A(ICOL,IROW) = MODEL(ICOL,IROW)*TOTOBS/TOTMOD - SKY
C              Keep sky in  SC 24MAY01
               A(ICOL,IROW) = MODEL(ICOL,IROW)*TOTOBS/TOTMOD

            END IF
            
 4402    CONTINUE
 4401 CONTINUE
      
      RETURN
      END
      
      FUNCTION GAMMLN(XX)
      REAL GAMMLN,XX
      INTEGER J
      DOUBLE PRECISION SER,STP,TMP,X,Y,COF(6)
      SAVE COF,STP
      DATA COF,STP/76.18009172947146D0,-86.50532032941677D0,
     *24.01409824083091D0,-1.231739572450155D0,.1208650973866179D-2,
     *-.5395239384953D-5,2.5066282746310005D0/
      X=XX
      Y=X
      TMP=X+5.5D0
      TMP=(X+0.5D0)*LOG(TMP)-TMP
      SER=1.000000000190015D0
      DO 11 J=1,6
        Y=Y+1.D0
        SER=SER+COF(J)/Y
11    CONTINUE
      GAMMLN=TMP+LOG(STP*SER/X)
      RETURN
      END


      DOUBLE PRECISION FUNCTION RINNER(IE, IO, RE, H, N)

      DOUBLE PRECISION IE, IO, RE, H, N
      DOUBLE PRECISION RL, RH, RT, B, BNCOEFF
      DOUBLE PRECISION IBULGE, IDISK, DIFF

      RL = 0D0
      RH = RE
      RT = RH
      B = BNCOEFF(N)

C     TRY TO ENCAPSULATE SOLUTION BETWEEN UPPER AND LOWER BOUNDS

 1    IBULGE = IE*DEXP(-B*((RH/RE)**(1/N) - 1))
      IDISK = IO*DEXP(-RH/H)

      DIFF = IBULGE - IDISK
      
      IF(DIFF .GT. 0) THEN
         RL = RH
         RH = RH + RE
         RT = (RL + RH) / 2
      ELSE
         GOTO 3
      END IF

      GOTO 1

C     BISECTOR ALGORITHM
 3    DO I=1,100
        IBULGE = IE*DEXP(-B*((RT/RE)**(1/N) - 1))
        IDISK = IO*DEXP(-RT/H)
        DIFF = IBULGE - IDISK
        IF(DABS(RH - RL) .LT. 1E-10) THEN
           GOTO 4
        ELSE
           IF(DIFF .LT. 0) THEN
              RH = RT
              RT = (RH + RL) / 2
           ELSE IF(DIFF .GT. 0) THEN
              RL = RT
              RT = (RH + RL) / 2
           END IF
        END IF
      END DO

 4    RINNER = RT

      RETURN
      END
            
      FUNCTION BNCOEFF(N)
      DOUBLE PRECISION BNCOEFF, N
      DOUBLE PRECISION C(15), A(5), CB(5)
      INTEGER NC
      COMMON /BNDATA/ C, CB
      DATA CB/-0.3333333,9.8765432e-3,1.80286106e-3,1.14094106e-4,-7.1510123e-5/
      DATA C/ 0.1945D-01, -8.902D-01, 1.095D+01, -1.967D+01, 1.343D+01,
     &       -2.8196996655357D-01, 1.9265292066342D0, 4.5605000551699D-02, 
     &          -1.2901384332585D-02, 1.3631303810263D-03,
     &       -3.2768779377532D-01, 1.9992310286790D0, 2.9933606340104D-05, 
     &          0D0, 0D0/
     
      IF (N .LT. 0.36) THEN
C      IF (N .LT. 0.55) THEN
C         NC = 0
C      ELSE IF ((N .GE. 0.55) .AND. (N .LT. 3.0)) THEN
C         NC = 5
C      ELSE
C         NC = 10
C      END IF
        NC = 0
        DO 5688 I=1,5
           A(I) = C(I+NC)
 5688   CONTINUE

        BNCOEFF = A(1) + A(2)*N + A(3)*N**2 + A(4)*N**3 + A(5)*N**4
      ELSE

        BNCOEFF = 2*N
        DO 5689 I=1,5 
          BNCOEFF = BNCOEFF + CB(I)/N**(I-1)
 5689   CONTINUE
      END IF

      RETURN
      END

      FUNCTION DBNCOEFF(N)
      DOUBLE PRECISION DBNCOEFF, N
      DOUBLE PRECISION C(15), A(5), CB(5)
      INTEGER NC
      COMMON /BNDATA/ C, CB

C      IF (N .LT. 0.55) THEN
C         NC = 0
C      ELSE IF ((N .GE. 0.55) .AND. (N .LT. 3.0)) THEN
C         NC = 5
C      ELSE
C         NC = 10
C      END IF

      IF (N .LT. 0.36) THEN
        NC = 0
        DO 5688 I=1,5
          A(I) = C(I+NC)
 5688   CONTINUE

        DBNCOEFF = A(2) + 2*A(3)*N + 3*A(4)*N**2 + 4*A(5)*N**3
      ELSE

        DBNCOEFF = 2.
        DO 5689 I=2,5 
          DBNCOEFF = DBNCOEFF - (I-1)*CB(I)/N**I
 5689   CONTINUE

      END IF

      RETURN
      END

      SUBROUTINE ONEDCONVOLVE(MODEL,I1,I2,FWHM)

      REAL MODEL(I1:I2), FWHM, MINT
      REAL*8 TMP(2048), BESSI0, R, X, SIG2

      SIG2=(FWHM/2.354)**2
      NPTS=201
      DO I=I1,I2
        R=I-1
        TMP(I) = 0
        DO J=-NPTS/2,NPTS/2
          X=R+J*(5*FWHM)/(NPTS-1)
          IX = INT(X)+1
          IF (X .GE. 0 .AND. IX .GE. I1 .AND. IX+1 .LE. I2) THEN
            MINT =  MODEL(IX) + (X+1-IX)*(MODEL(IX+1)-MODEL(IX))
            TMP(I) = TMP(I) + X*MINT*PBESSI0(X*R/SIG2)*
     &            EXP((X*R-R**2/2-X**2/2)/SIG2)
          END IF
        END DO
        TMP(I) = TMP(I) / SIG2 * (5*FWHM)/(NPTS-1)
      END DO
      DO I=I1,I2
        MODEL(I) = TMP(I)
      END DO
C	pause

      RETURN
      END


      FUNCTION pbessi0(x)
      REAL*8 pbessi0,bessi0,x
      REAL*8 ax
      DOUBLE PRECISION p1,p2,p3,p4,p5,p6,p7,q1,q2,q3,q4,q5,q6,q7,q8,q9,y
      SAVE p1,p2,p3,p4,p5,p6,p7,q1,q2,q3,q4,q5,q6,q7,q8,q9
      DATA p1,p2,p3,p4,p5,p6,p7/1.0d0,3.5156229d0,3.0899424d0,
     *1.2067492d0,0.2659732d0,0.360768d-1,0.45813d-2/
      DATA q1,q2,q3,q4,q5,q6,q7,q8,q9/0.39894228d0,0.1328592d-1,
     *0.225319d-2,-0.157565d-2,0.916281d-2,-0.2057706d-1,0.2635537d-1,
     *-0.1647633d-1,0.392377d-2/
      ax=abs(x)
      if (ax.lt.3.75) then
        y=(x/3.75)**2
        bessi0=p1+y*(p2+y*(p3+y*(p4+y*(p5+y*(p6+y*p7)))))
        pbessi0=bessi0/exp(ax)
      else
        y=3.75/ax
        pbessi0=(1./sqrt(ax))*(q1+y*(q2+y*(q3+y*(q4+y*(q5+y*(q6+y*
     *(q7+y*(q8+y*q9))))))))
      endif
      return
      END
