#include "Vista.h"
C       THIS IS THE GRAMMAR CHECKER FOR THE PARSE TREE GENERATED BY
C       THE ROUTINE PARSER

        INTEGER FUNCTION GRAMMAR(TREESTART)

C       Written by Richard Stover, Lick Observatory, UCSC

C       Copyright 1985 by The Regent of The University of California.
C       This material may not be copied without the permission of the
C       authors.

        INTEGER TP,NL,NR,BKTYPE,FWTYPE
        INTEGER*4 TREESTART
        LOGICAL ISUNARY,ISBINARY,ISSYM
#ifdef VMS
        INCLUDE 'VINCLUDE:TREE.INC'
        INCLUDE 'VINCLUDE:ERROR.INC'
#else
        INCLUDE 'vistadisk/source/include/tree.inc'
        INCLUDE 'vistadisk/source/include/error.inc'
#endif
C       First check for left/right bracket (parenthesis) consistency
        NL = 0
        NR = 0
        TP = TREESTART
100     IF(WTYPE(TP) .EQ. TLBR) THEN
                NL = NL + 1
C                               ! Count left bracket
C               If the left bracket is not the first element
C               in the tree then it must be preceded by an
C               operator (unary or binary), an equate operator,
C               a function start, a parameter seperator, or another
C               left bracket.
                IBKT = BKTYPE(TP)
                IF(BACK(TP) .EQ. TREEEND) THEN
                        CONTINUE
                ELSE IF(ISUNARY(BACK(TP))) THEN
                        CONTINUE
                ELSE IF(ISBINARY(BACK(TP))) THEN
                        CONTINUE
                ELSE IF(IBKT .EQ. TEQU) THEN
                        CONTINUE
                ELSE IF(IBKT .EQ. TFUN) THEN
                        CONTINUE
                ELSE IF(IBKT .EQ. TSEP) THEN
                        CONTINUE
                ELSE IF(IBKT .EQ. TLBR) THEN
                        CONTINUE
                ELSE
                        GRAMMAR = EBRACKET
                        RETURN
                END IF
        ELSE IF(WTYPE(TP) .EQ. TRBR) THEN
                NR = NR + 1
C                                               ! Count right bracket
                IF(NR .GT. NL) THEN
                        GRAMMAR = EBRACKET
C                                               ! Too many right brackets
                        RETURN
                END IF
                IF(BKTYPE(TP) .EQ. TLBR) THEN
                        GRAMMAR = EBRACKET
C                                               ! EMPTY SET!
                        RETURN
                END IF
        END IF
        TP = FORW(TP)
        IF(TP .NE. TREEEND) GOTO 100

        IF(NL .NE. NR) THEN
                GRAMMAR = EBRACKET
C                                               ! Unbalanced brackets
                RETURN
        END IF

C       First check for left/right square bracket (function) consistency
        NL = 0
        NR = 0
        TP = TREESTART
150     IF(WTYPE(TP) .EQ. TFUN) THEN
                NL = NL + 1
C                                               ! Count left bracket
        ELSE IF(WTYPE(TP) .EQ. TFEN) THEN
                NR = NR + 1
C                                               ! Count right bracket
                IF(NR .GT. NL) THEN
                        GRAMMAR = ESQBRACKET
C                                               ! Too many right brackets
                        RETURN
                END IF
        END IF
        TP = FORW(TP)
        IF(TP .NE. TREEEND) GOTO 150

        IF(NL .NE. NR) THEN
                GRAMMAR = ESQBRACKET
C                                               ! Unbalanced brackets
                RETURN
        END IF

C       Now check unary operators.  They must be first element in the
C       list or they must follow a left bracket or a binary operator,
C       or a function separator, or the start of a function, or an
C       equate operator.

        TP = 1
200     IF(ISUNARY(TP)) THEN
                NL = BKTYPE(TP)
                IF(BACK(TP) .EQ. TREEEND) THEN
                        CONTINUE
                ELSE IF(NL .EQ. TLBR) THEN
                        CONTINUE
                ELSE IF(ISBINARY(BACK(TP))) THEN
                        CONTINUE
                ELSE IF(NL .EQ. TFUN) THEN
                        CONTINUE
                ELSE IF(NL .EQ. TSEP) THEN
                        CONTINUE
                ELSE IF(NL .EQ. TEQU) THEN
                        CONTINUE
                ELSE
                        GRAMMAR = EUNARY
                        RETURN
                END IF
        END IF

        TP = FORW(TP)
        IF(TP .NE. TREEEND) GOTO 200

C       Next check binary operators.  They must be preceded by a right
C       bracket, a symbol, a function end, or a number, and they must be
C       followed by a left bracket, a symbol, a unary operator, a function
C       start, or a number.

        TP = 1
300     IF(ISBINARY(TP)) THEN
                NL = BKTYPE(TP)
                NR = FWTYPE(TP)
                IF(NL .EQ. TRBR) THEN
                        CONTINUE
                ELSE IF(NL .EQ. TNUM) THEN
                        CONTINUE
                ELSE IF(ISSYM(BACK(TP))) THEN
                        CONTINUE
                ELSE IF(NL .EQ. TFEN) THEN
                        CONTINUE
                ELSE
                        GRAMMAR = EBINARY
                        RETURN
                END IF
                IF(NR .EQ. TLBR) THEN
                        CONTINUE
                ELSE IF(NR .EQ. TNUM) THEN
                        CONTINUE
                ELSE IF(ISSYM(FORW(TP))) THEN
                        CONTINUE
                ELSE IF(ISUNARY(FORW(TP))) THEN
                        CONTINUE
                ELSE IF(NR .EQ. TFUN) THEN
                        CONTINUE
                ELSE
                        GRAMMAR = EBINARY
                        RETURN
                END IF
        END IF

        TP = FORW(TP)
        IF(TP .NE. TREEEND) GOTO 300

C       Next check for equate operator.  It must be preceded by a symbol or
C       a function end.  Here we will assume that the function end is the
C       end of an array element reference and we''ll let ECRUNCH handle it
C       if it is not.  If the equate operator is preceded by a symbol then
C       the symbol must not be part of an expression.  That is, the symbol
C       can only be preceded either by a left bracket, a function start,
C       a function parameter separator, or by the start of the tree.
C       The equate operator must be followed by a symbol, a function,
C       a number, a left bracket, a unary operator, or a number.

        TP = 1
400     IF(WTYPE(TP) .EQ. TEQU) THEN
                NL = BKTYPE(TP)
                IF(NL .EQ. TFEN) GOTO 500
                NR = FWTYPE(TP)
                IF(NL .NE. TSYM) THEN
                        GRAMMAR = EEQUATE
                        RETURN
                END IF
                NL = BKTYPE(BACK(TP))
                IF(BACK(BACK(TP)) .EQ. TREEEND) THEN
                        CONTINUE
                ELSE IF(NL .EQ. TLBR) THEN
                        CONTINUE
                ELSE IF(NL .EQ. TFUN) THEN
                        CONTINUE
                ELSE IF(NL .EQ. TSEP) THEN
                        CONTINUE
                ELSE IF(NL .EQ. TEQU) THEN
                        CONTINUE
                ELSE
                        GRAMMAR = EEQUATE
                        RETURN
                END IF

                IF(NR .EQ. TLBR) THEN
                        CONTINUE
                ELSE IF(NR .EQ. TFUN) THEN
                        CONTINUE
                ELSE IF(NR .EQ. TSYM) THEN
                        CONTINUE
                ELSE IF(ISUNARY(FORW(TP))) THEN
                        CONTINUE
                ELSE IF(NR .EQ. TNUM) THEN
                        CONTINUE
                ELSE
                        GRAMMAR = EEQUATE
                        RETURN
                END IF
        END IF

500     TP = FORW(TP)
        IF(TP .NE. TREEEND) GOTO 400

        GRAMMAR = SUCCESS
        RETURN
        END
