#include "Vista.h"

C       Here are the spectrum commands.  If this file is included in the
C       VISTA.FOR, these commands can be run.

        ELSE IF (COM .EQ. 'MASH') THEN
C          Extract spectrum
                NEEDIM = 1
                IMSP   = 1
                IF (GO) THEN
                     IMSP = 0
                     CALL CCMASH(LOCIM,IMSR,IMER,IMSC,IMEC)
                END IF

        ELSE IF (COM .EQ. 'EXTRACT') THEN
C          Optimal extraction
                NEEDIM = 1
                IMSP   = 1
                IF (GO) THEN
                   IMSP = 0
                   CALL CCEXTRACT(LOCIM,IMSR,IMER,IMSC,IMEC)
                END IF

        ELSE IF (COM .EQ. 'STRETCH') THEN
C          Spectrum --> image
                NEEDIM = 1
                IMSP   = 1
                IF (GO) THEN
                    IMSP = 0
                    CALL CCSTRETCH(LOCIM,IMSR,IMER,IMSC,IMEC)
                END IF

        ELSE IF (COM .EQ. 'SPECTROID') THEN
C          Locate spectrum
                NEEDIM = 1
                IMSP   = 1
                IF (GO) THEN
                   IMSP = 0
                   CALL CCSPECTROID(LOCIM,IMSR,IMER,IMSC,IMEC)
                END IF

        ELSE IF (COM .EQ. 'LINEID') THEN
C          Identify lines
             NEEDIM = 1
             IF (GO) CALL CCLINEID(LOCIM,IMSR,IMER,IMSC,IMEC)

        ELSE IF (COM .EQ. 'WSCALE') THEN
C          Identify lines
             NEEDIM = 1
             IF (GO) CALL CCWAVESCALE(LOCIM,IMSR,IMER,IMSC,IMEC)

        ELSE IF (COM .EQ. 'EWAVE') THEN
C          Hamilton wavelength calibration
             NEEDIM = 1
             IF (GO) CALL CCEWAVE(LOCIM,IMSR,IMER,IMSC,IMEC)

        ELSE IF (COM .EQ. 'COPW') THEN
C          Copy wavelengths
             NEEDIM = 2
             IF (GO) CALL CCCOPYW(LOCIM,IMSR,IMER,IMSC,IMEC,
     &                          LOCB, JMSR,JMER,JMSC,JMEC)

        ELSE IF (COM .EQ. 'EXTINCT') THEN
             NEEDIM = 1
             IF (GO) CALL CCEXTINCT(LOCIM,IMSR,IMER,IMSC,IMEC)

        ELSE IF (COM .EQ. 'REFRACT') THEN
             NEEDIM = 1
             IF (GO) CALL CCREFRACT(LOCIM,IMSR,IMER,IMSC,IMEC)

        ELSE IF (COM .EQ. 'FLUX' .OR.
     &          COM .EQ. 'FLUXSTAR') THEN
C          Fluxing
             NEEDIM = 1
             IF (GO) CALL CCFLUXCAL(LOCIM,IMSR,IMER,IMSC,IMEC)

        ELSE IF (COM .EQ. 'SKYLINE') THEN
C          Wavelength adjust
             NEEDIM = 1
             IF( GO) CALL CCSKYLINE(LOCIM,IMSR,IMER,IMSC,IMEC)

        ELSE IF (COM .EQ. 'POLY') THEN
C          Polynomial fitter.
             NEEDIM = 1
             IF (GO) CALL CCPOLYFIT(LOCIM,IMSR,IMER,IMSC,IMEC)

        ELSE IF (COM .EQ. 'EXTSPEC') THEN
             NEEDIM = 1
             IMSP   = 1
             IF (GO) THEN
                   IMSP = 0
                   CALL CCEXTSPEC(LOCIM,IMSR,IMER,IMSC,IMEC)
             END IF

        ELSE IF (COM .EQ. 'FINDPEAK') THEN
             NEEDIM = 1
             IMSP = 1
             IF (GO) THEN
                   IMSP = 0
                   CALL CCFINDPEAK(LOCIM,IMSR,IMER,IMSC,IMEC)
             END IF

        ELSE IF (COM .EQ. 'FINDSHIFT') THEN
             NEEDIM = 2
             IF (GO) CALL CCFINDSHIFT(LOCIM,IMSR,IMER,IMSC,IMEC,
     &                      LOCB,JMSR,JMER,JMSC,JMEC)

        ELSE IF (COM .EQ. 'SPLINE') THEN
C            Spline fit.
                NEEDIM = 1
                IF (GO) CALL CCFITSPLINE(LOCIM,IMSR,IMER,IMSC,IMEC)

        ELSE IF (COM .EQ. 'ISPLINE') THEN
C            Interactive spline
                NEEDIM = 1
                IF (GO) CALL CCISPLINE(LOCIM,IMSR,IMER,IMSC,IMEC)

        ELSE IF (COM .EQ. 'SPINDEX') THEN
C       Meassure spectral indices.
                NEEDIM = 1
                IMSP = 1
                IF (GO) THEN
                     IMSP = 0
                     CALL CCSPINDEX(LOCIM,IMSR,IMER,IMSC,IMEC)
                END IF

        ELSE IF (COM .EQ.'FQUO') THEN
C       Fit a gaussian broadening function to the fourier-quotient.
                NEEDIM = 2
                IF (GO) CALL CCFQUO(LOCIM,IMSR,IMER,IMSC,IMEC,
     &                              LOCB,JMSR,JMER,JMSC,JMEC)

C  Generate a synthetic Blackbody Spectrum [rwp/osu 96Nov30]
 
        ELSE IF (COM .EQ. 'BLACKBODY') THEN
                IF (GO) CALL BLACKBODY
 

