C       'Q' SUBROUTINES

	SUBROUTINE QAOI(XLO,XHI,YLO,YHI)

	INTEGER XLO,XHI,YLO,YHI
	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'

	XLOAOI=MAX0(0,MIN0(XLO,N_COLS_TV-1))
	XHIAOI=MAX0(0,MIN0(XHI,N_COLS_TV-1))
	YLOAOI=MAX0(0,MIN0(YLO,N_ROWS_TV-1))
	YHIAOI=MAX0(0,MIN0(YHI,N_ROWS_TV-1))

	RETURN
	END
C
	SUBROUTINE QCHECK(XLO,XHI,YLO,YHI)

	INTEGER XLO,XHI,YLO,YHI,ADX,ADY,DX,DY
	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'

	ADX=ABS(XHI-XLO)
	ADY=ABS(YHI-YLO)
	DX=XHIAOI-XLOAOI
	DY=YHIAOI-YLOAOI

	IF(ABS(DX).NE.ADX) THEN
		IF(DX.GT.0) THEN
			XHIAOI=MIN0(N_COLS_TV,XLOAOI+ADX)
			XLOAOI=XHIAOI-ADX
		ELSE
			XHIAOI=MAX0(1,XLOAOI-ADX)
			XLOAOI=XHIAOI+ADX
		END IF
	END IF

	IF(ABS(DY).NE.ADY) THEN
		IF(DY.GT.0) THEN
			YHIAOI=MIN0(N_ROWS_TV,YLOAOI+ADY)
			YLOAOI=YHIAOI-ADY
		ELSE
			YHIAOI=MAX0(1,XLOAOI-ADY)
			YLOAOI=YHIAOI+ADY
		END IF
	END IF

	RETURN
	END
C
	SUBROUTINE QCOLOR(ACTION,FIRST,N,R,G,B)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'

	BYTE R(1),G(1),B(1), ARRAY(8192), STUFF
	INTEGER ACTION,FIRST,N,RED,GREEN,BLUE,HALF

	ARRAY(1)=AED_SCT_INST
	IF(ACTION.EQ.0) THEN
		ARRAY(2)=0
		ARRAY(3)=0
		DO I=0,N_COLOR-2
			J=3*I+4
			ARRAY(J)=  STUFF(I)
			ARRAY(J+1)=STUFF(I)
			ARRAY(J+2)=STUFF(I)
		ENDDO
		ARRAY(J+3)=1
		ARRAY(J+4)=STUFF(N_COLOR-1)
		ARRAY(J+5)=1
		NUM=J+5
	ELSE IF (ACTION.EQ.1) THEN
		ARRAY(2)=STUFF(FIRST)
		ARRAY(3)=STUFF(N)
		DO I=1,N
			J=3*(I-1)+4
			ARRAY(J)=  R(I)
			ARRAY(J+1)=G(I)
			ARRAY(J+2)=B(I)
		END DO
		NUM=J+2
	ELSE IF (ACTION.EQ.2) THEN
		NCOL=R(1)
		MN=0
		IF(G(1)) MN=1
		MX=NCOL
		IF(B(1)) MX=NCOL-1
		NB=N/NCOL+.5
		HALF=.38*NCOL

		ARRAY(2)=0
		ARRAY(3)=0

		DO I=0,N_COLOR-2
			J=3*I+4
			IB=MAX(0,I-FIRST)/NB
			IF ((IB.EQ.0).AND.G(1)) THEN
				RED=0
				GREEN=0
				BLUE=0
			ELSE IF ((IB.GE.NCOL-1).AND.B(1)) THEN
				RED=N_COLOR-26
				GREEN=N_COLOR-26
				BLUE=N_COLOR-26
			ELSE
				RED=(N_COLOR-1)*MAX(IB-HALF,0)/(MX-HALF)
				BLUE=(N_COLOR-1)
	1                               *MAX(HALF-IB,0)/(HALF-MN)
				IF(IB.GE.HALF) THEN
					GREEN=(N_COLOR-1)-RED
				ELSE
					GREEN=(N_COLOR-1)-BLUE
				END IF
			END IF
			ICONSTANT=N_COLOR/2 - 8
			ARRAY(J)  =STUFF(RED/2+ICONSTANT)
			ARRAY(J+1)=STUFF(GREEN/2+ICONSTANT)
			ARRAY(J+2)=STUFF(BLUE/2+ICONSTANT)
		END DO
		ARRAY(J+3)=1
		ARRAY(J+4)=STUFF(N_COLOR-1)
		ARRAY(J+5)=1
		NUM=J+5
	END IF

	ARRAY(NUM+1)=AED_SEC_INST
	ARRAY(NUM+2)='FF'X
	ARRAY(NUM+3)=AED_SAC_INST
	ARRAY(NUM+4)='FF'X
	CALL OBYTE(ARRAY,NUM+4)

	RETURN
	END
C
	SUBROUTINE QCOOR(IX,IY,C3)
C
C       Turns integer*2 positions IX and IY into
C       "xy20" format (see 5-132 in Colorware manual)
C

	INTEGER*2 IXX,IYY,A,B,C
	BYTE C3(3)

	IXX=IX
	IYY=IY
	A=(IXX.AND.'FF'X)
	B=(IYY.AND.'FF'X)
	C=(ISHFT(IXX-A,-4).AND.'F0'X) .OR. (ISHFT(IYY-B,-8).AND.'F'X)
	C3(1)=C
	C3(2)=A
	C3(3)=B

	RETURN
	END
C
	SUBROUTINE QCURSOFF

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192)

	ARRAY(1)=AED_DJC_INST
	CALL OBYTE(ARRAY,1)

	RETURN
	END
C
	SUBROUTINE QCURSON

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
C
	BYTE ARRAY(8192)

	ARRAY(1)=AED_SCC_INST
	ARRAY(2)='FF'x
	ARRAY(3)=0
	ARRAY(4)='0F'X
	ARRAY(5)=AED_SCP_INST
	ARRAY(6)='X'
	ARRAY(7)=0
	ARRAY(8)=0
	ARRAY(9)=AED_EJC_INST
	CALL OBYTE(ARRAY,9)

	RETURN
	END
C
	SUBROUTINE QDAI(IXLO, IXHI, IYLO, IYHI)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'

	BYTE ARRAY(8192), C3(3)

	ARRAY(1)=AED_MOV_INST
	IXL=IXLO
	IXH=IXHI
	IYL=IYLO
	IYH=IYHI
	CALL QCOOR(IXL,IYL,C3)
	ARRAY(2)=C3(1)
	ARRAY(3)=C3(2)
	ARRAY(4)=C3(3)
	ARRAY(5)=AED_DAI_INST
	CALL QCOOR(IXH,IYH,C3)
	ARRAY(6)=C3(1)
	ARRAY(7)=C3(2)
	ARRAY(8)=C3(3)
	CALL OBYTE(ARRAY,8)

	RETURN
	END
C
	SUBROUTINE QDRAW(X,Y)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	INTEGER X,Y
	BYTE ARRAY(8192), C3(3)

	ARRAY(1)=AED_DVA_INST
	CALL QCOOR(X,Y,C3)
	ARRAY(2)=C3(1)
	ARRAY(3)=C3(2)
	ARRAY(4)=C3(3)

	CALL OBYTE(ARRAY,4)

	RETURN
	END
C
	SUBROUTINE QERASE(MASK)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192), MASK

	ARRAY(1)=AED_SWM_INST
	ARRAY(2)=MASK
	ARRAY(3)=AED_ERS_INST
	CALL OBYTE (ARRAY,3)

	RETURN
	END
C
	SUBROUTINE QETC(N)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192)

	ARRAY(1)=AED_ETC_INST
	ARRAY(2)=N
	CALL OBYTE(ARRAY,2)
	RETURN
	END
C
	SUBROUTINE QETP(N)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192)

	ARRAY(1)=AED_ETP_INST
	ARRAY(2)=1
	CALL OBYTE(ARRAY,2)
	RETURN
	END
C
	SUBROUTINE QINIT
C
C       York AED Initialization Program (for Quasar)
C       based on AEDINIT from the Berkeley subroutines
C
	INCLUDE 'IOBYTE.CMN'
	INCLUDE 'VINCLUDE:AED.INC'

	BYTE ARRAY(9)
	DATA ARRAY/27,72,83,94,49,55,10,10,76/
C                 ESC, H, S, ^, 1, 7,FF,FF,L

C       Enter interpreter mode

	SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),
	1       IO$_ACCESS,AED_PAR_STAT,,,,,%VAL(ESC),%VAL(0),,)

	IF (.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
	IF (.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))

C       Send reset command

	IER=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),
	1       IO$_ACCESS,AED_PAR_STAT,,,,,%VAL(AED_RST_INST),%VAL(0),,)

	IF (.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
	IF (.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))

C       Delay 200msec to allow the terminal to reset

	DO I=1,4
		CALL DEL50
	ENDDO

	CALL OBYTE(ARRAY,9)

	RETURN
	END

C
	SUBROUTINE DEL50
C
C       DEL50--DELAY 50MSEC, FOR USE WITH RESET ROUTINE
C

	INTEGER*4 SYS$BINTIM,SYS$WAITFR,SYS$SETIMR
	1       ,TIME(2),FIRST/0/
	CHARACTER ASCIITIME*13/'0 00:00:00.10'/

	IF (FIRST.EQ.0) THEN
		I=SYS$BINTIM(ASCIITIME,TIME)
		IF(.NOT.I) CALL LIB$STOP(%VAL(I))
		FIRST=1
	ENDIF

	I=SYS$SETIMR(%VAL(1),TIME,,)
	IF(.NOT.I)CALL SYS$EXIT(%VAL(I))
	I=SYS$WAITFR(%VAL(1))
	IF(.NOT.I)CALL SYS$EXIT(%VAL(I))
	RETURN
	END
C
	SUBROUTINE QLABEL(IX,IY,CHAR_ARRAY)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192)
	CHARACTER*(*) CHAR_ARRAY

	IXX=IX
	IYY=IY
	CALL QMOV(IXX,IYY)      ! Move to correct location on screen

	I=50
	DO WHILE(CHAR_ARRAY(I:I).EQ.' ')        ! Find length of string
		I=I-1
	ENDDO
	NUMCHAR=I

	ARRAY(1)=AED_TXT_INST           ! AED 512 doesn't have this instruction
	DO I=1,NUMCHAR                  ! Fill array with text of label
		ARRAY(I+1)=ICHAR(CHAR_ARRAY(I:I))
	ENDDO
	ARRAY(NUMCHAR+2)=0              ! MDR's code
	CALL OBYTE(ARRAY,NUMCHAR+2)     ! Send whole string to be displayed

	RETURN
	END
C
	SUBROUTINE QMASK(WMASK,RMASK)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	INTEGER WMASK,RMASK
	BYTE ARRAY(8192)

	ARRAY(1)=AED_SWM_INST
	ARRAY(2)=WMASK
	ARRAY(3)=AED_SRM_INST
	ARRAY(4)=RMASK
	ARRAY(5)=0
	ARRAY(6)=0
	ARRAY(7)=0
	CALL OBYTE(ARRAY,7)

	RETURN
	END
C
	SUBROUTINE QMOV(IX,IY)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192), C3(3)

	ARRAY(1)=AED_MOV_INST
	CALL QCOOR(IX,IY,C3)
	ARRAY(2)=C3(1)
	ARRAY(3)=C3(2)
	ARRAY(4)=C3(3)

	CALL OBYTE(ARRAY,4)

	RETURN
	END
C
	SUBROUTINE QRCURS(IX,IY)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192), C3(3)

C       READ JOYSTICK POSITION

	ARRAY(1)=AED_RCP_INST
	CALL OBYTE(ARRAY,1)
	CALL IBYTE(C3,3)

c       take xy20 format and convert to integer*2

	J=  C3(1)
	JJ= C3(2)
	JJJ=C3(3)
	JJ= JJ.AND.'FF'X
	JJJ=JJJ.AND.'FF'X
	IX= JJ+ISHFT(J.AND.'F0'X,4)
	IF (IX.LT.0) IX=IX+1024
	IY= N_ROWS_TV-(JJJ+ISHFT(J.AND.'F'X,8))
	IF (IY.LT.0) IY=IY+1024

	RETURN
	END
C
	SUBROUTINE QRESET

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
C
	BYTE ARRAY(8192)

	ARRAY(1)=AED_RST_INST
	CALL OBYTE(ARRAY,1)

	RETURN
	END
C
	SUBROUTINE QRJOY(IX,IY)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192), C3(3), BKEY

c       Select parameters of and enable the Joystick cursor
C       read cursor position

	ARRAY(1)=AED_RJP_INST
	CALL OBYTE(ARRAY,1)
	CALL IBYTE(C3,3)

c       take xy20 format and convert to integer*2

	J=  C3(1)
	JJ= C3(2)
	JJJ=C3(3)
	JJ= JJ.AND.'FF'X
	JJJ=JJJ.AND.'FF'X
	IX=  JJ+ISHFT(J.AND.'F0'X,4)
	IY= (N_ROWS_TV-1)-(JJJ+ISHFT(J.AND.'F'X,8))

	RETURN
	END
C
	SUBROUTINE QSETUP

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
C
	BYTE ARRAY(8192)

	ARRAY(1)=AED_SAP_INST
	ARRAY(2)='1'
	ARRAY(3)='7'
	ARRAY(4)=10
	ARRAY(5)=10
	ARRAY(6)='L'
	CALL OBYTE(ARRAY,6)

	RETURN
	END
C
	SUBROUTINE QSGT(N)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192)

C       N=3 ... MOUSE
C       N=4 ... KEYBOARD CURSOR KEYS

	ARRAY(1)=AED_SGT_INST
	ARRAY(2)=3
	CALL OBYTE(ARRAY,2)
	RETURN
	END
C
	SUBROUTINE QSIF(OPTION)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192)
	CHARACTER*1 OPTION

	ARRAY(1)=AED_SIF_INST

	IF (OPTION .EQ. 'p' .OR. OPTION. EQ. 'P') THEN
		ARRAY(2)=80
	ELSE IF (OPTION .EQ. 's' .OR. OPTION .EQ. 'S') THEN
		ARRAY(2)=82
	ELSE IF (OPTION .EQ. 'm' .OR. OPTION .EQ. 'M') THEN
		ARRAY(2)=77
	ELSE IF (OPTION .EQ. 'd' .OR. OPTION .EQ. 'D') THEN
		ARRAY(2)=68
	ELSE
		STOP 'SIF ERROR'
	ENDIF
	CALL OBYTE(ARRAY,2)
	RETURN
	END
C
	SUBROUTINE QSTP(N)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'
	BYTE ARRAY(8192)

c       n=0 ... status and coordinates sent on pen down
c       n=1 ... status and coordinates sent on pen down and up
c       n=2 ... status and coordinates sent on pen down packed binary
c       n=3 ... status and coordinates sent on pen down and up packed binary

	ARRAY(1)=AED_STP_INST
	ARRAY(2)=2
	CALL OBYTE(ARRAY,2)

	RETURN
	END
C
	SUBROUTINE QZOOM(ZOOM,IXX,IYY)

	INCLUDE 'IOBYTE.INC'
	INCLUDE 'VINCLUDE:AED.INC'

	INTEGER ZOOM,Z
	BYTE ARRAY(8192)

	Z=MAX(1,MIN(16,ZOOM))
	ICC=(N_COLS_TV+1)/2
	ICR=(N_ROWS_TV+1)/2
	IX=IXX-JINT(FLOAT(ICC)/FLOAT(Z))
	IF(IX.LT.0) IX=IX+1024
	IY=IYY+JINT(FLOAT(ICR)/FLOAT(Z))
	IF(IY.LT.0) IY=IY+1024
	ARRAY(1)=AED_SHO_INST
	ARRAY(2)=IX/256
	ARRAY(3)=MOD(IX,256)
	CALL OBYTE(ARRAY,3)
	ARRAY(1)=AED_SVO_INST
	ARRAY(2)=IY/256
	ARRAY(3)=MOD(IY,256)
	CALL OBYTE(ARRAY,3)
	ARRAY(1)=AED_SZR_INST
	ARRAY(2)=Z
	ARRAY(3)=Z
	CALL OBYTE(ARRAY,3)

	RETURN
	END

