C       14.3.1983
C
C       COPYRIGHT
C
C       CIS GMBH U. CO KG
C       KREFELDER STRASSE 172
C       4060 VIERSEN 1
C
C
C
	SUBROUTINE SETAED (MODE)
	INCLUDE 'IOBYTE.CMN'
	CHARACTER MODE*3
	BYTE NOP(3)
	DATA    NOP(1)/27/,NOP(2)/27/,NOP(3)/27/

	AED_DMA_MAX= 450500             !585X768=449280... OLD=8192
	IF(MODE.EQ.'SER'.OR.MODE.EQ.'ser') THEN

		IF(AED_MODE.EQ.2) THEN
			IF (MOD(AED_DMA_POINTER,2).EQ.1) THEN
				CALL OBYTE (NOP,3)
			ELSE
				CALL OBYTE (NOP,2)
			ENDIF
		ENDIF

		AED_MODE=0
		AED_IN_MODE=0
	ELSE IF(MODE.EQ.'PAR'.OR.MODE.EQ.'par') THEN

		IF(AED_MODE.EQ.2) THEN
			IF (MOD(AED_DMA_POINTER,2).EQ.1) THEN
				CALL OBYTE (NOP,3)
			ELSE
				CALL OBYTE (NOP,2)
			ENDIF
		ENDIF
		AED_MODE=1
	ELSE IF(MODE.EQ.'DMA'.OR.MODE.EQ.'dma') THEN
		AED_MODE=2
		AED_DMA_POINTER=0
	ELSE IF(MODE.EQ.'PIN'.OR.MODE.EQ.'pin') THEN
		AED_IN_MODE=1
	ELSE
		STOP 'ILLEGAL ARGUMENT IN SETAED'
	ENDIF
	RETURN
	END
C
C
C
	SUBROUTINE SEL512 (DEVICE)
	INCLUDE 'IOBYTE.CMN'
	CHARACTER*(*) DEVICE

	IF (DEVICE(1:2).EQ.'TT'.OR.DEVICE(1:3).EQ.'_TT') THEN

		IF (FIRST_SER.NE.0) THEN
C	DEASSIGN OLD CHANNEL
			SYS=SYS$DASSGN(%VAL(AED_SER_CHANNEL))
			IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		ENDIF

C	ASSIGN NEW CHANNEL
		AED_SER_DEVICE=DEVICE
		SYS=SYS$ASSIGN(AED_SER_DEVICE,AED_SER_CHANNEL,,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		FIRST_SER=FIRST_SER+1

	ELSE IF (DEVICE(1:2).EQ.'AE'.OR.DEVICE(1:3).EQ.'_AE') THEN

		IF (FIRST_PAR.NE.0) THEN
C	DEASSIGN OLD CHANNEL
			SYS=SYS$DASSGN(%VAL(AED_PAR_CHANNEL))
			IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		ENDIF

C	ASSIGN NEW CHANNEL
		AED_PAR_DEVICE=DEVICE
		SYS=SYS$ASSIGN(AED_PAR_DEVICE,AED_PAR_CHANNEL,,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		FIRST_PAR=FIRST_PAR+1
		P3=AED_PAR_UNIT
		SYS=SYS$QIOW (,%VAL(AED_PAR_CHANNEL),IO$_ACCESS,AED_PAR_STAT,,,
	1		,,%VAL(P3),%VAL(1),,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		IF(.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
	ELSE
		STOP 'ILLEGAL DEVICE NAME IN SEL512'
	ENDIF
	RETURN
	END
C
C
C
	SUBROUTINE RST512 (ARRAY)
	INCLUDE 'IOBYTE.CMN'
	BYTE ARRAY(450500)              !8192)

	IF (AED_MODE.EQ.1) THEN
		SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),IO$_ACCESS,AED_PAR_STAT,,,
	1		,,,%VAL(2),,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		IF(.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
	ENDIF

	RETURN
	END
C
C
C
	SUBROUTINE OBYTE (ARRAY,N)
	INCLUDE 'IOBYTE.CMN'
	BYTE ARRAY(450500)              !8192)

	IF (AED_MODE.EQ.0) THEN
		SYS=SYS$QIOW(,%VAL(AED_SER_CHANNEL),IO$_WRITEVBLK,
	1		AED_SER_STAT,,,ARRAY,%VAL(N),,,,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
	ELSE IF (AED_MODE.EQ.1) THEN
		DO 30 I=1,N
			P3=ARRAY(I)
			SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),IO$_ACCESS,
	1			AED_PAR_STAT,,,,,%VAL(P3),%VAL(0),,)
			IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
			IF(.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
30		CONTINUE
	ELSE
		DO 60 I=1,N
			AED_DMA_POINTER=AED_DMA_POINTER+1
			IF (AED_DMA_POINTER.LE.AED_DMA_LEN) THEN
				AED_DMA_BUFFER(AED_DMA_POINTER)=ARRAY(I)
			ELSE
				STOP 'BUFFER TOO SMALL IN OBYTE'
			ENDIF
60		CONTINUE
	ENDIF
	RETURN
	END
C
C
C
	SUBROUTINE IBYTE (ARRAY,N)
	INCLUDE 'IOBYTE.CMN'
	BYTE ARRAY(450500)              !8192)
	INTEGER*4 TERM(2)
	DATA       TERM(1)/0/,TERM(2)/0/

	IF (AED_IN_MODE.EQ.0) THEN
		SYS=SYS$QIOW(,%VAL(AED_SER_CHANNEL),IO$_TTYREADALL,
	1		AED_SER_STAT,,,ARRAY,%VAL(N),,TERM,,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
	ELSE
		DO 30 I=1,N
			SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),IO$_ACCESS,
	1			AED_PAR_STAT,,,,,%VAL(P3),%VAL(4),,)
			IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
			IF(.NOT.AED_PAR_STAT(1)) THEN
				CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
			END IF
			ARRAY(I)=AED_PAR_STAT_B(5)
30		CONTINUE
	ENDIF
	RETURN
	END
C
C
	FUNCTION  KSR(N)
	INCLUDE 'IOBYTE.CMN'
	BYTE ARRAY(450500)              !8192)
	INTEGER*4 TERM(2)
	DATA       TERM(1)/0/,TERM(2)/0/

	IF (AED_IN_MODE.EQ.0) THEN
		TYPE *,'**IOBYTE** KSR FUNCTION NOT SUPPORTED'
		TYPE *,'  WITH SERIAL DRIVER'
		CALL SYS$EXIT (%VAL(SYS))
	ELSE
		SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),IO$_ACCESS,
	1		AED_PAR_STAT,,,,,%VAL(P3),%VAL(5),,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		IF(.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
		KSR=AED_PAR_STAT_B(5)
		N = KSR
	ENDIF
	RETURN
	END
C
C
C
	SUBROUTINE WRD (ARRAY,N)
	INCLUDE 'IOBYTE.CMN'
	BYTE ARRAY(450500)              !8192)

	IF (N.GT.0.AND.N.LE.AED_DMA_MAX) THEN
		SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),IO$_WRITEVBLK,
	1		AED_PAR_STAT,,,ARRAY,%VAL(N),%VAL(70),,,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		IF(.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
	ELSE
		STOP 'ILLEGAL ARGUMENT IN WRD'
	ENDIF
	RETURN
	END
C
C
C
	SUBROUTINE RRD (ARRAY,N)
	INCLUDE 'IOBYTE.CMN'
	BYTE ARRAY(450500)              !8192)

	IF (N.GT.0.AND.N.LE.AED_DMA_MAX) THEN
		SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),IO$_READVBLK,
	1		AED_PAR_STAT,,,ARRAY,%VAL(N),%VAL(64),,,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		IF(.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
	ELSE
		STOP 'ILLEGAL ARGUMENT IN RRD'
	ENDIF

	RETURN
	END
C
C
C
	SUBROUTINE WDA (ARRAY,N)
	INCLUDE 'IOBYTE.CMN'
	BYTE ARRAY(450500)              !8192)

	IF (N.GT.0.AND.N.LE.AED_DMA_MAX) THEN
		SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),IO$_WRITEVBLK,
	1		AED_PAR_STAT,,,ARRAY,%VAL(N),%VAL(46),,,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		IF(.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
	ELSE
		STOP 'ILLEGAL ARGUMENT IN WDA'
	ENDIF

	RETURN
	END
C
C
C
	SUBROUTINE RDA (ARRAY,N)
	INCLUDE 'IOBYTE.CMN'
	BYTE ARRAY(450500)              !8192)

	IF (N.GT.0.AND.N.LE.AED_DMA_MAX) THEN
		SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),IO$_READVBLK,
	1		AED_PAR_STAT,,,ARRAY,%VAL(N),%VAL(47),,,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		IF(.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
	ELSE
		STOP 'ILLEGAL ARGUMENT IN RDA'
	ENDIF

	RETURN
	END
C
C
C
	SUBROUTINE SCD (ARRAY,N)
	INCLUDE 'IOBYTE.CMN'
	BYTE ARRAY(450500)              !8192)

	ARRAY(N+1) = 0
	ARRAY(N+2) = 0
	ARRAY(N+3) = 0
	ARRAY(N+4) = 0
	N = N+4
	IF (N.GT.0.AND.N.LE.AED_DMA_MAX.AND.N.LE.AED_DMA_LEN) THEN
		SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),IO$_WRITEVBLK,
	1		AED_PAR_STAT,,,ARRAY,%VAL(N),%VAL(42),,,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		IF(.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
	ELSE
		STOP 'ILLEGAL ARGUMENT IN SCD'
	ENDIF

	AED_DMA_POINTER=0
	RETURN
	END
C
C
C
	SUBROUTINE SKS (ARRAY)
	INCLUDE 'IOBYTE.CMN'
	BYTE ARRAY(450500)              !8192)
	INTEGER*4 TERM(2)
	INTEGER*4 N
	DATA       TERM(1)/0/,TERM(2)/0/
	DATA    N /1/

	IF (AED_MODE.EQ.0) THEN
		SYS=SYS$QIOW(,%VAL(AED_SER_CHANNEL),IO$_TTYREADALL,
	1		AED_SER_STAT,,,ARRAY,%VAL(N),,TERM,,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
	ELSE
10		IF (KSR(IK).EQ.0) GO TO 10
		SYS=SYS$QIOW(,%VAL(AED_PAR_CHANNEL),IO$_ACCESS,
	1		AED_PAR_STAT,,,,,%VAL(54),%VAL(3),,)
		IF(.NOT.SYS) CALL SYS$EXIT (%VAL(SYS))
		IF(.NOT.AED_PAR_STAT(1)) CALL SYS$EXIT (%VAL(AED_PAR_STAT(1)))
		ARRAY(1)=AED_PAR_STAT_B(5)
	ENDIF
	RETURN
	END
C
C
C
	SUBROUTINE DEFBUF (LEN)
	INCLUDE 'IOBYTE.CMN'

	IF (LEN.GT.0.AND.LEN.LE.AED_DMA_MAX.AND.MOD(LEN,2).EQ.0) THEN
		AED_DMA_LEN=LEN
		AED_DMA_POINTER=0
	ELSE
		STOP 'ILLEGAL ARGUMENT IN DEFBUF'
	ENDIF
	RETURN
	END
