#include "Vista.h"
C       Routine to extract the numeric values from a FITS header


        SUBROUTINE GETCOORD(PARAM,IP1,IP2,FP3,SG)

C       Input:
C               PARAM = Input character string of the form
C                       -xx:xx:xx.x where the leading sign is
C                       optional.  The numeric fields are assumed to be
C                       separated by colons and the first two fields
C                       are assumed to be integers.  The third field
C                       can be floating point, but does not have to be.

C       Output:
C               IP1 =   Integer value of first numeric field
C                       Note that IP1 is positive even if the leading
C                       negative sign was present.
C               IP2 =   Integer value of second numeric field
C               FP3 =   Floating value of third numeric field
C               SG  =   -1.0 if leading negative sign was present,
C                       and +1.0 otherwise.

        CHARACTER*(*) PARAM
        CHARACTER*80 TEMP,TEMP2

C       First strip out the colons or slashes

        TEMP = PARAM

C       Check for leading sign

        SG = 1.0
        I = 1
8702    IF (TEMP(I:I) .EQ. ' ' .AND. I .LE. LEN(PARAM)) THEN
                I = I + 1
                GO TO 8702
        END IF

        IF(TEMP(I:I) .EQ. '-') THEN
                SG = -1.0
                TEMP(I:I) = ' '
        ELSE IF(TEMP(I:I) .EQ. '+') THEN
                TEMP(I:I) = ' '
        END IF

C   	Replace delimiters with spaces

        DO 8701 I=1,LEN(PARAM)
                IF(TEMP(I:I) .EQ. ':' .OR. TEMP(I:I) .EQ. '/' .OR.
     &             TEMP(I:I) .EQ. '-')  TEMP(I:I) = ' '
8701    CONTINUE

C       Extract the three parameters

        CALL DISSECT(TEMP,1,.FALSE.,NTYPE,IP1,FNUM,TEMP2,NCHAR,IERR)
        CALL DISSECT(TEMP,2,.FALSE.,NTYPE,IP2,FNUM,TEMP2,NCHAR,IERR)
        CALL DISSECT(TEMP,3,.FALSE.,NTYPE,IP3,FP3,TEMP2,NCHAR,IERR)
	IF (NTYPE .EQ. 1) FP3 = FLOAT(IP3)
        IP1 = IABS(IP1)

        RETURN
        END

