#include "Vista.h"
	SUBROUTINE BUFFERS

C       Routine to print out buffer header information

C       This routine is used to examine the parameters of the images
C       spectra connected to VISTA.  By default, a one line buffer
C       summary is printed out.  A complete summary can be printed out
C       by specifying the appropriate keyword.

C       If the user specifies specific buffers in the command line,
C       the contents of those buffers are listed.  Otherwise, all
C       buffers that are loaded are listed.

C       COM     BUF             List image buffers

C       Keyword FULL            Give full buffer listing
C               FITS[=keyword]  Give FITS header parameter (or all
C                               if FULL keyword is also given
C
C       Author: Tod R. Lauer    11/29/82
C               Richard Stover  December, 1983
C               Don Terndrup    January, 1984
C               Lick Observatory
C               University of California
C               Santa Cruz, CA 95064
C
C       Version 3       May, 1985
C
C       Modified by:    April Atwood    7/1/86, 1/87
C       Modified by:    Richard Stover  Oct 9, 87  (fixed date bug)
#ifdef VMS
	INCLUDE 'VINCLUDE:VISTALINK.INC'               ! Vista communication
	INCLUDE 'VINCLUDE:IMAGELINK.INC'               ! Image headers
#else
	INCLUDE 'vistadisk/source/include/vistalink.inc'
	INCLUDE 'vistadisk/source/include/imagelink.inc'
#endif

	INTEGER UPPER
	INTEGER BUFFERLIST(MAXIM)

	CHARACTER OBJ*30
	CHARACTER*15 INTRO
	CHARACTER*8 DATE, HOLD, FITSKEY

	LOGICAL IMAGE, FULL, FITS
	LOGICAL KEYCHECK

C       List allowed keywords.

	CALL KEYINIT
	CALL KEYDEF('FULL')
	CALL KEYDEF('FITS')
	CALL KEYDEF('FITS=')

C       Exit if any improper keywords were given.
	IF (.NOT. KEYCHECK()) THEN
		XERR = .TRUE.
		RETURN
	END IF

C       Look to see if any images exist.
	IMAGE   =.FALSE.
	DO 8701 II=1, MAXIM
C           Check to make sure at least 1 image exists.
		IF (BUFF(II)) IMAGE=.TRUE.
8701    CONTINUE

	IF (.NOT. IMAGE) THEN
		PRINT *,'No images connected.'
		RETURN
	END IF

C       Look at the integer buffer to see if any buffers have been
C       mentioned.  NUMBERMENTIONED is that number.  Load the
C       list of those mentioned into an array.  If none are mentioned,
C       load the numbers of all possible buffers.

	DO 8702 I=1,NINTS
		IF (IBUF(I) .LE. 0 .OR. IBUF(I) .GT. MAXIM) THEN
			PRINT *,'Buffer ',IBUF(I),' is out of range.'
			XERR = .TRUE.
			RETURN
		ELSE
			BUFFERLIST(I) = IBUF(I)
		END IF

8702    CONTINUE
	NUMBERMENTIONED = NINTS

	IF (NUMBERMENTIONED .EQ. 0) THEN
		DO 8703 I=1,MAXIM
			BUFFERLIST(I) = I
8703            CONTINUE
		NUMBERMENTIONED = MAXIM
	END IF

C       Check to see if full parameter listing is desired
C       or if literal FITS header listing is desired.

	FULL    =.FALSE.
	FITS    =.FALSE.
	FITSKEY = ' '
	DO 8704 I=1, NWORD
		N = UPPER(WORD(I))
		IF (WORD(I) .EQ. 'FULL') THEN
			FULL    =.TRUE.
		ELSE IF (WORD(I)(1:4) .EQ. 'FITS') THEN
			FITS = .TRUE.
			FITSKEY = ' '
			IF (WORD(I)(5:5) .EQ. '=') THEN
				FITSKEY = WORD(I)(6:13)
			ELSE IF (WORD(I)(5:5) .NE. ' ') THEN
				FITS = .FALSE.
			END IF
		END IF
8704    CONTINUE
C	IF (FITS .AND. (FITSKEY .EQ. ' ') .AND. .NOT. FULL) FITS =
C     &        .FALSE.
	IF (FITS .AND. (FITSKEY .EQ. ' ') .AND. .NOT. FULL) FULL =
     &        .TRUE.

	IF (.NOT. FULL .AND. .NOT. FITS) THEN
  	  WRITE(olu,101,ERR=9999)
 101      FORMAT (/' Buf   SC    NC    SR    NR   Exp   Obs    Date  ',
     .            ' Name')
	END IF

	DO 8705 JJ=1,NUMBERMENTIONED
		IF (NOGO) RETURN
		I = BUFFERLIST(JJ)

		IF (BUFF(I) .AND. .NOT. FULL .AND. .NOT. FITS) THEN
			HOLD    =' '
			CALL CCCHEAD('DATE-OBS',HEADBUF(1,I),DATE)
			L       =INDEX(DATE,'/')
			IF (L .EQ. 0) L = INDEX(DATE,'-')

			IF (L.GT.1 .AND. L .LT. 4) THEN
				HOLD(4-L:8)     =DATE
				HOLD(1:2)       =DATE(L+1:L+2)
C                               If there is only one digit in the day
C                               then HOLD(4:4) must be set to '0'.
C                               We set 4 and 5 just for good measure.
C                               R. Stover   Oct. 9, 1987
				HOLD(4:5) = '00'
				HOLD(7-L:5)     =DATE(1:L-1)
			END IF
			CALL CCINHEAD('EXPOSURE',HEADBUF(1,I),IT)
			CALL CCCHEAD('OBJECT',HEADBUF(1,I),OBJ)
			CALL CCINHEAD('OBSNUM',HEADBUF(1,I),II)

			IF (.NOT. ISSPECTRUM(I) .OR. 
     &                           ICOORD(IYSR,I) .NE. 1) THEN
			  WRITE(olu,102,ERR=9999) I, ICOORD(IXSC,I),
     &                      ICOORD(NNCOL,I),ICOORD(IYSR,I),
     &                      ICOORD(NNROW,I),IT, II, HOLD, OBJ
102                         FORMAT (I3,1X,4(I5,1X),2(I5,1X),1X,A8,
     &                                       3X,A30)
			ELSE
				WRITE(olu,103,ERR=9999) I, ICOORD(IXSC,I),
     &                            ICOORD(NNCOL,I),IT,II,HOLD,OBJ
103                             FORMAT (I3,1X,2(I5,1X),'  <spectrum>',
     &                            2(I5,1X),1X,A8,3X,A30)
			END IF

		ELSE IF (BUFF(I) .AND. .NOT. FITS) THEN
		    WRITE (INTRO,'(''Buffer '',I3,'' *** '')') I
		    CALL CCHEADER(INTRO,HEADBUF(1,I),NOUT)

		ELSE IF (BUFF(I)) THEN
			WRITE(olu,'(/,1X,A6,1X,I2)',ERR=9999) 'BUFFER',I
			CALL CCPRFITS(HEADBUF(1,I),FITSKEY,FULL)
		END IF
8705    CONTINUE

	RETURN

C       Error during write - issue message
9999    CALL SYSERRPRINT(0,'WHILE WRITING HEADER')
	XERR = .TRUE.
	RETURN

	END

C       -----------------------------------------------------------------

C       Routine to print FITS header buffer

	SUBROUTINE PRFITS(HEADBUF,FITSKEY,FULL)

C       This routine prints out the FITS card with label contained in
C       FITSKEY.  The FITS header is stored in HEADBUF.  If FULL is
C       .TRUE., then all FITS cards are printed.

	CHARACTER*(*) HEADBUF,FITSKEY
	LOGICAL FULL
#ifdef VMS
	INCLUDE 'VINCLUDE:VISTALINK.INC'
#else
	INCLUDE 'vistadisk/source/include/vistalink.inc'
#endif

	NCARD = LEN(HEADBUF)/80
	DO 8706 N=1,NCARD
		IF(NOGO) RETURN
		N1 = (N-1)*80 + 1
		N2 = N1 + 75
		IF(FULL) THEN
			IF(HEADBUF(N1:N2) .NE. ' ')
     .                          WRITE(olu,*,ERR=9999)HEADBUF(N1:N2)
		ELSE IF(HEADBUF(N1:N1+7) .EQ. FITSKEY) THEN
				IF(FITSKEY .NE. ' ')
     .                              WRITE(olu,*,ERR=9999) HEADBUF(N1:N2)
		END IF
8706    CONTINUE
	RETURN

C       Error during write - issue message
9999    CALL SYSERRPRINT(0,'WHILE WRITING FITS HEADER')
	XERR = .TRUE.
	RETURN

	END
