c.......................................................................
c  

      SUBROUTINE intro(iterm)

c
c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

      implicit none

      integer            iterm

      real*4             pxmin,pymin,pxmax,pymax


  
      pxmin = 0.0
      pymin = 0.0
      pxmax = 10000.
      pymax = 10000.

c     starting Mongo... initialize the plotting device; wait a little for
c     the window to be mapped

      CALL device(iterm)
      CALL tsetup
      CALL setphysical(pxmin,pymin,pxmax,pymax)
      CALL sleep(1)
      CALL erase
      CALL getphysical(pxmin,pymin,pxmax,pymax)
      pxmax = pxmax * 0.60
      pymax = pymax * 0.50
      CALL setphysical(pxmin,pymin,pxmax,pymax)
      CALL erase
      CALL window(1,1,1)

c     define some colors, the first parameter in the list is the color
c     index in the color table: current definition: 0=background=black,
c     1=foreground=white, 2=red, 3=green 4=blue 5=yellow 6=blue/green
c     7=orange

      CALL makecolor(0,0.,0.,0.)
      CALL makecolor(1,1.,1.,1.)
      CALL makecolor(2,1.,0.,0.)
      CALL makecolor(3,0.,1.,0.)
      CALL makecolor(4,0.,0.,1.)
      CALL makecolor(5,1.,1.,0.)
      CALL makecolor(6,0.,1.,1.)
      CALL makecolor(7,0.9,0.8,0.)

c     make a unit sized invisible box

      CALL setlvis(0)
      CALL setlim(0.,0.,1.,1.)
      CALL rect(-1,-1,-1,-1)

c     make a large announcement

      CALL setlweight(2.0)
      CALL setexpand(3.0)
      CALL setcolor(3)
      CALL relocate(0.5,0.8)
      CALL putlabel(80,'System Analysis V1.0\\e',5) 
      CALL setexpand(2.0)
      CALL tidle
  
      CALL setexpand(1.0)
      CALL setlweight(0.5)
      CALL setcolor(1)
      CALL submargins(0.6,1.0)
      CALL tidle
  
      RETURN
      END

c
c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      SUBROUTINE autoxlimits

c
c.......................................................................

      implicit none

      include            'sysanal.h'

      integer            i
      double precision   xl,xh
      

      include            'sysanal.com'
      include            'lmongo.com'


c provide the maximum window

       xl =  1.0d10
       xh = -1.0d10

       DO 01 i=1,norders
        xl = min(vel(1,i),xl)
        xh = max(vel(ndata(i),i),xh)
 01    CONTINUE


c     save

       x_lo = xl
       x_hi = xh

c     return

      RETURN
      END

c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      SUBROUTINE autoylimits(ptype,iorder)

c
c.......................................................................

      implicit none

      include            'sysanal.h'

      integer            i,j,lpix,upix
      integer            iorder,ptype
      double precision   Nsig

      include            'sysanal.com'
      include            'lmongo.com'

c     find the y limits automoatigically; first set the scale factor in
c     case user is an idiot

      IF (plt_factor.lt.1.0d0) plt_factor = 1.25
      Nsig = N_sigma(iorder)
      y_lo = 0.0d0
      y_hi = 0.0d0

c     find the lower pixel of our current window

      lpix  = 1
      DO 11 j=1,ndata(iorder)-1
        IF ((x_lo.gt.vel(j,iorder)).AND.
     &     (x_lo.le.vel(j+1,iorder))) lpix = j
 11   CONTINUE

c     find the upper pixel of our current window

      upix  = ndata(iorder)
      DO 13 j=1,ndata(iorder)-1
        IF ((x_hi.gt.vel(j,iorder)).AND.
     &     (x_hi.le.vel(j+1,iorder))) upix = j
 13   CONTINUE

c     if we are plotting the data, account for normalization flag

      IF (ptype.eq.1) then
        DO 02 i=lpix,upix
          IF (normalize) then
            y_hi = max(y_hi,flux(i,iorder)/cont(i,iorder))
            y_hi = max(y_hi,1.0d0)
          ELSE
            y_hi = max(y_hi,flux(i,iorder))
            y_hi = max(y_hi,cont(i,iorder))
          END IF
 02     CONTINUE
        y_lo = 0.5*(1.0d0-plt_factor) * y_hi
        y_hi = plt_factor * y_hi
      END IF

c     if we are plotting the equivalent width array

      IF (ptype.eq.2) then
        DO 03 i=lpix,upix
         y_lo = min(y_lo,ewpix(i,iorder))
         y_lo = min(y_lo,-Nsig*ewsigpix(i,iorder))
         y_hi = max(y_hi,ewpix(i,iorder))
         y_hi = max(y_hi,Nsig*ewsigpix(i,iorder))
 03     CONTINUE
         y_lo = plt_factor * y_lo
         y_hi = plt_factor * y_hi
      END IF

c     if we are plotting the sigma data

      IF (ptype.eq.3) then
        DO 04 i=lpix,upix
          y_hi = max(y_hi,sigma(i,iorder))
 04     CONTINUE
        y_lo = (1.0d0-plt_factor) * y_hi
        y_hi = plt_factor * y_hi
      END IF

c     if we are plotting the smooth sigma data (or sky)

      IF (ptype.eq.4) then
        DO 05 i=lpix,upix
          y_hi = max(y_hi,smsig(i,iorder))
 05    CONTINUE
        y_lo = (1.0d0-plt_factor) * y_hi
        y_hi = plt_factor * y_hi
      END IF


      RETURN
      END

c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      SUBROUTINE plotter(ptype,iorder)

c
c.......................................................................

      implicit none

      include            'sysanal.h'

      integer            ptype,iorder,nywin,i,j
      character*80       title
    
      include            'sysanal.com'
      include            'lmongo.com'




      CALL erase

c     we plot the first order ion transition on the bottom window at all
c     time and the current order ion transition on the top window; if
c     there is only one ion transition, be sure to just plot it

      nywin = 1
      IF (norders.gt.1) nywin = 2

      DO 11 i=nywin,1,-1
      
       IF (i.eq.2) then 
        title = order(iorder)
        j     = iorder
       ELSE
        title  = order(1)
        j      = 1            
       END IF

       CALL window(1,nywin,i)
       CALL pltwin(ptype,iorder,title)
       IF (ptype.eq.1)   CALL pltdata(j)
       IF (ptype.eq.2)   CALL pltews(j)
       IF (ptype.eq.3)   CALL pltsigs(j)
       IF (ptype.eq.4)   CALL pltsmsigs(j)
       IF (show_regions) CALL pltregions(j)

 11   CONTINUE

      RETURN
      END

c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c
  
      SUBROUTINE pltwin(ptype,iorder,title)

c
c.......................................................................

      implicit none

      integer            iorder,ptype
      real*4             xxlo,xxhi,yylo,yyhi
      character*80       title

      include            'lmongo.com'



c     set the limits and make the plot title

      xxlo  = x_lo
      xxhi  = x_hi
      yylo  = y_lo
      yyhi  = y_hi
 
      CALL sappend(title,' ','\\e',title)

c     draw the box and the labels

      CALL setcolor(5)
      CALL tlabel(80,title)
      CALL xlabel(80,'Velocity\\e')
      IF (ptype.eq.1) CALL ylabel(80,'Flux\\e')
      IF (ptype.eq.2) CALL ylabel(80,'Equivalent Width\\e')
      IF (ptype.eq.3) CALL ylabel(80,'Sigma\\e')
      IF (ptype.eq.4) CALL ylabel(80,'Error\\e')
      CALL setlim(xxlo,yylo,xxhi,yyhi)
      CALL setlweight(0.5)
      CALL abox(1,2,0,0)

c     draw a dotted line at the zero point

      IF (y_lo.lt.0.d0) then
       CALL setltype(1)
       CALL relocate(xxlo,0.0)
       CALL draw(xxhi,0.0)
       CALL setltype(0)
      END IF

c     reset the color and flush

      CALL setcolor(1)
      CALL tidle


      RETURN
      END
  
c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      SUBROUTINE pltdata(iorder)

c
c.......................................................................

      implicit none

      include            'sysanal.h'

      integer            i
      integer            iorder

      real*4             xx(nmx),yy(nmx),ss(nmx),cc(nmx)

      include            'sysanal.com'
      include            'lmongo.com'




c     set the line weight and line type (thin solid)
  
       CALL setlweight(0.5)
       CALL setltype(0)

c     stuff the plotting data

       DO 03 i=1,ndata(iorder)
        xx(i) = vel(i,iorder)
        IF (normalize) then 
          yy(i) = flux(i,iorder)/cont(i,iorder)
          ss(i) = sigma(i,iorder)/cont(i,iorder)
          cc(i) = cont(i,iorder)/cont(i,iorder)
        ELSE
          yy(i) = flux(i,iorder)
          ss(i) = sigma(i,iorder)
          cc(i) = cont(i,iorder)
        END IF
 03    CONTINUE

c     plot the continuum first; set the color blue/green

      CALL setcolor(6) ! blue/green
      CALL connect(xx,cc,ndata(iorder))
      CALL tidle

c     plot the data and the sigma array; reset the color

      CALL setcolor(1) ! white
      CALL histogram(xx,yy,ndata(iorder))
      CALL tidle
      CALL setcolor(3) ! green
      CALL histogram(xx,ss,ndata(iorder))
      CALL tidle

c  reset the line type (solid), the color, and flush

      CALL setltype(0)
      CALL setcolor(1)
      CALL setlweight(0.5)
      CALL tidle


      RETURN
      END
  
c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      SUBROUTINE pltews(iorder)

c
c.......................................................................

      implicit none

      include            'sysanal.h'

      integer            i,iorder
      double precision   Nsig
      real*4             xx(nmx),yy(nmx),su(nmx),sd(nmx)

      include            'sysanal.com'




      Nsig = N_sigma(iorder)

      CALL setlweight(0.5)
      CALL setltype(0)

      DO 03 i=1,ndata(iorder)
       xx(i) = vel(i,iorder)
       yy(i) = ewpix(i,iorder)
       su(i) = ewsigpix(i,iorder)
       sd(i) = - su(i)
 03   CONTINUE

c     plot the 1-sigma spectra first

      CALL setcolor(6) ! blue/green
      CALL histogram(xx,su,ndata(iorder))
      CALL tidle
      CALL histogram(xx,sd,ndata(iorder))
      CALL tidle

c     plot the Nsig-sigma spectra first

      DO 05 i=1,ndata(iorder)
       su(i) = Nsig * ewsigpix(i,iorder)
       sd(i) = - su(i)
 05   CONTINUE

      CALL histogram(xx,su,ndata(iorder))
      CALL tidle
      CALL histogram(xx,sd,ndata(iorder))
      CALL tidle

c     finally, plot the equivalent width spectrum

      CALL setcolor(1)  ! white
      CALL histogram(xx,yy,ndata(iorder))
      CALL tidle

      CALL setlweight(0.5)


      RETURN
      END
  
c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      SUBROUTINE pltsigs(iorder)

c
c.......................................................................

      implicit none

      include            'sysanal.h'

      integer            i
      integer            iorder

      real*4             xx(nmx),yy(nmx)

      include            'sysanal.com'
      include            'lmongo.com'



c     set the line weight and line type (thin solid)
  
       CALL setlweight(0.5)
       CALL setltype(0)

c     stuff the plotting data
       
       DO 03 i=1,ndata(iorder)
        xx(i) = vel(i,iorder)
        yy(i) = sigma(i,iorder)
 03    CONTINUE

c     plot the data and the sigma array; reset the color

      CALL setcolor(1) ! white
      CALL histogram(xx,yy,ndata(iorder))
      CALL tidle

c     reset the line type (solid), the color, and flush

      CALL setltype(0)
      CALL setcolor(1)
      CALL setlweight(0.5)
      CALL tidle


      RETURN
      END
  
c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      SUBROUTINE pltsmsigs(iorder)

c
c.......................................................................

      implicit none

      include            'sysanal.h'

      integer            i
      integer            iorder

      real*4             xx(nmx),yy(nmx)

      include            'sysanal.com'
      include            'lmongo.com'



c     set the line weight and line type (thin solid)
  
       CALL setlweight(0.5)
       CALL setltype(0)

c     stuff the plotting data

       DO 03 i=1,ndata(iorder)
        xx(i) = vel(i,iorder)
        yy(i) = smsig(i,iorder)
 03    CONTINUE

c     plot the data and the sigma array; reset the color


      CALL setcolor(1) ! white
      CALL histogram(xx,yy,ndata(iorder))
      CALL tidle

c     reset the line type (solid), the color, and flush

      CALL setltype(0)
      CALL setcolor(1)
      CALL setlweight(0.5)
      CALL tidle


      RETURN
      END
  
c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      SUBROUTINE pltregions(iorder)

c
c.......................................................................

      implicit none     

      include            'sysanal.h'

      integer            i,k
      integer            iorder
      real*4             xtick,ytick

      include            'sysanal.com'
      include            'lmongo.com'

c
c
c



      CALL setltype(1) ! dotted
      CALL setlweight(0.5)
       
      DO 07 k=1,nlines

       IF (iorder.eq.1) THEN
        CALL setcolor(3) ! green
       ELSE
        CALL setcolor(7) ! light orange
       END IF

c     plot the detections from below the continuum, except for the
c     primary ion, plot the regions over the full evertical extent of
c     the plot

       IF (sf_flag(iorder,k)) THEN
        DO 09 i=1,nfind(iorder,k)
         xtick = vel(f_beg(k,iorder,i),iorder)
         IF (iorder.eq.1) then
          ytick = y_hi
         ELSE 
          ytick = 1.0
         END IF
         CALL relocate(xtick,ytick)
         ytick = y_lo
         CALL draw(xtick,ytick)
         xtick = vel(f_end(k,iorder,i),iorder)
         CALL relocate(xtick,ytick)
         IF (iorder.eq.1) then
          ytick = y_hi
         ELSE 
          ytick = 1.0
         END IF
         CALL draw(xtick,ytick)
         CALL tidle
 09     CONTINUE
       END IF

c     now plot the limit regions and above the continuum

       IF (iorder.ne.1) then 
        CALL setcolor(6) ! blue green

        DO 19 i=1,nfind(iorder,k)
         xtick = vel(f_beg(k,iorder,i),iorder)
         ytick = y_hi
         CALL relocate(xtick,ytick)
         ytick = 1.0
         CALL draw(xtick,ytick)
         xtick = vel(f_end(k,iorder,i),iorder)
         CALL relocate(xtick,ytick)
         ytick = y_hi
         CALL draw(xtick,ytick)
         CALL tidle
19      CONTINUE

       END IF

 07   CONTINUE ! next line (region)

      CALL setcolor(1)  ! white
      CALL setltype(0)  ! solid 
      CALL setlweight(0.5)


       RETURN
       END

c  
c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      SUBROUTINE pltedit(iorder,iline,isub)

c
c.......................................................................

      implicit none     

      include            'sysanal.h'

      integer            i,k
      integer            iorder,iline,isub
      real*4             xtick,ytick

      include            'sysanal.com'
      include            'lmongo.com'

c
c
c


      CALL window(1,2,2)

      k = iline
      i = isub

      CALL setltype(1) ! dotted
      CALL setlweight(0.5)
       
      CALL setcolor(2) ! red

      xtick = vel(f_beg(k,iorder,i),iorder)
      ytick = y_hi
      CALL relocate(xtick,ytick)
      ytick = y_lo
      CALL draw(xtick,ytick)
      xtick = vel(f_end(k,iorder,i),iorder)
      CALL relocate(xtick,ytick)
      ytick = y_hi
      CALL draw(xtick,ytick)
      CALL tidle

      CALL setcolor(1)  ! white
      CALL setltype(0)  ! solid 
      CALL setlweight(0.5)


       RETURN
       END

c  
c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      SUBROUTINE hardcopy(action,iorder)

c
c.......................................................................

      implicit none

      include            'sysanal.h'

      logical            flag

      integer            ptype,iorder,action

      character*80       psfilename,title

      include            'sysanal.com'
      include            'lmongo.com'



      flag = .true.


c     query PostScript filename

      IF (action.eq.1) then
        CALL mgoprompt('                                 ')
        CALL mgoprompt('PostScript File Name : ')
        CALL mx11gets(psfilename)
      END IF

      IF (action.eq.2) then
        CALL fappend(order(iorder),'ps',psfilename)
      END IF

c     this creates the PostScript file to $cwd

      CALL psplot(flag,psfilename,' ')      

c     set the window for a more pleasing aspect ratio

      CALL submargins(0.,1.0)

c     first plot the data

      CALL window(1,3,2)
      ptype = 1
      CALL autoylimits(ptype,iorder)
      title = order(iorder)
      CALL pltwin(ptype,iorder,title)
      CALL pltdata(iorder)

c     now plot the ewspectra

      CALL window(1,3,1)
      ptype = 2
      CALL autoylimits(ptype,iorder)
      title = ' '
      CALL pltwin(ptype,iorder,title)
      CALL pltews(iorder)

      CALL fileplot
      CALL tidle

c     we must reset the terminal output

      CALL device(11)

      RETURN
      END
c
c     eof
