c.........................................................................
c

      SUBROUTINE sigscale(ptype,iorder) 
 
c
c   Calculate the chi squared for the user's choice of scaling for
c   the sigma vector.  Give user the choice to adopt this scaling
c   and print out a new .sig2 file for the order or not.
c
c::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      implicit none
     
      include             'sysanal.h'
      include             'lmongo.h'
 
      logical             error
      integer             ikey,iorder,ipix,line,i,nu,
     @                    ptype,ptype_save,findfeat
      double precision    factor,dfactor,chisq,data,vardata,varfit
      double precision    value2,chisqnu,rdum
      double precision    savesig(nmx)
      real*4              xpos,ypos
      character*80        ch_dum,write_file
 
      include             'sysanal.com'
      include             'lmongo.com'
 
 
 

c     save the sigma vector for good measure

      DO 07 ipix = 1,ndata(iorder)
       savesig(ipix) = sigma(ipix,iorder)
 07   CONTINUE
 
 
      factor     = 1.0d0
      dfactor    = 0.05        ! begin user at 5% changes
      ptype_save = ptype


 01   chisq   = 0.0d0
      nu      = 0
      vardata = 0.0d0

  
c     re-establish the features for this scaling; re-establish the ew
c     arrays for this scaling


      CALL ewspec(iorder)
      nfind(iorder) = findfeat(iorder)

c     compute the chisq, toss out pixels that are in features; be sure
c     to mask out detection features

      DO 03 ipix=1,ndata(iorder)
       DO 04 line=1,nfind(iorder)
        DO 05 i=f_beg(line,iorder),f_end(line,iorder)
           IF (i.eq.ipix) GOTO 03
 05     CONTINUE
 04    CONTINUE
 
       data    = max(0.0d0,flux(ipix,iorder))
       chisq   = chisq + ((data-1.0d0)/(sigma(ipix,iorder)))**2
       vardata = vardata + 1.0d0/(sigma(ipix,iorder)**2)
       nu      = nu + 1
 
 03   CONTINUE

      vardata = nu/vardata
      chisqnu = chisq/nu
      varfit  = chisqnu*vardata

      WRITE(6,*) 'WITH SCALE FACTOR = ',factor 
      WRITE(6,*) 'chisq = ',chisq
      WRITE(6,*) 'chisqnu = ',chisqnu
      WRITE(6,*) 'vardata = ',vardata
      WRITE(6,*) 'varfit = ',varfit
      WRITE(6,*)


      CALL plotter(ptype,iorder)
 02   CALL mongohairs(ikey,xpos,ypos)


c     forget changes; complete restore

      IF (ikey.eq.key_f) then
        DO 09 ipix = 1,ndata(iorder)
         sigma(ipix,iorder) = savesig(ipix)
 09     CONTINUE
        factor = 1.0d0
        WRITE(6,*) ' Spectra Restored'
        GOTO 01
      END IF

c     plot data space

      IF (ikey.eq.key_h) THEN
        ptype = 1
        CALL autoylimits(ptype,iorder)
        GOTO 01
      END IF

c     plot ew space

      IF (ikey.eq.key_k) THEN 
        ptype = 2
        CALL autoylimits(ptype,iorder)
        GOTO 01
      END IF
 
c     bail... keeps current settings but does not write

      IF (ikey.eq.key_q) THEN
        RETURN
      END IF

c     scale dfactor up by 1%; do not let it go above 50%

      IF (ikey.eq.key_u) THEN
        if (dfactor.lt.0.5) dfactor = dfactor + 0.01
        WRITE(6,*) ' DFACTOR = ',dfactor
        GOTO 02
      END IF

c     scale dfactor down by 1%; do not let it go to zero

      IF (ikey.eq.key_d) THEN
        if (dfactor.gt.0.01) dfactor = dfactor - 0.01
        WRITE(6,*) ' DFACTOR = ',dfactor
        GOTO 02
      END IF

c     scale the sigma spectrum down by dfactor

      IF (ikey.eq.left_mouse_button) then
        factor = factor/(1.0d0+dfactor)
        DO 13 ipix = 1,ndata(iorder)
         sigma(ipix,iorder) = sigma(ipix,iorder)/(1.0d0+dfactor)
 13     CONTINUE
        GOTO 01
      END IF

c     scale the sigma spectrum up by dfactor

      IF (ikey.eq.right_mouse_button) then
        factor = factor*(1.0d0+dfactor)
        DO 15 ipix = 1,ndata(iorder)
         sigma(ipix,iorder) = (1.0d0+dfactor)*sigma(ipix,iorder)
 15     CONTINUE
        GOTO 01
      END IF

c     type in the relative scaling factor

      IF (ikey.eq.center_mouse_button) then
        CALL mgoprompt('Enter Relative Scaling Factor [1.00] : ')
        CALL mx11gets(ch_dum)
        CALL mgoprompt('                                            ')
        IF (ch_dum.eq.' ') GOTO 01
        factor = value2(ch_dum,error)
        IF (error) then
          factor = 1.0d0
          WRITE(6,*) ' Invalid Input- try again.'
        END IF
        DO 17 ipix = 1,ndata(iorder)
         sigma(ipix,iorder) = factor*sigma(ipix,iorder)
 17     CONTINUE
        GOTO 01
      END IF

c     windowing abilities

      IF (ikey.eq.key_w) then
        CALL mgoprompt('Window mode:               ')
        CALL mongohairs(ikey,xpos,ypos)
        IF (ikey.eq.key_a) then
          CALL autoxlimits
          CALL autoylimits(ptype,iorder)
        END IF
        IF (ikey.eq.key_e) then
           x_lo = xpos
           y_lo = ypos
         CALL mgoprompt('again:                    ')
         CALL mongohairs(ikey,xpos,ypos)
           x_hi = xpos
           y_hi = ypos
         IF (x_lo.gt.x_hi) then
           rdum = x_lo
           x_lo = x_hi
           x_hi = rdum
         END IF
         IF (y_lo.gt.y_hi) then
           rdum = y_lo
           y_lo = y_hi
           y_hi = rdum
         END IF
        END IF
        GOTO 01
      END IF
 
c     help menu

      IF (ikey.eq.key_questionmark) then
        WRITE(6,*) ' --- editing mode cursor control --- '
        WRITE(6,*) ' ? - this menu'
        WRITE(6,*) ' w - window mode'
        WRITE(6,*) ' f - forget (restore to original)'
        WRITE(6,*) ' h - view spectra'
        WRITE(6,*) ' u - increment DFACTOR by 1%'
        WRITE(6,*) ' k - decrement DFACTOR by 1%'
        WRITE(6,*) ' left mouse button  - decrement sigma'
        WRITE(6,*) ' right mouse button - increment sigma'
        WRITE(6,*) ' center mouse button - type in FACTOR'
        WRITE(6,*) ' q - quit ; changes kept'
        GOTO 02
      END IF

c     if you are here then you made a bogus keystroke

      GOTO 01

c     formats

 801  FORMAT(1x,8f15.7)

      END

c     eof
