c.........................................................................
c

      SUBROUTINE interact

c
c     LICK MONGO INTERACTIVE MODE
c
c
c:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
c

      implicit none

      include            'sysanal.h'
      include            'lmongo.h'

      logical            flag,error
      integer            i,j,k,ikey,itmp,jtmp,ktmp,ptype,action
      integer            subfeat,iorder,ioni
      double precision   rtmp,value2
      real*4             xpos,ypos
      character*80       ch_tmp,string1,string2

      include            'sysanal.com'
      include            'lmongo.com'



c     open the Mongo window
      
      CALL intro(11)

c     initialize; ptype determines the data to be plotted

      ptype          = 1       ! initialize for plotting the data
      iorder         = 1       ! initialize to the primary ion
      flag           = .false.
      normalize      = .false.
      show_regions   = .true.

c     set the limits for plotting

 201  CALL autoxlimits
      CALL autoylimits(ptype,iorder)

c     plot the data

 202  CALL plotter(ptype,iorder)

c     query for the input; this is the top level query

 203  CALL mongohairs(ikey,xpos,ypos)

c     the following conidtional blocks are traps for the value of IKEY,
c     which returns the ASCII code value for the input keystroke; XPOS
c     and YPOS are the x and y positions in user coordinates where the
c     cursor is on the plot; in the traps a "return" via a GOTO
c     statement sends us back to the tope level query; a return to 201
c     refreshes the limits and the plot first; a return to 202 refreshes
c     just the plot; a return to 203 simply puts us back to the top

c.........................................................................
c     navigate - change order (up 1)
c.........................................................................

       IF (ikey.eq.key_f) then  
         IF (iorder.eq.norders) then  
           iorder = 1
         ELSE 
           iorder = iorder + 1 
         END IF
         GOTO 201  ! refresh full order
       END IF

c.........................................................................
c     navigate - change order (down 1)
c.........................................................................

       IF (ikey.eq.key_b) then  
         IF (iorder.eq.1) then
           iorder = norders
         ELSE 
           iorder = iorder - 1
         END IF
         GOTO 201  ! refresh full order
       END IF

c.........................................................................
c     colon commands
c.........................................................................

       IF (ikey.eq.key_colon) then

c     coln command: take the input; if invalid 

         error = .false.
         CALL mgoprompt('                                   ')
         CALL mgoprompt(':')
         CALL mx11gets(ch_tmp)
         CALL parzstring(ch_tmp,string1,string2,error)
         IF (error) then  ! back to the top
           CALL mgoprompt('ERROR: invalid colon command     ')
           WRITE(6,*) ' ERROR: invalid colon command'         
           GOTO 203  ! requery
         END IF

c     colon command: input N_SIGMA

         IF (string1.eq.'sigma') then  ! modify N_sigma
           rtmp = value2(string2,error)
           IF (error) then  ! back to the top
             WRITE(6,*) ' ERROR: sigma non numerical'         
             GOTO 203  ! top level no refresh
           END IF
           N_sigma(iorder) = rtmp
           GOTO 202  ! refresh plot current limits
         END IF           

c     colon command: end block

       END IF

c.........................................................................
c     add a master region; we do not mave a mechanism for adding
c     subegions
c.........................................................................


      IF (ikey.eq.key_a) then

c     add the feature or bail if cursor not position correctly; else
c     plot new region; conidtions for a bail are 1. no significant
c     detection at the cursoe location, 2. cursoe in an already defined
c     master region velocity range; message of return is provided in
c     routin ADDREGION

         rtmp = xpos
         CALL addregion(rtmp,flag)
         IF (.not.flag) GOTO 202  ! refresh current limits
         CALL plotter(ptype,iorder)

c     check if this master region is spurious and query user to keep or
c     reject if so

         action = 0
         CALL spurious(nlines,action,flag)

         IF (flag) then 
           WRITE(6,*) ' There are no corroborating features over'
           WRITE(6,*) ' this velocity range in other transitions....'
 43        CALL mgoprompt('Keep region? (y/n)               ')
           WRITE(6,*) ' Keep region? (y/n)'
           CALL mongohairs(ikey,xpos,ypos)
           IF ((ikey.ne.key_y).AND.(ikey.ne.key_n)) GOTO 43  ! ask again
           IF (ikey.eq.key_n) then
            action = 1
            CALL spurious(nlines,action,flag)  ! this call will remove it
            WRITE(6,*) ' new region discarded'
           END IF
           IF (ikey.eq.key_y) then
            WRITE(6,*) ' new region added'
            mkmod(iorder) = .true.  ! flag that user made a modification
           END IF
         ELSE
           WRITE(6,*) ' new region added'
         END IF

       GOTO 202 ! refresh current limits

c     add region: end block

      END IF

c.........................................................................
c  delete region or subregion limits
c.........................................................................

      IF (ikey.eq.key_d) then 

c     delete: grab region; on error requery; if the cursor is not in the
c     region bail; the message of a bad cursor location is provided in
c     routine GETREGION

        rtmp = xpos
        CALL getregion(jtmp,itmp,iorder,rtmp,error)
        IF (error) GOTO 203 ! requery only

c     delete: if order 1 delete master region; verify

        IF (iorder.eq.1) THEN

          CALL pltedit(iorder,jtmp,1)
          WRITE(6,*) ' Deleting Master Region ',jtmp
          WRITE(6,*) ' of Ion Transition ',order(iorder)(1:20)
 63       CALL mgoprompt('Are you sure? (y/n)               ')
          WRITE(6,*) ' Are you sure? (y/n)'
          CALL mongohairs(ikey,xpos,ypos)
          IF ((ikey.ne.key_y).AND.(ikey.ne.key_n)) GOTO 63  ! ask again
          IF (ikey.eq.key_y) then
            CALL delregion(jtmp)
            mkmod(iorder) = .true.  ! flag that user made a modification
          END IF
          IF (ikey.eq.key_n) then
            WRITE(6,*) ' No action taken'
          END IF

c     delete: if not order=1 delete subregion; verify

        ELSE

          CALL pltedit(iorder,jtmp,itmp)
          WRITE(6,*) ' Deleting Subregion ',itmp
          WRITE(6,*) ' of Master Region ',jtmp
          WRITE(6,*) ' of Ion Transition ',order(iorder)(1:20)
 64       CALL mgoprompt('Are you sure? (y/n)               ')
          WRITE(6,*) ' Are you sure? (y/n)'
          CALL mongohairs(ikey,xpos,ypos)
          IF ((ikey.ne.key_y).AND.(ikey.ne.key_n)) GOTO 64
          IF (ikey.eq.key_y) then
            CALL delsubreg(iorder,jtmp,itmp)
            mkmod(iorder) = .true.  ! flag that user made a modification
          END IF
          IF (ikey.eq.key_n) then
            WRITE(6,*) ' No action taken'
          END IF
        END IF

c     delete: communicate that we are done, back to the top; replot with
c     current limits

        WRITE(6,*)  ' end delete mode'
        GOTO 202 ! refresh current limits

c     delete: end block

      END IF

c.........................................................................
c  modify region or subregion limits
c.........................................................................

        IF (ikey.eq.key_m) then
 
c     modify: grab region; if cursor is not in a region, then bail;
c     message of error is given in routine GETREGION; on error requery

         rtmp = xpos
         CALL getregion(jtmp,itmp,iorder,rtmp,error)
         IF (error) GOTO 203 ! requery only

c     modify: enter modify mode; communicate

          action = 0

          j = f_beg(jtmp,iorder,itmp)
          k = f_end(jtmp,iorder,itmp)

 54       WRITE(6,*) ' ------------- modify mode --------------'
          WRITE(6,*) '   l - move lower (dynamic)'
          WRITE(6,*) '   u - move upper (dynamic)'
          WRITE(6,*) '   i - insert changes and quit (keep mods) '
          WRITE(6,*) '   f - forget changes and quit (restore) '
          WRITE(6,*) '   ? - this menu '
          WRITE(6,*) '   q - quit '
 55       CALL mgoprompt('Modify mode: (l,u,i,f,?,q)  ')
          CALL mongohairs(ikey,xpos,ypos)
          rtmp = xpos

c     modify mode: help

          IF (ikey.eq.key_questionmark) then
            GOTO 54 ! print help screen for modify mode
          END IF

c     modify mode : quit

          IF (ikey.eq.key_q) then

            IF ((j.eq.f_beg(jtmp,iorder,itmp)).AND.
     &          (k.eq.f_end(jtmp,iorder,itmp))) then
              WRITE(6,*) ' (EDIT): mode disabled'
              WRITE(6,*) ' - no modifications saved'
              GOTO 202 ! refresh current limits
            ELSE
              WRITE(6,*) ' (EDIT): *** WARNING ***'
              WRITE(6,*) '  * feature limits modified *'
              WRITE(6,*) '  use "i" or "f" keys prior to quit'
              GOTO 55  ! ask again
            END IF
          END IF

c     modify mode: (insert) keep changes; since we have modified a
c     master region we need to recompute the subregions within this new
c     region

          IF (ikey.eq.key_i) then
            mkmod(iorder) = .true.  ! flag that user made a modification
            IF (iorder.eq.1) then
             DO 52 i=2,norders
              nfind(i,jtmp) = subfeat(i,jtmp)
 52          CONTINUE
            END IF
            WRITE(6,*) ' (EDIT): feature updated'
            WRITE(6,*) ' end edit mode'
            GOTO 202 ! refresh current limits
          END IF

c     modify mode: (forget) restore and quit

          IF (ikey.eq.key_f) then
            f_beg(jtmp,iorder,itmp) = j
            f_end(jtmp,iorder,itmp) = k
            CALL plotter(ptype,iorder)
            WRITE(6,*) ' (EDIT): feature restored'
            WRITE(6,*) ' end edit mode'
            GOTO 202 ! refresh current limits
          END IF

c     modify mode: adjust lower boundry

          IF (ikey.eq.key_l) then
            action = 1
            CALL getpixel(jtmp,itmp,iorder,action,rtmp,error)
            CALL plotter(ptype,iorder)
            GOTO 55  ! next modify query
          END IF

c     modify mode: adjust upper boundary

          IF (ikey.eq.key_u) then
            action = 2
            CALL getpixel(jtmp,itmp,iorder,action,rtmp,error)
            CALL plotter(ptype,iorder)
            GOTO 55 ! next modify query
          END IF

c     modify mode: no valid entry start over

          WRITE(6,*) ' (EDIT): Invalid Modification Command'
          GOTO 55  ! next modify query

c     modify mode: end block

        END IF


c.........................................................................
c  re Initialize regions and subregion; verify
c.........................................................................

      IF (ikey.eq.key_bigI) then

c     reinitialize: communicate warning

        WRITE(6,*) ' WARNING: you are about to reinitialize all'
        WRITE(6,*) ' regions and subregions.  You will loose all'
        WRITE(6,*) ' edits and modifications.  Verify (y/n)'

c     reinitialize: verify

 82     CALL mgoprompt('Initilize regions/subregion? Verify (y/n) ')
        CALL mongohairs(ikey,xpos,ypos)
        IF ((ikey.ne.key_y).AND.(ikey.ne.key_n)) GOTO 82
        IF (ikey.eq.key_n) GOTO 202  ! refresh current limits

c     reinitialize: we are GO?

        IF (ikey.eq.key_y) THEN
        CALL initregs
        DO 37 j=1,norders
          mkmod(j) = .true.  ! flag that user made all modification     
 37     CONTINUE
        GOTO 202 ! refresh current limits
        END IF

c     reinitilize: end block

      END IF

c.........................................................................
c  relocate subregions (done auto with SUBFEAT) in the current region
c.........................................................................

      IF (ikey.eq.key_l) then

c     relocate: grab region; if we are not in a region; communicate
c     (done in routine GETREGION); on error requery

         rtmp = xpos
         ktmp = 1  ! temporary IORDER
         CALL getregion(jtmp,itmp,ktmp,rtmp,error)
         IF (error) GOTO 203 ! requery only

c     relocate: communicate warning

        WRITE(6,*) ' WARNING: you are about to relocate new'
        WRITE(6,*) ' subregions in region ', jtmp  ! temporary LINEI
        WRITE(6,*) ' for ion/transition ', order(iorder)(1:20)
        WRITE(6,*) ' Verify (y/n)'

c     relocate: verify

 92     CALL mgoprompt('relocate subregions? Verify (y/n) ')
        CALL mongohairs(ikey,xpos,ypos)
        IF ((ikey.ne.key_y).AND.(ikey.ne.key_n)) GOTO 92 ! ask again
        IF (ikey.eq.key_n) GOTO 202  ! refresh current limits

c     relocate: we are GO?

        IF (ikey.eq.key_y) THEN
         nfind(iorder,jtmp) = subfeat(iorder,jtmp)
         mkmod(iorder) = .true.  ! flag that user made all modification     
        GOTO 202 ! top level refresh
        END IF

c     relocate: reinitilize: end block

      END IF

c.........................................................................
c     data spectra plotting; set PTYPE=1
c.........................................................................

       IF (ikey.eq.key_h) then
         ptype = 1
         CALL autoylimits(ptype,iorder)
         GOTO 202  ! refresh new limits
       END IF

c.........................................................................
c     ew spectra plotting; set PTYPE=2
c.........................................................................

       IF (ikey.eq.key_k) then
         ptype = 2
         CALL autoylimits(ptype,iorder)
         GOTO 202  ! refresh new limits
       END IF

c.........................................................................
c     sigma spectra plotting; set PTYPE=3
c.........................................................................

       IF (ikey.eq.key_j) then
         ptype = 3
         CALL autoylimits(ptype,iorder)
         GOTO 202  ! refresh new limits
       END IF

c.........................................................................
c     smsig (or sky) plotting; set PTYPE=4
c.........................................................................

       IF (ikey.eq.key_s) then
         ptype = 4
         CALL autoylimits(ptype,iorder)
         GOTO 202  ! refresh new limits
       END IF

c.........................................................................
c     window mode;
c.........................................................................

      IF (ikey.eq.key_w) then

 72     CALL mgoprompt('Window mode: (a,e,n,r,y,?,q)  ')
        CALL mongohairs(ikey,xpos,ypos)

c     (wa) refresh full window

        IF (ikey.eq.key_a) GOTO 201  ! reset autolimits

c     (we) window in - cursor defined in x

        IF (ikey.eq.key_e) then
           x_lo = xpos
           y_lo = ypos
           CALL mgoprompt('e again:                   ')
           CALL mongohairs(ikey,xpos,ypos)
           x_hi = xpos
           y_hi = ypos
         IF (x_lo.gt.x_hi) then
           rtmp = x_lo
           x_lo = x_hi
           x_hi = rtmp
         END IF
         IF (y_lo.gt.y_hi) then
           rtmp = y_lo
           y_lo = y_hi
           y_hi = rtmp
         END IF
         GOTO 201  ! refresh new limits
        END IF

c     (wn) toggle ON/OFF viewing normalized data

        IF (ikey.eq.key_n) then
         IF (normalize) then
           normalize = .false.
         ELSE
           normalize = .true.
         END IF
         CALL autoylimits(ptype,iorder)
         GOTO 202  ! refresh with new y limits, old x limits
        END IF

c     (wr) toggle ON/OFF viewing of feature regions

        IF (ikey.eq.key_r) then
         IF (show_regions) then
           show_regions = .false.
         ELSE
           show_regions = .true.
         END IF
         GOTO 202  ! refresh current limits
        END IF

c     (w?) help

        IF (ikey.eq.key_questionmark) then
          WRITE(6,*) ' --- window mode cursor control --- '
          WRITE(6,*) ' a - autoscale full window '
          WRITE(6,*) ' e - expand - 1st e lower left '
          WRITE(6,*) '            - 2nd e upper right '
          WRITE(6,*) ' n - toggle ON/OFF view normalized data '
          WRITE(6,*) ' r - toggle ON/OFF line regions '
          WRITE(6,*) ' y - autoscale y axis '
          WRITE(6,*) ' ? - this menu '
          WRITE(6,*) ' q - exit, no action '
          GOTO 72
        END IF

c     (wy) autoset y limits only

        IF (ikey.eq.key_y) then 
          CALL autoylimits(ptype,iorder)
          GOTO 202 ! refresh new limits
        END IF

c     (wq) - bail)

        IF (ikey.eq.key_q) then 
          GOTO 203 ! requery only
        END IF

c     key stroke not trapped; bad entry

        GOTO 72  ! requery window mode input

c     window: end block

      END IF

c.........................................................................
c  need help
c.........................................................................

      IF (ikey.eq.key_questionmark) then
        CALL system('clear')
        WRITE(6,*) '============== CURSOR ACTION KEY ==============='
        WRITE(6,*) '                -- navigation --'
        WRITE(6,*) ' ? - this help menu      Q - quit (save) '
        WRITE(6,*) ' f - forward 1 order     b - back 1 order'
        WRITE(6,*) ' h - view FLUX spectra   s - view ERR/SKY spectra '
        WRITE(6,*) ' k - view EW spectra     j - view SIGMA spectra '
        WRITE(6,*) ' m - enter modify mode   w - enter window mode'
        WRITE(6,*) ' r - refresh plotting window'
        WRITE(6,*) ' '
        WRITE(6,*) '                -- actions --'
        WRITE(6,*) ' a - add region at cursor '
        WRITE(6,*) ' d - delete region or subregion at cursor'
        WRITE(6,*) ' l - locate subregions in region '
        WRITE(6,*) ' R - rescale sigma spectrum (not functional)'
        WRITE(6,*) ' I - (re)initialize the regions and subregions'
        WRITE(6,*) ' p - PostScript plot'
        WRITE(6,*) ' '
        WRITE(6,*) '              -- modify mode --'
        WRITE(6,*) ' l - move lower limit of region (dynamic)'
        WRITE(6,*) ' u - move upper limit of region (dynamic)'
        WRITE(6,*) ' i - insert changes and quit (keep mods) '
        WRITE(6,*) ' f - forget changes and quit (restore) '
        WRITE(6,*) ' ? - modify mode help menu '
        WRITE(6,*) ' q - quit '
        WRITE(6,*) ' '
        WRITE(6,*) '            -- windowing mode --'
        WRITE(6,*) ' a - autoscale full window '
        WRITE(6,*) ' e - set limits - 1st e lower left '
        WRITE(6,*) '                - 2nd e upper right '
        WRITE(6,*) ' n - toggle ON/OFF view normalized data '
        WRITE(6,*) ' r - toggle ON/OFF line regions '
        WRITE(6,*) ' y - autoscale y axis '
        WRITE(6,*) ' ? - window mode help menu '
        WRITE(6,*) ' q - exit, no action '
        WRITE(6,*) ' '
        WRITE(6,*) '              === COLON COMMANDS ==='
        WRITE(6,*) ' :sigma [value]  enter a new sigma level          '  
        WRITE(6,*) 
        GOTO 203  ! top level no refresh
      END IF

c.........................................................................
c  redraw window
c.........................................................................

      IF (ikey.eq.key_r) GOTO 202  ! refresh plot current limits

c.........................................................................
c  make PostScript plot
c.........................................................................

      IF (ikey.eq.key_p) then
 90     CALL mgoprompt('                                       ')
        CALL mgoprompt('PS PLOT: order(current) [current,all,quit] = ')
        CALL mx11gets(ch_tmp)
        IF (ch_tmp.eq.'quit') GOTO 203  ! top level no refresh
        IF ((ch_tmp.eq.' ').OR.(ch_tmp.eq.'current')) then ! do current order
          action = 1
          CALL hardcopy(action,iorder)
          CALL autoylimits(ptype,iorder)
          GOTO 202  ! refresh plot current limits (** critical here **)
        END IF
        IF (ch_tmp.eq.'all') then  ! do all orders
          action = 2
          DO 91 itmp=1,norders
           CALL autoxlimits
           CALL hardcopy(action,itmp)
 91       CONTINUE
          CALL autoxlimits
          CALL autoylimits(ptype,iorder)
          GOTO 202  ! refresh plot current limits (** critical here **)
        END IF
        WRITE(6,*) ' ERROR(search): bad input - try again.'
        GOTO 90
      END IF

c.........................................................................
c     Quit; upon return to the main module, all the data are analyized
c     and the files are written to disk
c.........................................................................

      IF (ikey.eq.key_bigQ) then
        CALL mgoprompt('QUIT: verify (y/n)                ')
        CALL mongohairs(ikey,xpos,ypos)
        IF (ikey.eq.key_y) RETURN
        GOTO 203  ! top level no refresh
      END IF

c.........................................................................
c  RESCALE sigma vector (not functional)
c.........................................................................

C       IF (ikey.eq.key_bigR) then
c         CALL sigscale(ptype,iorder)
c         GOTO 202  ! top level refresh
C       END IF

c.........................................................................
c  missed all traps 
c.........................................................................

      GOTO 202  ! top refresh

c.........................................................................
c     the return occurs in the key_bigQ trap
c.........................................................................

      END

c     eof
