      PROGRAM   ks2driver
c  
      implicit none
      logical           error
      external          cdf_func
      integer           maxdata,nhead
      parameter         (maxdata=500000)
      integer           i,j,ndata1,col1,ncdf
      double precision  x1(maxdata),xcdf(maxdata),ksstat
      double precision  prob,xx,value2,cdf_func
      character*80      file1,outfile,string


c
c  get the command line arguments, which are
c
      CALL getarg(1,string)  
      IF (string.eq.' ') then
       CALL helpline
       STOP '(doksone): comm-line help'
      ELSE
       file1 = string
      END IF
c
      CALL getarg(2,string)
      col1 = value2(string,error)
      IF (error) STOP ' ERROR(doksone): bad $2 on comm-line'
c
      CALL getarg(3,string)
      nhead = int(value2(string,error))
      IF (error) STOP ' ERROR(doksone): bad $3 on comm-line'

c
c  READ in the data files
c

      ndata1 = 0
      OPEN(unit=1,file=file1,ERR=991,status='old')
c read the header rows (if nhead>0)
      DO 09 i=1,nhead
       READ(1,*) string
 09   CONTINUE
c rad the data
      DO 11 i=1,maxdata
       READ(1,*,ERR=993,END=12) (xx,j=1,col1-1),x1(i)
       ndata1 = ndata1 + 1
 11   CONTINUE
 12   CLOSE(unit=1)
      GOTO 21

 991  STOP ' ERROR(doksone): cannot open file'
 993  STOP ' ERROR(doksone): format error in file data'

c
c  sort
c

 21   CALL sort(ndata1,x1)


      ncdf = 0
      DO 31 i=1,ndata1
       ncdf = ncdf + 1
       xcdf(ncdf) = x1(i)
 31   CONTINUE

c
c  call the ksone subroutine
c

      CALL ksone(xcdf,ncdf,cdf_func,ksstat,prob)

      IF (prob.LT.1.e-20) prob= 0.

c
c  now output the results, and include input information
c

c  write results to screen

      WRITE(6,100)
      WRITE(6,101) file1,col1,ncdf,xcdf(1),xcdf(ncdf)
      WRITE(6,102) ksstat,prob


      CALL fappend(file1,'ksone',outfile)
      OPEN(unit=1,file=outfile,status='unknown')
      WRITE(1,100)
      WRITE(1,101) file1,col1,ncdf,xcdf(1),xcdf(ncdf)
      WRITE(1,102) ksstat,prob
      CLOSE(unit=1)

      CALL fappend(file1,'ksone.data',outfile)
      OPEN(unit=2,file=outfile,status='unknown')
      DO 41 i=1,ndata1
        WRITE(2,200) x1(i),xcdf(i),cdf_func(x1(i)) 
 41   CONTINUE
      CLOSE(unit=2)



 100  FORMAT(1x,'*** Kolmogorov-Smirnov Results ***',/,
     @       1x,t15,'file',t25,'xcol',t32,'ndata',
     @       t40,'Xmin',t51,'Xmax')
 101  FORMAT(1x,a20,i5,5x,i5,1pe11.3,1pe11.3)
 102  FORMAT(1x,'-----> KS stat =',1pe11.3,
     @       4x,'P(KS) =',1pe11.3,'  <-----')
 200  FORMAT(1x,3(1pe12.4))

c
      STOP
      END
c
c
c..........................................................................

c     modify this to the file with the CDF that you want

      include  'cdf_PA.f'

c..........................................................................


c..........................................................................
c  
c
c
      SUBROUTINE          helpline
c
c
c..........................................................................
c
      WRITE(6,*) ' Usage: kstwo $1 $2 $3 $4 '
      WRITE(6,*) '  $1  = 1st input file name '
      WRITE(6,*) '  $2  = column the data are in'
      WRITE(6,*) ' [$3] = number of header lines in file'

c
c
      RETURN
      END
c
c..........................................................................
c
c  
c  
      SUBROUTINE          fappend(in_file,delim,out_file)   
c
c  
c  replace the delimeter on infile with delim and output the
c  result in out_file
c  If the infile has no delimeter, then append delim prefixed 
c  with a "." to infile and output the result in out_file
c..........................................................................
c  
      implicit none
      integer             i,k,lend      
      character*(*)       in_file,delim,out_file
c  
       lend = len(in_file)
       k    = 0
       DO 09 i=1,lend
        k = i
        IF ((in_file(i:i).eq.'.').or.(in_file(i:i).eq.' ')) goto 10
 09   CONTINUE
c  
 10   IF (in_file(k:k).eq.'.') out_file= in_file(1:k)//delim
      IF (in_file(k:k).eq.' ') out_file= in_file(1:k-1)//"."//delim
c  
c  normal exit
       RETURN
c  
       END
c  
c  eof   

