c
      PROGRAM cleanspec

c     This program sets the continuum outside detection regions to unity
c     The output spectrum will be normalized

c     Usaage: rebinspec inspec [printflag]
c     to which inspec will be rebinned
c     logical printflag =0 or blank will suprress writing to screen

      implicit none

      include            'rebinspec.h'
      logical            pflag,hit,detected
      integer            i,j,m,nreg,nions,maxions
      parameter          (maxions=50)
      double precision   dum,lambda0
      double precision   vreg1(mxpix),vreg2(mxpix)
      double precision   clnflx(maxions,mxpix)
      character*80       inspec,ewregfile,ionlist
      character*80       header,pfstr,cfstr,ionname(maxions)
      include            'rebinspec.com'
    
      CALL getarg(1,ionlist)   ! spectrum to be rebinned
      CALL getarg(2,pfstr)    ! flag for printing progress to screen

c     check the command line

      IF (inspec.eq."") STOP 'command line ionlist is blank'

c     set the print to screen flag

      pflag = .false.
      IF (pfstr.ne."")  pflag = .true.   ! any character will set it high
      IF (pfstr.eq."0") pflag = .false.  ! but if it is a "0", the reset it low

c     central wavelength needed to determine system redshift

      lambda0 = 0.0d0
      nreg    = 1
   

      OPEN(unit=21,file=ionlist,status='unknown')
      DO i=1,maxions
       READ(21,*,end=22) ionname(i)
      ENDDO
       WRITE(6,*) 'WARNING: ionlist file length exceeded: ',ionlist
 22   CLOSE(unit=21)
      nions = i - 1

      DO 1001 m=1,nions
      inspec = ionname(m)

c
c     open file: the spectrum to be rebinned read in the velocity
c     regions of the absorption and store read in the spectum to be
c     rebinned; normalize if need be; replace flux=1 if outside
c     absorption region any pixel with abs(fluxdec/sigma) >= 3.0 is
c     replace with unity

      CALL fappend(inspec,'ewreg',ewregfile)
      OPEN(unit=4,file=ewregfile,err=994,status='unknown')
      READ(4,*) header
      DO j=1,mxpix
       READ(4,*,end=204) dum,dum,dum,dum,dum,
     &           vreg1(j),vreg2(j),lambda0,detected
      ENDDO
      WRITE(6,*) 'WARNING: file truncated: ',ewregfile
 204  CLOSE(unit=4)
      nreg = j - 1

      OPEN(unit=2,file=inspec,err=992,status='unknown')
      DO i=1,mxpix
       READ(2,*,end=202) wave(i),vel(i),flux(i),sigma(i),
     &                   smsig(i),cont(i) 
       flux(i) = flux(i)/cont(i)
       IF (sigma(i).ne.-1.0) sigma(i) = sigma(i)/cont(i)
       hit = .false.
       IF (detected) then  ! clean only pixels outside the detection regions
        DO j=1,nreg  ! cleaning loop followed by cleaning traps
         IF ((vel(i).ge.vreg1(j)).AND.(vel(i).le.vreg2(j))) hit=.true.  ! inside detection region
        ENDDO
        IF (.not.hit) flux(i) = 1.0d0
        IF ((sigma(i).eq.-1.0).AND.(.not.hit)) flux(i) = 1.0d0  ! bad pixel outside region
        dum = abs(1.0d0-flux(i))/sigma(i)
        IF ((dum.ge.3.0).AND.(.not.hit)) flux(i) = 1.0d0  ! bad pixel outside region
       ELSE  ! not detected, so clean all pixels
        flux(i) = 1.0d0
       ENDIF
      ENDDO
      WRITE(6,*) 'WARNNG: file truncated: ',inspec
 202  CLOSE(unit=2)
      ndata = i - 1

      IF (pflag) then
       WRITE(6,*) 'target spectrum      : ',inspec
       WRITE(6,601) 'npix,vlo,vhi,dv1,dvN : ',ndata,vel(1),vel(ndata),
     &               vel(2)-vel(1),vel(ndata)-vel(ndata-1)
       WRITE(6,*) '-- cleaning is ON'
      ENDIF

c     store the clean flux for this ion

      DO i=1,ndata
        clnflx(m,i) = flux(i)
      ENDDO

 1001 ENDDO


c     output the result

      IF (pflag) WRITE(6,*) 'writing cleanflux.txt output file...'
      OPEN(unit=1,file='cleanflux.txt',err=991,status='unknown')
      DO i=1,ndata
       WRITE(1,300) (clnflx(m,i),m=1,nions)
      ENDDO
      CLOSE(unit=1)

c     we are done

      STOP

c     error traps

 994  WRITE(6,*) 'Cannot open : ',ewregfile
      STOP 'cleanspec terminated with error'
 992  WRITE(6,*) 'Cannot open : ',inspec
      STOP 'cleanspec terminated with error'
 991  WRITE(6,*) 'Cannot open : cleanflux.txt'
      STOP 'cleanspec terminated with error'

 300  FORMAT(1x,50f8.4)
C 300  FORMAT(1x,f11.4,f9.2,1pe12.4,1pe12.4,1pe12.4,1pe12.4,1pe12.4)
 601  FORMAT(1x,a23,i3,4f9.2)
      END

C      include 'bindata.f'

c=======================================================================

      SUBROUTINE fappend(infile,delim,outfile)   


      implicit none
      integer             i,k,lend      
      character*(*)       infile,delim,outfile

      lend = len(infile)
      k    = 0

      DO 09 i=1,lend
        k = i
        IF ((infile(i:i).eq.'.').OR.(infile(i:i).eq.' ')) GOTO 10
 09   CONTINUE

 10   IF (delim.eq.' ') then
       outfile = infile(1:k-1)
      ELSE
       IF (infile(k:k).eq.'.') outfile = infile(1:k)//delim
       IF (infile(k:k).eq.' ') outfile = infile(1:k-1)//"."//delim
      END IF


      RETURN
      END

c=======================================================================
