%%
%% This is file 'cambridge6A.cls'
%% cambridge6A LaTeX2e document class
%%
%% copyright (c) 2010 ali woollatt
%%   generated from cambridge7A.cls 2009/05/13, v1.00
%%
%% Bugs (in the case of unchanged files) should be reported to
%% texline@cambridge.org
%%
%% 2009/09/16, v2.00 includes the following changes:
%%   01 removed space after \LARGE\rm #1 in \makechapterhead and \makeschapterhead
%%   02 changed \oddsidemargin, \evensidemargin, \marginparwidth to 4.5pc
%%   03 added auto-version numbering
%%   04 changed \smallverbatimsize from 8/9 to 9/11
%%
%% 2010/09/09, v2.10 includes the following changes:
%%   01 oddsidemargin changed to 66pt
%%   02 evensidemargin changed to 67pt
%%   03 marginparwidth changed to 61pt
%%   04 topmargin changed to 35pt
%%
%% This software may only be used in the preparation of journal articles
%% or books or parts of books to be published by Cambridge University Press.
%% Any other use constitutes an infringement of copyright.
%%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
%%

\NeedsTeXFormat{LaTeX2e}

\newcommand\version{2010/09/09, v2.10 }
\ProvidesClass{cambridge6A}[\version LaTeX2e document class]

% font sizes for cambridge6A, 247x174mm
% \tiny                        5/6
% \footnotesize                8/9
% \indexsize                   8/9.5
% \large                      11/14
% \Aheadsize                  12/14
% \Large                      12/17
% \LARGE                      16/19 (chaptertitle size)
% \let\Huge\huge              18/24 (chapternumber size)
% \scriptsize                  8/9
% \enotesize                   9/10
% \smallverbatimsize           9/11
% \let\tablesize\small        10/11
% \smallish                   10/12
% \normalsmall                11/13
% \let\listsize\normalsize    11/14

\newif\ifAJW@multisty
%\newif\ifAJW@largesty
\newif\ifAJW@indentsty % false
\newif\ifAJW@landscape
\newif\if@openright
\newif\ifAJW@truesize
\newif\ifchapterrule
\newdimen\AJW@indent
\newdimen\AJW@floatindent
\AJW@indent\z@        % zero
\newif\ifsp@nningrule

\DeclareOption{multi}{\AJW@multistytrue}

%\DeclareOption{cup5a}{\AJW@largestytrue\AJW@indentstytrue\AJW@indent 3pc}
%\DeclareOption{CUP5A}{\@nameuse{ds@cup5a}}
%\DeclareOption{cup5b}{\AJW@multistytrue\AJW@largestytrue
%  \AJW@indentstytrue\AJW@indent 3pc}
%\DeclareOption{CUP5B}{\@nameuse{ds@cup5b}}
%\DeclareOption{cup6a}{\AJW@largestytrue}
%\DeclareOption{CUP6A}{\@nameuse{ds@cup6a}}
%\DeclareOption{cup6b}{\AJW@multistytrue\AJW@largestytrue}
%\DeclareOption{CUP6B}{\@nameuse{ds@cup6b}}
%\DeclareOption{cup7a}{\relax}
%\DeclareOption{CUP7A}{\relax}
%\DeclareOption{cup7b}{\AJW@multistytrue}
%\DeclareOption{CUP7B}{\@nameuse{ds@cup7b}}
%\DeclareOption{cup8a}{\AJW@indentstytrue\AJW@indent 3pc}
%\DeclareOption{CUP8A}{\@nameuse{ds@cup8a}}
%\DeclareOption{cup8b}{\AJW@multistytrue\AJW@indentstytrue\AJW@indent 3pc}
%\DeclareOption{CUP8B}{\@nameuse{ds@cup8b}}
%\DeclareOption{cup9a}{\AJW@indentstytrue\AJW@indent=\z@}
%\DeclareOption{CUP9A}{\@nameuse{ds@cup9a}}
%\DeclareOption{cup9b}{\AJW@multistytrue\AJW@indentstytrue}
%\DeclareOption{CUP9B}{\@nameuse{ds@cup9b}}

\DeclareOption{oneside}{\relax}
\DeclareOption{twoside}{\@twosidetrue \@mparswitchtrue}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{draft}{\setlength\overfullrule{5\p@}}
\DeclareOption{final}{\setlength\overfullrule{\z@}}
\DeclareOption{openright}{\@openrighttrue}
\DeclareOption{openany}{\@openrightfalse}
\DeclareOption{a4paper}
  {\setlength\paperheight {297mm}%
   \setlength\paperwidth  {210mm}}
\DeclareOption{landscape}
  {\setlength\@tempdima   {\paperheight}%
   \setlength\paperheight {\paperwidth}%
   \setlength\paperwidth  {\@tempdima}%
   \AJW@landscapetrue}
\DeclareOption{truesize}{\AJW@truesizetrue}
\DeclareOption{spanningrule}{\sp@nningruletrue}

\ExecuteOptions{a4paper,twoside,onecolumn,final,openright}
\ProcessOptions\relax

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\AtEndOfPackage{\AtBeginDocument{%

% 1. to bring amsthm.sty    into line with cambridge style
% 2. to bring multind.sty   into line with cambridge style
% 3. to bring index.sty     into line with cambridge style
% 4. to bring natbib.sty    into line with cambridge style
% 5. to bring rotating.sty  into line with cambridge style

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 1. to bring amsthm.sty into line with cambridge style
%
% replace period after heading with \enskip
%
\@ifpackageloaded{amsthm}{%
\providecommand\proof{}
\renewenvironment{proof}[1][\proofname]{\par
  \pushQED{\qed}%
% \normalfont \topsep6\p@\@plus6\p@\relax
  \normalfont \topsep0.5\AJW@theskip \@plus 2\p@ \@minus 1\p@\relax
  \trivlist
  \item[\hskip\labelsep
        \itshape
%    #1\@addpunct{.}]\ignorespaces
     #1\enskip]\ignorespaces
}{%
  \popQED\endtrivlist\@endpefalse
}
%
% replace period after heading with \enskip
%
\def\@thm#1#2#3{%
  \ifhmode\unskip\unskip\par\fi
  \normalfont
  \trivlist
  \let\thmheadnl\relax
  \let\thm@swap\@gobble
  \thm@notefont{\fontseries\mddefault\upshape}%
% \thm@headpunct{.}% add period after heading
  \thm@headpunct{\enskip}% add period after heading
  \thm@headsep 5\p@ plus\p@ minus\p@\relax
  \thm@space@setup
  #1% style overrides
  \@topsep \thm@preskip               % used by thm head
  \@topsepadd \thm@postskip           % used by \@endparenv
  \def\@tempa{#2}\ifx\@empty\@tempa
    \def\@tempa{\@oparg{\@begintheorem{#3}{}}[]}%
  \else
    \refstepcounter{#2}%
    \def\@tempa{\@oparg{\@begintheorem{#3}{\csname the#2\endcsname}}[]}%
  \fi
  \@tempa
}}{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 2. to bring multind.sty into line with cambridge style
%      note that an error in multind.sty will stop verbatim environment
%      working; also everything will come out \indexsize
%      to correct this, we've added an extra set of parens
%
% change chapter opening
%
\@ifpackageloaded{multind}{%
  \def\printindex#1#2{{\@restonecoltrue
    \if@twocolumn\@restonecolfalse\fi
    \columnseprule\z@
    \columnsep 1pc%
    \twocolumn[\vspace*{10\p@}\mbox{}\par\@makeschapterhead{#2}]%
    \@mkboth{#2}{#2}%\markright{\uppercase{#2}}
    \typeout{#2}%
    \addcontentsline{toc}{schapter}{#2}%
    \thispagestyle{plain}
    \indexsize\raggedright
    \parindent\z@
    \parskip\z@ \@plus.3\p@\relax
    \let\item=\@idxitem
    \@input{#1.ind}}}
%
  \def\@idxitem{\par\hangindent 2em}
  \def\subitem{\par\hangindent 3em \hspace*{1em}}
  \def\subsubitem{\par\hangindent 4em \hspace*{2em}}
  \def\indexspace{\par \vskip 3\p@ \@plus 1\p@ \@minus 1\p@\relax}}{}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 3. to bring index.sty into line with cambridge style
%
\@ifpackageloaded{index}{%
  \renewenvironment{theindex}{%
    \edef\indexname{\the\@nameuse{idxtitle@\@indextype}}%
    \if@twocolumn
      \@restonecolfalse
    \else
      \@restonecoltrue
    \fi
    \columnseprule \z@
    \columnsep 1pc
    %\twocolumn[\@makeschapterhead{\indexname}%
    \twocolumn[\vspace*{10\p@}\mbox{}\par\@makeschapterhead{\indexname}
    \ifx\index@prologue\@empty\else
      \index@prologue
      \bigskip
    \fi
  ]%
    % \@mkboth{\MakeUppercase\indexname}%
    % {\MakeUppercase\indexname}%
  \@mkboth{\indexname}%
  {\indexname}%
  \ifAJW@indentsty
    \ifdim\AJW@indent>\z@
      \addcontentsline{toc}{schapter}{\protect\numberline{\mbox{}}\indexname}
    \else
      \addcontentsline{toc}{schapter}{\indexname}
    \fi
  \else
    \addcontentsline{toc}{schapter}{\indexname}
  \fi
  \thispagestyle{plain}%
  \indexsize\raggedright
  \parindent\z@
  \parskip\z@ \@plus .3\p@\relax
  \let\item\@idxitem
  }{%
  \if@restonecol
    \onecolumn
  \else
    \clearpage
  \fi
  }}%
{}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 4. to bring natbib.sty into line with cambridge style
%    and make 'References' the default
%
\@ifpackageloaded{natbib}{%
\providecommand\refname{References}
\providecommand\bibname{Bibliography}

\ifAJW@multisty
  \def\NAT@sectionbib{on}% natbib will use \section* headings
\fi

\setlength\bibhang{2em}
\renewenvironment{thebibliography}[1]{%
% \bibsection\parindent \z@\bibpreamble\bibfont\list
  \bibsection\parindent \z@\bibpreamble\small\list
   {\@biblabel{\arabic{NAT@ctr}}}{\@bibsetup{#1}%
    \setcounter{NAT@ctr}{0}}%
    \ifNAT@openbib
      \renewcommand\newblock{\par}
    \else
      \renewcommand\newblock{\hskip .11em \@plus.33em \@minus.07em}%
    \fi
    \sloppy\clubpenalty4000\widowpenalty4000
    \sfcode`\.=1000\relax
    \let\citeN\cite \let\shortcite\cite
    \let\citeasnoun\cite
 }{\def\@noitemerr{%
  \PackageWarning{natbib}
     {Empty `thebibliography' environment}}%
  \endlist\vskip-\lastskip}


\ifAJW@multisty
  \renewcommand\bibsection{\section*{\refname
    %\ifx\@mkboth\@gobbletwo\else\markright{\refname}\fi
    }}%
\else
  \renewcommand\bibsection{\chapter*{\refname
    %\@mkboth{\refname}{\refname}
    }}%
\fi}{}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 5. to bring rotating.sty into line with cambridge style
%
%
% \rotFPtop        \rotFPbot          Effect
% 0pt plus 1fil    0pt plus 1fil      figure/table appears in middle (default value)
% 0pt              0pt plus 1fil      figure/table appears with its top nearest the edge of the page
% 0pt plus 1fil    0pt plus 2fil      figure/tables bottom appears twice as far from the edge as the top does

\@ifpackageloaded{rotating}{%
  \let\@makecaption=\make@table@caption
  \def\sidewaystable{\@rotfloat{table}\small}%
  \renewenvironment{sidewaystable*}%
    {\@rotdblfloat{table}\small}%
    {\end@rotdblfloat}%
  \rotFPtop 0pt plus 1fil%
  \rotFPbot 0pt plus 1fil%
  }%
  {}%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
}}% end of \AtEndOfPackage section
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  \newcommand\cls@pttxt[1]{\typeout{cambridge6A.cls, [multi] option}}
% \newcommand\CUP@five{\ifAJW@multisty \cls@pttxt{5b}\else \cls@pttxt{5a}\fi}
  \newcommand\CUP@six{\ifAJW@multisty \cls@pttxt{cambridge6B}\fi}
% \newcommand\CUP@seven{\ifAJW@multisty \cls@pttxt{cambridge7B}\fi}
% \newcommand\CUP@eight{\ifAJW@multisty \cls@pttxt{8b}\else \cls@pttxt{8a}\fi}
% \newcommand\CUP@nine{\ifAJW@multisty \cls@pttxt{9b}\else \cls@pttxt{9a}\fi}

% \ifAJW@largesty
% \ifAJW@indentsty \CUP@five\else
    \CUP@six
% \fi
% \else
% \ifAJW@indentsty {\ifdim\AJW@indent=\z@ \CUP@nine\else \CUP@eight\fi}%
% \else
%   \CUP@seven
% \fi
% \fi

\newif\if@mainmatter \@mainmattertrue
\newcommand\frontmatter{\cleardoublepage
            \@mainmatterfalse\pagenumbering{roman}}
\newcommand\mainmatter{\cleardoublepage
       \@mainmattertrue\pagenumbering{arabic}}
\newcommand\backmatter{\if@openright\cleardoublepage\else\clearpage\fi
      \@mainmatterfalse}

%  ****************************************
%  *               FONTS                  *
%  ****************************************
%
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\newskip\AJW@baseskip
\newskip\AJW@theskip
\def\AJW@setskips#1{\AJW@theskip #1\relax%
  \abovedisplayskip      0.50\AJW@theskip \@plus 0.25\AJW@theskip \@minus 1\p@%
  \belowdisplayskip      \abovedisplayskip
  \abovedisplayshortskip 0.25\AJW@theskip \@plus 0.25\AJW@theskip
  \belowdisplayshortskip 0.50\AJW@theskip \@plus 0.25\AJW@theskip \@minus 1\p@%
}
\def\AJW@setlists#1{\AJW@theskip #1\relax%
 \def\@listi{\leftmargin\leftmargini
  \topsep  0.5\AJW@theskip \@plus 2\p@ \@minus 1\p@%
  \parsep  \z@
  \itemsep \z@}}
%
%
% common sizes
\newcommand{\@xvipt}{16}%                     16pt size
\DeclareMathSizes{\@xvipt}{\@xvipt}{\@xiipt}{\@xpt}
\newcommand{\@xviiipt}{18}%                   18pt size
\DeclareMathSizes{\@xviiipt}{\@xviiipt}{\@xiipt}{\@xpt}

\newcommand\tiny{\@setfontsize\tiny\@vpt{6}\AJW@setskips\AJW@setlists}
\newcommand\footnotesize{\AJW@baseskip 9pt%
  \@setfontsize\footnotesize\@viiipt{9}\AJW@setskips\AJW@setlists}
\newcommand\indexsize{\AJW@baseskip 9.5pt%
  \@setfontsize\indexsize\@viiipt{9.5}\AJW@setskips\AJW@setlists}
\newcommand\large{\@setfontsize\large\@xipt{14}\AJW@setskips\AJW@setlists}
\newcommand\Aheadsize{\@setfontsize\Aheadsize\@xiipt{14}\AJW@setskips\AJW@setlists}
\newcommand\Large{\@setfontsize\Large\@xiipt{17}\AJW@setskips\AJW@setlists}
\newcommand\LARGE{\@setfontsize\LARGE\@xvipt{19}\AJW@setskips\AJW@setlists}
\newcommand\huge{\@setfontsize\huge\@xviiipt{24}\AJW@setskips\AJW@setlists}
\let\Huge\huge

%\ifAJW@largesty
  \newcommand\scriptsize{%
    \@setfontsize\scriptsize\@viiipt{9}\AJW@setskips\AJW@setlists}
  \newcommand\enotesize{\AJW@baseskip 10pt%
    \@setfontsize\enotesize\@ixpt{10}\AJW@setskips\AJW@setlists}
  \newcommand\smallverbatimsize{\AJW@baseskip 11pt%
    \@setfontsize\smallverbatimsize\@ixpt{11}\AJW@setskips\AJW@setlists}
  \newcommand\small{\AJW@baseskip 11pt%
    \@setfontsize\small\@xpt{11}\AJW@setskips\AJW@setlists}
  \let\tablesize\small
  \newcommand\smallish{\AJW@baseskip 12pt%
    \@setfontsize\smallish\@xpt{12}\AJW@setskips\AJW@setlists}
  \newcommand\normalsmall{\AJW@baseskip 13pt%
    \@setfontsize\normalsmall\@xipt{13}\AJW@setskips\AJW@setlists}
  \renewcommand\normalsize{\AJW@baseskip 14pt%
    \@setfontsize\normalsize\@xipt{14}\AJW@setskips{\AJW@baseskip}%
    \let\@listi\@listI}
%\else
%  \newcommand\scriptsize{%
%    \@setfontsize\scriptsize\@viipt{8}\AJW@setskips\AJW@setlists}
%  \newcommand\small{\AJW@baseskip 10pt%
%    \@setfontsize\small\@ixpt{10}\AJW@setskips\AJW@setlists}
%  \let\tablesize\small
%  \let\enotesize\small
%  \newcommand\smallish{\AJW@baseskip 11pt%
%    \@setfontsize\smallish\@ixpt{11}\AJW@setskips\AJW@setlists}
%  \newcommand\normalsmall{\AJW@baseskip 12pt%
%    \@setfontsize\normalsmall\@xpt{12}\AJW@setskips\AJW@setlists}
%  \renewcommand\normalsize{\AJW@baseskip 13pt%
%    \@setfontsize\normalsize\@xpt{13}\AJW@setskips{\AJW@baseskip}%
%    \let\@listi\@listI}
  \let\listsize\normalsize
%\fi
\normalsize

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch{\relax}{\mathcal}}
\DeclareRobustCommand*\mit{\@fontswitch{\relax}{\mathnormal}}


\begingroup \catcode `|=0 \catcode `[= 1
\catcode`]=2 \catcode `\{=12 \catcode `\}=12
\catcode`\\=12 |gdef|@xsmallverbatim#1\end{smallverbatim}[#1|end[smallverbatim]]
|gdef|@sxsmallverbatim#1\end{smallverbatim*}[#1|end[smallverbatim*]]
|endgroup


\def\@smallverbatim{\trivlist \item\relax
  \if@minipage\else\vskip\parskip\fi
  \leftskip\@totalleftmargin\rightskip\z@skip
  \parindent\z@\parfillskip\@flushglue\parskip\z@skip
  \@@par
  \@tempswafalse
  \def\par{%
    \if@tempswa
      \leavevmode \null \@@par\penalty\interlinepenalty
    \else
      \@tempswatrue
      \ifhmode\@@par\penalty\interlinepenalty\fi
    \fi}%
  \let\do\@makeother \dospecials
  \obeylines \smallverbatim@font \@noligs
  \hyphenchar\font\m@ne
  \everypar \expandafter{\the\everypar \unpenalty}%
}
\def\smallverbatim{\@smallverbatim \frenchspacing\@vobeyspaces \@xsmallverbatim}
\def\endsmallverbatim{\if@newlist \leavevmode\fi\endtrivlist}

\def\smallverbatim@font{\normalfont\smallverbatimsize\ttfamily}


%  ****************************************
%  *            PAGE LAYOUT               *
%  ****************************************
%
% All margin dimensions measured from a point one inch from top and side
% of page.
%
% SIDE MARGINS:
%
  \setlength\oddsidemargin{66pt}
  \setlength\evensidemargin{67pt}
  \setlength\marginparwidth{61pt}%67pt minus \marginparsep
  \setlength\marginparsep{6pt}
%\ifAJW@largesty
%  \setlength\topmargin{34\p@}
%  \setlength\headheight{14\p@}
% %% \setlength\footheight{14\p@}
%  \setlength\footskip{28\p@}
%  \setlength\topskip{11\p@}
%\else
  \setlength\topmargin{35\p@}
  \setlength\headheight{13\p@}
%%  \setlength\footheight{13\p@}
  \setlength\footskip{26\p@}
  \setlength\topskip{10\p@}
%\fi
  \setlength\headsep{11\p@}
%
% DIMENSION OF TEXT:
%
\newdimen\AJW@measure
\setlength\textheight{39\baselineskip}
\addtolength\textheight{\topskip}

%\ifAJW@largesty
   \AJW@measure 30pc
%\else
%  \AJW@measure 26pc
%\fi
\textwidth\AJW@measure
\ifAJW@landscape
  \textwidth\textheight
  \textheight\AJW@measure
\fi
\setlength\columnsep{1pc}
\setlength\columnseprule{0\p@}
%
% FOOTNOTES
%
\setlength\footnotesep{6.5\p@}
\setlength{\skip\footins}{9\p@ \@plus 4\p@ \@minus 2\p@}% top of first footnote.



%
% FLOATS
%
\setlength\floatsep{13\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep{13\p@ \@plus 2\p@ \@minus 2\p@}
%%\setlength\@maxsep{20\p@}
\setlength\dblfloatsep{13\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
%%\setlength\@dblmaxsep{20\p@}
%
% for floats on a separate float page
\setlength\@fptop{0\p@ \@plus 1fil}
\setlength\@fpsep{13\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}

%
%   wide floats
\setlength\@dblfptop{0\p@ \@plus 0fil}
\setlength\@dblfpsep{13\p@ \@plus 0fil}
\setlength\@dblfpbot{0\p@ \@plus 3fil}
%
%
% MARGINAL NOTES:
%
\setlength\marginparpush{5\p@}

%  ****************************************
%  *           PARAGRAPHING               *
%  ****************************************
%
\setlength\parskip{0\p@ \@plus .25\p@}
\setlength\parindent{1em}
\listparindent\parindent
\setlength\partopsep{0\p@ \@plus 1\p@}
%
% The following page-breaking penalties are defined
%
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
%
  \clubpenalty=0       % 'Club line'  at bottom of page.
  \widowpenalty=10000  % 'Widow line' at top of page.
% \displaywidowpenalty % Math display widow line.
% \predisplaypenalty   % Breaking before a math display.
% \postdisplaypenalty  % Breaking after a math display.
% \interlinepenalty    % Breaking at a line within a paragraph.
% \brokenpenalty       % Breaking after a hyphenated line.

%    ****************************************
%    *        CHAPTERS AND SECTIONS         *
%    ****************************************
%
% Heading for the \chapter command -- fixed depth chapter headings...
%
\newdimen\AJW@headwidth
\AJW@headwidth \textwidth
\addtolength{\AJW@headwidth}{-\AJW@indent}

\newif\ifAJW@appendix
\newif\ifAJW@oneappendix

\newcommand\chapterauthor[1]{%
  \ifAJW@multisty
    \def\@chapterauthor{}%
  \else
    \def\@chapterauthor{#1}%
  \fi
}

\edef\@chapterauthor{\relax}

\newcommand\ch@pterauthor[1]{%
  \gdef\@ch@pterauthor{#1}}

\gdef\@ch@pterauthor{%
  \vbox to0pt{%
  \vspace*{-7pt}
  \parbox[t]{\textwidth}{\normalfont\normalsize%\baselineskip 13\p@
  \centering\@chapterauthor
  }%
  \vss}%
}

\def\@makechapterhead#1{%
  {\normalsize
  \parindent 0\p@
  \vspace*{-0.5\baselineskip}
  \ifnum \c@secnumdepth >\m@ne
   \raisebox{0.5\baselineskip}[0\p@][0\p@]{\mbox{\hspace*{\AJW@indent}}%
    \begin{minipage}[t]{\AJW@headwidth}
     \ifAJW@indentsty \raggedright \else \centering \fi
     \ifAJW@oneappendix
       {\huge \appendixname}%
     \else
       \ifAJW@appendix
         {\huge \appendixname\ \thechapter}%
       \else
       {\huge\bfseries \thechapter}%
       \fi
     \fi
     \par
     %\ifAJW@largesty \vskip 9\p@ \else
     %\vskip 7\p@
        \ifsp@nningrule
          \vskip 1\p@
          \rule{\textwidth}{0.4pt}\par
          \vskip 6pt
        \else
 %        \vskip 7\p@
          \vskip 9\p@
        \fi
     %\fi
     \LARGE\rm #1%
     \nobreak
     \par
     \ifAJW@multisty
      \vskip 7\p@
      \normalsize
      \ifAJW@indentsty \begin{author@tabular}[t]{@{}l@{}}
                 \else \begin{author@tabular}[t]{c}
      \fi
        \@author
      \end{author@tabular}
      \par
     \fi
     \@ch@pterauthor
    \end{minipage}%
    }
  \else
   \raisebox{0.5\baselineskip}[0\p@][0\p@]{\mbox{\hspace*{\AJW@indent}}%
    \begin{minipage}[t]{\AJW@headwidth}
     \ifAJW@indentsty \raggedright \else \centering \fi
     {\huge\bfseries \mbox{}}
     \par
     %\ifAJW@largesty \vskip 9\p@ \else
     %\vskip 7\p@
        \ifsp@nningrule
          \vskip 1\p@
          \rule{\textwidth}{0.4pt}\par
          \vskip 6pt
        \else
 %        \vskip 7\p@
          \vskip 9\p@
        \fi
     %\fi
     \LARGE\rm #1%
     \nobreak
     \par
    \@ch@pterauthor
    \end{minipage}}
  \fi
  \par \nobreak
  \vskip 10.5\baselineskip% 2.5 less than the first line of text
  }
  \chapterauthor{\relax}%
}

\def\@makeschapterhead#1{{\normalsize
  \parindent 0\p@
  \vspace*{-0.5\baselineskip}
  \raisebox{0.5\baselineskip}[0\p@][0\p@]{\mbox{\hspace*{\AJW@indent}}%
   \begin{minipage}[t]{\AJW@headwidth}
    \ifAJW@indentsty \raggedright \else \centering \fi
    {\huge\bfseries \mbox{}}
    \par
    %\ifAJW@largesty \vskip 9\p@ \else
    %\vskip 7\p@
       \ifsp@nningrule
         \vskip 1\p@
         \rule{\textwidth}{0.4pt}\par
         \vskip 6pt
       \else
 %       \vskip 7\p@
         \vskip 9\p@
       \fi
    %\fi
    \LARGE\rm #1%
    \nobreak
    \par
    \@ch@pterauthor
   \end{minipage}}
  \par \nobreak
  \vskip 10.5\baselineskip % 2.5 less than the first line of text
  }\chapterauthor{\relax}%
}
%
% \secdef{UNSTARCMDS}{STARCMDS} :
%

\newcount\apptmp
\def\chapter{%
   %\c@chapter=\apptmp
   %\stepcounter{chapter}
   \endappendix% in case previous chapter contained appendices
   \clearpage
   \thispagestyle{plain}
   \global\@topnum\z@
   \@afterindentfalse
   \secdef\@chapter\@schapter}
\def\@chapter[#1]#2{%
  \ifnum \c@secnumdepth >\m@ne
    \refstepcounter{chapter}
    \typeout{\@chapapp\space\thechapter.}
    \ifAJW@multisty
      \ifx\@shortauthor\@empty
%
% this code just added
      \ifAJW@oneappendix
        \addcontentsline{toc}{chapter}{\protect\AJW@nonumberline{}#1}
      \else
        \ifAJW@appendix
          \addcontentsline{toc}{chapter}{\protect\AJW@numberline{\thechapter}#1}
        \else
          \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#1}
        \fi
      \fi
%
%
%%%%%%%%%\addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#1}
      \else
        \addcontentsline{toc}{chapter}{\protect
        \numberline{\thechapter}#2\hspace{1em}{\itshape \@shortauthor\/}}% #1 changed to #2
                                                                         % so long version of chapter title
                                                                         % appears in toc
      \fi
    \else %if single-author
      \ifAJW@oneappendix
        \addcontentsline{toc}{chapter}{\protect\AJW@nonumberline{}#1}
      \else
        \ifAJW@appendix
          \addcontentsline{toc}{chapter}{\protect\AJW@numberline{\thechapter}#1}
        \else
          \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#1}
        \fi
      \fi
    \fi
  \else
   \addcontentsline{toc}{chapter}{#1}
  \fi
  \ifAJW@multisty
   \markboth{\@shortauthor}{#1}
   \gdef\AJW@endnotehead{\relax}
  \else
   \chaptermark{#1}
   \gdef\AJW@endnotehead{\@chapapp\ \thechapter}
  \fi
  \if@twocolumn
    \@topnewpage[\@makechapterhead{#2}]
   \else
    \@makechapterhead{#2}
    \@afterheading
  \fi
  \ifAJW@multisty
   \gdef\@author{}
   \gdef\@shortauthor{}
  \fi
}
\def\@schapter#1{%
 \ifAJW@addtoc
  \ifAJW@indentsty
   \ifdim\AJW@indent>\z@
    \addcontentsline{toc}{schapter}{\protect\numberline{\mbox{}}#1}
   \else
    \addcontentsline{toc}{schapter}{#1}
   \fi
  \else
   \addcontentsline{toc}{schapter}{#1}
  \fi
 \fi
 \ifAJW@multisty
  \markboth{#1}{#1}
  \gdef\AJW@endnotehead{\relax}
 \else
  \chaptermark{#1}
  \gdef\AJW@endnotehead{#1}
 \fi
 \if@twocolumn
  \@topnewpage[\@makeschapterhead{#1}]
 \else
  \@makeschapterhead{#1}
  \@afterheading
 \fi
 \normalsize
}

%
% \@startsection {NAME}{LEVEL}{INDENT}{BEFORESKIP}{AFTERSKIP}{STYLE}
%            optional * [ALTHEADING]{HEADING}
%
\ifAJW@indentsty
 \def\section{\@startsection {section}{1}{\AJW@indent}
  {-23\p@ \@plus-6\p@ \@minus-3\p@}{5\p@}{\normalsize\bfseries\AJW@hangraggedright}}
 \def\subsection{\@startsection{subsection}{2}{\AJW@indent}
  {-23\p@ \@plus-6\p@ \@minus-3\p@}{5\p@}{\normalsize\itshape\bfseries\AJW@hangraggedright}}
 \def\subsubsection{\@startsection{subsubsection}{3}{\AJW@indent}
  {-11\p@ \@plus-5\p@ \@minus-2.5\p@}{3\p@}{\normalsize\itshape\AJW@hangraggedright}}
 \def\paragraph{\@startsection{paragraph}{4}{\AJW@indent}
  {14\p@ \@plus6\p@ \@minus3\p@}{-0.5em}{\normalsize\itshape\AJW@raggedright}}
 \def\subparagraph{\@startsection{subparagraph}{5}{\AJW@indent}
  {14\p@ \@plus6\p@ \@minus3\p@}{-0.5em}{\normalsize\itshape\AJW@raggedright}}
\else
 \def\section{\@startsection {section}{1}{\z@}
  {-23\p@ \@plus-6\p@ \@minus-3\p@}{5\p@}{\normalsize\bfseries\centering}}
 \def\subsection{\@startsection{subsection}{2}{\z@}
  {-23\p@ \@plus-6\p@ \@minus-3\p@}{5\p@}{\normalsize\itshape\bfseries\centering}}
 \def\subsubsection{\@startsection{subsubsection}{3}{\z@}
  {-11\p@ \@plus-5\p@ \@minus-2.5\p@}{3\p@}{\normalsize\itshape\centering}}
 \def\paragraph{\@startsection{paragraph}{4}{\z@}
  {14\p@ \@plus6\p@ \@minus3\p@}{-0.5em}{\normalsize\itshape}}
 \def\subparagraph{\@startsection{subparagraph}{5}{\parindent}
  {14\p@ \@plus6\p@ \@minus3\p@}{-0.5em}{\normalsize\itshape}}
\fi
\def\AJW@hangraggedright{\rightskip\@flushglue \let\\=\newline}
\def\AJW@raggedright{\rightskip\@flushglue \let\\=\@centercr
 \parindent=\AJW@indent}
%
% Default initializations of \...mark commands
%
%\def\chaptermark#1{}
\newcommand*\chaptermark[1]{}
\setcounter{secnumdepth}{2}

%
% APPENDIX
%

\ifAJW@multisty
%
  \def\appendix{%
    \apptmp=\c@chapter %save chapter number
    \par
    \AJW@appendixtrue
    \def\section{\@startsection {section}{1}{\z@}
      {-30\p@ \@plus-7\p@ \@minus-3.5\p@}{8\p@}{\Aheadsize\bfseries\centering Appendix~}}
    \setcounter{section}{0}
    \@addtoreset{figure}{subsection}
    \setcounter{figure}{0}
    \setcounter{table}{0}
% set tocdepth to chapter heads only whether multi-author or single-author
    %\addtocontents{toc}{\protect\setcounter{tocdepth}{1}}
    \def\@chapapp{\appendixname}
    \def\thechapter {\Alph{chapter}}
    \def\thesection {\Alph{section}}
    \def\thesubsection {\Alph{section}.\arabic{subsection}}
    \def\thetable   {\Alph{section}.\@arabic\c@table}
    \def\thefigure  {\Alph{section}.\@arabic\c@figure}
    \def\theequation{\Alph{section}.\arabic{equation}}
}

% and only one appendix
  \def\oneappendix{\AJW@oneappendixtrue\appendix
    \def\thesection {}% remove the 'A' from Appendix heading
  }
\else
%
% single version
\def\appendix{\par\clearpage
 \AJW@appendixtrue
 \setcounter{chapter}{0}
 \setcounter{section}{0}
% set tocdepth to chapter heads only whether multi-author or single-author
 \addtocontents{toc}{\protect\setcounter{tocdepth}{0}}
 \def\@chapapp{\appendixname}
 \def\thechapter {\Alph{chapter}}
 \def\thesection {\thechapter.\arabic{section}}
 \def\thetable   {\thechapter.\@arabic\c@table}
 \def\thefigure  {\thechapter.\@arabic\c@figure}
 \def\theequation{\thechapter.\arabic{equation}}
}
%
% and only one appendix
    \def\oneappendix{\AJW@oneappendixtrue\appendix}
\fi


%%%%%%%%%%%%%%%%%%%%%%
\ifAJW@multisty
  \def\endappendix{\AJW@appendixfalse
    \def\section{\@startsection {section}{1}{\z@}
      {-30\p@ \@plus-7\p@ \@minus-3.5\p@}{8\p@}{\Aheadsize\bfseries\centering}}
    \def\thechapter {\arabic{chapter}}
    \def\thesection {\thechapter.\arabic{section}}
    \def\thesubsection {\thesection.\arabic{subsection}}
    \def\thetable{\thechapter.\@arabic\c@table}
    \def\thefigure{\thechapter.\@arabic\c@figure}
    \def\theequation{\arabic{chapter}.\arabic{equation}}%
  }
\else
  \def\endappendix{\relax}
\fi

%    ****************************************
%    *                LISTS                 *
%    ****************************************
%
\ifAJW@indentsty
 \ifdim \AJW@indent=\z@ \setlength\leftmargini{1em}
  \else \setlength\leftmargini{\AJW@indent}
 \fi \else \setlength\leftmargini{1em}
\fi
\setlength\leftmarginii{1em}
\setlength\leftmarginiii{1em}
\setlength\leftmarginiv{1em}
\setlength\leftmarginv{1em}
\setlength\leftmarginvi{1em}
\leftmargin\leftmargini
\setlength\labelsep{0.5em}
\labelwidth\leftmargini \advance\labelwidth-\labelsep
\def\@listI{\leftmargin\leftmargini
 \parsep    \z@ \@plus 2\p@
 \partopsep \z@ \@plus 1\p@
 \topsep  6.5\p@ \@plus 3.25\p@ \@minus 1\p@%
 \itemsep   \z@ \@plus.1\p@
 \listparindent \parindent
}
\let\@listi\@listI
\@listi
\def\@listii{\leftmargin\leftmarginii
 \labelwidth\leftmarginii \advance\labelwidth-\labelsep
 \parsep    \z@ \@plus 2\p@
 \partopsep \z@ \@plus 1\p@
 \topsep 3.25\p@ \@plus .5\p@ \@minus 1\p@%
 \itemsep   \z@ \@plus.1\p@
}
\def\@listiii{\leftmargin\leftmarginiii
 \labelwidth\leftmarginiii \advance\labelwidth-\labelsep
 \parsep    \z@ \@plus 2\p@
 \partopsep \z@ \@plus 1\p@
 \topsep 3.25\p@ \@plus .5\p@ \@minus 1\p@%
 \itemsep   \z@ \@plus.1\p@
}
\def\@listiv{\leftmargin\leftmarginiv
 \labelwidth\leftmarginiv \advance\labelwidth-\labelsep}
\def\@listv{\leftmargin\leftmarginv
 \labelwidth\leftmarginv  \advance\labelwidth-\labelsep}
\def\@listvi{\leftmargin\leftmarginvi
 \labelwidth\leftmarginvi \advance\labelwidth-\labelsep}

%    ****************************************
%    *           LIST ENVIRONMENTS          *
%    ****************************************
%
%
% ENUMERATE -- with optional argument to set left margin
% DEFAULT is arabic numbering with full point

\def\makeRRlabel#1{\hss\llap{#1}}
\def\makeRRlabeldot#1{\hss\llap{#1.}}

\newbox\@dotbox
\setbox\@dotbox\hbox{.}%
\def\enumerate{\ifnum \@enumdepth >3 \@toodeep \else
  \advance\@enumdepth \@ne
  \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
 \fi
 \@ifnextchar [{\@enumeratetwo}{\@enumerateone}%
}
\def\@enumeratetwo[#1]{%
 \list{\csname label\@enumctr\endcsname}%
  {\settowidth\labelwidth{#1}%
   \leftmargin\labelwidth \advance\leftmargin\labelsep
   \usecounter{\@enumctr}%
   \let\makelabel\makeRRlabel}%
}
\def\@enumerateone{%\listsize
 \list{\csname label\@enumctr\endcsname}%
  {\usecounter{\@enumctr}%
   \ifAJW@indentsty
    \ifdim \AJW@indent=\z@ \leftmargin 1em % overrides \leftmargini,ii,iii...
                 \fi \else %\leftmargin 1em
                           \leftmargin 0.5em% width of a digit
                           \advance\leftmargin\labelsep
                           \advance\leftmargin\wd\@dotbox
   \fi
   \let\makelabel\makeRRlabeldot}}

\newcommand\labelenumi{\theenumi}
\newcommand\labelenumii{\theenumii}
\newcommand\labelenumiii{\theenumiii}
\newcommand\labelenumiv{\theenumiv}

\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
%
% ITEMIZE
%
\def\itemize{\ifnum \@itemdepth >3 \@toodeep \else
  \advance\@itemdepth \@ne
  \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
%  \listsize
  \list{\csname\@itemitem\endcsname}%
   {\def\makelabel##1{\hss\llap{##1}}}
 \fi
}
\newcommand\labelitemi{$\bullet$}
\newcommand\labelitemii{\bfseries --}
\newcommand\labelitemiii{$\circ$}
\newcommand\labelitemiv{$\diamond$}
%
% DESCRIPTION
%
\newcommand*\descriptionlabel[1]{\hspace\labelsep\bfseries #1}
\def\description{%\listsize
 \list{}{\labelwidth\z@
  \leftmargin 3pc
  \itemindent-\leftmargin
  \let\makelabel\descriptionlabel
 }}
\let\enddescription\endlist
%

%    ****************************************
%    *         OTHER ENVIRONMENTS           *
%    ****************************************
%
% VERSE
%
\def\verse{\let\\=\@centercr
  \list{}{\itemsep\z@ \itemindent -1em\listparindent \itemindent
          \rightmargin\z@
          \leftmargin\AJW@indent\advance\leftmargin 1em}\item[]\smallish}
\let\endverse=\endlist
%
% QUOTATION
%
\def\quotation{\list{}{\leftmargin\AJW@indent\rightmargin\z@}\item[]\smallish}
\let\endquotation=\endlist
%
% QUOTE
%
\def\quote{\list{}{\leftmargin\AJW@indent \rightmargin\z@}\item[]\smallish}
\let\endquote=\endlist
%
% INDENTED (for use in title pages)
%
\def\indented{\list{}{\leftmargin\AJW@indent
 \listparindent\z@\rightmargin\z@}\raggedright\item[]}
\let\endindented=\endlist
%
% ARRAY AND TABULAR
%
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.5\p@}
\setlength\doublerulesep{2\p@}
%
% TABBING
%
\tabbingsep\labelsep
%
% FRAMEBOX
%
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.5\p@}
%

% THEOREM
%
% let theorems be handled by amsthm.sty
%
% PROOFs
%
% let proofs be handled by amsthm.sty

\newenvironment{proof*}[1][\proofname]{\par
  \pushQED{}%{\qed}%
  \normalfont \topsep6\p@\@plus6\p@\relax
  \trivlist
  \item[\hskip\labelsep
        \itshape
    #1\@addpunct{\enskip}]\ignorespaces
}{%
  \popQED\endtrivlist\@endpefalse
}

%    ****************************************
%    *        CHAPTERS AND SECTIONS         *
%    ****************************************
%
% DEFINE COUNTERS:
%
\newcounter {part}
\newcounter {chapter}
\newcounter {section}[chapter]
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
%\renewcommand \thepart {\Roman{part}}
 \renewcommand \thepart {%
        \ifnum\c@part=1 ONE%
   \else\ifnum\c@part=2 TWO%
   \else\ifnum\c@part=3 THREE%
   \else\ifnum\c@part=4 FOUR%
   \else\ifnum\c@part=5 FIVE%
   \else\ifnum\c@part=6 SIX%
   \else\ifnum\c@part=7 SEVEN%
   \else\ifnum\c@part=8 EIGHT%
   \else\ifnum\c@part=9 NINE%
   \else *\fi\fi\fi\fi\fi\fi\fi\fi\fi\relax}

\def\thechapter       {\arabic{chapter}}
\def\thesection       {\thechapter.\arabic{section}}
\def\thesubsection    {\thesection.\arabic{subsection}}
\def\thesubsubsection {\thesubsection .\arabic{subsubsection}}
\def\theparagraph     {\thesubsubsection.\arabic{paragraph}}
\def\thesubparagraph  {\theparagraph.\arabic{subparagraph}}
\def\@chapapp{\chaptername}

%    ****************************************
%    *                 PARTS                *
%    ****************************************
%
\def\part{\cleardoublepage
 \thispagestyle{empty}
 \if@twocolumn
   \onecolumn
   \@tempswatrue
  \else \@tempswafalse
 \fi
 \secdef\@part\@spart
}

\def\@part[#1]#2{\ifnum \c@secnumdepth >-2\relax
  \refstepcounter{part}
  \ifAJW@indentsty
   \ifdim\AJW@indent>\z@
    \ifAJW@multisty
     \addcontentsline{toc}{part}{\MakeUppercase{\partname\ \thepart\quad #1}}
    \else
     \addcontentsline{toc}{part}{\MakeUppercase{\partname\ \thepart\quad #1}}
    \fi
   \else
     \addcontentsline{toc}{part}{\MakeUppercase{\partname\ \thepart\quad #1}}
   \fi
  \else
    \addcontentsline{toc}{part}{\MakeUppercase{\partname\ \thepart\quad #1}}
  \fi
  \else
    \addcontentsline{toc}{part}{#1}
  \fi
  \@mkboth{}{}
  {\ifAJW@indentsty \raggedright \else \centering \fi
  \vspace*{-\baselineskip}
   \ifnum \c@secnumdepth >-2\relax
    {\huge\rm \hspace*{\AJW@indent}\MakeUppercase{\bfseries \partname\ \thepart}}%\enskip #1
    \par
    %\ifAJW@largesty \vskip 9\p@ \else
      \ifsp@nningrule
        \vskip 1\p@
        \rule{\textwidth}{0.4pt}\par
        \vskip 6pt
      \else
        \vskip 9\p@% part title on 3rd text line
     \fi
    %\fi
   \else
    \par
    \vskip 2.5\baselineskip
   \fi
  \LARGE \rm \hspace*{\AJW@indent}\MakeUppercase{#2}\par}
  \@endpart
}


\def\@spart#1{{\ifAJW@indentsty \raggedright \else \centering \fi
  \vspace*{-\baselineskip}
  \par
% \vskip 19.5\p@
  \vskip 14\p@
      \ifsp@nningrule
        \vskip 1\p@
        \rule{\textwidth}{0.4pt}\par
        \vskip 6pt
      \else
        \vskip 9\p@% part title on 3rd text line
      \fi
  \LARGE \rm \MakeUppercase{#1}\par}
\@endpart}
%
% \@endpart finishes the part page
%
\def\@endpart{\cleardoublepage}

%    ****************************************
%    *               EXERCISES              *
%    ****************************************

% Exercises numbered by section
\newcounter{ex@bean}[section]
\def\p@ex@bean{\thesection.}% add section number to cross-references

\newcount\tmp
\def\exerciselist{\@ifnextchar [{\@exerciselisttwo}{\@exerciselistone}}
\def\@exerciselistone{\ifnum \@enumdepth >3 \@toodeep \else
  \advance\@enumdepth \@ne
  \def\exerciselabel##1{\rm \thesection.##1\hss}
  \list{\arabic{ex@bean}}%
       {\usecounter{ex@bean}%
        \leftmargin 2pc
        \labelwidth \leftmargin
        \labelsep 1em%ajw
        \addtolength{\labelwidth}{-\labelsep}
  \let\makelabel\exerciselabel}%
\fi}
\def\@exerciselisttwo[#1]{\ifnum \@enumdepth >3 \@toodeep \else
  \advance\@enumdepth \@ne
  \def\exerciselabel##1{\bf #1 \thesection.##1\hss}
  \list{\arabic{ex@bean}}%
       {\tmp=\c@ex@bean%new line
        \usecounter{ex@bean}%
        \c@ex@bean=\tmp%new line
        \leftmargin 2pc
        \labelwidth \leftmargin
        \labelsep 1em%ajw
        \addtolength{\labelwidth}{-\labelsep}
  \let\makelabel\exerciselabel}%
\fi}
\let\endexerciselist=\endlist

% Exercises numbered by chapter
\newcounter{ex@beanbychapter}[chapter]
\def\p@ex@beanbychapter{\thechapter.}% add chapter number to cross-references

\def\exerciselistbychapter{\@ifnextchar [{\@exerciselisttwobychapter}{\@exerciselistonebychapter}}
\def\@exerciselistonebychapter{\ifnum \@enumdepth >3 \@toodeep \else
  \advance\@enumdepth \@ne
  \def\exerciselabel##1{\rm \thechapter.##1\hss}
  \list{\arabic{ex@beanbychapter}}%
       {\usecounter{ex@beanbychapter}%
        \leftmargin 2pc
        \labelwidth \leftmargin
        \addtolength{\labelwidth}{-\labelsep}
  \let\makelabel\exerciselabel}%
\fi}
\def\@exerciselisttwobychapter[#1]{\ifnum \@enumdepth >3 \@toodeep \else
  \advance\@enumdepth \@ne
  \def\exerciselabel##1{\bf #1 \thechapter.##1\hss}
  \list{\arabic{ex@beanbychapter}}%
       {\tmp=\c@ex@beanbychapter%new line
        \usecounter{ex@beanbychapter}%
        \c@ex@beanbychapter=\tmp%new line
        \leftmargin 2pc
        \labelwidth \leftmargin
        \addtolength{\labelwidth}{-\labelsep}
  \let\makelabel\exerciselabel}%
\fi}

\let\endexerciselistbychapter=\endlist



\def\exercises{\section*{Exercises}%
  \addcontentsline{toc}{section}{Exercises}
  \ifAJW@multisty\else\markright{Exercises}\fi
  \exerciselistbychapter
  %\setcounter{equation}{0}
  %\def\theequation{E\thechapter.\arabic{equation}}
}
\let\endexercises=\endexerciselistbychapter
\let\exercise=\item


%    ****************************************
%    *         TABLE OF CONTENTS, ETC.      *
%    ****************************************
%
\newdimen\AJW@tocindent
%\ifAJW@largesty \AJW@tocindent=65\p@ \else
  \AJW@tocindent=60\p@
%\fi
% \def\numberline#1{\hbox to\@tempdima{#1\hfil}}
\def\AJW@numberline#1{\hbox to 1.25\AJW@tocindent {{\itshape \appendixname\ #1\hfil}}}%
\def\AJW@nonumberline#1{\hbox to 56pt{{\itshape \appendixname\hfil}}}%56pt matches section heads
\ifAJW@indentsty \ifdim\AJW@indent>\z@
 \def\numberline#1{\hbox to\@tempdima{\hfil#1\hspace*{0.5em}}}
 \def\AJW@numberline#1{\hspace*{\@tempdima}%
  \hbox to 1.15\AJW@tocindent {{\itshape \appendixname\ #1\hfil}}}
\fi \fi
%
\newif\ifAJW@addtoc        \AJW@addtocfalse
\newif\ifAJW@firstTOCentry \AJW@firstTOCentrytrue
\newdimen\AJW@toclmarg
%\newdimen\AJW@tocfloatlmarg
\ifAJW@multisty
 \setcounter{tocdepth}{0}
 \AJW@toclmarg 16\p@
% \AJW@tocfloatlmarg 16\p@
\else
 \setcounter{tocdepth}{1}
 \AJW@toclmarg 28\p@
% \AJW@tocfloatlmarg 28\p@
\fi
\ifAJW@indentsty %and
  \ifdim\AJW@indent>\z@
    \AJW@toclmarg \AJW@indent
%    \AJW@tocfloatlmarg \AJW@indent
 \fi
\fi
\def\@pnumwidth{2.55em}%{1.55em}
\def\@tocrmarg {3.55em}%{2.55em}
\def\@dotsep{4.5}
%
% TABLEOFCONTENTS
%
\newcommand\tableofcontents{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \AJW@addtocfalse
 \chapter*{\contentsname}
 \@starttoc{toc}
 \AJW@addtoctrue
 \if@restonecol\twocolumn\fi
}

\newcommand*\l@part[2]{\vspace{2\baselineskip}%
 \addpenalty{-\@highpenalty}%
 \begingroup
  \parindent \z@ \rightskip \@pnumwidth
  \parfillskip -\@pnumwidth
  \leavevmode
  \ifAJW@multisty \else \hspace*{\AJW@toclmarg}\fi
  \ifAJW@firstTOCentry
    {\normalfont\bfseries #1} \hfil \hbox to\@pnumwidth{\hss {\normalfont\itshape page\/} #2}\par
    \global\AJW@firstTOCentryfalse
  \else
    {\normalfont\bfseries #1} \hfil \hbox to\@pnumwidth{\hss #2}\par
  \fi
  \nobreak
 \endgroup
}

\newcommand*\l@chapter[2]{\pagebreak[3]
 \vspace{3pt plus 2pt}%
 \@tempdima \AJW@toclmarg
 \begingroup
  \parindent \z@  \rightskip \@pnumwidth  \parfillskip -\@pnumwidth
  \leavevmode
  \advance \leftskip \@tempdima  \hskip -\leftskip
  \ifAJW@firstTOCentry
   {\normalfont\bfseries #1}\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss {\normalfont\itshape page\/} #2}\par
   \global\AJW@firstTOCentryfalse
  \else
   {\normalfont\bfseries #1}\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss #2}\par
  \fi
 \endgroup
}

\newcommand*\l@schapter[2]{\pagebreak[3]% now indented
 \@tempdima \AJW@toclmarg
 \begingroup
  \parindent \z@  \rightskip \@pnumwidth  \parfillskip -\@pnumwidth
  \leavevmode
  \advance \leftskip \@tempdima  %\hskip -\leftskip
  \ifAJW@firstTOCentry
   {\itshape #1}\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss {\itshape page\/} #2}\par
   \global\AJW@firstTOCentryfalse
  \else
   {\itshape #1}\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss #2}\par
  \fi
 \endgroup
}


% remove page number from contributor page
\newcommand*\l@contrib[2]{\pagebreak[3]
 \@tempdima \AJW@toclmarg
 \begingroup
% \parindent \z@  \rightskip \@pnumwidth  \parfillskip -\@pnumwidth
  \parindent \z@  \rightskip \z@
  \leavevmode
  \advance \leftskip \@tempdima  \hskip -\leftskip
  \ifAJW@firstTOCentry
   {#1}\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss {\itshape page\/} #2}\par
   \global\AJW@firstTOCentryfalse
  \else
%  {#1}\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss #2}\par
   {#1}\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss }\par
  \fi
 \endgroup
}

% instead of using \AJW@toclmarg, revert to 28pt throughout
% (sections not listed in multi-author designs)

\newcommand*\l@section      {\@dottedtocline{1}{28pt}{28pt}}
\newcommand*\l@subsection   {\@dottedtocline{2}{56pt}{34pt}}

% these are not used
\newcommand*\l@subsubsection{\@dottedtocline{3}{\z@}{\AJW@toclmarg}}
\newcommand*\l@paragraph    {\@dottedtocline{4}{\z@}{\AJW@toclmarg}}
\newcommand*\l@subparagraph {\@dottedtocline{5}{\z@}{\AJW@toclmarg}}
%
% LIST OF FIGURES
%
\newcommand\listoffigures{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \bgroup
 \AJW@addtocfalse% different chapter title and toc entries
   \chapter*{\listfigurename}
   \addcontentsline{toc}{schapter}{{List of illustrations}}
 \normalsmall
 \setcounter{tocdepth}{1}
 \@starttoc{lof}
 \egroup
 \if@restonecol\twocolumn\fi
}

%%%\newcommand*\l@figure{\@dottedtocline{1}{0pt}{28pt}}% same as sections

% listing for figures (repeat of schapter)
\newcommand*\l@figure[2]{\pagebreak[3]
 \@tempdima 28pt%\AJW@toclmarg
 \begingroup
  \parindent \z@  \rightskip \@pnumwidth  \parfillskip -\@pnumwidth
  \leavevmode
  \advance \leftskip \@tempdima  \hskip -\leftskip
%
  \ifAJW@firstTOCentry
    {#1}\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss {\itshape page\/} #2}\par
    \global\AJW@firstTOCentryfalse
  \else
    {#1}\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss #2}\par
 \fi
%
 \endgroup
}


%
% LIST OF TABLES
%
\newcommand\listoftables{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \bgroup
 \AJW@addtocfalse% different chapter title and toc entries
   \chapter*{\listtablename}
   \addcontentsline{toc}{schapter}{List of tables}
 \normalsmall
 \setcounter{tocdepth}{1}
 \@starttoc{lot}
 \egroup
 \if@restonecol\twocolumn\fi
}

\let\l@table\l@figure

% LIST OF CONTRIBUTORS
\newcommand\contributor[1]{\addcontentsline{loc}{contrib}{#1}}
\newcommand\affiliation[1]{\quad {\em #1}}

\newcommand\listofcontributors{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \bgroup
 \AJW@addtocfalse% different chapter title and toc entries
   \chapter*{\listcontribname}
   \addcontentsline{toc}{schapter}{List of contributors}
 \normalsmall
 \setcounter{tocdepth}{1}
 \@starttoc{loc}
 \egroup
 \if@restonecol\twocolumn\fi
}

\newcommand\editedlistofcontributors{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \bgroup
 \AJW@addtocfalse% different chapter title and toc entries
   \chapter*{\listcontribname}
   \addcontentsline{toc}{schapter}{List of contributors}
 \normalsmall
 \setcounter{tocdepth}{1}
 %\@starttoc{loc}
 \input{editedloc}
 \egroup
 \if@restonecol\twocolumn\fi
}

%
% \@dottedtocline{LEVEL}{INDENT}{NUMWIDTH}{TITLE}{PAGE} without the dots
%

\def\@dottedtocline#1#2#3#4#5{% For toc alone, all designs assume \AJW@indent=0pc
 \ifnum #1>\c@tocdepth
 \else
  \vskip \z@ \@plus .2\p@
  {\leftskip #2\relax
   \rightskip \@tocrmarg \@plus2em % for ragged right entries
   \parfillskip -\rightskip
   \parindent #2\relax
   \@afterindenttrue
   \interlinepenalty\@M
   \leavevmode
   \@tempdima #3\relax \advance\leftskip \@tempdima \hbox{}\hskip -\leftskip
   #4\nobreak
   \hfill \nobreak
   \ifAJW@firstTOCentry
    \hbox to\@pnumwidth{\hfil\rm {\itshape page\/} #5}\par
    \global\AJW@firstTOCentryfalse
   \else
    \hbox to\@pnumwidth{\hfil\rm #5}\par
   \fi}%
 \fi
}



%    ****************************************
%    *             BIBLIOGRAPHY             *
%    ****************************************
%

% from book.cls
\newdimen\bibindent
\setlength\bibindent{2em}
\newenvironment{thebibliography}[1]
     {\chapter*{\refname}%
      \@mkboth{\refname}{\refname}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\small\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty


%    ****************************************
%    *              THE INDEX               *
%    ****************************************
%
% THE THEINDEX ENVIRONMENT
%

\def\index@prologue{}
\def\@indextype{}

\newif\if@restonecol
\newenvironment{theindex}{\the@index{\indexname}}{\par\endthe@index}
%\newenvironment{theauthorindex}{\the@index{Author index}}{\par\endthe@index}
%\newenvironment{thesubjectindex}{\the@index{Subject index}}{\par\endthe@index}

\newcommand\the@index[1]{\@restonecoltrue
 \if@twocolumn\@restonecolfalse\fi
 \columnseprule \z@
 \columnsep 1pc
 \twocolumn[\vspace*{10\p@}\mbox{}\par\@makeschapterhead{#1}]
 \@mkboth{#1}{#1}
 \typeout{#1.}
 \ifAJW@indentsty
  \ifdim\AJW@indent>\z@
   \addcontentsline{toc}{schapter}{\protect\numberline{\mbox{}}#1}
  \else
   \addcontentsline{toc}{schapter}{#1}
  \fi
 \else
  \addcontentsline{toc}{schapter}{#1}
 \fi
 \thispagestyle{plain}
 \indexsize\raggedright
 \parindent\z@
 \parskip\z@ \@plus.3\p@\relax
 \let\item=\@idxitem
}
\def\endthe@index{\if@restonecol\onecolumn\else\clearpage\fi}

\newcommand\@idxitem{\par\hangindent 2em}
\newcommand\subitem{\par\hangindent 3em \hspace*{1em}}
\newcommand\subsubitem{\par\hangindent 4em \hspace*{2em}}
%\newcommand\indexspace{\par \vskip 9\p@ \@plus 5\p@ \@minus 3\p@\relax}
\newcommand\indexspace{\par \vskip 3\p@ \@plus 1\p@ \@minus 1\p@\relax}


%    ****************************************
%    *          NUMBERED FOOTNOTES          *
%    ****************************************
%

\newskip\@footindent
\@footindent=1em

\renewcommand\footnoterule{\kern-3\p@ \hrule width 0\columnwidth \kern 2.6\p@}

% reset on chapters
\@addtoreset{footnote}{chapter}
\long\def\@makefntext#1{\raggedright\@setpar{\@@par\@tempdima \hsize
 \advance\@tempdima-\@footindent
 \parshape \@ne \@footindent \@tempdima}\par
 \noindent \hbox to \z@{\hss\@thefnmark\enskip}#1}

\renewcommand\thefootnote{\mbox{$\fnsymbol{footnote}$}}
\def\@makefnmark{\hbox{\@thefnmark}}

% numbers preferred
%\def\fnsymbol#1{\expandafter\@fnsymbol\csname c@#1\endcsname}
 \def\@fnsymbol#1{{{^{\scriptstyle\@arabic{#1}}}\relax}}% correct


% redfine footnotemark and footnotetext to work on chapter openings
\newcommand\alphafootnotes{%
 \def\@fnsymbol##1{{{\scriptstyle\@alph{##1}}\relax}}%
 \def\@xfootnotenext[##1]{%
  \begingroup
     \csname c@\@mpfn\endcsname ##1\relax
     \unrestored@protected@xdef\@thefnmark{$^{\thempfn}$}%
  \endgroup
  \@footnotetext}%
}

\newcommand\arabicfootnotes{%
  \setcounter{footnote}{0}%
  \def\@fnsymbol##1{{{^{\scriptstyle\@arabic{##1}}}\relax}}%
}

%\def\@fnsymbol#1{\ifcase#1\or \dagger\or \ddagger\or
%   \S \or \P \or \|\or \dagger\dagger
%   \or \ddagger\ddagger\or \S\S\or \P\P\or \|\|\else *\fi\relax}
%
% MINIPAGE
%
\skip\@mpfootins = 4\p@ \@plus 1\p@ \@minus .1\p@  % top of first minipage footnote.
\def\thempfootnote{\alph{mpfootnote}}
\def\@makempfnmark{\hbox{$^{\@thefnmark}$}}
%
\long\def\@makempfntext#1{\@setpar{\@@par\@tempdima \hsize
 \advance\@tempdima-\@footindent
 \parshape \@ne \@footindent \@tempdima}\par
 \noindent \hbox to \z@{\hss$^{\@thefnmark}$\enskip}#1}
%
% redefine minipage to reset footnotemark as well as text and counters...
%
%\def\@iminipage[#1]#2{\leavevmode \@pboxswfalse
% \if #1b\vbox
%  \else \if #1t\vtop
%         \else \ifmmode \vcenter
%                \else \@pboxswtrue $\vcenter
%               \fi
%        \fi
% \fi\bgroup
% \hsize #2\textwidth\hsize \columnwidth\hsize
% \@parboxrestore
% \def\@mpfn{mpfootnote}
% \def\thempfn{\thempfootnote}\c@mpfootnote\z@
% \let\@makefnmark\@makempfnmark % v.01.03 AJW
% \let\@footnotetext\@mpfootnotetext
% \let\@listdepth\@mplistdepth \@mplistdepth\z@
% \@minipagerestore\global\@minipagetrue
% \everypar{\global\@minipagefalse\everypar{}}}

\def\@iiiminipage#1#2[#3]#4{% from latex.ltx
  \leavevmode
  \@pboxswfalse
  \setlength\@tempdima{#4}%
  \def\@mpargs{{#1}{#2}[#3]{#4}}%
  \setbox\@tempboxa\vbox\bgroup
    \color@begingroup
      \hsize\@tempdima
      \textwidth\hsize \columnwidth\hsize
      \@parboxrestore
      \def\@mpfn{mpfootnote}\def\thempfn{\thempfootnote}\c@mpfootnote\z@
      \let\@makefnmark\@makempfnmark % from v1.2 ajw
      \let\@footnotetext\@mpfootnotetext
      \let\@listdepth\@mplistdepth \@mplistdepth\z@
      \@minipagerestore\global\@minipagetrue %% \global added 24 May 89
      \everypar{\global\@minipagefalse\everypar{}}}

\long\def\@mpfootnotetext#1{\global\setbox\@mpfootins
 \vbox{\unvbox\@mpfootins
  \footnotesize
  \hsize\columnwidth \@parboxrestore
  \edef\@currentlabel{\csname p@mpfootnote\endcsname\@thefnmark}
  \@makempfntext{\rule{\z@}{\footnotesep}\ignorespaces #1\strut}}}

%       ****************************************
%       *               ENDNOTES               *
%       ****************************************
%
\newcounter{endnote}[chapter] \def\theendnote{\arabic{endnote}}
\newdimen\endnotesep
\newwrite\@enotes
\newif\if@enotesopen          \global\@enotesopenfalse
\newif\ifAJW@firstendnote     \global\AJW@firstendnotefalse

\def\@makeenmark{\hbox{$^{\@theenmark}$}}

\def\endnote{%
 \ifAJW@multisty \AJW@firstendnotefalse
        \else \ifnum \c@endnote = \z@ \AJW@firstendnotetrue
                                \else \AJW@firstendnotefalse \fi
 \fi
 \@ifnextchar[{\@xendnote
  }{\stepcounter{endnote}%
    \xdef\@theenmark{\theendnote}%
   }%
 \@endnotemark
 \@endnotetext
}
\def\@xendnote[#1]{\begingroup \c@endnote=#1\relax
  \xdef\@theenmark{\theendnote}\endgroup
}
\let\@doanenote=0
\let\@endanenote=0
\def\@openenotes{\immediate\openout\@enotes=\jobname.ent\relax
 \global\@enotesopentrue
}
\gdef\AJW@endnotehead{\relax}
\long\def\@endnotetext#1{%
 \if@enotesopen \else \@openenotes \fi
 \ifAJW@firstendnote
  \addtoendnotes{\protect\endnoteheading*{\AJW@endnotehead}}%
  %\addtoendnotes{\protect\noindent}%
 \fi
 \ifAJW@multisty\else
  \addtoendnotes{\protect\mark{\thepage}}%
 \fi
 \immediate\write\@enotes{\@doanenote{\@theenmark}}%
 \begingroup
  \def\next{#1}%
  \newlinechar='40
  \immediate\write\@enotes{\meaning\next}%
 \endgroup
 \immediate\write\@enotes{\@endanenote}%
 \edef\@currentlabel{\csname p@endnote\endcsname\@theenmark}%
}
\long\def\addtoendnotes#1{%
 \if@enotesopen \else \@openenotes \fi
 \begingroup
  \newlinechar='40
  \let\protect\string
  \immediate\write\@enotes{#1}%
 \endgroup
}
\def\endnotemark{\@ifnextchar [{\@xendnotemark
 }{\stepcounter{endnote}%
   \xdef\@theenmark{\theendnote}}%
 \@endnotemark
}
\def\@xendnotemark[#1]{\begingroup
  \c@endnote #1\relax
  \xdef\@theenmark{\theendnote}\endgroup
}
\def\@endnotemark{\leavevmode
 \ifhmode \edef\@x@sf{\the\spacefactor}\fi
 \@makeenmark
 \ifhmode\spacefactor\@x@sf\fi\relax
}
\def\endnotetext{\@ifnextchar [{\@xendnotenext
  }{\xdef\@theenmark{\theendnote}}%
 \@endnotetext
}
\def\@xendnotenext[#1]{\begingroup
  \c@endnote=#1\relax \xdef\@theenmark{\theendnote}\endgroup
}
\ifAJW@multisty
%\def\enoteheading{\section*{Notes}}
 \def\enoteheading{\endnoteheading*{Notes}}
\else
 \def\enoteheading{\chapter*{Notes}\leavevmode\par\vskip-\baselineskip}
\fi
\def\enoteformat{\raggedright
 \ifAJW@indentsty
  \@tempdima = 3pc
 \else
  \@tempdima = 1.5em
 \fi
 \leftskip \@tempdima \parindent=1em%
 \leavevmode
 \hskip-\@tempdima
 \hskip-\parindent
 \hbox to \@tempdima {\hfil\@theenmark\hspace*{0.5em}}%
}
\ifAJW@multisty\else
 \def\AJW@enoteheadline{Notes to pp. \firstmark--\botmark}
\fi
\def\theendnotes{\immediate\closeout\@enotes
 \global\@enotesopenfalse
 \begingroup
  \makeatletter
  \def\@doanenote##1##2>{\def\@theenmark{##1}%\par removed
    \begingroup\enoteformat}%
  \def\@endanenote{\par\endgroup}%
  \def\ETC.{\@warning{[CUPBOOK] Some long endnotes will be truncated}
   \def\ETC.{\relax}}
  \enoteheading
  \ifAJW@multisty\else % redefine marking for running heads
   \def\chaptermark##1{}
   \def\leftmark{\AJW@enoteheadline}
   \def\rightmark{\AJW@enoteheadline}
  \fi
  \enotesize
  %\noindent
  \@input{\jobname.ent}%
  \ifAJW@multisty\else\clearpage\fi
 \endgroup
}
\ifAJW@indentsty
 \def\endnoteheading{\@startsection {endnoteheading}{1}{\z@}
   {12\p@ \@plus6\p@ \@minus3\p@}{6\p@}{\smallish\bfseries\raggedright}}
\else
 \def\endnoteheading{\@startsection {endnoteheading}{1}{\z@}
   {12\p@ \@plus6\p@ \@minus3\p@}{6\p@}{\smallish\bfseries\centering}}
\fi

%    ****************************************
%    *         FIGURES AND TABLES           *
%    ****************************************
%
% Float placement parameters.
%
\setcounter{topnumber}{2}
\renewcommand\topfraction{0.9}
\setcounter{bottomnumber}{2}
\renewcommand\bottomfraction{0.5}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{0.05}
\renewcommand\floatpagefraction{0.95}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{0.9}
\renewcommand\dblfloatpagefraction{0.8}
%
% \@makecaption{NUMBER}{TEXT} : Macro to make a figure or table caption.
%
\long\def\make@table@caption#1#2{\vskip 10\p@%
  \setbox\@tempboxa\hbox{{\rm #1\enskip\itshape #2}}%
  \ifdim \wd\@tempboxa >\hsize
    {\ifAJW@indentsty \raggedright\else \centering\fi
    \rm #1\enskip{\itshape #2}\par}%
  \else
    \ifAJW@indentsty
      \hbox to\hsize{\box\@tempboxa\hfill}\par
    \else
      \hbox to\hsize{\hfil\box\@tempboxa\hfil}\par
    \fi
  \fi
  \vspace*{2.5\p@}\par
}
%
\newlength\figcapindent
\setlength\figcapindent{1.5pc}% 1.5pc either side

\newlength\figcapwidth
\setlength\figcapwidth\textwidth
\addtolength\figcapwidth{-2\figcapindent}

\newbox\@figbox
\long\def\make@figure@caption#1#2{\vskip 10\p@
  \setbox\@tempboxa\hbox{{\small\rm #1\enskip #2}}%
% \ifdim \wd\@tempboxa >\hsize
  \ifdim \wd\@tempboxa >\figcapwidth
    \leftskip=\figcapindent
    \rightskip\leftskip
      {\small\rm #1\enskip #2\par}%
  \else
%    \ifAJW@indentsty
%      \hbox to\hsize{\box\@tempboxa\hfill}\par
%    \else
       \hbox to\hsize{\hfil\box\@tempboxa\hfil}\par
%    \fi
  \fi
}

%
% Float control
%
\newdimen\AJW@floatwidth

\def\AJW@float{\AJW@floatwidth \textwidth
 \addtolength{\AJW@floatwidth}{-\AJW@floatindent}
 \hspace*{\AJW@floatindent}\minipage{\AJW@floatwidth}%
 \ifAJW@indentsty\raggedright\else\centering\fi\small}
\def\endAJW@float{\endminipage}
\def\AJW@widefloat{\minipage{\textwidth}\raggedright\small}
\let\endAJW@widefloat=\endAJW@float
%
% FIGURE
%
\newcounter{figure}[chapter]
\def\thefigure{\thechapter.\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename\ \thefigure}

\def\figure{\let\@makecaption=\make@figure@caption
 \AJW@floatindent=\AJW@indent
 \@ifnextchar[{\AJW@figone}{\AJW@figzero}}
\def\AJW@figone[#1]{\@xfloat{figure}[#1]\AJW@float}
\edef\AJW@figzero{\noexpand\@xfloat{figure}[\fps@figure]\noexpand\AJW@float}
\def\endfigure{\endAJW@float\end@float}

\@namedef{figure*}{\let\@makecaption=\make@figure@caption
 \@ifnextchar[{\AJW@widefigone}{\AJW@widefigzero}}
\def\AJW@widefigone[#1]{\@xfloat{figure}[#1]\AJW@widefloat}
%\edef\AJW@widefigzero{\noexpand\@xfloat{figure}[p]\noexpand\AJW@widefloat}
\edef\AJW@widefigzero{\noexpand\@xfloat{figure}[\fps@figure]\noexpand
  \AJW@widefloat}
\@namedef{endfigure*}{\endAJW@widefloat\end@float}
%
% TABLE
%
\newcounter{table}[chapter]
\def\thetable{\thechapter.\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename\ \thetable}

\newenvironment{table}{%
  \let\@makecaption=\make@table@caption
  \ifAJW@indentsty
    \ifdim\AJW@indent>\z@
      %\ifAJW@largesty
      %  \AJW@floatindent=\AJW@indent
      %\else
        \AJW@floatindent=\z@
      %\fi
    \fi
  \fi
  \@ifnextchar[{\AJW@tabone}{\AJW@tabzero}%
  }%
  {\endAJW@float\end@float}

\def\AJW@tabone[#1]{\@xfloat{table}[#1]\AJW@float}
\edef\AJW@tabzero{%
  \noexpand\@xfloat{table}[\fps@table]\noexpand\AJW@float}

\newenvironment{table*}{%
  \let\@makecaption=\make@table@caption
  \let\AJW@currenthline=\AJW@fullhline
  \@ifnextchar[{\AJW@widetabone}{\AJW@widetabzero}%
  }%
  {\endAJW@widefloat\end@float}

\def\AJW@widetabone[#1]{\@xfloat{table}[#1]\AJW@widefloat}
%\edef\AJW@widetabzero{\noexpand\@xfloat{table}[p]\noexpand\AJW@widefloat}
\edef\AJW@widetabzero{\noexpand\@xfloat{table}[\fps@table]\noexpand\AJW@widefloat}

%    ****************************************
%    *                TITLE                 *
%    ****************************************
%
% TITLEPAGE
%
\newif\ifAJW@titlepage
\def\titlepage{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn
  \else \newpage
 \fi
 \AJW@titlepagetrue
 \thispagestyle{empty}%
}
\def\endtitlepage{\if@restonecol\twocolumn \else \newpage \fi
  \AJW@titlepagefalse}
%
\def\maketitle{\openin1 \jobname.ttl
 \ifeof1
  \typeout{No file \jobname.ttl.}
  \begin{titlepage}
   \ifAJW@indentsty \begin{indented}
              \else \begin{center}
   \fi
   %\ifAJW@largesty \vspace*{4\p@} \else
   \vspace*{2\p@}
   %\fi
   \huge \@title \par
   \if\@subtitle\empty\else \vskip 9\p@ \Large\@subtitle \par \fi
   \vspace{28\p@}
   {\large
     \ifAJW@multisty {\itshape Edited by} \\ \fi
   % \ifAJW@indentsty \begin{author@tabular}[t]{@{}l@{}}
   %   \else \begin{author@tabular}[t]{c}
   % \fi \@author
   % \end{author@tabular}\par}
% four lines above re-written to avoid clash with array.sty
     \@author
     \par}
   \vfill
   \ifAJW@indentsty \end{indented}
              \else \end{center}
   \fi
  \end{titlepage}
  \cleardoublepage
 \else
  \closein1 \relax\@@input \jobname.ttl
 \fi
 \setcounter{footnote}{0} % Reset definitions
 \let\thanks\relax
 \gdef\@thanks{}
 \gdef\@author{}
 \gdef\@shortauthor{}
 \gdef\@title{}
 \let\maketitle\relax
}
\gdef\@title{\mbox{}}
\def\title{\@ifnextchar[ {\@titletwo}{\@titleone}}
\def\@titletwo[#1]#2{\gdef\@title{#2}\gdef\@subtitle{#1}}
\def\@titleone#1{\gdef\@title{#1}\gdef\@subtitle{}}
\def\subtitle#1{\gdef\@subtitle{#1}}
\gdef\@subtitle{}
\def\halftitle#1{\gdef\@halftitle{#1}}
\gdef\@halftitle{\@title}
%
\gdef\@author{\mbox{}}
\gdef\@shortauthor{}
\def\author{
  \@ifnextchar[{\@authortwo}{\@authorone}%
}
\def\@authortwo[#1]#2{\gdef\@author{#2}\gdef\@shortauthor{#1}}
\def\@authorone#1{\gdef\@author{#1}\gdef\@shortauthor{}}

\def\author@tabular{\def\@halignto{}\@authortable}

\let\endauthor@tabular=\endtabular

\def\@authortable{\leavevmode \hbox \bgroup $\let\@acol=\@tabacol
 \let\@classz=\@tabclassz \let\@classiv=\@tabclassiv
 \ifAJW@titlepage \let\\=\AJWauthor@tabcrone
            \else \let\\=\author@tabcrone
 \fi
 \ignorespaces \@tabarray}
\def\author@tabcrone{{\ifnum0=`}\fi\@xtabularcr\enotesize\itshape
 \ifAJW@titlepage \let\\=\AJWauthor@tabcrtwo
            \else \let\\=\author@tabcrtwo
 \fi
 \ignorespaces}
\def\author@tabcrtwo{{\ifnum0=`}\fi\@xtabularcr[-3\p@]\enotesize\itshape
 \ifAJW@titlepage \let\\=\AJWauthor@tabcrtwo
            \else \let\\=\author@tabcrtwo
 \fi
 \ignorespaces}
\def\AJWauthor@tabcrone{{\ifnum0=`}\fi\@xtabularcr[-2\p@]\footnotesize\itshape
 \let\\=\AJWauthor@tabcrtwo\ignorespaces}
\def\AJWauthor@tabcrtwo{{\ifnum0=`}\fi\@xtabularcr[-5\p@]\footnotesize\itshape
 \let\\=\AJWauthor@tabcrtwo\ignorespaces}
\def\and{\end{author@tabular}\vskip 6\p@\par
 \ifAJW@indentsty \begin{author@tabular}[t]{@{}l@{}}
            \else \begin{author@tabular}[t]{c}
 \fi}

%    ****************************************
%    *            PAGE STYLES               *
%    ****************************************
%

\newcommand\copyrightline[1]{%
  \def\@copyrightline{#1}}

\edef\@copyrightline{\relax}

\newcommand\c@pyrightline[1]{%
  \gdef\@c@pyrightline{#1}}

\gdef\@c@pyrightline{%
  \vbox to 5.5\p@{\noindent
  \parbox[t]{\textwidth}{\normalfont\footnotesize\baselineskip 9\p@
  \@copyrightline
  }%
  \vss}%
}


% Initializes TeX's marks
%
\mark{{}{}}
%
% centred \ps@plain and \ps@empty defined in LATEX.TEX
%
\ifAJW@indentsty
  \def\ps@plain{\let\@mkboth=\@gobbletwo
    \def\@oddfoot {\listsize\rm\hfill\thepage}
    \def\@evenfoot{\listsize\rm\thepage\hfill}
    \def\@oddhead {}
    \def\@evenhead{}}
\else
  \def\ps@plain{\leftskip\z@\let\@mkboth\@gobbletwo\vfuzz=5\p@
    \def\@oddhead{}%
    \def\@evenhead{}%
    \def\@oddfoot{\@c@pyrightline \hfil}%
    \def\@evenfoot{\@c@pyrightline \hfil}%
    \def\sectionmark##1{}%
    \def\subsectionmark##1{}%
 }
\fi


%
% Definition of 'headings' page style
%
\def\ps@headings{%
 \let\@mkboth=\markboth
 \def\@oddfoot {}
 \def\@evenfoot{}
 \ifAJW@indentsty
  \ifdim\AJW@indent=\z@
   \def\@oddhead {\smallish\itshape \rightmark \hfill \rm \thepage}
   \def\@evenhead{\smallish\rm \thepage \hfill \itshape \leftmark}
  \else
   \def\@oddhead {\smallish
                  \hspace*{\AJW@indent}\itshape \rightmark \hfil \rm\thepage}
   \def\@evenhead{\smallish
                  \makebox[\z@][l]{\rm \thepage}\hspace*{\AJW@indent}\itshape
                  \leftmark \hfill}
  \fi
 \else
  \def\@oddhead {\smallish
                 \hfil \itshape \rightmark \hfil \makebox[\z@][r]{\rm \thepage}}
  \def\@evenhead{\smallish
                 \makebox[\z@][l]{\rm \thepage}\hfil \itshape \leftmark \hfil}
 \fi
 \ifAJW@multisty
  \def\chaptermark##1{}
  \def\sectionmark##1{}
 \else
  \def\chaptermark##1{\markboth{##1}{##1}}
  \def\sectionmark##1{\markright{\ifnum \c@secnumdepth >\z@
   \thesection\hspace{0.5em}\fi ##1}}%
 \fi
}
%
% Definition of 'myheadings' page style.
%
\def\ps@myheadings{\let\@mkboth=\@gobbletwo
 \def\@oddfoot {}
 \def\@evenfoot{}
 \def\@oddhead {\smallish\hfil \normalfont\itshape\rightmark
     \hfil \llap{\normalfont\rmfamily\thepage}}
 \def\@evenhead{\smallish\rlap{\normalfont\rmfamily\thepage}%
     \hfil\normalfont\itshape\leftmark\hfil}
 \def\chaptermark##1{}
 \def\sectionmark##1{}
 \def\subsectionmark##1{}}


\newcommand\contentsname{Contents}
\newcommand\listfigurename{Illustrations}
\newcommand\listtablename{Tables}
\newcommand\listcontribname{Contributors}
\newcommand\bibname{Bibliography}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\chaptername{Chapter}
\newcommand\appendixname{Appendix}

%    ****************************************
%    *            MISCELLANEOUS             *
%    ****************************************
%
% DATE
%
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
%
% EQUATION and EQNARRAY -- put here because it must follow \chapter definition
%
\@addtoreset{equation}{chapter}
\def\theequation{\thechapter.\arabic{equation}}
% \jot = 3\p@ % Extra space added between lines of an eqnarray environment
%
% Flush left / indented equations
%
% FLEQN DOCUMENT-STYLE OPTION - released 9 March 1987
%    for LaTeX version 2.09
% Copyright (C) 1987 by Leslie Lamport
%
\ifAJW@indentsty
 \def\[{\relax\ifmmode\@badmath\else\begin{trivlist}\item[]\leavevmode
  \hbox to\linewidth\bgroup$ \displaystyle \hskip\AJW@indent\bgroup\fi}
 \def\]{\relax\ifmmode \egroup $\hfil \egroup \end{trivlist}%
  \else \@badmath \fi}
 \def\equation{\refstepcounter{equation}\trivlist \item[]\leavevmode
  \hbox to\linewidth\bgroup $ \displaystyle \hskip\AJW@indent}
 \def\endequation{$\hfil \displaywidth\linewidth\@eqnnum\egroup \endtrivlist}
 \def\eqnarray{\stepcounter{equation}\let\@currentlabel=\theequation
  \global\@eqnswtrue
  \global\@eqcnt\z@\tabskip\AJW@indent\let\\=\@eqncr
  \abovedisplayskip\topsep\ifvmode\advance\abovedisplayskip\partopsep\fi
  \belowdisplayskip\abovedisplayskip
  \belowdisplayshortskip\abovedisplayskip
  \abovedisplayshortskip\abovedisplayskip
  $$\halign
   to \linewidth\bgroup\@eqnsel\hskip\@centering$\displaystyle\tabskip\z@
   {##}$&\global\@eqcnt\@ne \hskip 2\arraycolsep \hfil${##}$\hfil
   &\global\@eqcnt\tw@ \hskip 2\arraycolsep $\displaystyle{##}$\hfil
    \tabskip\@centering&\llap{##}\tabskip\z@\cr}
 \def\endeqnarray{\@@eqncr\egroup
  \global\advance\c@equation\m@ne$$\global\@ignoretrue}%
\else
 \renewenvironment{eqnarray} % remove exta space around alignment marks
  {\stepcounter{equation}%
   \let\@currentlabel=\theequation
   \global\@eqnswtrue
   \m@th
   \global\@eqcnt\z@
   \tabskip\@centering
   \let\\\@eqncr
   $$\everycr{}\halign to \displaywidth\bgroup
     \hskip\@centering$\displaystyle\tabskip\z@skip{##}$\@eqnsel
   &\global\@eqcnt\@ne \hfil${\;##\;}$\hfil
   &\global\@eqcnt\tw@
     $\displaystyle\tabskip\z@skip{##}$\hfil \tabskip\@centering
   &\hb@xt@\z@\bgroup\hss##\egroup
     \tabskip\z@skip \cr}
  {\@@eqncr\egroup\global\advance\c@equation\m@ne
   $$\global\@ignoretrue}
\fi

% this allows proof boxes to be right-aligned in eqnarrays
\newcommand\arrayqed{\arrayqedtrue}
\newcommand\arrayqedhere{\arrayqedfalse}
\newif\ifarrayqed

\def\@@eqncr{\let\reserved@a\relax
    \ifcase\@eqcnt \def\reserved@a{& & &}\or \def\reserved@a{& &}%
     \or \def\reserved@a{&}\else
       \let\reserved@a\@empty
       \@latex@error{Too many columns in eqnarray environment}\@ehc\fi
     \reserved@a
     \if@eqnsw
       \ifarrayqed
         \qedsymbol%
       \else
         \@eqnnum\stepcounter{equation}%
       \fi
    \fi
     \global\@eqnswtrue\global\@eqcnt\z@\cr}


%    ****************************************
%    *            CUP SPECIALS              *
%    ****************************************
%
% redefinition of \cleardoublepage to get blank empty pages
%
\def\clearemptypage{\clearpage
 \if@twoside
  \ifodd\c@page
   \else
    \thispagestyle{empty}
    \mbox{}\newpage
    \if@twocolumn
      \hbox{}\newpage
    \fi
  \fi
 \fi
}
\let\cleardoublepage=\clearemptypage
%
% redefinition of sections to get en space after chapter number
%
\def\@sect#1#2#3#4#5#6[#7]#8{%
 \ifnum #2>\c@secnumdepth % LEVEL -- is heading to be numbered?
  \def\@svsec{}%
 \else
  \refstepcounter{#1}
  \edef\@svsec{\csname the#1\endcsname\hskip 0.5em}
 \fi
 \@tempskipa #5\relax % AFTERSKIP (-ve indicates a run-in heading)
 \ifdim \@tempskipa>\z@
  \begingroup #6\relax
   \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M #8\par}
  \endgroup
  \csname #1mark\endcsname{#7}%
  \addcontentsline{toc}{#1}{\ifnum #2>\c@secnumdepth \else
   \protect\numberline{\csname the#1\endcsname}\fi #7}
 \else
  \def\@svsechd{#6\hskip #3\@svsec #8%
   \csname #1mark\endcsname{#7}%
   \addcontentsline{toc}{#1}{\ifnum #2>\c@secnumdepth \else
    \protect\numberline{\csname the#1\endcsname}\fi#7}}%
 \fi
 \@xsect{#5}}


% remove the vertical rules in tables, by default
\def\AJW@fullhline{\noalign{\ifnum0=`}\fi \vskip 3\p@
  \hrule \@height\arrayrulewidth width\textwidth
  \vskip 3\p@
  \futurelet \@tempa\@xhline}
\def\AJW@hline{\noalign{\ifnum0=`}\fi
  \vskip 3\p@
  \hrule \@height \arrayrulewidth
  \vskip 3\p@
  \futurelet \@tempa\@xhline}
\let\AJW@currenthline=\AJW@hline
%
\def\tabular{\def\@halignto{}%
  \let\hline=\AJW@currenthline
  \def\@xhline{\ifx\@tempa\hline
    \vskip -6\p@
    \vskip \doublerulesep
  \fi
  \ifnum0=`{\fi}}%
  \def\@arrayrule{\@addtopreamble{\hskip -.5\arrayrulewidth
%   \vrule \@width \arrayrulewidth
    \hskip .5\arrayrulewidth}}%
  \@tabular}


% If authors really need to re-instate the rules,

\newcommand\reinstaterules{%
  \def\tabular{\let\@halignto\@empty\@tabular}%
}


% ABSTRACT
%
\newenvironment{abstract}{\section*{Abstract}\trivlist\item[]%
 }{\endtrivlist\addvspace{13\p@}}


%    ****************************************
%    *           INITIALIZATION             *
%    ****************************************
%
% Default initializations
%
\ifAJW@landscape \pagestyle{empty}\else \pagestyle{headings}\fi
\pagenumbering{arabic}
\onecolumn
\flushbottom
\frenchspacing

\endinput

